*#**********************************************************************

      SUBROUTINE CPBCO(ABD,LDA,N,M,RCOND,Z,INFO)                        00000010

      INTEGER LDA,N,M,INFO                                              00000020
      COMPLEX ABD(LDA,1),Z(1)                                           00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CPBCO FACTORS A COMPLEX HERMITIAN POSITIVE DEFINITE MATRIX        00000060
C     STORED IN BAND FORM AND ESTIMATES THE CONDITION OF THE MATRIX.    00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, CPBFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW CPBCO BY CPBSL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CPBCO BY CPBSL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CPBCO BY CPBDI.               00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        ABD     COMPLEX(LDA, N)                                        00000160
C                THE MATRIX TO BE FACTORED.  THE COLUMNS OF THE UPPER   00000170
C                TRIANGLE ARE STORED IN THE COLUMNS OF ABD AND THE      00000180
C                DIAGONALS OF THE UPPER TRIANGLE ARE STORED IN THE      00000190
C                ROWS OF ABD .  SEE THE COMMENTS BELOW FOR DETAILS.     00000200
C                                                                       00000210
C        LDA     INTEGER                                                00000220
C                THE LEADING DIMENSION OF THE ARRAY  ABD .              00000230
C                LDA MUST BE .GE. M + 1 .                               00000240
C                                                                       00000250
C        N       INTEGER                                                00000260
C                THE ORDER OF THE MATRIX  A .                           00000270
C                                                                       00000280
C        M       INTEGER                                                00000290
C                THE NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.       00000300
C                0 .LE. M .LT. N .                                      00000310
C                                                                       00000320
C     ON RETURN                                                         00000330
C                                                                       00000340
C        ABD     AN UPPER TRIANGULAR MATRIX  R , STORED IN BAND         00000350
C                FORM, SO THAT  A = CTRANS(R)*R .                       00000360
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000370
C                                                                       00000380
C        RCOND   REAL                                                   00000390
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000400
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000410
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000420
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000430
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000440
C                           1.0 + RCOND .EQ. 1.0                        00000450
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000460
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000470
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000480
C                UNDERFLOWS.  IF INFO .NE. 0 , RCOND IS UNCHANGED.      00000490
C                                                                       00000500
C        Z       COMPLEX(N)                                             00000510
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000520
C                IF  A  IS SINGULAR TO WORKING PRECISION, THEN  Z  IS   00000530
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000540
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000550
C                IF  INFO .NE. 0 , Z  IS UNCHANGED.                     00000560
C                                                                       00000570
C        INFO    INTEGER                                                00000580
C                = 0  FOR NORMAL RETURN.                                00000590
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000600
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000610
C                                                                       00000620
C     BAND STORAGE                                                      00000630
C                                                                       00000640
C           IF  A  IS A HERMITIAN POSITIVE DEFINITE BAND MATRIX,        00000650
C           THE FOLLOWING PROGRAM SEGMENT WILL SET UP THE INPUT.        00000660
C                                                                       00000670
C                   M = (BAND WIDTH ABOVE DIAGONAL)                     00000680
C                   DO 20 J = 1, N                                      00000690
C                      I1 = MAX0(1, J-M)                                00000700
C                      DO 10 I = I1, J                                  00000710
C                         K = I-J+M+1                                   00000720
C                         ABD(K,J) = A(I,J)                             00000730
C                10    CONTINUE                                         00000740
C                20 CONTINUE                                            00000750
C                                                                       00000760
C           THIS USES  M + 1  ROWS OF  A , EXCEPT FOR THE  M BY M       00000770
C           UPPER LEFT TRIANGLE, WHICH IS IGNORED.                      00000780
C                                                                       00000790
C     EXAMPLE..  IF THE ORIGINAL MATRIX IS                              00000800
C                                                                       00000810
C           11 12 13  0  0  0                                           00000820
C           12 22 23 24  0  0                                           00000830
C           13 23 33 34 35  0                                           00000840
C            0 24 34 44 45 46                                           00000850
C            0  0 35 45 55 56                                           00000860
C            0  0  0 46 56 66                                           00000870
C                                                                       00000880
C     THEN  N = 6 , M = 2  AND  ABD  SHOULD CONTAIN                     00000890
C                                                                       00000900
C            *  * 13 24 35 46                                           00000910
C            * 12 23 34 45 56                                           00000920
C           11 22 33 44 55 66                                           00000930
C                                                                       00000940
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000950
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000960
C                                                                       00000970
C     SUBROUTINES AND FUNCTIONS                                         00000980
C                                                                       00000990
C     LINPACK CPBFA                                                     00001000
C     BLAS CAXPY,CDOTC,CSSCAL,SCASUM                                    00001010
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,MAX0,MIN0,REAL                00001020
C                                                                       00001030
C     INTERNAL VARIABLES                                                00001040
C                                                                       00001050
      COMPLEX CDOTC,EK,T,WK,WKM                                         00001060
      REAL ANORM,S,SCASUM,SM,YNORM                                      00001070
      INTEGER I,J,J2,K,KB,KP1,L,LA,LB,LM,MU                             00001080
C                                                                       00001090
      COMPLEX ZDUM,ZDUM2,CSIGN1                                         00001100
      REAL CABS1                                                        00001110
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00001120
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00001130
C                                                                       00001140
C     FIND NORM OF A                                                    00001150
C                                                                       00001160
      DO 30 J = 1, N                                                    00001170
         L = MIN0(J,M+1)                                                00001180
         MU = MAX0(M+2-J,1)                                             00001190
         Z(J) = CMPLX(SCASUM(L,ABD(MU,J),1),0.0E0)                      00001200
         K = J - L                                                      00001210
         IF (M .LT. MU) GO TO 20                                        00001220
         DO 10 I = MU, M                                                00001230
            K = K + 1                                                   00001240
            Z(K) = CMPLX(REAL(Z(K))+CABS1(ABD(I,J)),0.0E0)              00001250
   10    CONTINUE                                                       00001260
   20    CONTINUE                                                       00001270
   30 CONTINUE                                                          00001280
      ANORM = 0.0E0                                                     00001290
      DO 40 J = 1, N                                                    00001300
         ANORM = AMAX1(ANORM,REAL(Z(J)))                                00001310
   40 CONTINUE                                                          00001320
C                                                                       00001330
C     FACTOR                                                            00001340
C                                                                       00001350
      CALL CPBFA(ABD,LDA,N,M,INFO)                                      00001360
      IF (INFO .NE. 0) GO TO 180                                        00001370
C                                                                       00001380
C        RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .           00001390
C        ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .      00001400
C        THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL        00001410
C        GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(R)*W = E .          00001420
C        THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.         00001430
C                                                                       00001440
C        SOLVE CTRANS(R)*W = E                                          00001450
C                                                                       00001460
         EK = (1.0E0,0.0E0)                                             00001470
         DO 50 J = 1, N                                                 00001480
            Z(J) = (0.0E0,0.0E0)                                        00001490
   50    CONTINUE                                                       00001500
         DO 110 K = 1, N                                                00001510
            IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,-Z(K))           00001520
            IF (CABS1(EK-Z(K)) .LE. REAL(ABD(M+1,K))) GO TO 60          00001530
               S = REAL(ABD(M+1,K))/CABS1(EK-Z(K))                      00001540
               CALL CSSCAL(N,S,Z,1)                                     00001550
               EK = CMPLX(S,0.0E0)*EK                                   00001560
   60       CONTINUE                                                    00001570
            WK = EK - Z(K)                                              00001580
            WKM = -EK - Z(K)                                            00001590
            S = CABS1(WK)                                               00001600
            SM = CABS1(WKM)                                             00001610
            WK = WK/ABD(M+1,K)                                          00001620
            WKM = WKM/ABD(M+1,K)                                        00001630
            KP1 = K + 1                                                 00001640
            J2 = MIN0(K+M,N)                                            00001650
            I = M + 1                                                   00001660
            IF (KP1 .GT. J2) GO TO 100                                  00001670
               DO 70 J = KP1, J2                                        00001680
                  I = I - 1                                             00001690
                  SM = SM + CABS1(Z(J)+WKM*CONJG(ABD(I,J)))             00001700
                  Z(J) = Z(J) + WK*CONJG(ABD(I,J))                      00001710
                  S = S + CABS1(Z(J))                                   00001720
   70          CONTINUE                                                 00001730
               IF (S .GE. SM) GO TO 90                                  00001740
                  T = WKM - WK                                          00001750
                  WK = WKM                                              00001760
                  I = M + 1                                             00001770
                  DO 80 J = KP1, J2                                     00001780
                     I = I - 1                                          00001790
                     Z(J) = Z(J) + T*CONJG(ABD(I,J))                    00001800
   80             CONTINUE                                              00001810
   90          CONTINUE                                                 00001820
  100       CONTINUE                                                    00001830
            Z(K) = WK                                                   00001840
  110    CONTINUE                                                       00001850
         S = 1.0E0/SCASUM(N,Z,1)                                        00001860
         CALL CSSCAL(N,S,Z,1)                                           00001870
C                                                                       00001880
C        SOLVE  R*Y = W                                                 00001890
C                                                                       00001900
         DO 130 KB = 1, N                                               00001910
            K = N + 1 - KB                                              00001920
            IF (CABS1(Z(K)) .LE. REAL(ABD(M+1,K))) GO TO 120            00001930
               S = REAL(ABD(M+1,K))/CABS1(Z(K))                         00001940
               CALL CSSCAL(N,S,Z,1)                                     00001950
  120       CONTINUE                                                    00001960
            Z(K) = Z(K)/ABD(M+1,K)                                      00001970
            LM = MIN0(K-1,M)                                            00001980
            LA = M + 1 - LM                                             00001990
            LB = K - LM                                                 00002000
            T = -Z(K)                                                   00002010
            CALL CAXPY(LM,T,ABD(LA,K),1,Z(LB),1)                        00002020
  130    CONTINUE                                                       00002030
         S = 1.0E0/SCASUM(N,Z,1)                                        00002040
         CALL CSSCAL(N,S,Z,1)                                           00002050
C                                                                       00002060
         YNORM = 1.0E0                                                  00002070
C                                                                       00002080
C        SOLVE CTRANS(R)*V = Y                                          00002090
C                                                                       00002100
         DO 150 K = 1, N                                                00002110
            LM = MIN0(K-1,M)                                            00002120
            LA = M + 1 - LM                                             00002130
            LB = K - LM                                                 00002140
            Z(K) = Z(K) - CDOTC(LM,ABD(LA,K),1,Z(LB),1)                 00002150
            IF (CABS1(Z(K)) .LE. REAL(ABD(M+1,K))) GO TO 140            00002160
               S = REAL(ABD(M+1,K))/CABS1(Z(K))                         00002170
               CALL CSSCAL(N,S,Z,1)                                     00002180
               YNORM = S*YNORM                                          00002190
  140       CONTINUE                                                    00002200
            Z(K) = Z(K)/ABD(M+1,K)                                      00002210
  150    CONTINUE                                                       00002220
         S = 1.0E0/SCASUM(N,Z,1)                                        00002230
         CALL CSSCAL(N,S,Z,1)                                           00002240
         YNORM = S*YNORM                                                00002250
C                                                                       00002260
C        SOLVE  R*Z = W                                                 00002270
C                                                                       00002280
         DO 170 KB = 1, N                                               00002290
            K = N + 1 - KB                                              00002300
            IF (CABS1(Z(K)) .LE. REAL(ABD(M+1,K))) GO TO 160            00002310
               S = REAL(ABD(M+1,K))/CABS1(Z(K))                         00002320
               CALL CSSCAL(N,S,Z,1)                                     00002330
               YNORM = S*YNORM                                          00002340
  160       CONTINUE                                                    00002350
            Z(K) = Z(K)/ABD(M+1,K)                                      00002360
            LM = MIN0(K-1,M)                                            00002370
            LA = M + 1 - LM                                             00002380
            LB = K - LM                                                 00002390
            T = -Z(K)                                                   00002400
            CALL CAXPY(LM,T,ABD(LA,K),1,Z(LB),1)                        00002410
  170    CONTINUE                                                       00002420
C        MAKE ZNORM = 1.0                                               00002430
         S = 1.0E0/SCASUM(N,Z,1)                                        00002440
         CALL CSSCAL(N,S,Z,1)                                           00002450
         YNORM = S*YNORM                                                00002460
C                                                                       00002470
         IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                      00002480
         IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                            00002490
  180 CONTINUE                                                          00002500
      RETURN                                                            00002510
      END                                                               00002520
