*#**********************************************************************

      SUBROUTINE CPOCO(A,LDA,N,RCOND,Z,INFO)                            00000010

      INTEGER LDA,N,INFO                                                00000020
      COMPLEX A(LDA,1),Z(1)                                             00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CPOCO FACTORS A COMPLEX HERMITIAN POSITIVE DEFINITE MATRIX        00000060
C     AND ESTIMATES THE CONDITION OF THE MATRIX.                        00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, CPOFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW CPOCO BY CPOSL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CPOCO BY CPOSL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CPOCO BY CPODI.               00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW CPOCO BY CPODI.                   00000130
C                                                                       00000140
C     ON ENTRY                                                          00000150
C                                                                       00000160
C        A       COMPLEX(LDA, N)                                        00000170
C                THE HERMITIAN MATRIX TO BE FACTORED.  ONLY THE         00000180
C                DIAGONAL AND UPPER TRIANGLE ARE USED.                  00000190
C                                                                       00000200
C        LDA     INTEGER                                                00000210
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        A       AN UPPER TRIANGULAR MATRIX  R  SO THAT  A =            00000290
C                CTRANS(R)*R WHERE  CTRANS(R)  IS THE CONJUGATE         00000300
C                TRANSPOSE.  THE STRICT LOWER TRIANGLE IS UNALTERED.    00000310
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000320
C                                                                       00000330
C        RCOND   REAL                                                   00000340
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000350
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000360
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000370
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000380
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000390
C                           1.0 + RCOND .EQ. 1.0                        00000400
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000410
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000420
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000430
C                UNDERFLOWS.  IF INFO .NE. 0 , RCOND IS UNCHANGED.      00000440
C                                                                       00000450
C        Z       COMPLEX(N)                                             00000460
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000470
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000480
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000490
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000500
C                IF  INFO .NE. 0 , Z  IS UNCHANGED.                     00000510
C                                                                       00000520
C        INFO    INTEGER                                                00000530
C                = 0  FOR NORMAL RETURN.                                00000540
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000550
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000560
C                                                                       00000570
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000580
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000590
C                                                                       00000600
C     SUBROUTINES AND FUNCTIONS                                         00000610
C                                                                       00000620
C     LINPACK CPOFA                                                     00000630
C     BLAS CAXPY,CDOTC,CSSCAL,SCASUM                                    00000640
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,REAL                          00000650
C                                                                       00000660
C     INTERNAL VARIABLES                                                00000670
C                                                                       00000680
      COMPLEX CDOTC,EK,T,WK,WKM                                         00000690
      REAL ANORM,S,SCASUM,SM,YNORM                                      00000700
      INTEGER I,J,JM1,K,KB,KP1                                          00000710
C                                                                       00000720
      COMPLEX ZDUM,ZDUM2,CSIGN1                                         00000730
      REAL CABS1                                                        00000740
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000750
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000760
C                                                                       00000770
C     FIND NORM OF A USING ONLY UPPER HALF                              00000780
C                                                                       00000790
      DO 30 J = 1, N                                                    00000800
         Z(J) = CMPLX(SCASUM(J,A(1,J),1),0.0E0)                         00000810
         JM1 = J - 1                                                    00000820
         IF (JM1 .LT. 1) GO TO 20                                       00000830
         DO 10 I = 1, JM1                                               00000840
            Z(I) = CMPLX(REAL(Z(I))+CABS1(A(I,J)),0.0E0)                00000850
   10    CONTINUE                                                       00000860
   20    CONTINUE                                                       00000870
   30 CONTINUE                                                          00000880
      ANORM = 0.0E0                                                     00000890
      DO 40 J = 1, N                                                    00000900
         ANORM = AMAX1(ANORM,REAL(Z(J)))                                00000910
   40 CONTINUE                                                          00000920
C                                                                       00000930
C     FACTOR                                                            00000940
C                                                                       00000950
      CALL CPOFA(A,LDA,N,INFO)                                          00000960
      IF (INFO .NE. 0) GO TO 180                                        00000970
C                                                                       00000980
C        RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .           00000990
C        ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .      00001000
C        THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL        00001010
C        GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(R)*W = E .          00001020
C        THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.         00001030
C                                                                       00001040
C        SOLVE CTRANS(R)*W = E                                          00001050
C                                                                       00001060
         EK = (1.0E0,0.0E0)                                             00001070
         DO 50 J = 1, N                                                 00001080
            Z(J) = (0.0E0,0.0E0)                                        00001090
   50    CONTINUE                                                       00001100
         DO 110 K = 1, N                                                00001110
            IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,-Z(K))           00001120
            IF (CABS1(EK-Z(K)) .LE. REAL(A(K,K))) GO TO 60              00001130
               S = REAL(A(K,K))/CABS1(EK-Z(K))                          00001140
               CALL CSSCAL(N,S,Z,1)                                     00001150
               EK = CMPLX(S,0.0E0)*EK                                   00001160
   60       CONTINUE                                                    00001170
            WK = EK - Z(K)                                              00001180
            WKM = -EK - Z(K)                                            00001190
            S = CABS1(WK)                                               00001200
            SM = CABS1(WKM)                                             00001210
            WK = WK/A(K,K)                                              00001220
            WKM = WKM/A(K,K)                                            00001230
            KP1 = K + 1                                                 00001240
            IF (KP1 .GT. N) GO TO 100                                   00001250
               DO 70 J = KP1, N                                         00001260
                  SM = SM + CABS1(Z(J)+WKM*CONJG(A(K,J)))               00001270
                  Z(J) = Z(J) + WK*CONJG(A(K,J))                        00001280
                  S = S + CABS1(Z(J))                                   00001290
   70          CONTINUE                                                 00001300
               IF (S .GE. SM) GO TO 90                                  00001310
                  T = WKM - WK                                          00001320
                  WK = WKM                                              00001330
                  DO 80 J = KP1, N                                      00001340
                     Z(J) = Z(J) + T*CONJG(A(K,J))                      00001350
   80             CONTINUE                                              00001360
   90          CONTINUE                                                 00001370
  100       CONTINUE                                                    00001380
            Z(K) = WK                                                   00001390
  110    CONTINUE                                                       00001400
         S = 1.0E0/SCASUM(N,Z,1)                                        00001410
         CALL CSSCAL(N,S,Z,1)                                           00001420
C                                                                       00001430
C        SOLVE R*Y = W                                                  00001440
C                                                                       00001450
         DO 130 KB = 1, N                                               00001460
            K = N + 1 - KB                                              00001470
            IF (CABS1(Z(K)) .LE. REAL(A(K,K))) GO TO 120                00001480
               S = REAL(A(K,K))/CABS1(Z(K))                             00001490
               CALL CSSCAL(N,S,Z,1)                                     00001500
  120       CONTINUE                                                    00001510
            Z(K) = Z(K)/A(K,K)                                          00001520
            T = -Z(K)                                                   00001530
            CALL CAXPY(K-1,T,A(1,K),1,Z(1),1)                           00001540
  130    CONTINUE                                                       00001550
         S = 1.0E0/SCASUM(N,Z,1)                                        00001560
         CALL CSSCAL(N,S,Z,1)                                           00001570
C                                                                       00001580
         YNORM = 1.0E0                                                  00001590
C                                                                       00001600
C        SOLVE CTRANS(R)*V = Y                                          00001610
C                                                                       00001620
         DO 150 K = 1, N                                                00001630
            Z(K) = Z(K) - CDOTC(K-1,A(1,K),1,Z(1),1)                    00001640
            IF (CABS1(Z(K)) .LE. REAL(A(K,K))) GO TO 140                00001650
               S = REAL(A(K,K))/CABS1(Z(K))                             00001660
               CALL CSSCAL(N,S,Z,1)                                     00001670
               YNORM = S*YNORM                                          00001680
  140       CONTINUE                                                    00001690
            Z(K) = Z(K)/A(K,K)                                          00001700
  150    CONTINUE                                                       00001710
         S = 1.0E0/SCASUM(N,Z,1)                                        00001720
         CALL CSSCAL(N,S,Z,1)                                           00001730
         YNORM = S*YNORM                                                00001740
C                                                                       00001750
C        SOLVE R*Z = V                                                  00001760
C                                                                       00001770
         DO 170 KB = 1, N                                               00001780
            K = N + 1 - KB                                              00001790
            IF (CABS1(Z(K)) .LE. REAL(A(K,K))) GO TO 160                00001800
               S = REAL(A(K,K))/CABS1(Z(K))                             00001810
               CALL CSSCAL(N,S,Z,1)                                     00001820
               YNORM = S*YNORM                                          00001830
  160       CONTINUE                                                    00001840
            Z(K) = Z(K)/A(K,K)                                          00001850
            T = -Z(K)                                                   00001860
            CALL CAXPY(K-1,T,A(1,K),1,Z(1),1)                           00001870
  170    CONTINUE                                                       00001880
C        MAKE ZNORM = 1.0                                               00001890
         S = 1.0E0/SCASUM(N,Z,1)                                        00001900
         CALL CSSCAL(N,S,Z,1)                                           00001910
         YNORM = S*YNORM                                                00001920
C                                                                       00001930
         IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                      00001940
         IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                            00001950
  180 CONTINUE                                                          00001960
      RETURN                                                            00001970
      END                                                               00001980
