*#**********************************************************************

      SUBROUTINE CPOFA(A,LDA,N,INFO)                                    00000010

      INTEGER LDA,N,INFO                                                00000020
      COMPLEX A(LDA,1)                                                  00000030
C                                                                       00000040
C     CPOFA FACTORS A COMPLEX HERMITIAN POSITIVE DEFINITE MATRIX.       00000050
C                                                                       00000060
C     CPOFA IS USUALLY CALLED BY CPOCO, BUT IT CAN BE CALLED            00000070
C     DIRECTLY WITH A SAVING IN TIME IF  RCOND  IS NOT NEEDED.          00000080
C     (TIME FOR CPOCO) = (1 + 18/N)*(TIME FOR CPOFA) .                  00000090
C                                                                       00000100
C     ON ENTRY                                                          00000110
C                                                                       00000120
C        A       COMPLEX(LDA, N)                                        00000130
C                THE HERMITIAN MATRIX TO BE FACTORED.  ONLY THE         00000140
C                DIAGONAL AND UPPER TRIANGLE ARE USED.                  00000150
C                                                                       00000160
C        LDA     INTEGER                                                00000170
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000180
C                                                                       00000190
C        N       INTEGER                                                00000200
C                THE ORDER OF THE MATRIX  A .                           00000210
C                                                                       00000220
C     ON RETURN                                                         00000230
C                                                                       00000240
C        A       AN UPPER TRIANGULAR MATRIX  R  SO THAT  A =            00000250
C                CTRANS(R)*R WHERE  CTRANS(R)  IS THE CONJUGATE         00000260
C                TRANSPOSE.  THE STRICT LOWER TRIANGLE IS UNALTERED.    00000270
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000280
C                                                                       00000290
C        INFO    INTEGER                                                00000300
C                = 0  FOR NORMAL RETURN.                                00000310
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000320
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000330
C                                                                       00000340
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000350
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000360
C                                                                       00000370
C     SUBROUTINES AND FUNCTIONS                                         00000380
C                                                                       00000390
C     BLAS CDOTC                                                        00000400
C     FORTRAN AIMAG,CMPLX,CONJG,REAL,SQRT                               00000410
C                                                                       00000420
C     INTERNAL VARIABLES                                                00000430
C                                                                       00000440
      COMPLEX CDOTC,T                                                   00000450
      REAL S                                                            00000460
      INTEGER J,JM1,K                                                   00000470
C     BEGIN BLOCK WITH ...EXITS TO 40                                   00000480
C                                                                       00000490
C                                                                       00000500
         DO 30 J = 1, N                                                 00000510
            INFO = J                                                    00000520
            S = 0.0E0                                                   00000530
            JM1 = J - 1                                                 00000540
            IF (JM1 .LT. 1) GO TO 20                                    00000550
            DO 10 K = 1, JM1                                            00000560
               T = A(K,J) - CDOTC(K-1,A(1,K),1,A(1,J),1)                00000570
               T = T/A(K,K)                                             00000580
               A(K,J) = T                                               00000590
               S = S + REAL(T*CONJG(T))                                 00000600
   10       CONTINUE                                                    00000610
   20       CONTINUE                                                    00000620
            S = REAL(A(J,J)) - S                                        00000630
C     ......EXIT                                                        00000640
            IF (S .LE. 0.0E0 .OR. AIMAG(A(J,J)) .NE. 0.0E0) GO TO 40    00000650
            A(J,J) = CMPLX(SQRT(S),0.0E0)                               00000660
   30    CONTINUE                                                       00000670
         INFO = 0                                                       00000680
   40 CONTINUE                                                          00000690
      RETURN                                                            00000700
      END                                                               00000710
