*#**********************************************************************

      SUBROUTINE CPOSL(A,LDA,N,B)                                       00000010

      INTEGER LDA,N                                                     00000020
      COMPLEX A(LDA,1),B(1)                                             00000030
C                                                                       00000040
C     CPOSL SOLVES THE COMPLEX HERMITIAN POSITIVE DEFINITE SYSTEM       00000050
C     A * X = B                                                         00000060
C     USING THE FACTORS COMPUTED BY CPOCO OR CPOFA.                     00000070
C                                                                       00000080
C     ON ENTRY                                                          00000090
C                                                                       00000100
C        A       COMPLEX(LDA, N)                                        00000110
C                THE OUTPUT FROM CPOCO OR CPOFA.                        00000120
C                                                                       00000130
C        LDA     INTEGER                                                00000140
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000150
C                                                                       00000160
C        N       INTEGER                                                00000170
C                THE ORDER OF THE MATRIX  A .                           00000180
C                                                                       00000190
C        B       COMPLEX(N)                                             00000200
C                THE RIGHT HAND SIDE VECTOR.                            00000210
C                                                                       00000220
C     ON RETURN                                                         00000230
C                                                                       00000240
C        B       THE SOLUTION VECTOR  X .                               00000250
C                                                                       00000260
C     ERROR CONDITION                                                   00000270
C                                                                       00000280
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS     00000290
C        A ZERO ON THE DIAGONAL.  TECHNICALLY THIS INDICATES            00000300
C        SINGULARITY BUT IT IS USUALLY CAUSED BY IMPROPER SUBROUTINE    00000310
C        ARGUMENTS.  IT WILL NOT OCCUR IF THE SUBROUTINES ARE CALLED    00000320
C        CORRECTLY AND  INFO .EQ. 0 .                                   00000330
C                                                                       00000340
C     TO COMPUTE  INVERSE(A) * C  WHERE  C  IS A MATRIX                 00000350
C     WITH  P  COLUMNS                                                  00000360
C           CALL CPOCO(A,LDA,N,RCOND,Z,INFO)                            00000370
C           IF (RCOND IS TOO SMALL .OR. INFO .NE. 0) GO TO ...          00000380
C           DO 10 J = 1, P                                              00000390
C              CALL CPOSL(A,LDA,N,C(1,J))                               00000400
C        10 CONTINUE                                                    00000410
C                                                                       00000420
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000430
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000440
C                                                                       00000450
C     SUBROUTINES AND FUNCTIONS                                         00000460
C                                                                       00000470
C     BLAS CAXPY,CDOTC                                                  00000480
C                                                                       00000490
C     INTERNAL VARIABLES                                                00000500
C                                                                       00000510
      COMPLEX CDOTC,T                                                   00000520
      INTEGER K,KB                                                      00000530
C                                                                       00000540
C     SOLVE CTRANS(R)*Y = B                                             00000550
C                                                                       00000560
      DO 10 K = 1, N                                                    00000570
         T = CDOTC(K-1,A(1,K),1,B(1),1)                                 00000580
         B(K) = (B(K) - T)/A(K,K)                                       00000590
   10 CONTINUE                                                          00000600
C                                                                       00000610
C     SOLVE R*X = Y                                                     00000620
C                                                                       00000630
      DO 20 KB = 1, N                                                   00000640
         K = N + 1 - KB                                                 00000650
         B(K) = B(K)/A(K,K)                                             00000660
         T = -B(K)                                                      00000670
         CALL CAXPY(K-1,T,A(1,K),1,B(1),1)                              00000680
   20 CONTINUE                                                          00000690
      RETURN                                                            00000700
      END                                                               00000710
