*#**********************************************************************

      SUBROUTINE CPPCO(AP,N,RCOND,Z,INFO)                               00000010

      INTEGER N,INFO                                                    00000020
      COMPLEX AP(1),Z(1)                                                00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CPPCO FACTORS A COMPLEX HERMITIAN POSITIVE DEFINITE MATRIX        00000060
C     STORED IN PACKED FORM                                             00000070
C     AND ESTIMATES THE CONDITION OF THE MATRIX.                        00000080
C                                                                       00000090
C     IF  RCOND  IS NOT NEEDED, CPPFA IS SLIGHTLY FASTER.               00000100
C     TO SOLVE  A*X = B , FOLLOW CPPCO BY CPPSL.                        00000110
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CPPCO BY CPPSL.                 00000120
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CPPCO BY CPPDI.               00000130
C     TO COMPUTE  INVERSE(A) , FOLLOW CPPCO BY CPPDI.                   00000140
C                                                                       00000150
C     ON ENTRY                                                          00000160
C                                                                       00000170
C        AP      COMPLEX (N*(N+1)/2)                                    00000180
C                THE PACKED FORM OF A HERMITIAN MATRIX  A .  THE        00000190
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000200
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000210
C                SEE COMMENTS BELOW FOR DETAILS.                        00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        AP      AN UPPER TRIANGULAR MATRIX  R , STORED IN PACKED       00000290
C                FORM, SO THAT  A = CTRANS(R)*R .                       00000300
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000310
C                                                                       00000320
C        RCOND   REAL                                                   00000330
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000340
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000350
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000360
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000370
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000380
C                           1.0 + RCOND .EQ. 1.0                        00000390
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000400
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000410
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000420
C                UNDERFLOWS.  IF INFO .NE. 0 , RCOND IS UNCHANGED.      00000430
C                                                                       00000440
C        Z       COMPLEX(N)                                             00000450
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000460
C                IF  A  IS SINGULAR TO WORKING PRECISION, THEN  Z  IS   00000470
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000480
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000490
C                IF  INFO .NE. 0 , Z  IS UNCHANGED.                     00000500
C                                                                       00000510
C        INFO    INTEGER                                                00000520
C                = 0  FOR NORMAL RETURN.                                00000530
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000540
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000550
C                                                                       00000560
C     PACKED STORAGE                                                    00000570
C                                                                       00000580
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000590
C          TRIANGLE OF A HERMITIAN MATRIX.                              00000600
C                                                                       00000610
C                K = 0                                                  00000620
C                DO 20 J = 1, N                                         00000630
C                   DO 10 I = 1, J                                      00000640
C                      K = K + 1                                        00000650
C                      AP(K) = A(I,J)                                   00000660
C             10    CONTINUE                                            00000670
C             20 CONTINUE                                               00000680
C                                                                       00000690
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000700
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000710
C                                                                       00000720
C     SUBROUTINES AND FUNCTIONS                                         00000730
C                                                                       00000740
C     LINPACK CPPFA                                                     00000750
C     BLAS CAXPY,CDOTC,CSSCAL,SCASUM                                    00000760
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,REAL                          00000770
C                                                                       00000780
C     INTERNAL VARIABLES                                                00000790
C                                                                       00000800
      COMPLEX CDOTC,EK,T,WK,WKM                                         00000810
      REAL ANORM,S,SCASUM,SM,YNORM                                      00000820
      INTEGER I,IJ,J,JM1,J1,K,KB,KJ,KK,KP1                              00000830
C                                                                       00000840
      COMPLEX ZDUM,ZDUM2,CSIGN1                                         00000850
      REAL CABS1                                                        00000860
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000870
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000880
C                                                                       00000890
C     FIND NORM OF A                                                    00000900
C                                                                       00000910
      J1 = 1                                                            00000920
      DO 30 J = 1, N                                                    00000930
         Z(J) = CMPLX(SCASUM(J,AP(J1),1),0.0E0)                         00000940
         IJ = J1                                                        00000950
         J1 = J1 + J                                                    00000960
         JM1 = J - 1                                                    00000970
         IF (JM1 .LT. 1) GO TO 20                                       00000980
         DO 10 I = 1, JM1                                               00000990
            Z(I) = CMPLX(REAL(Z(I))+CABS1(AP(IJ)),0.0E0)                00001000
            IJ = IJ + 1                                                 00001010
   10    CONTINUE                                                       00001020
   20    CONTINUE                                                       00001030
   30 CONTINUE                                                          00001040
      ANORM = 0.0E0                                                     00001050
      DO 40 J = 1, N                                                    00001060
         ANORM = AMAX1(ANORM,REAL(Z(J)))                                00001070
   40 CONTINUE                                                          00001080
C                                                                       00001090
C     FACTOR                                                            00001100
C                                                                       00001110
      CALL CPPFA(AP,N,INFO)                                             00001120
      IF (INFO .NE. 0) GO TO 180                                        00001130
C                                                                       00001140
C        RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .           00001150
C        ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .      00001160
C        THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL        00001170
C        GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(R)*W = E .          00001180
C        THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.         00001190
C                                                                       00001200
C        SOLVE CTRANS(R)*W = E                                          00001210
C                                                                       00001220
         EK = (1.0E0,0.0E0)                                             00001230
         DO 50 J = 1, N                                                 00001240
            Z(J) = (0.0E0,0.0E0)                                        00001250
   50    CONTINUE                                                       00001260
         KK = 0                                                         00001270
         DO 110 K = 1, N                                                00001280
            KK = KK + K                                                 00001290
            IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,-Z(K))           00001300
            IF (CABS1(EK-Z(K)) .LE. REAL(AP(KK))) GO TO 60              00001310
               S = REAL(AP(KK))/CABS1(EK-Z(K))                          00001320
               CALL CSSCAL(N,S,Z,1)                                     00001330
               EK = CMPLX(S,0.0E0)*EK                                   00001340
   60       CONTINUE                                                    00001350
            WK = EK - Z(K)                                              00001360
            WKM = -EK - Z(K)                                            00001370
            S = CABS1(WK)                                               00001380
            SM = CABS1(WKM)                                             00001390
            WK = WK/AP(KK)                                              00001400
            WKM = WKM/AP(KK)                                            00001410
            KP1 = K + 1                                                 00001420
            KJ = KK + K                                                 00001430
            IF (KP1 .GT. N) GO TO 100                                   00001440
               DO 70 J = KP1, N                                         00001450
                  SM = SM + CABS1(Z(J)+WKM*CONJG(AP(KJ)))               00001460
                  Z(J) = Z(J) + WK*CONJG(AP(KJ))                        00001470
                  S = S + CABS1(Z(J))                                   00001480
                  KJ = KJ + J                                           00001490
   70          CONTINUE                                                 00001500
               IF (S .GE. SM) GO TO 90                                  00001510
                  T = WKM - WK                                          00001520
                  WK = WKM                                              00001530
                  KJ = KK + K                                           00001540
                  DO 80 J = KP1, N                                      00001550
                     Z(J) = Z(J) + T*CONJG(AP(KJ))                      00001560
                     KJ = KJ + J                                        00001570
   80             CONTINUE                                              00001580
   90          CONTINUE                                                 00001590
  100       CONTINUE                                                    00001600
            Z(K) = WK                                                   00001610
  110    CONTINUE                                                       00001620
         S = 1.0E0/SCASUM(N,Z,1)                                        00001630
         CALL CSSCAL(N,S,Z,1)                                           00001640
C                                                                       00001650
C        SOLVE R*Y = W                                                  00001660
C                                                                       00001670
         DO 130 KB = 1, N                                               00001680
            K = N + 1 - KB                                              00001690
            IF (CABS1(Z(K)) .LE. REAL(AP(KK))) GO TO 120                00001700
               S = REAL(AP(KK))/CABS1(Z(K))                             00001710
               CALL CSSCAL(N,S,Z,1)                                     00001720
  120       CONTINUE                                                    00001730
            Z(K) = Z(K)/AP(KK)                                          00001740
            KK = KK - K                                                 00001750
            T = -Z(K)                                                   00001760
            CALL CAXPY(K-1,T,AP(KK+1),1,Z(1),1)                         00001770
  130    CONTINUE                                                       00001780
         S = 1.0E0/SCASUM(N,Z,1)                                        00001790
         CALL CSSCAL(N,S,Z,1)                                           00001800
C                                                                       00001810
         YNORM = 1.0E0                                                  00001820
C                                                                       00001830
C        SOLVE CTRANS(R)*V = Y                                          00001840
C                                                                       00001850
         DO 150 K = 1, N                                                00001860
            Z(K) = Z(K) - CDOTC(K-1,AP(KK+1),1,Z(1),1)                  00001870
            KK = KK + K                                                 00001880
            IF (CABS1(Z(K)) .LE. REAL(AP(KK))) GO TO 140                00001890
               S = REAL(AP(KK))/CABS1(Z(K))                             00001900
               CALL CSSCAL(N,S,Z,1)                                     00001910
               YNORM = S*YNORM                                          00001920
  140       CONTINUE                                                    00001930
            Z(K) = Z(K)/AP(KK)                                          00001940
  150    CONTINUE                                                       00001950
         S = 1.0E0/SCASUM(N,Z,1)                                        00001960
         CALL CSSCAL(N,S,Z,1)                                           00001970
         YNORM = S*YNORM                                                00001980
C                                                                       00001990
C        SOLVE R*Z = V                                                  00002000
C                                                                       00002010
         DO 170 KB = 1, N                                               00002020
            K = N + 1 - KB                                              00002030
            IF (CABS1(Z(K)) .LE. REAL(AP(KK))) GO TO 160                00002040
               S = REAL(AP(KK))/CABS1(Z(K))                             00002050
               CALL CSSCAL(N,S,Z,1)                                     00002060
               YNORM = S*YNORM                                          00002070
  160       CONTINUE                                                    00002080
            Z(K) = Z(K)/AP(KK)                                          00002090
            KK = KK - K                                                 00002100
            T = -Z(K)                                                   00002110
            CALL CAXPY(K-1,T,AP(KK+1),1,Z(1),1)                         00002120
  170    CONTINUE                                                       00002130
C        MAKE ZNORM = 1.0                                               00002140
         S = 1.0E0/SCASUM(N,Z,1)                                        00002150
         CALL CSSCAL(N,S,Z,1)                                           00002160
         YNORM = S*YNORM                                                00002170
C                                                                       00002180
         IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                      00002190
         IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                            00002200
  180 CONTINUE                                                          00002210
      RETURN                                                            00002220
      END                                                               00002230
