*#**********************************************************************

      SUBROUTINE CSIFA(A,LDA,N,KPVT,INFO)                               00000010

      INTEGER LDA,N,KPVT(1),INFO                                        00000020
      COMPLEX A(LDA,1)                                                  00000030
C                                                                       00000040
C     CSIFA FACTORS A COMPLEX SYMMETRIC MATRIX BY ELIMINATION           00000050
C     WITH SYMMETRIC PIVOTING.                                          00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW CSIFA BY CSISL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CSIFA BY CSISL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CSIFA BY CSIDI.               00000100
C     TO COMPUTE  INVERSE(A) , FOLLOW CSIFA BY CSIDI.                   00000110
C                                                                       00000120
C     ON ENTRY                                                          00000130
C                                                                       00000140
C        A       COMPLEX(LDA,N)                                         00000150
C                THE SYMMETRIC MATRIX TO BE FACTORED.                   00000160
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000170
C                                                                       00000180
C        LDA     INTEGER                                                00000190
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000200
C                                                                       00000210
C        N       INTEGER                                                00000220
C                THE ORDER OF THE MATRIX  A .                           00000230
C                                                                       00000240
C     ON RETURN                                                         00000250
C                                                                       00000260
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000270
C                WERE USED TO OBTAIN IT.                                00000280
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000290
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000300
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000310
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000320
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000330
C                                                                       00000340
C        KPVT    INTEGER(N)                                             00000350
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000360
C                                                                       00000370
C        INFO    INTEGER                                                00000380
C                = 0  NORMAL VALUE.                                     00000390
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000400
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000410
C                     BUT IT DOES INDICATE THAT CSISL OR CSIDI MAY      00000420
C                     DIVIDE BY ZERO IF CALLED.                         00000430
C                                                                       00000440
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000450
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000460
C                                                                       00000470
C     SUBROUTINES AND FUNCTIONS                                         00000480
C                                                                       00000490
C     BLAS CAXPY,CSWAP,ICAMAX                                           00000500
C     FORTRAN ABS,AIMAG,AMAX1,REAL,SQRT                                 00000510
C                                                                       00000520
C     INTERNAL VARIABLES                                                00000530
C                                                                       00000540
      COMPLEX AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T                       00000550
      REAL ABSAKK,ALPHA,COLMAX,ROWMAX                                   00000560
      INTEGER IMAX,IMAXP1,J,JJ,JMAX,K,KM1,KM2,KSTEP,ICAMAX              00000570
      LOGICAL SWAP                                                      00000580
C                                                                       00000590
      COMPLEX ZDUM                                                      00000600
      REAL CABS1                                                        00000610
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000620
C                                                                       00000630
C     INITIALIZE                                                        00000640
C                                                                       00000650
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000660
      ALPHA = (1.0E0 + SQRT(17.0E0))/8.0E0                              00000670
C                                                                       00000680
      INFO = 0                                                          00000690
C                                                                       00000700
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000710
C                                                                       00000720
      K = N                                                             00000730
   10 CONTINUE                                                          00000740
C                                                                       00000750
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000760
C                                                                       00000770
C     ...EXIT                                                           00000780
         IF (K .EQ. 0) GO TO 200                                        00000790
         IF (K .GT. 1) GO TO 20                                         00000800
            KPVT(1) = 1                                                 00000810
            IF (CABS1(A(1,1)) .EQ. 0.0E0) INFO = 1                      00000820
C     ......EXIT                                                        00000830
            GO TO 200                                                   00000840
   20    CONTINUE                                                       00000850
C                                                                       00000860
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00000870
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00000880
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00000890
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00000900
C        REQUIRED.                                                      00000910
C                                                                       00000920
         KM1 = K - 1                                                    00000930
         ABSAKK = CABS1(A(K,K))                                         00000940
C                                                                       00000950
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00000960
C        COLUMN K.                                                      00000970
C                                                                       00000980
         IMAX = ICAMAX(K-1,A(1,K),1)                                    00000990
         COLMAX = CABS1(A(IMAX,K))                                      00001000
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00001010
            KSTEP = 1                                                   00001020
            SWAP = .FALSE.                                              00001030
         GO TO 90                                                       00001040
   30    CONTINUE                                                       00001050
C                                                                       00001060
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001070
C           ROW IMAX.                                                   00001080
C                                                                       00001090
            ROWMAX = 0.0E0                                              00001100
            IMAXP1 = IMAX + 1                                           00001110
            DO 40 J = IMAXP1, K                                         00001120
               ROWMAX = AMAX1(ROWMAX,CABS1(A(IMAX,J)))                  00001130
   40       CONTINUE                                                    00001140
            IF (IMAX .EQ. 1) GO TO 50                                   00001150
               JMAX = ICAMAX(IMAX-1,A(1,IMAX),1)                        00001160
               ROWMAX = AMAX1(ROWMAX,CABS1(A(JMAX,IMAX)))               00001170
   50       CONTINUE                                                    00001180
            IF (CABS1(A(IMAX,IMAX)) .LT. ALPHA*ROWMAX) GO TO 60         00001190
               KSTEP = 1                                                00001200
               SWAP = .TRUE.                                            00001210
            GO TO 80                                                    00001220
   60       CONTINUE                                                    00001230
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001240
               KSTEP = 1                                                00001250
               SWAP = .FALSE.                                           00001260
            GO TO 80                                                    00001270
   70       CONTINUE                                                    00001280
               KSTEP = 2                                                00001290
               SWAP = IMAX .NE. KM1                                     00001300
   80       CONTINUE                                                    00001310
   90    CONTINUE                                                       00001320
         IF (AMAX1(ABSAKK,COLMAX) .NE. 0.0E0) GO TO 100                 00001330
C                                                                       00001340
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001350
C                                                                       00001360
            KPVT(K) = K                                                 00001370
            INFO = K                                                    00001380
         GO TO 190                                                      00001390
  100    CONTINUE                                                       00001400
         IF (KSTEP .EQ. 2) GO TO 140                                    00001410
C                                                                       00001420
C           1 X 1 PIVOT BLOCK.                                          00001430
C                                                                       00001440
            IF (.NOT.SWAP) GO TO 120                                    00001450
C                                                                       00001460
C              PERFORM AN INTERCHANGE.                                  00001470
C                                                                       00001480
               CALL CSWAP(IMAX,A(1,IMAX),1,A(1,K),1)                    00001490
               DO 110 JJ = IMAX, K                                      00001500
                  J = K + IMAX - JJ                                     00001510
                  T = A(J,K)                                            00001520
                  A(J,K) = A(IMAX,J)                                    00001530
                  A(IMAX,J) = T                                         00001540
  110          CONTINUE                                                 00001550
  120       CONTINUE                                                    00001560
C                                                                       00001570
C           PERFORM THE ELIMINATION.                                    00001580
C                                                                       00001590
            DO 130 JJ = 1, KM1                                          00001600
               J = K - JJ                                               00001610
               MULK = -A(J,K)/A(K,K)                                    00001620
               T = MULK                                                 00001630
               CALL CAXPY(J,T,A(1,K),1,A(1,J),1)                        00001640
               A(J,K) = MULK                                            00001650
  130       CONTINUE                                                    00001660
C                                                                       00001670
C           SET THE PIVOT ARRAY.                                        00001680
C                                                                       00001690
            KPVT(K) = K                                                 00001700
            IF (SWAP) KPVT(K) = IMAX                                    00001710
         GO TO 190                                                      00001720
  140    CONTINUE                                                       00001730
C                                                                       00001740
C           2 X 2 PIVOT BLOCK.                                          00001750
C                                                                       00001760
            IF (.NOT.SWAP) GO TO 160                                    00001770
C                                                                       00001780
C              PERFORM AN INTERCHANGE.                                  00001790
C                                                                       00001800
               CALL CSWAP(IMAX,A(1,IMAX),1,A(1,K-1),1)                  00001810
               DO 150 JJ = IMAX, KM1                                    00001820
                  J = KM1 + IMAX - JJ                                   00001830
                  T = A(J,K-1)                                          00001840
                  A(J,K-1) = A(IMAX,J)                                  00001850
                  A(IMAX,J) = T                                         00001860
  150          CONTINUE                                                 00001870
               T = A(K-1,K)                                             00001880
               A(K-1,K) = A(IMAX,K)                                     00001890
               A(IMAX,K) = T                                            00001900
  160       CONTINUE                                                    00001910
C                                                                       00001920
C           PERFORM THE ELIMINATION.                                    00001930
C                                                                       00001940
            KM2 = K - 2                                                 00001950
            IF (KM2 .EQ. 0) GO TO 180                                   00001960
               AK = A(K,K)/A(K-1,K)                                     00001970
               AKM1 = A(K-1,K-1)/A(K-1,K)                               00001980
               DENOM = 1.0E0 - AK*AKM1                                  00001990
               DO 170 JJ = 1, KM2                                       00002000
                  J = KM1 - JJ                                          00002010
                  BK = A(J,K)/A(K-1,K)                                  00002020
                  BKM1 = A(J,K-1)/A(K-1,K)                              00002030
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002040
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002050
                  T = MULK                                              00002060
                  CALL CAXPY(J,T,A(1,K),1,A(1,J),1)                     00002070
                  T = MULKM1                                            00002080
                  CALL CAXPY(J,T,A(1,K-1),1,A(1,J),1)                   00002090
                  A(J,K) = MULK                                         00002100
                  A(J,K-1) = MULKM1                                     00002110
  170          CONTINUE                                                 00002120
  180       CONTINUE                                                    00002130
C                                                                       00002140
C           SET THE PIVOT ARRAY.                                        00002150
C                                                                       00002160
            KPVT(K) = 1 - K                                             00002170
            IF (SWAP) KPVT(K) = -IMAX                                   00002180
            KPVT(K-1) = KPVT(K)                                         00002190
  190    CONTINUE                                                       00002200
         K = K - KSTEP                                                  00002210
      GO TO 10                                                          00002220
  200 CONTINUE                                                          00002230
      RETURN                                                            00002240
      END                                                               00002250
