*#**********************************************************************

      SUBROUTINE CSPCO(AP,N,KPVT,RCOND,Z)                               00000010

      INTEGER N,KPVT(1)                                                 00000020
      COMPLEX AP(1),Z(1)                                                00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CSPCO FACTORS A COMPLEX SYMMETRIC MATRIX STORED IN PACKED         00000060
C     FORM BY ELIMINATION WITH SYMMETRIC PIVOTING AND ESTIMATES         00000070
C     THE CONDITION OF THE MATRIX.                                      00000080
C                                                                       00000090
C     IF  RCOND  IS NOT NEEDED, CSPFA IS SLIGHTLY FASTER.               00000100
C     TO SOLVE  A*X = B , FOLLOW CSPCO BY CSPSL.                        00000110
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CSPCO BY CSPSL.                 00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW CSPCO BY CSPDI.                   00000130
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CSPCO BY CSPDI.               00000140
C                                                                       00000150
C     ON ENTRY                                                          00000160
C                                                                       00000170
C        AP      COMPLEX (N*(N+1)/2)                                    00000180
C                THE PACKED FORM OF A SYMMETRIC MATRIX  A .  THE        00000190
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000200
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000210
C                SEE COMMENTS BELOW FOR DETAILS.                        00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000290
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000300
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000310
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000320
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000330
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000340
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000350
C                                                                       00000360
C        KPVT    INTEGER(N)                                             00000370
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000380
C                                                                       00000390
C        RCOND   REAL                                                   00000400
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000410
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000420
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000430
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000440
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000450
C                           1.0 + RCOND .EQ. 1.0                        00000460
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000470
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000480
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000490
C                UNDERFLOWS.                                            00000500
C                                                                       00000510
C        Z       COMPLEX(N)                                             00000520
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000530
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000540
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000550
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000560
C                                                                       00000570
C     PACKED STORAGE                                                    00000580
C                                                                       00000590
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000600
C          TRIANGLE OF A SYMMETRIC MATRIX.                              00000610
C                                                                       00000620
C                K = 0                                                  00000630
C                DO 20 J = 1, N                                         00000640
C                   DO 10 I = 1, J                                      00000650
C                      K = K + 1                                        00000660
C                      AP(K) = A(I,J)                                   00000670
C             10    CONTINUE                                            00000680
C             20 CONTINUE                                               00000690
C                                                                       00000700
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000710
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000720
C                                                                       00000730
C     SUBROUTINES AND FUNCTIONS                                         00000740
C                                                                       00000750
C     LINPACK CSPFA                                                     00000760
C     BLAS CAXPY,CDOTU,CSSCAL,SCASUM                                    00000770
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,IABS,REAL                           00000780
C                                                                       00000790
C     INTERNAL VARIABLES                                                00000800
C                                                                       00000810
      COMPLEX AK,AKM1,BK,BKM1,CDOTU,DENOM,EK,T                          00000820
      REAL ANORM,S,SCASUM,YNORM                                         00000830
      INTEGER I,IJ,IK,IKM1,IKP1,INFO,J,JM1,J1                           00000840
      INTEGER K,KK,KM1K,KM1KM1,KP,KPS,KS                                00000850
C                                                                       00000860
      COMPLEX ZDUM,ZDUM2,CSIGN1                                         00000870
      REAL CABS1                                                        00000880
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000890
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000900
C                                                                       00000910
C     FIND NORM OF A USING ONLY UPPER HALF                              00000920
C                                                                       00000930
      J1 = 1                                                            00000940
      DO 30 J = 1, N                                                    00000950
         Z(J) = CMPLX(SCASUM(J,AP(J1),1),0.0E0)                         00000960
         IJ = J1                                                        00000970
         J1 = J1 + J                                                    00000980
         JM1 = J - 1                                                    00000990
         IF (JM1 .LT. 1) GO TO 20                                       00001000
         DO 10 I = 1, JM1                                               00001010
            Z(I) = CMPLX(REAL(Z(I))+CABS1(AP(IJ)),0.0E0)                00001020
            IJ = IJ + 1                                                 00001030
   10    CONTINUE                                                       00001040
   20    CONTINUE                                                       00001050
   30 CONTINUE                                                          00001060
      ANORM = 0.0E0                                                     00001070
      DO 40 J = 1, N                                                    00001080
         ANORM = AMAX1(ANORM,REAL(Z(J)))                                00001090
   40 CONTINUE                                                          00001100
C                                                                       00001110
C     FACTOR                                                            00001120
C                                                                       00001130
      CALL CSPFA(AP,N,KPVT,INFO)                                        00001140
C                                                                       00001150
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00001160
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00001170
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001180
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00001190
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001200
C                                                                       00001210
C     SOLVE U*D*W = E                                                   00001220
C                                                                       00001230
      EK = (1.0E0,0.0E0)                                                00001240
      DO 50 J = 1, N                                                    00001250
         Z(J) = (0.0E0,0.0E0)                                           00001260
   50 CONTINUE                                                          00001270
      K = N                                                             00001280
      IK = (N*(N - 1))/2                                                00001290
   60 IF (K .EQ. 0) GO TO 120                                           00001300
         KK = IK + K                                                    00001310
         IKM1 = IK - (K - 1)                                            00001320
         KS = 1                                                         00001330
         IF (KPVT(K) .LT. 0) KS = 2                                     00001340
         KP = IABS(KPVT(K))                                             00001350
         KPS = K + 1 - KS                                               00001360
         IF (KP .EQ. KPS) GO TO 70                                      00001370
            T = Z(KPS)                                                  00001380
            Z(KPS) = Z(KP)                                              00001390
            Z(KP) = T                                                   00001400
   70    CONTINUE                                                       00001410
         IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,Z(K))               00001420
         Z(K) = Z(K) + EK                                               00001430
         CALL CAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                        00001440
         IF (KS .EQ. 1) GO TO 80                                        00001450
            IF (CABS1(Z(K-1)) .NE. 0.0E0) EK = CSIGN1(EK,Z(K-1))        00001460
            Z(K-1) = Z(K-1) + EK                                        00001470
            CALL CAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)                 00001480
   80    CONTINUE                                                       00001490
         IF (KS .EQ. 2) GO TO 100                                       00001500
            IF (CABS1(Z(K)) .LE. CABS1(AP(KK))) GO TO 90                00001510
               S = CABS1(AP(KK))/CABS1(Z(K))                            00001520
               CALL CSSCAL(N,S,Z,1)                                     00001530
               EK = CMPLX(S,0.0E0)*EK                                   00001540
   90       CONTINUE                                                    00001550
            IF (CABS1(AP(KK)) .NE. 0.0E0) Z(K) = Z(K)/AP(KK)            00001560
            IF (CABS1(AP(KK)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)          00001570
         GO TO 110                                                      00001580
  100    CONTINUE                                                       00001590
            KM1K = IK + K - 1                                           00001600
            KM1KM1 = IKM1 + K - 1                                       00001610
            AK = AP(KK)/AP(KM1K)                                        00001620
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00001630
            BK = Z(K)/AP(KM1K)                                          00001640
            BKM1 = Z(K-1)/AP(KM1K)                                      00001650
            DENOM = AK*AKM1 - 1.0E0                                     00001660
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001670
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001680
  110    CONTINUE                                                       00001690
         K = K - KS                                                     00001700
         IK = IK - K                                                    00001710
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00001720
      GO TO 60                                                          00001730
  120 CONTINUE                                                          00001740
      S = 1.0E0/SCASUM(N,Z,1)                                           00001750
      CALL CSSCAL(N,S,Z,1)                                              00001760
C                                                                       00001770
C     SOLVE TRANS(U)*Y = W                                              00001780
C                                                                       00001790
      K = 1                                                             00001800
      IK = 0                                                            00001810
  130 IF (K .GT. N) GO TO 160                                           00001820
         KS = 1                                                         00001830
         IF (KPVT(K) .LT. 0) KS = 2                                     00001840
         IF (K .EQ. 1) GO TO 150                                        00001850
            Z(K) = Z(K) + CDOTU(K-1,AP(IK+1),1,Z(1),1)                  00001860
            IKP1 = IK + K                                               00001870
            IF (KS .EQ. 2)                                              00001880
     *         Z(K+1) = Z(K+1) + CDOTU(K-1,AP(IKP1+1),1,Z(1),1)         00001890
            KP = IABS(KPVT(K))                                          00001900
            IF (KP .EQ. K) GO TO 140                                    00001910
               T = Z(K)                                                 00001920
               Z(K) = Z(KP)                                             00001930
               Z(KP) = T                                                00001940
  140       CONTINUE                                                    00001950
  150    CONTINUE                                                       00001960
         IK = IK + K                                                    00001970
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00001980
         K = K + KS                                                     00001990
      GO TO 130                                                         00002000
  160 CONTINUE                                                          00002010
      S = 1.0E0/SCASUM(N,Z,1)                                           00002020
      CALL CSSCAL(N,S,Z,1)                                              00002030
C                                                                       00002040
      YNORM = 1.0E0                                                     00002050
C                                                                       00002060
C     SOLVE U*D*V = Y                                                   00002070
C                                                                       00002080
      K = N                                                             00002090
      IK = N*(N - 1)/2                                                  00002100
  170 IF (K .EQ. 0) GO TO 230                                           00002110
         KK = IK + K                                                    00002120
         IKM1 = IK - (K - 1)                                            00002130
         KS = 1                                                         00002140
         IF (KPVT(K) .LT. 0) KS = 2                                     00002150
         IF (K .EQ. KS) GO TO 190                                       00002160
            KP = IABS(KPVT(K))                                          00002170
            KPS = K + 1 - KS                                            00002180
            IF (KP .EQ. KPS) GO TO 180                                  00002190
               T = Z(KPS)                                               00002200
               Z(KPS) = Z(KP)                                           00002210
               Z(KP) = T                                                00002220
  180       CONTINUE                                                    00002230
            CALL CAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                     00002240
            IF (KS .EQ. 2) CALL CAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)  00002250
  190    CONTINUE                                                       00002260
         IF (KS .EQ. 2) GO TO 210                                       00002270
            IF (CABS1(Z(K)) .LE. CABS1(AP(KK))) GO TO 200               00002280
               S = CABS1(AP(KK))/CABS1(Z(K))                            00002290
               CALL CSSCAL(N,S,Z,1)                                     00002300
               YNORM = S*YNORM                                          00002310
  200       CONTINUE                                                    00002320
            IF (CABS1(AP(KK)) .NE. 0.0E0) Z(K) = Z(K)/AP(KK)            00002330
            IF (CABS1(AP(KK)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)          00002340
         GO TO 220                                                      00002350
  210    CONTINUE                                                       00002360
            KM1K = IK + K - 1                                           00002370
            KM1KM1 = IKM1 + K - 1                                       00002380
            AK = AP(KK)/AP(KM1K)                                        00002390
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00002400
            BK = Z(K)/AP(KM1K)                                          00002410
            BKM1 = Z(K-1)/AP(KM1K)                                      00002420
            DENOM = AK*AKM1 - 1.0E0                                     00002430
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002440
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002450
  220    CONTINUE                                                       00002460
         K = K - KS                                                     00002470
         IK = IK - K                                                    00002480
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00002490
      GO TO 170                                                         00002500
  230 CONTINUE                                                          00002510
      S = 1.0E0/SCASUM(N,Z,1)                                           00002520
      CALL CSSCAL(N,S,Z,1)                                              00002530
      YNORM = S*YNORM                                                   00002540
C                                                                       00002550
C     SOLVE TRANS(U)*Z = V                                              00002560
C                                                                       00002570
      K = 1                                                             00002580
      IK = 0                                                            00002590
  240 IF (K .GT. N) GO TO 270                                           00002600
         KS = 1                                                         00002610
         IF (KPVT(K) .LT. 0) KS = 2                                     00002620
         IF (K .EQ. 1) GO TO 260                                        00002630
            Z(K) = Z(K) + CDOTU(K-1,AP(IK+1),1,Z(1),1)                  00002640
            IKP1 = IK + K                                               00002650
            IF (KS .EQ. 2)                                              00002660
     *         Z(K+1) = Z(K+1) + CDOTU(K-1,AP(IKP1+1),1,Z(1),1)         00002670
            KP = IABS(KPVT(K))                                          00002680
            IF (KP .EQ. K) GO TO 250                                    00002690
               T = Z(K)                                                 00002700
               Z(K) = Z(KP)                                             00002710
               Z(KP) = T                                                00002720
  250       CONTINUE                                                    00002730
  260    CONTINUE                                                       00002740
         IK = IK + K                                                    00002750
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00002760
         K = K + KS                                                     00002770
      GO TO 240                                                         00002780
  270 CONTINUE                                                          00002790
C     MAKE ZNORM = 1.0                                                  00002800
      S = 1.0E0/SCASUM(N,Z,1)                                           00002810
      CALL CSSCAL(N,S,Z,1)                                              00002820
      YNORM = S*YNORM                                                   00002830
C                                                                       00002840
      IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                         00002850
      IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                               00002860
      RETURN                                                            00002870
      END                                                               00002880
