*#**********************************************************************

      SUBROUTINE CSPDI(AP,N,KPVT,DET,WORK,JOB)                          00000010

      INTEGER N,JOB                                                     00000020
      COMPLEX AP(1),WORK(1),DET(2)                                      00000030
      INTEGER KPVT(1)                                                   00000040
C                                                                       00000050
C     CSPDI COMPUTES THE DETERMINANT AND INVERSE                        00000060
C     OF A COMPLEX SYMMETRIC MATRIX USING THE FACTORS FROM CSPFA,       00000070
C     WHERE THE MATRIX IS STORED IN PACKED FORM.                        00000080
C                                                                       00000090
C     ON ENTRY                                                          00000100
C                                                                       00000110
C        AP      COMPLEX (N*(N+1)/2)                                    00000120
C                THE OUTPUT FROM CSPFA.                                 00000130
C                                                                       00000140
C        N       INTEGER                                                00000150
C                THE ORDER OF THE MATRIX A.                             00000160
C                                                                       00000170
C        KPVT    INTEGER(N)                                             00000180
C                THE PIVOT VECTOR FROM CSPFA.                           00000190
C                                                                       00000200
C        WORK    COMPLEX(N)                                             00000210
C                WORK VECTOR.  CONTENTS IGNORED.                        00000220
C                                                                       00000230
C        JOB     INTEGER                                                00000240
C                JOB HAS THE DECIMAL EXPANSION  AB  WHERE               00000250
C                   IF  B .NE. 0, THE INVERSE IS COMPUTED,              00000260
C                   IF  A .NE. 0, THE DETERMINANT IS COMPUTED,          00000270
C                                                                       00000280
C                FOR EXAMPLE, JOB = 11  GIVES BOTH.                     00000290
C                                                                       00000300
C     ON RETURN                                                         00000310
C                                                                       00000320
C        VARIABLES NOT REQUESTED BY JOB ARE NOT USED.                   00000330
C                                                                       00000340
C        AP     CONTAINS THE UPPER TRIANGLE OF THE INVERSE OF           00000350
C               THE ORIGINAL MATRIX, STORED IN PACKED FORM.             00000360
C               THE COLUMNS OF THE UPPER TRIANGLE ARE STORED            00000370
C               SEQUENTIALLY IN A ONE-DIMENSIONAL ARRAY.                00000380
C                                                                       00000390
C        DET    COMPLEX(2)                                              00000400
C               DETERMINANT OF ORIGINAL MATRIX.                         00000410
C               DETERMINANT = DET(1) * 10.0**DET(2)                     00000420
C               WITH 1.0 .LE. ABS(DET(1)) .LT. 10.0                     00000430
C               OR DET(1) = 0.0.                                        00000440
C                                                                       00000450
C     ERROR CONDITION                                                   00000460
C                                                                       00000470
C        A DIVISION BY ZERO WILL OCCUR IF THE INVERSE IS REQUESTED      00000480
C        AND  CSPCO  HAS SET RCOND .EQ. 0.0                             00000490
C        OR  CSPFA  HAS SET  INFO .NE. 0 .                              00000500
C                                                                       00000510
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000520
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000530
C                                                                       00000540
C     SUBROUTINES AND FUNCTIONS                                         00000550
C                                                                       00000560
C     BLAS CAXPY,CCOPY,CDOTU,CSWAP                                      00000570
C     FORTRAN ABS,CMPLX,IABS,MOD,REAL                                   00000580
C                                                                       00000590
C     INTERNAL VARIABLES.                                               00000600
C                                                                       00000610
      COMPLEX AK,AKKP1,AKP1,CDOTU,D,T,TEMP                              00000620
      REAL TEN                                                          00000630
      INTEGER IJ,IK,IKP1,IKS,J,JB,JK,JKP1                               00000640
      INTEGER K,KK,KKP1,KM1,KS,KSJ,KSKP1,KSTEP                          00000650
      LOGICAL NOINV,NODET                                               00000660
C                                                                       00000670
      COMPLEX ZDUM                                                      00000680
      REAL CABS1                                                        00000690
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000700
C                                                                       00000710
      NOINV = MOD(JOB,10) .EQ. 0                                        00000720
      NODET = MOD(JOB,100)/10 .EQ. 0                                    00000730
C                                                                       00000740
      IF (NODET) GO TO 110                                              00000750
         DET(1) = (1.0E0,0.0E0)                                         00000760
         DET(2) = (0.0E0,0.0E0)                                         00000770
         TEN = 10.0E0                                                   00000780
         T = (0.0E0,0.0E0)                                              00000790
         IK = 0                                                         00000800
         DO 100 K = 1, N                                                00000810
            KK = IK + K                                                 00000820
            D = AP(KK)                                                  00000830
C                                                                       00000840
C           CHECK IF 1 BY 1                                             00000850
C                                                                       00000860
            IF (KPVT(K) .GT. 0) GO TO 30                                00000870
C                                                                       00000880
C              2 BY 2 BLOCK                                             00000890
C              USE DET (D  T)  =  (D/T * C - T) * T                     00000900
C                      (T  C)                                           00000910
C              TO AVOID UNDERFLOW/OVERFLOW TROUBLES.                    00000920
C              TAKE TWO PASSES THROUGH SCALING.  USE  T  FOR FLAG.      00000930
C                                                                       00000940
               IF (CABS1(T) .NE. 0.0E0) GO TO 10                        00000950
                  IKP1 = IK + K                                         00000960
                  KKP1 = IKP1 + K                                       00000970
                  T = AP(KKP1)                                          00000980
                  D = (D/T)*AP(KKP1+1) - T                              00000990
               GO TO 20                                                 00001000
   10          CONTINUE                                                 00001010
                  D = T                                                 00001020
                  T = (0.0E0,0.0E0)                                     00001030
   20          CONTINUE                                                 00001040
   30       CONTINUE                                                    00001050
C                                                                       00001060
            IF (NODET) GO TO 90                                         00001070
               DET(1) = D*DET(1)                                        00001080
               IF (CABS1(DET(1)) .EQ. 0.0E0) GO TO 80                   00001090
   40             IF (CABS1(DET(1)) .GE. 1.0E0) GO TO 50                00001100
                     DET(1) = CMPLX(TEN,0.0E0)*DET(1)                   00001110
                     DET(2) = DET(2) - (1.0E0,0.0E0)                    00001120
                  GO TO 40                                              00001130
   50             CONTINUE                                              00001140
   60             IF (CABS1(DET(1)) .LT. TEN) GO TO 70                  00001150
                     DET(1) = DET(1)/CMPLX(TEN,0.0E0)                   00001160
                     DET(2) = DET(2) + (1.0E0,0.0E0)                    00001170
                  GO TO 60                                              00001180
   70             CONTINUE                                              00001190
   80          CONTINUE                                                 00001200
   90       CONTINUE                                                    00001210
            IK = IK + K                                                 00001220
  100    CONTINUE                                                       00001230
  110 CONTINUE                                                          00001240
C                                                                       00001250
C     COMPUTE INVERSE(A)                                                00001260
C                                                                       00001270
      IF (NOINV) GO TO 240                                              00001280
         K = 1                                                          00001290
         IK = 0                                                         00001300
  120    IF (K .GT. N) GO TO 230                                        00001310
            KM1 = K - 1                                                 00001320
            KK = IK + K                                                 00001330
            IKP1 = IK + K                                               00001340
            IF (KPVT(K) .LT. 0) GO TO 150                               00001350
C                                                                       00001360
C              1 BY 1                                                   00001370
C                                                                       00001380
               AP(KK) = (1.0E0,0.0E0)/AP(KK)                            00001390
               IF (KM1 .LT. 1) GO TO 140                                00001400
                  CALL CCOPY(KM1,AP(IK+1),1,WORK,1)                     00001410
                  IJ = 0                                                00001420
                  DO 130 J = 1, KM1                                     00001430
                     JK = IK + J                                        00001440
                     AP(JK) = CDOTU(J,AP(IJ+1),1,WORK,1)                00001450
                     CALL CAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IK+1),1)      00001460
                     IJ = IJ + J                                        00001470
  130             CONTINUE                                              00001480
                  AP(KK) = AP(KK) + CDOTU(KM1,WORK,1,AP(IK+1),1)        00001490
  140          CONTINUE                                                 00001500
               KSTEP = 1                                                00001510
            GO TO 190                                                   00001520
  150       CONTINUE                                                    00001530
C                                                                       00001540
C              2 BY 2                                                   00001550
C                                                                       00001560
               KKP1 = IKP1 + K                                          00001570
               T = AP(KKP1)                                             00001580
               AK = AP(KK)/T                                            00001590
               AKP1 = AP(KKP1+1)/T                                      00001600
               AKKP1 = AP(KKP1)/T                                       00001610
               D = T*(AK*AKP1 - (1.0E0,0.0E0))                          00001620
               AP(KK) = AKP1/D                                          00001630
               AP(KKP1+1) = AK/D                                        00001640
               AP(KKP1) = -AKKP1/D                                      00001650
               IF (KM1 .LT. 1) GO TO 180                                00001660
                  CALL CCOPY(KM1,AP(IKP1+1),1,WORK,1)                   00001670
                  IJ = 0                                                00001680
                  DO 160 J = 1, KM1                                     00001690
                     JKP1 = IKP1 + J                                    00001700
                     AP(JKP1) = CDOTU(J,AP(IJ+1),1,WORK,1)              00001710
                     CALL CAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IKP1+1),1)    00001720
                     IJ = IJ + J                                        00001730
  160             CONTINUE                                              00001740
                  AP(KKP1+1) = AP(KKP1+1)                               00001750
     *                         + CDOTU(KM1,WORK,1,AP(IKP1+1),1)         00001760
                  AP(KKP1) = AP(KKP1)                                   00001770
     *                       + CDOTU(KM1,AP(IK+1),1,AP(IKP1+1),1)       00001780
                  CALL CCOPY(KM1,AP(IK+1),1,WORK,1)                     00001790
                  IJ = 0                                                00001800
                  DO 170 J = 1, KM1                                     00001810
                     JK = IK + J                                        00001820
                     AP(JK) = CDOTU(J,AP(IJ+1),1,WORK,1)                00001830
                     CALL CAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IK+1),1)      00001840
                     IJ = IJ + J                                        00001850
  170             CONTINUE                                              00001860
                  AP(KK) = AP(KK) + CDOTU(KM1,WORK,1,AP(IK+1),1)        00001870
  180          CONTINUE                                                 00001880
               KSTEP = 2                                                00001890
  190       CONTINUE                                                    00001900
C                                                                       00001910
C           SWAP                                                        00001920
C                                                                       00001930
            KS = IABS(KPVT(K))                                          00001940
            IF (KS .EQ. K) GO TO 220                                    00001950
               IKS = (KS*(KS - 1))/2                                    00001960
               CALL CSWAP(KS,AP(IKS+1),1,AP(IK+1),1)                    00001970
               KSJ = IK + KS                                            00001980
               DO 200 JB = KS, K                                        00001990
                  J = K + KS - JB                                       00002000
                  JK = IK + J                                           00002010
                  TEMP = AP(JK)                                         00002020
                  AP(JK) = AP(KSJ)                                      00002030
                  AP(KSJ) = TEMP                                        00002040
                  KSJ = KSJ - (J - 1)                                   00002050
  200          CONTINUE                                                 00002060
               IF (KSTEP .EQ. 1) GO TO 210                              00002070
                  KSKP1 = IKP1 + KS                                     00002080
                  TEMP = AP(KSKP1)                                      00002090
                  AP(KSKP1) = AP(KKP1)                                  00002100
                  AP(KKP1) = TEMP                                       00002110
  210          CONTINUE                                                 00002120
  220       CONTINUE                                                    00002130
            IK = IK + K                                                 00002140
            IF (KSTEP .EQ. 2) IK = IK + K + 1                           00002150
            K = K + KSTEP                                               00002160
         GO TO 120                                                      00002170
  230    CONTINUE                                                       00002180
  240 CONTINUE                                                          00002190
      RETURN                                                            00002200
      END                                                               00002210
