*#**********************************************************************

      SUBROUTINE CSVDC(X,LDX,N,P,S,E,U,LDU,V,LDV,WORK,JOB,INFO)         00000010

      INTEGER LDX,N,P,LDU,LDV,JOB,INFO                                  00000020
      COMPLEX X(LDX,1),S(1),E(1),U(LDU,1),V(LDV,1),WORK(1)              00000030
C                                                                       00000040
C                                                                       00000050
C     CSVDC IS A SUBROUTINE TO REDUCE A COMPLEX NXP MATRIX X BY         00000060
C     UNITARY TRANSFORMATIONS U AND V TO DIAGONAL FORM.  THE            00000070
C     DIAGONAL ELEMENTS S(I) ARE THE SINGULAR VALUES OF X.  THE         00000080
C     COLUMNS OF U ARE THE CORRESPONDING LEFT SINGULAR VECTORS,         00000090
C     AND THE COLUMNS OF V THE RIGHT SINGULAR VECTORS.                  00000100
C                                                                       00000110
C     ON ENTRY                                                          00000120
C                                                                       00000130
C         X         COMPLEX(LDX,P), WHERE LDX.GE.N.                     00000140
C                   X CONTAINS THE MATRIX WHOSE SINGULAR VALUE          00000150
C                   DECOMPOSITION IS TO BE COMPUTED.  X IS              00000160
C                   DESTROYED BY CSVDC.                                 00000170
C                                                                       00000180
C         LDX       INTEGER.                                            00000190
C                   LDX IS THE LEADING DIMENSION OF THE ARRAY X.        00000200
C                                                                       00000210
C         N         INTEGER.                                            00000220
C                   N IS THE NUMBER OF COLUMNS OF THE MATRIX X.         00000230
C                                                                       00000240
C         P         INTEGER.                                            00000250
C                   P IS THE NUMBER OF ROWS OF THE MATRIX X.            00000260
C                                                                       00000270
C         LDU       INTEGER.                                            00000280
C                   LDU IS THE LEADING DIMENSION OF THE ARRAY U         00000290
C                   (SEE BELOW).                                        00000300
C                                                                       00000310
C         LDV       INTEGER.                                            00000320
C                   LDV IS THE LEADING DIMENSION OF THE ARRAY V         00000330
C                   (SEE BELOW).                                        00000340
C                                                                       00000350
C         WORK      COMPLEX(N).                                         00000360
C                   WORK IS A SCRATCH ARRAY.                            00000370
C                                                                       00000380
C         JOB       INTEGER.                                            00000390
C                   JOB CONTROLS THE COMPUTATION OF THE SINGULAR        00000400
C                   VECTORS.  IT HAS THE DECIMAL EXPANSION AB           00000410
C                   WITH THE FOLLOWING MEANING                          00000420
C                                                                       00000430
C                        A.EQ.0    DO NOT COMPUTE THE LEFT SINGULAR     00000440
C                                  VECTORS.                             00000450
C                        A.EQ.1    RETURN THE N LEFT SINGULAR VECTORS   00000460
C                                  IN U.                                00000470
C                        A.GE.2    RETURNS THE FIRST MIN(N,P)           00000480
C                                  LEFT SINGULAR VECTORS IN U.          00000490
C                        B.EQ.0    DO NOT COMPUTE THE RIGHT SINGULAR    00000500
C                                  VECTORS.                             00000510
C                        B.EQ.1    RETURN THE RIGHT SINGULAR VECTORS    00000520
C                                  IN V.                                00000530
C                                                                       00000540
C     ON RETURN                                                         00000550
C                                                                       00000560
C         S         COMPLEX(MM), WHERE MM=MIN(N+1,P).                   00000570
C                   THE FIRST MIN(N,P) ENTRIES OF S CONTAIN THE         00000580
C                   SINGULAR VALUES OF X ARRANGED IN DESCENDING         00000590
C                   ORDER OF MAGNITUDE.                                 00000600
C                                                                       00000610
C         E         COMPLEX(P).                                         00000620
C                   E ORDINARILY CONTAINS ZEROS.  HOWEVER SEE THE       00000630
C                   DISCUSSION OF INFO FOR EXCEPTIONS.                  00000640
C                                                                       00000650
C         U         COMPLEX(LDU,K), WHERE LDU.GE.N.  IF JOBA.EQ.1 THEN  00000660
C                                   K.EQ.N, IF JOBA.GE.2 THEN           00000670
C                                   K.EQ.MIN(N,P).                      00000680
C                   U CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.    00000690
C                   U IS NOT REFERENCED IF JOBA.EQ.0.  IF N.LE.P        00000700
C                   OR IF JOBA.GT.2, THEN U MAY BE IDENTIFIED WITH X    00000710
C                   IN THE SUBROUTINE CALL.                             00000720
C                                                                       00000730
C         V         COMPLEX(LDV,P), WHERE LDV.GE.P.                     00000740
C                   V CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.    00000750
C                   V IS NOT REFERENCED IF JOBB.EQ.0.  IF P.LE.N,       00000760
C                   THEN V MAY BE IDENTIFIED WHTH X IN THE              00000770
C                   SUBROUTINE CALL.                                    00000780
C                                                                       00000790
C         INFO      INTEGER.                                            00000800
C                   THE SINGULAR VALUES (AND THEIR CORRESPONDING        00000810
C                   SINGULAR VECTORS) S(INFO+1),S(INFO+2),...,S(M)      00000820
C                   ARE CORRECT (HERE M=MIN(N,P)).  THUS IF             00000830
C                   INFO.EQ.0, ALL THE SINGULAR VALUES AND THEIR        00000840
C                   VECTORS ARE CORRECT.  IN ANY EVENT, THE MATRIX      00000850
C                   B = CTRANS(U)*X*V IS THE BIDIAGONAL MATRIX          00000860
C                   WITH THE ELEMENTS OF S ON ITS DIAGONAL AND THE      00000870
C                   ELEMENTS OF E ON ITS SUPER-DIAGONAL (CTRANS(U)      00000880
C                   IS THE CONJUGATE-TRANSPOSE OF U).  THUS THE         00000890
C                   SINGULAR VALUES OF X AND B ARE THE SAME.            00000900
C                                                                       00000910
C     LINPACK. THIS VERSION DATED 03/19/79 .                            00000920
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00000930
C                                                                       00000940
C     CSVDC USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00000950
C                                                                       00000960
C     EXTERNAL CSROT                                                    00000970
C     BLAS CAXPY,CDOTC,CSCAL,CSWAP,SCNRM2,SROTG                         00000980
C     FORTRAN ABS,AIMAG,AMAX1,CABS,CMPLX                                00000990
C     FORTRAN CONJG,MAX0,MIN0,MOD,REAL,SQRT                             00001000
C                                                                       00001010
C     INTERNAL VARIABLES                                                00001020
C                                                                       00001030
      INTEGER I,ITER,J,JOBU,K,KASE,KK,L,LL,LLS,LM1,LP1,LS,LU,M,MAXIT,   00001040
     *        MM,MM1,MP1,NCT,NCTP1,NCU,NRT,NRTP1                        00001050
      COMPLEX CDOTC,T,R                                                 00001060
      REAL B,C,CS,EL,EMM1,F,G,SCNRM2,SCALE,SHIFT,SL,SM,SN,SMM1,T1,TEST, 00001070
     *     ZTEST                                                        00001080
      LOGICAL WANTU,WANTV                                               00001090
C                                                                       00001100
      COMPLEX CSIGN,ZDUM,ZDUM1,ZDUM2                                    00001110
      REAL CABS1                                                        00001120
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00001130
      CSIGN(ZDUM1,ZDUM2) = CABS(ZDUM1)*(ZDUM2/CABS(ZDUM2))              00001140
C                                                                       00001150
C     SET THE MAXIMUM NUMBER OF ITERATIONS.                             00001160
C                                                                       00001170
      MAXIT = 30                                                        00001180
C                                                                       00001190
C     DETERMINE WHAT IS TO BE COMPUTED.                                 00001200
C                                                                       00001210
      WANTU = .FALSE.                                                   00001220
      WANTV = .FALSE.                                                   00001230
      JOBU = MOD(JOB,100)/10                                            00001240
      NCU = N                                                           00001250
      IF (JOBU .GT. 1) NCU = MIN0(N,P)                                  00001260
      IF (JOBU .NE. 0) WANTU = .TRUE.                                   00001270
      IF (MOD(JOB,10) .NE. 0) WANTV = .TRUE.                            00001280
C                                                                       00001290
C     REDUCE X TO BIDIAGONAL FORM, STORING THE DIAGONAL ELEMENTS        00001300
C     IN S AND THE SUPER-DIAGONAL ELEMENTS IN E.                        00001310
C                                                                       00001320
      INFO = 0                                                          00001330
      NCT = MIN0(N-1,P)                                                 00001340
      NRT = MAX0(0,MIN0(P-2,N))                                         00001350
      LU = MAX0(NCT,NRT)                                                00001360
      IF (LU .LT. 1) GO TO 170                                          00001370
      DO 160 L = 1, LU                                                  00001380
         LP1 = L + 1                                                    00001390
         IF (L .GT. NCT) GO TO 20                                       00001400
C                                                                       00001410
C           COMPUTE THE TRANSFORMATION FOR THE L-TH COLUMN AND          00001420
C           PLACE THE L-TH DIAGONAL IN S(L).                            00001430
C                                                                       00001440
            S(L) = CMPLX(SCNRM2(N-L+1,X(L,L),1),0.0E0)                  00001450
            IF (CABS1(S(L)) .EQ. 0.0E0) GO TO 10                        00001460
               IF (CABS1(X(L,L)) .NE. 0.0E0) S(L) = CSIGN(S(L),X(L,L))  00001470
               CALL CSCAL(N-L+1,1.0E0/S(L),X(L,L),1)                    00001480
               X(L,L) = (1.0E0,0.0E0) + X(L,L)                          00001490
   10       CONTINUE                                                    00001500
            S(L) = -S(L)                                                00001510
   20    CONTINUE                                                       00001520
         IF (P .LT. LP1) GO TO 50                                       00001530
         DO 40 J = LP1, P                                               00001540
            IF (L .GT. NCT) GO TO 30                                    00001550
            IF (CABS1(S(L)) .EQ. 0.0E0) GO TO 30                        00001560
C                                                                       00001570
C              APPLY THE TRANSFORMATION.                                00001580
C                                                                       00001590
               T = -CDOTC(N-L+1,X(L,L),1,X(L,J),1)/X(L,L)               00001600
               CALL CAXPY(N-L+1,T,X(L,L),1,X(L,J),1)                    00001610
   30       CONTINUE                                                    00001620
C                                                                       00001630
C           PLACE THE L-TH ROW OF X INTO  E FOR THE                     00001640
C           SUBSEQUENT CALCULATION OF THE ROW TRANSFORMATION.           00001650
C                                                                       00001660
            E(J) = CONJG(X(L,J))                                        00001670
   40    CONTINUE                                                       00001680
   50    CONTINUE                                                       00001690
         IF (.NOT.WANTU .OR. L .GT. NCT) GO TO 70                       00001700
C                                                                       00001710
C           PLACE THE TRANSFORMATION IN U FOR SUBSEQUENT BACK           00001720
C           MULTIPLICATION.                                             00001730
C                                                                       00001740
            DO 60 I = L, N                                              00001750
               U(I,L) = X(I,L)                                          00001760
   60       CONTINUE                                                    00001770
   70    CONTINUE                                                       00001780
         IF (L .GT. NRT) GO TO 150                                      00001790
C                                                                       00001800
C           COMPUTE THE L-TH ROW TRANSFORMATION AND PLACE THE           00001810
C           L-TH SUPER-DIAGONAL IN E(L).                                00001820
C                                                                       00001830
            E(L) = CMPLX(SCNRM2(P-L,E(LP1),1),0.0E0)                    00001840
            IF (CABS1(E(L)) .EQ. 0.0E0) GO TO 80                        00001850
               IF (CABS1(E(LP1)) .NE. 0.0E0) E(L) = CSIGN(E(L),E(LP1))  00001860
               CALL CSCAL(P-L,1.0E0/E(L),E(LP1),1)                      00001870
               E(LP1) = (1.0E0,0.0E0) + E(LP1)                          00001880
   80       CONTINUE                                                    00001890
            E(L) = -CONJG(E(L))                                         00001900
            IF (LP1 .GT. N .OR. CABS1(E(L)) .EQ. 0.0E0) GO TO 120       00001910
C                                                                       00001920
C              APPLY THE TRANSFORMATION.                                00001930
C                                                                       00001940
               DO 90 I = LP1, N                                         00001950
                  WORK(I) = (0.0E0,0.0E0)                               00001960
   90          CONTINUE                                                 00001970
               DO 100 J = LP1, P                                        00001980
                  CALL CAXPY(N-L,E(J),X(LP1,J),1,WORK(LP1),1)           00001990
  100          CONTINUE                                                 00002000
               DO 110 J = LP1, P                                        00002010
                  CALL CAXPY(N-L,CONJG(-E(J)/E(LP1)),WORK(LP1),1,       00002020
     *                       X(LP1,J),1)                                00002030
  110          CONTINUE                                                 00002040
  120       CONTINUE                                                    00002050
            IF (.NOT.WANTV) GO TO 140                                   00002060
C                                                                       00002070
C              PLACE THE TRANSFORMATION IN V FOR SUBSEQUENT             00002080
C              BACK MULTIPLICATION.                                     00002090
C                                                                       00002100
               DO 130 I = LP1, P                                        00002110
                  V(I,L) = E(I)                                         00002120
  130          CONTINUE                                                 00002130
  140       CONTINUE                                                    00002140
  150    CONTINUE                                                       00002150
  160 CONTINUE                                                          00002160
  170 CONTINUE                                                          00002170
C                                                                       00002180
C     SET UP THE FINAL BIDIAGONAL MATRIX OR ORDER M.                    00002190
C                                                                       00002200
      M = MIN0(P,N+1)                                                   00002210
      NCTP1 = NCT + 1                                                   00002220
      NRTP1 = NRT + 1                                                   00002230
      IF (NCT .LT. P) S(NCTP1) = X(NCTP1,NCTP1)                         00002240
      IF (N .LT. M) S(M) = (0.0E0,0.0E0)                                00002250
      IF (NRTP1 .LT. M) E(NRTP1) = X(NRTP1,M)                           00002260
      E(M) = (0.0E0,0.0E0)                                              00002270
C                                                                       00002280
C     IF REQUIRED, GENERATE U.                                          00002290
C                                                                       00002300
      IF (.NOT.WANTU) GO TO 300                                         00002310
         IF (NCU .LT. NCTP1) GO TO 200                                  00002320
         DO 190 J = NCTP1, NCU                                          00002330
            DO 180 I = 1, N                                             00002340
               U(I,J) = (0.0E0,0.0E0)                                   00002350
  180       CONTINUE                                                    00002360
            U(J,J) = (1.0E0,0.0E0)                                      00002370
  190    CONTINUE                                                       00002380
  200    CONTINUE                                                       00002390
         IF (NCT .LT. 1) GO TO 290                                      00002400
         DO 280 LL = 1, NCT                                             00002410
            L = NCT - LL + 1                                            00002420
            IF (CABS1(S(L)) .EQ. 0.0E0) GO TO 250                       00002430
               LP1 = L + 1                                              00002440
               IF (NCU .LT. LP1) GO TO 220                              00002450
               DO 210 J = LP1, NCU                                      00002460
                  T = -CDOTC(N-L+1,U(L,L),1,U(L,J),1)/U(L,L)            00002470
                  CALL CAXPY(N-L+1,T,U(L,L),1,U(L,J),1)                 00002480
  210          CONTINUE                                                 00002490
  220          CONTINUE                                                 00002500
               CALL CSCAL(N-L+1,(-1.0E0,0.0E0),U(L,L),1)                00002510
               U(L,L) = (1.0E0,0.0E0) + U(L,L)                          00002520
               LM1 = L - 1                                              00002530
               IF (LM1 .LT. 1) GO TO 240                                00002540
               DO 230 I = 1, LM1                                        00002550
                  U(I,L) = (0.0E0,0.0E0)                                00002560
  230          CONTINUE                                                 00002570
  240          CONTINUE                                                 00002580
            GO TO 270                                                   00002590
  250       CONTINUE                                                    00002600
               DO 260 I = 1, N                                          00002610
                  U(I,L) = (0.0E0,0.0E0)                                00002620
  260          CONTINUE                                                 00002630
               U(L,L) = (1.0E0,0.0E0)                                   00002640
  270       CONTINUE                                                    00002650
  280    CONTINUE                                                       00002660
  290    CONTINUE                                                       00002670
  300 CONTINUE                                                          00002680
C                                                                       00002690
C     IF IT IS REQUIRED, GENERATE V.                                    00002700
C                                                                       00002710
      IF (.NOT.WANTV) GO TO 350                                         00002720
         DO 340 LL = 1, P                                               00002730
            L = P - LL + 1                                              00002740
            LP1 = L + 1                                                 00002750
            IF (L .GT. NRT) GO TO 320                                   00002760
            IF (CABS1(E(L)) .EQ. 0.0E0) GO TO 320                       00002770
               DO 310 J = LP1, P                                        00002780
                  T = -CDOTC(P-L,V(LP1,L),1,V(LP1,J),1)/V(LP1,L)        00002790
                  CALL CAXPY(P-L,T,V(LP1,L),1,V(LP1,J),1)               00002800
  310          CONTINUE                                                 00002810
  320       CONTINUE                                                    00002820
            DO 330 I = 1, P                                             00002830
               V(I,L) = (0.0E0,0.0E0)                                   00002840
  330       CONTINUE                                                    00002850
            V(L,L) = (1.0E0,0.0E0)                                      00002860
  340    CONTINUE                                                       00002870
  350 CONTINUE                                                          00002880
C                                                                       00002890
C     TRANSFORM S AND E SO THAT THEY ARE REAL.                          00002900
C                                                                       00002910
      DO 380 I = 1, M                                                   00002920
         IF (CABS1(S(I)) .EQ. 0.0E0) GO TO 360                          00002930
            T = CMPLX(CABS(S(I)),0.0E0)                                 00002940
            R = S(I)/T                                                  00002950
            S(I) = T                                                    00002960
            IF (I .LT. M) E(I) = E(I)/R                                 00002970
            IF (WANTU) CALL CSCAL(N,R,U(1,I),1)                         00002980
  360    CONTINUE                                                       00002990
C     ...EXIT                                                           00003000
         IF (I .EQ. M) GO TO 390                                        00003010
         IF (CABS1(E(I)) .EQ. 0.0E0) GO TO 370                          00003020
            T = CMPLX(CABS(E(I)),0.0E0)                                 00003030
            R = T/E(I)                                                  00003040
            E(I) = T                                                    00003050
            S(I+1) = S(I+1)*R                                           00003060
            IF (WANTV) CALL CSCAL(P,R,V(1,I+1),1)                       00003070
  370    CONTINUE                                                       00003080
  380 CONTINUE                                                          00003090
  390 CONTINUE                                                          00003100
C                                                                       00003110
C     MAIN ITERATION LOOP FOR THE SINGULAR VALUES.                      00003120
C                                                                       00003130
      MM = M                                                            00003140
      ITER = 0                                                          00003150
  400 CONTINUE                                                          00003160
C                                                                       00003170
C        QUIT IF ALL THE SINGULAR VALUES HAVE BEEN FOUND.               00003180
C                                                                       00003190
C     ...EXIT                                                           00003200
         IF (M .EQ. 0) GO TO 660                                        00003210
C                                                                       00003220
C        IF TOO MANY ITERATIONS HAVE BEEN PERFORMED, SET                00003230
C        FLAG AND RETURN.                                               00003240
C                                                                       00003250
         IF (ITER .LT. MAXIT) GO TO 410                                 00003260
            INFO = M                                                    00003270
C     ......EXIT                                                        00003280
            GO TO 660                                                   00003290
  410    CONTINUE                                                       00003300
C                                                                       00003310
C        THIS SECTION OF THE PROGRAM INSPECTS FOR                       00003320
C        NEGLIGIBLE ELEMENTS IN THE S AND E ARRAYS.  ON                 00003330
C        COMPLETION THE VARIABLES KASE AND L ARE SET AS FOLLOWS.        00003340
C                                                                       00003350
C           KASE = 1     IF S(M) AND E(L-1) ARE NEGLIGIBLE AND L.LT.M   00003360
C           KASE = 2     IF S(L) IS NEGLIGIBLE AND L.LT.M               00003370
C           KASE = 3     IF E(L-1) IS NEGLIGIBLE, L.LT.M, AND           00003380
C                        S(L), ..., S(M) ARE NOT NEGLIGIBLE (QR STEP).  00003390
C           KASE = 4     IF E(M-1) IS NEGLIGIBLE (CONVERGENCE).         00003400
C                                                                       00003410
         DO 430 LL = 1, M                                               00003420
            L = M - LL                                                  00003430
C        ...EXIT                                                        00003440
            IF (L .EQ. 0) GO TO 440                                     00003450
            TEST = CABS(S(L)) + CABS(S(L+1))                            00003460
            ZTEST = TEST + CABS(E(L))                                   00003470
            IF (ZTEST .NE. TEST) GO TO 420                              00003480
               E(L) = (0.0E0,0.0E0)                                     00003490
C        ......EXIT                                                     00003500
               GO TO 440                                                00003510
  420       CONTINUE                                                    00003520
  430    CONTINUE                                                       00003530
  440    CONTINUE                                                       00003540
         IF (L .NE. M - 1) GO TO 450                                    00003550
            KASE = 4                                                    00003560
         GO TO 520                                                      00003570
  450    CONTINUE                                                       00003580
            LP1 = L + 1                                                 00003590
            MP1 = M + 1                                                 00003600
            DO 470 LLS = LP1, MP1                                       00003610
               LS = M - LLS + LP1                                       00003620
C           ...EXIT                                                     00003630
               IF (LS .EQ. L) GO TO 480                                 00003640
               TEST = 0.0E0                                             00003650
               IF (LS .NE. M) TEST = TEST + CABS(E(LS))                 00003660
               IF (LS .NE. L + 1) TEST = TEST + CABS(E(LS-1))           00003670
               ZTEST = TEST + CABS(S(LS))                               00003680
               IF (ZTEST .NE. TEST) GO TO 460                           00003690
                  S(LS) = (0.0E0,0.0E0)                                 00003700
C           ......EXIT                                                  00003710
                  GO TO 480                                             00003720
  460          CONTINUE                                                 00003730
  470       CONTINUE                                                    00003740
  480       CONTINUE                                                    00003750
            IF (LS .NE. L) GO TO 490                                    00003760
               KASE = 3                                                 00003770
            GO TO 510                                                   00003780
  490       CONTINUE                                                    00003790
            IF (LS .NE. M) GO TO 500                                    00003800
               KASE = 1                                                 00003810
            GO TO 510                                                   00003820
  500       CONTINUE                                                    00003830
               KASE = 2                                                 00003840
               L = LS                                                   00003850
  510       CONTINUE                                                    00003860
  520    CONTINUE                                                       00003870
         L = L + 1                                                      00003880
C                                                                       00003890
C        PERFORM THE TASK INDICATED BY KASE.                            00003900
C                                                                       00003910
         GO TO (530, 560, 580, 610), KASE                               00003920
C                                                                       00003930
C        DEFLATE NEGLIGIBLE S(M).                                       00003940
C                                                                       00003950
  530    CONTINUE                                                       00003960
            MM1 = M - 1                                                 00003970
            F = REAL(E(M-1))                                            00003980
            E(M-1) = (0.0E0,0.0E0)                                      00003990
            DO 550 KK = L, MM1                                          00004000
               K = MM1 - KK + L                                         00004010
               T1 = REAL(S(K))                                          00004020
               CALL SROTG(T1,F,CS,SN)                                   00004030
               S(K) = CMPLX(T1,0.0E0)                                   00004040
               IF (K .EQ. L) GO TO 540                                  00004050
                  F = -SN*REAL(E(K-1))                                  00004060
                  E(K-1) = CS*E(K-1)                                    00004070
  540          CONTINUE                                                 00004080
               IF (WANTV) CALL CSROT(P,V(1,K),1,V(1,M),1,CS,SN)         00004090
  550       CONTINUE                                                    00004100
         GO TO 650                                                      00004110
C                                                                       00004120
C        SPLIT AT NEGLIGIBLE S(L).                                      00004130
C                                                                       00004140
  560    CONTINUE                                                       00004150
            F = REAL(E(L-1))                                            00004160
            E(L-1) = (0.0E0,0.0E0)                                      00004170
            DO 570 K = L, M                                             00004180
               T1 = REAL(S(K))                                          00004190
               CALL SROTG(T1,F,CS,SN)                                   00004200
               S(K) = CMPLX(T1,0.0E0)                                   00004210
               F = -SN*REAL(E(K))                                       00004220
               E(K) = CS*E(K)                                           00004230
               IF (WANTU) CALL CSROT(N,U(1,K),1,U(1,L-1),1,CS,SN)       00004240
  570       CONTINUE                                                    00004250
         GO TO 650                                                      00004260
C                                                                       00004270
C        PERFORM ONE QR STEP.                                           00004280
C                                                                       00004290
  580    CONTINUE                                                       00004300
C                                                                       00004310
C           CALCULATE THE SHIFT.                                        00004320
C                                                                       00004330
            SCALE = AMAX1(CABS(S(M)),CABS(S(M-1)),CABS(E(M-1)),         00004340
     *                    CABS(S(L)),CABS(E(L)))                        00004350
            SM = REAL(S(M))/SCALE                                       00004360
            SMM1 = REAL(S(M-1))/SCALE                                   00004370
            EMM1 = REAL(E(M-1))/SCALE                                   00004380
            SL = REAL(S(L))/SCALE                                       00004390
            EL = REAL(E(L))/SCALE                                       00004400
            B = ((SMM1 + SM)*(SMM1 - SM) + EMM1**2)/2.0E0               00004410
            C = (SM*EMM1)**2                                            00004420
            SHIFT = 0.0E0                                               00004430
            IF (B .EQ. 0.0E0 .AND. C .EQ. 0.0E0) GO TO 590              00004440
               SHIFT = SQRT(B**2+C)                                     00004450
               IF (B .LT. 0.0E0) SHIFT = -SHIFT                         00004460
               SHIFT = C/(B + SHIFT)                                    00004470
  590       CONTINUE                                                    00004480
            F = (SL + SM)*(SL - SM) - SHIFT                             00004490
            G = SL*EL                                                   00004500
C                                                                       00004510
C           CHASE ZEROS.                                                00004520
C                                                                       00004530
            MM1 = M - 1                                                 00004540
            DO 600 K = L, MM1                                           00004550
               CALL SROTG(F,G,CS,SN)                                    00004560
               IF (K .NE. L) E(K-1) = CMPLX(F,0.0E0)                    00004570
               F = CS*REAL(S(K)) + SN*REAL(E(K))                        00004580
               E(K) = CS*E(K) - SN*S(K)                                 00004590
               G = SN*REAL(S(K+1))                                      00004600
               S(K+1) = CS*S(K+1)                                       00004610
               IF (WANTV) CALL CSROT(P,V(1,K),1,V(1,K+1),1,CS,SN)       00004620
               CALL SROTG(F,G,CS,SN)                                    00004630
               S(K) = CMPLX(F,0.0E0)                                    00004640
               F = CS*REAL(E(K)) + SN*REAL(S(K+1))                      00004650
               S(K+1) = -SN*E(K) + CS*S(K+1)                            00004660
               G = SN*REAL(E(K+1))                                      00004670
               E(K+1) = CS*E(K+1)                                       00004680
               IF (WANTU .AND. K .LT. N)                                00004690
     *            CALL CSROT(N,U(1,K),1,U(1,K+1),1,CS,SN)               00004700
  600       CONTINUE                                                    00004710
            E(M-1) = CMPLX(F,0.0E0)                                     00004720
            ITER = ITER + 1                                             00004730
         GO TO 650                                                      00004740
C                                                                       00004750
C        CONVERGENCE.                                                   00004760
C                                                                       00004770
  610    CONTINUE                                                       00004780
C                                                                       00004790
C           MAKE THE SINGULAR VALUE  POSITIVE                           00004800
C                                                                       00004810
            IF (REAL(S(L)) .GE. 0.0E0) GO TO 620                        00004820
               S(L) = -S(L)                                             00004830
               IF (WANTV) CALL CSCAL(P,(-1.0E0,0.0E0),V(1,L),1)         00004840
  620       CONTINUE                                                    00004850
C                                                                       00004860
C           ORDER THE SINGULAR VALUE.                                   00004870
C                                                                       00004880
  630       IF (L .EQ. MM) GO TO 640                                    00004890
C           ...EXIT                                                     00004900
               IF (REAL(S(L)) .GE. REAL(S(L+1))) GO TO 640              00004910
               T = S(L)                                                 00004920
               S(L) = S(L+1)                                            00004930
               S(L+1) = T                                               00004940
               IF (WANTV .AND. L .LT. P)                                00004950
     *            CALL CSWAP(P,V(1,L),1,V(1,L+1),1)                     00004960
               IF (WANTU .AND. L .LT. N)                                00004970
     *            CALL CSWAP(N,U(1,L),1,U(1,L+1),1)                     00004980
               L = L + 1                                                00004990
            GO TO 630                                                   00005000
  640       CONTINUE                                                    00005010
            ITER = 0                                                    00005020
            M = M - 1                                                   00005030
  650    CONTINUE                                                       00005040
      GO TO 400                                                         00005050
  660 CONTINUE                                                          00005060
      RETURN                                                            00005070
      END                                                               00005080
