*#**********************************************************************

      SUBROUTINE CTRDI(T,LDT,N,DET,JOB,INFO)                            00000010

      INTEGER LDT,N,JOB,INFO                                            00000020
      COMPLEX T(LDT,1),DET(2)                                           00000030
C                                                                       00000040
C     CTRDI COMPUTES THE DETERMINANT AND INVERSE OF A COMPLEX           00000050
C     TRIANGULAR MATRIX.                                                00000060
C                                                                       00000070
C     ON ENTRY                                                          00000080
C                                                                       00000090
C        T       COMPLEX(LDT,N)                                         00000100
C                T CONTAINS THE TRIANGULAR MATRIX. THE ZERO             00000110
C                ELEMENTS OF THE MATRIX ARE NOT REFERENCED, AND         00000120
C                THE CORRESPONDING ELEMENTS OF THE ARRAY CAN BE         00000130
C                USED TO STORE OTHER INFORMATION.                       00000140
C                                                                       00000150
C        LDT     INTEGER                                                00000160
C                LDT IS THE LEADING DIMENSION OF THE ARRAY T.           00000170
C                                                                       00000180
C        N       INTEGER                                                00000190
C                N IS THE ORDER OF THE SYSTEM.                          00000200
C                                                                       00000210
C        JOB     INTEGER                                                00000220
C                = 010       NO DET, INVERSE OF LOWER TRIANGULAR.       00000230
C                = 011       NO DET, INVERSE OF UPPER TRIANGULAR.       00000240
C                = 100       DET, NO INVERSE.                           00000250
C                = 110       DET, INVERSE OF LOWER TRIANGULAR.          00000260
C                = 111       DET, INVERSE OF UPPER TRIANGULAR.          00000270
C                                                                       00000280
C     ON RETURN                                                         00000290
C                                                                       00000300
C        T       INVERSE OF ORIGINAL MATRIX IF REQUESTED.               00000310
C                OTHERWISE UNCHANGED.                                   00000320
C                                                                       00000330
C        DET     COMPLEX(2)                                             00000340
C                DETERMINANT OF ORIGINAL MATRIX IF REQUESTED.           00000350
C                OTHERWISE NOT REFERENCED.                              00000360
C                DETERMINANT = DET(1) * 10.0**DET(2)                    00000370
C                WITH  1.0 .LE. CABS1(DET(1)) .LT. 10.0                 00000380
C                OR  DET(1) .EQ. 0.0 .                                  00000390
C                                                                       00000400
C        INFO    INTEGER                                                00000410
C                INFO CONTAINS ZERO IF THE SYSTEM IS NONSINGULAR        00000420
C                AND THE INVERSE IS REQUESTED.                          00000430
C                OTHERWISE INFO CONTAINS THE INDEX OF                   00000440
C                A ZERO DIAGONAL ELEMENT OF T.                          00000450
C                                                                       00000460
C                                                                       00000470
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000480
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000490
C                                                                       00000500
C     SUBROUTINES AND FUNCTIONS                                         00000510
C                                                                       00000520
C     BLAS CAXPY,CSCAL                                                  00000530
C     FORTRAN ABS,AIMAG,CMPLX,MOD,REAL                                  00000540
C                                                                       00000550
C     INTERNAL VARIABLES                                                00000560
C                                                                       00000570
      COMPLEX TEMP                                                      00000580
      REAL TEN                                                          00000590
      INTEGER I,J,K,KB,KM1,KP1                                          00000600
C                                                                       00000610
      COMPLEX ZDUM                                                      00000620
      REAL CABS1                                                        00000630
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000640
C     BEGIN BLOCK PERMITTING ...EXITS TO 180                            00000650
C                                                                       00000660
C        COMPUTE DETERMINANT                                            00000670
C                                                                       00000680
         IF (JOB/100 .EQ. 0) GO TO 70                                   00000690
            DET(1) = (1.0E0,0.0E0)                                      00000700
            DET(2) = (0.0E0,0.0E0)                                      00000710
            TEN = 10.0E0                                                00000720
            DO 50 I = 1, N                                              00000730
               DET(1) = T(I,I)*DET(1)                                   00000740
C           ...EXIT                                                     00000750
               IF (CABS1(DET(1)) .EQ. 0.0E0) GO TO 60                   00000760
   10          IF (CABS1(DET(1)) .GE. 1.0E0) GO TO 20                   00000770
                  DET(1) = CMPLX(TEN,0.0E0)*DET(1)                      00000780
                  DET(2) = DET(2) - (1.0E0,0.0E0)                       00000790
               GO TO 10                                                 00000800
   20          CONTINUE                                                 00000810
   30          IF (CABS1(DET(1)) .LT. TEN) GO TO 40                     00000820
                  DET(1) = DET(1)/CMPLX(TEN,0.0E0)                      00000830
                  DET(2) = DET(2) + (1.0E0,0.0E0)                       00000840
               GO TO 30                                                 00000850
   40          CONTINUE                                                 00000860
   50       CONTINUE                                                    00000870
   60       CONTINUE                                                    00000880
   70    CONTINUE                                                       00000890
C                                                                       00000900
C        COMPUTE INVERSE OF UPPER TRIANGULAR                            00000910
C                                                                       00000920
         IF (MOD(JOB/10,10) .EQ. 0) GO TO 170                           00000930
            IF (MOD(JOB,10) .EQ. 0) GO TO 120                           00000940
C              BEGIN BLOCK PERMITTING ...EXITS TO 110                   00000950
                  DO 100 K = 1, N                                       00000960
                     INFO = K                                           00000970
C              ......EXIT                                               00000980
                     IF (CABS1(T(K,K)) .EQ. 0.0E0) GO TO 110            00000990
                     T(K,K) = (1.0E0,0.0E0)/T(K,K)                      00001000
                     TEMP = -T(K,K)                                     00001010
                     CALL CSCAL(K-1,TEMP,T(1,K),1)                      00001020
                     KP1 = K + 1                                        00001030
                     IF (N .LT. KP1) GO TO 90                           00001040
                     DO 80 J = KP1, N                                   00001050
                        TEMP = T(K,J)                                   00001060
                        T(K,J) = (0.0E0,0.0E0)                          00001070
                        CALL CAXPY(K,TEMP,T(1,K),1,T(1,J),1)            00001080
   80                CONTINUE                                           00001090
   90                CONTINUE                                           00001100
  100             CONTINUE                                              00001110
                  INFO = 0                                              00001120
  110          CONTINUE                                                 00001130
            GO TO 160                                                   00001140
  120       CONTINUE                                                    00001150
C                                                                       00001160
C              COMPUTE INVERSE OF LOWER TRIANGULAR                      00001170
C                                                                       00001180
               DO 150 KB = 1, N                                         00001190
                  K = N + 1 - KB                                        00001200
                  INFO = K                                              00001210
C     ............EXIT                                                  00001220
                  IF (CABS1(T(K,K)) .EQ. 0.0E0) GO TO 180               00001230
                  T(K,K) = (1.0E0,0.0E0)/T(K,K)                         00001240
                  TEMP = -T(K,K)                                        00001250
                  IF (K .NE. N) CALL CSCAL(N-K,TEMP,T(K+1,K),1)         00001260
                  KM1 = K - 1                                           00001270
                  IF (KM1 .LT. 1) GO TO 140                             00001280
                  DO 130 J = 1, KM1                                     00001290
                     TEMP = T(K,J)                                      00001300
                     T(K,J) = (0.0E0,0.0E0)                             00001310
                     CALL CAXPY(N-K+1,TEMP,T(K,K),1,T(K,J),1)           00001320
  130             CONTINUE                                              00001330
  140             CONTINUE                                              00001340
  150          CONTINUE                                                 00001350
               INFO = 0                                                 00001360
  160       CONTINUE                                                    00001370
  170    CONTINUE                                                       00001380
  180 CONTINUE                                                          00001390
      RETURN                                                            00001400
      END                                                               00001410
