*#**********************************************************************

      SUBROUTINE DGTSL(N,C,D,E,B,INFO)                                  00000010

      INTEGER N,INFO                                                    00000020
      DOUBLE PRECISION C(1),D(1),E(1),B(1)                              00000030
C                                                                       00000040
C     DGTSL GIVEN A GENERAL TRIDIAGONAL MATRIX AND A RIGHT HAND         00000050
C     SIDE WILL FIND THE SOLUTION.                                      00000060
C                                                                       00000070
C     ON ENTRY                                                          00000080
C                                                                       00000090
C        N       INTEGER                                                00000100
C                IS THE ORDER OF THE TRIDIAGONAL MATRIX.                00000110
C                                                                       00000120
C        C       DOUBLE PRECISION(N)                                    00000130
C                IS THE SUBDIAGONAL OF THE TRIDIAGONAL MATRIX.          00000140
C                C(2) THROUGH C(N) SHOULD CONTAIN THE SUBDIAGONAL.      00000150
C                ON OUTPUT C IS DESTROYED.                              00000160
C                                                                       00000170
C        D       DOUBLE PRECISION(N)                                    00000180
C                IS THE DIAGONAL OF THE TRIDIAGONAL MATRIX.             00000190
C                ON OUTPUT D IS DESTROYED.                              00000200
C                                                                       00000210
C        E       DOUBLE PRECISION(N)                                    00000220
C                IS THE SUPERDIAGONAL OF THE TRIDIAGONAL MATRIX.        00000230
C                E(1) THROUGH E(N-1) SHOULD CONTAIN THE SUPERDIAGONAL.  00000240
C                ON OUTPUT E IS DESTROYED.                              00000250
C                                                                       00000260
C        B       DOUBLE PRECISION(N)                                    00000270
C                IS THE RIGHT HAND SIDE VECTOR.                         00000280
C                                                                       00000290
C     ON RETURN                                                         00000300
C                                                                       00000310
C        B       IS THE SOLUTION VECTOR.                                00000320
C                                                                       00000330
C        INFO    INTEGER                                                00000340
C                = 0 NORMAL VALUE.                                      00000350
C                = K IF THE K-TH ELEMENT OF THE DIAGONAL BECOMES        00000360
C                    EXACTLY ZERO.  THE SUBROUTINE RETURNS WHEN         00000370
C                    THIS IS DETECTED.                                  00000380
C                                                                       00000390
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000400
C     JACK DONGARRA, ARGONNE NATIONAL LABORATORY.                       00000410
C                                                                       00000420
C     NO EXTERNALS                                                      00000430
C     FORTRAN DABS                                                      00000440
C                                                                       00000450
C     INTERNAL VARIABLES                                                00000460
C                                                                       00000470
      INTEGER K,KB,KP1,NM1,NM2                                          00000480
      DOUBLE PRECISION T                                                00000490
C     BEGIN BLOCK PERMITTING ...EXITS TO 100                            00000500
C                                                                       00000510
         INFO = 0                                                       00000520
         C(1) = D(1)                                                    00000530
         NM1 = N - 1                                                    00000540
         IF (NM1 .LT. 1) GO TO 40                                       00000550
            D(1) = E(1)                                                 00000560
            E(1) = 0.0D0                                                00000570
            E(N) = 0.0D0                                                00000580
C                                                                       00000590
            DO 30 K = 1, NM1                                            00000600
               KP1 = K + 1                                              00000610
C                                                                       00000620
C              FIND THE LARGEST OF THE TWO ROWS                         00000630
C                                                                       00000640
               IF (DABS(C(KP1)) .LT. DABS(C(K))) GO TO 10               00000650
C                                                                       00000660
C                 INTERCHANGE ROW                                       00000670
C                                                                       00000680
                  T = C(KP1)                                            00000690
                  C(KP1) = C(K)                                         00000700
                  C(K) = T                                              00000710
                  T = D(KP1)                                            00000720
                  D(KP1) = D(K)                                         00000730
                  D(K) = T                                              00000740
                  T = E(KP1)                                            00000750
                  E(KP1) = E(K)                                         00000760
                  E(K) = T                                              00000770
                  T = B(KP1)                                            00000780
                  B(KP1) = B(K)                                         00000790
                  B(K) = T                                              00000800
   10          CONTINUE                                                 00000810
C                                                                       00000820
C              ZERO ELEMENTS                                            00000830
C                                                                       00000840
               IF (C(K) .NE. 0.0D0) GO TO 20                            00000850
                  INFO = K                                              00000860
C     ............EXIT                                                  00000870
                  GO TO 100                                             00000880
   20          CONTINUE                                                 00000890
               T = -C(KP1)/C(K)                                         00000900
               C(KP1) = D(KP1) + T*D(K)                                 00000910
               D(KP1) = E(KP1) + T*E(K)                                 00000920
               E(KP1) = 0.0D0                                           00000930
               B(KP1) = B(KP1) + T*B(K)                                 00000940
   30       CONTINUE                                                    00000950
   40    CONTINUE                                                       00000960
         IF (C(N) .NE. 0.0D0) GO TO 50                                  00000970
            INFO = N                                                    00000980
         GO TO 90                                                       00000990
   50    CONTINUE                                                       00001000
C                                                                       00001010
C           BACK SOLVE                                                  00001020
C                                                                       00001030
            NM2 = N - 2                                                 00001040
            B(N) = B(N)/C(N)                                            00001050
            IF (N .EQ. 1) GO TO 80                                      00001060
               B(NM1) = (B(NM1) - D(NM1)*B(N))/C(NM1)                   00001070
               IF (NM2 .LT. 1) GO TO 70                                 00001080
               DO 60 KB = 1, NM2                                        00001090
                  K = NM2 - KB + 1                                      00001100
                  B(K) = (B(K) - D(K)*B(K+1) - E(K)*B(K+2))/C(K)        00001110
   60          CONTINUE                                                 00001120
   70          CONTINUE                                                 00001130
   80       CONTINUE                                                    00001140
   90    CONTINUE                                                       00001150
  100 CONTINUE                                                          00001160
C                                                                       00001170
      RETURN                                                            00001180
      END                                                               00001190
