*#**********************************************************************

      SUBROUTINE DPOCO(A,LDA,N,RCOND,Z,INFO)                            00000010

      INTEGER LDA,N,INFO                                                00000020
      DOUBLE PRECISION A(LDA,1),Z(1)                                    00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     DPOCO FACTORS A DOUBLE PRECISION SYMMETRIC POSITIVE DEFINITE      00000060
C     MATRIX AND ESTIMATES THE CONDITION OF THE MATRIX.                 00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, DPOFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW DPOCO BY DPOSL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW DPOCO BY DPOSL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW DPOCO BY DPODI.               00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW DPOCO BY DPODI.                   00000130
C                                                                       00000140
C     ON ENTRY                                                          00000150
C                                                                       00000160
C        A       DOUBLE PRECISION(LDA, N)                               00000170
C                THE SYMMETRIC MATRIX TO BE FACTORED.  ONLY THE         00000180
C                DIAGONAL AND UPPER TRIANGLE ARE USED.                  00000190
C                                                                       00000200
C        LDA     INTEGER                                                00000210
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        A       AN UPPER TRIANGULAR MATRIX  R  SO THAT  A = TRANS(R)*R 00000290
C                WHERE  TRANS(R)  IS THE TRANSPOSE.                     00000300
C                THE STRICT LOWER TRIANGLE IS UNALTERED.                00000310
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000320
C                                                                       00000330
C        RCOND   DOUBLE PRECISION                                       00000340
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000350
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000360
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000370
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000380
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000390
C                           1.0 + RCOND .EQ. 1.0                        00000400
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000410
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000420
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000430
C                UNDERFLOWS.  IF INFO .NE. 0 , RCOND IS UNCHANGED.      00000440
C                                                                       00000450
C        Z       DOUBLE PRECISION(N)                                    00000460
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000470
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000480
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000490
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000500
C                IF  INFO .NE. 0 , Z  IS UNCHANGED.                     00000510
C                                                                       00000520
C        INFO    INTEGER                                                00000530
C                = 0  FOR NORMAL RETURN.                                00000540
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000550
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000560
C                                                                       00000570
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000580
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000590
C                                                                       00000600
C     SUBROUTINES AND FUNCTIONS                                         00000610
C                                                                       00000620
C     LINPACK DPOFA                                                     00000630
C     BLAS DAXPY,DDOT,DSCAL,DASUM                                       00000640
C     FORTRAN DABS,DMAX1,DREAL,DSIGN                                    00000650
C                                                                       00000660
C     INTERNAL VARIABLES                                                00000670
C                                                                       00000680
      DOUBLE PRECISION DDOT,EK,T,WK,WKM                                 00000690
      DOUBLE PRECISION ANORM,S,DASUM,SM,YNORM                           00000700
      INTEGER I,J,JM1,K,KB,KP1                                          00000710
C                                                                       00000720
C                                                                       00000730
C     FIND NORM OF A USING ONLY UPPER HALF                              00000740
C                                                                       00000750
      DO 30 J = 1, N                                                    00000760
         Z(J) = DASUM(J,A(1,J),1)                                       00000770
         JM1 = J - 1                                                    00000780
         IF (JM1 .LT. 1) GO TO 20                                       00000790
         DO 10 I = 1, JM1                                               00000800
            Z(I) = Z(I) + DABS(A(I,J))                                  00000810
   10    CONTINUE                                                       00000820
   20    CONTINUE                                                       00000830
   30 CONTINUE                                                          00000840
      ANORM = 0.0D0                                                     00000850
      DO 40 J = 1, N                                                    00000860
         ANORM = DMAX1(ANORM,Z(J))                                      00000870
   40 CONTINUE                                                          00000880
C                                                                       00000890
C     FACTOR                                                            00000900
C                                                                       00000910
      CALL DPOFA(A,LDA,N,INFO)                                          00000920
      IF (INFO .NE. 0) GO TO 180                                        00000930
C                                                                       00000940
C        RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .           00000950
C        ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .      00000960
C        THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL        00000970
C        GROWTH IN THE ELEMENTS OF W  WHERE  TRANS(R)*W = E .           00000980
C        THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.         00000990
C                                                                       00001000
C        SOLVE TRANS(R)*W = E                                           00001010
C                                                                       00001020
         EK = 1.0D0                                                     00001030
         DO 50 J = 1, N                                                 00001040
            Z(J) = 0.0D0                                                00001050
   50    CONTINUE                                                       00001060
         DO 110 K = 1, N                                                00001070
            IF (Z(K) .NE. 0.0D0) EK = DSIGN(EK,-Z(K))                   00001080
            IF (DABS(EK-Z(K)) .LE. A(K,K)) GO TO 60                     00001090
               S = A(K,K)/DABS(EK-Z(K))                                 00001100
               CALL DSCAL(N,S,Z,1)                                      00001110
               EK = S*EK                                                00001120
   60       CONTINUE                                                    00001130
            WK = EK - Z(K)                                              00001140
            WKM = -EK - Z(K)                                            00001150
            S = DABS(WK)                                                00001160
            SM = DABS(WKM)                                              00001170
            WK = WK/A(K,K)                                              00001180
            WKM = WKM/A(K,K)                                            00001190
            KP1 = K + 1                                                 00001200
            IF (KP1 .GT. N) GO TO 100                                   00001210
               DO 70 J = KP1, N                                         00001220
                  SM = SM + DABS(Z(J)+WKM*A(K,J))                       00001230
                  Z(J) = Z(J) + WK*A(K,J)                               00001240
                  S = S + DABS(Z(J))                                    00001250
   70          CONTINUE                                                 00001260
               IF (S .GE. SM) GO TO 90                                  00001270
                  T = WKM - WK                                          00001280
                  WK = WKM                                              00001290
                  DO 80 J = KP1, N                                      00001300
                     Z(J) = Z(J) + T*A(K,J)                             00001310
   80             CONTINUE                                              00001320
   90          CONTINUE                                                 00001330
  100       CONTINUE                                                    00001340
            Z(K) = WK                                                   00001350
  110    CONTINUE                                                       00001360
         S = 1.0D0/DASUM(N,Z,1)                                         00001370
         CALL DSCAL(N,S,Z,1)                                            00001380
C                                                                       00001390
C        SOLVE R*Y = W                                                  00001400
C                                                                       00001410
         DO 130 KB = 1, N                                               00001420
            K = N + 1 - KB                                              00001430
            IF (DABS(Z(K)) .LE. A(K,K)) GO TO 120                       00001440
               S = A(K,K)/DABS(Z(K))                                    00001450
               CALL DSCAL(N,S,Z,1)                                      00001460
  120       CONTINUE                                                    00001470
            Z(K) = Z(K)/A(K,K)                                          00001480
            T = -Z(K)                                                   00001490
            CALL DAXPY(K-1,T,A(1,K),1,Z(1),1)                           00001500
  130    CONTINUE                                                       00001510
         S = 1.0D0/DASUM(N,Z,1)                                         00001520
         CALL DSCAL(N,S,Z,1)                                            00001530
C                                                                       00001540
         YNORM = 1.0D0                                                  00001550
C                                                                       00001560
C        SOLVE TRANS(R)*V = Y                                           00001570
C                                                                       00001580
         DO 150 K = 1, N                                                00001590
            Z(K) = Z(K) - DDOT(K-1,A(1,K),1,Z(1),1)                     00001600
            IF (DABS(Z(K)) .LE. A(K,K)) GO TO 140                       00001610
               S = A(K,K)/DABS(Z(K))                                    00001620
               CALL DSCAL(N,S,Z,1)                                      00001630
               YNORM = S*YNORM                                          00001640
  140       CONTINUE                                                    00001650
            Z(K) = Z(K)/A(K,K)                                          00001660
  150    CONTINUE                                                       00001670
         S = 1.0D0/DASUM(N,Z,1)                                         00001680
         CALL DSCAL(N,S,Z,1)                                            00001690
         YNORM = S*YNORM                                                00001700
C                                                                       00001710
C        SOLVE R*Z = V                                                  00001720
C                                                                       00001730
         DO 170 KB = 1, N                                               00001740
            K = N + 1 - KB                                              00001750
            IF (DABS(Z(K)) .LE. A(K,K)) GO TO 160                       00001760
               S = A(K,K)/DABS(Z(K))                                    00001770
               CALL DSCAL(N,S,Z,1)                                      00001780
               YNORM = S*YNORM                                          00001790
  160       CONTINUE                                                    00001800
            Z(K) = Z(K)/A(K,K)                                          00001810
            T = -Z(K)                                                   00001820
            CALL DAXPY(K-1,T,A(1,K),1,Z(1),1)                           00001830
  170    CONTINUE                                                       00001840
C        MAKE ZNORM = 1.0                                               00001850
         S = 1.0D0/DASUM(N,Z,1)                                         00001860
         CALL DSCAL(N,S,Z,1)                                            00001870
         YNORM = S*YNORM                                                00001880
C                                                                       00001890
         IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                      00001900
         IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                            00001910
  180 CONTINUE                                                          00001920
      RETURN                                                            00001930
      END                                                               00001940
