*#**********************************************************************

      SUBROUTINE DPOFA(A,LDA,N,INFO)                                    00000010

      INTEGER LDA,N,INFO                                                00000020
      DOUBLE PRECISION A(LDA,1)                                         00000030
C                                                                       00000040
C     DPOFA FACTORS A DOUBLE PRECISION SYMMETRIC POSITIVE DEFINITE      00000050
C     MATRIX.                                                           00000060
C                                                                       00000070
C     DPOFA IS USUALLY CALLED BY DPOCO, BUT IT CAN BE CALLED            00000080
C     DIRECTLY WITH A SAVING IN TIME IF  RCOND  IS NOT NEEDED.          00000090
C     (TIME FOR DPOCO) = (1 + 18/N)*(TIME FOR DPOFA) .                  00000100
C                                                                       00000110
C     ON ENTRY                                                          00000120
C                                                                       00000130
C        A       DOUBLE PRECISION(LDA, N)                               00000140
C                THE SYMMETRIC MATRIX TO BE FACTORED.  ONLY THE         00000150
C                DIAGONAL AND UPPER TRIANGLE ARE USED.                  00000160
C                                                                       00000170
C        LDA     INTEGER                                                00000180
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000190
C                                                                       00000200
C        N       INTEGER                                                00000210
C                THE ORDER OF THE MATRIX  A .                           00000220
C                                                                       00000230
C     ON RETURN                                                         00000240
C                                                                       00000250
C        A       AN UPPER TRIANGULAR MATRIX  R  SO THAT  A = TRANS(R)*R 00000260
C                WHERE  TRANS(R)  IS THE TRANSPOSE.                     00000270
C                THE STRICT LOWER TRIANGLE IS UNALTERED.                00000280
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000290
C                                                                       00000300
C        INFO    INTEGER                                                00000310
C                = 0  FOR NORMAL RETURN.                                00000320
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000330
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000340
C                                                                       00000350
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000360
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000370
C                                                                       00000380
C     SUBROUTINES AND FUNCTIONS                                         00000390
C                                                                       00000400
C     BLAS DDOT                                                         00000410
C     FORTRAN DSQRT                                                     00000420
C                                                                       00000430
C     INTERNAL VARIABLES                                                00000440
C                                                                       00000450
      DOUBLE PRECISION DDOT,T                                           00000460
      DOUBLE PRECISION S                                                00000470
      INTEGER J,JM1,K                                                   00000480
C     BEGIN BLOCK WITH ...EXITS TO 40                                   00000490
C                                                                       00000500
C                                                                       00000510
         DO 30 J = 1, N                                                 00000520
            INFO = J                                                    00000530
            S = 0.0D0                                                   00000540
            JM1 = J - 1                                                 00000550
            IF (JM1 .LT. 1) GO TO 20                                    00000560
            DO 10 K = 1, JM1                                            00000570
               T = A(K,J) - DDOT(K-1,A(1,K),1,A(1,J),1)                 00000580
               T = T/A(K,K)                                             00000590
               A(K,J) = T                                               00000600
               S = S + T*T                                              00000610
   10       CONTINUE                                                    00000620
   20       CONTINUE                                                    00000630
            S = A(J,J) - S                                              00000640
C     ......EXIT                                                        00000650
            IF (S .LE. 0.0D0) GO TO 40                                  00000660
            A(J,J) = DSQRT(S)                                           00000670
   30    CONTINUE                                                       00000680
         INFO = 0                                                       00000690
   40 CONTINUE                                                          00000700
      RETURN                                                            00000710
      END                                                               00000720
