*#**********************************************************************

      SUBROUTINE DQRSL(X,LDX,N,K,QRAUX,Y,QY,QTY,B,RSD,XB,JOB,INFO)      00000010

      INTEGER LDX,N,K,JOB,INFO                                          00000020
      DOUBLE PRECISION X(LDX,1),QRAUX(1),Y(1),QY(1),QTY(1),B(1),RSD(1), 00000030
     *                 XB(1)                                            00000040
C                                                                       00000050
C     DQRSL APPLIES THE OUTPUT OF DQRDC TO COMPUTE COORDINATE           00000060
C     TRANSFORMATIONS, PROJECTIONS, AND LEAST SQUARES SOLUTIONS.        00000070
C     FOR K .LE. MIN(N,P), LET XK BE THE MATRIX                         00000080
C                                                                       00000090
C            XK = (X(JPVT(1)),X(JPVT(2)), ... ,X(JPVT(K)))              00000100
C                                                                       00000110
C     FORMED FROM COLUMNNS JPVT(1), ... ,JPVT(K) OF THE ORIGINAL        00000120
C     N X P MATRIX X THAT WAS INPUT TO DQRDC (IF NO PIVOTING WAS        00000130
C     DONE, XK CONSISTS OF THE FIRST K COLUMNS OF X IN THEIR            00000140
C     ORIGINAL ORDER).  DQRDC PRODUCES A FACTORED ORTHOGONAL MATRIX Q   00000150
C     AND AN UPPER TRIANGULAR MATRIX R SUCH THAT                        00000160
C                                                                       00000170
C              XK = Q * (R)                                             00000180
C                       (0)                                             00000190
C                                                                       00000200
C     THIS INFORMATION IS CONTAINED IN CODED FORM IN THE ARRAYS         00000210
C     X AND QRAUX.                                                      00000220
C                                                                       00000230
C     ON ENTRY                                                          00000240
C                                                                       00000250
C        X      DOUBLE PRECISION(LDX,P).                                00000260
C               X CONTAINS THE OUTPUT OF DQRDC.                         00000270
C                                                                       00000280
C        LDX    INTEGER.                                                00000290
C               LDX IS THE LEADING DIMENSION OF THE ARRAY X.            00000300
C                                                                       00000310
C        N      INTEGER.                                                00000320
C               N IS THE NUMBER OF ROWS OF THE MATRIX XK.  IT MUST      00000330
C               HAVE THE SAME VALUE AS N IN DQRDC.                      00000340
C                                                                       00000350
C        K      INTEGER.                                                00000360
C               K IS THE NUMBER OF COLUMNS OF THE MATRIX XK.  K         00000370
C               MUST NNOT BE GREATER THAN MIN(N,P), WHERE P IS THE      00000380
C               SAME AS IN THE CALLING SEQUENCE TO DQRDC.               00000390
C                                                                       00000400
C        QRAUX  DOUBLE PRECISION(P).                                    00000410
C               QRAUX CONTAINS THE AUXILIARY OUTPUT FROM DQRDC.         00000420
C                                                                       00000430
C        Y      DOUBLE PRECISION(N)                                     00000440
C               Y CONTAINS AN N-VECTOR THAT IS TO BE MANIPULATED        00000450
C               BY DQRSL.                                               00000460
C                                                                       00000470
C        JOB    INTEGER.                                                00000480
C               JOB SPECIFIES WHAT IS TO BE COMPUTED.  JOB HAS          00000490
C               THE DECIMAL EXPANSION ABCDE, WITH THE FOLLOWING         00000500
C               MEANING.                                                00000510
C                                                                       00000520
C                    IF A.NE.0, COMPUTE QY.                             00000530
C                    IF B,C,D, OR E .NE. 0, COMPUTE QTY.                00000540
C                    IF C.NE.0, COMPUTE B.                              00000550
C                    IF D.NE.0, COMPUTE RSD.                            00000560
C                    IF E.NE.0, COMPUTE XB.                             00000570
C                                                                       00000580
C               NOTE THAT A REQUEST TO COMPUTE B, RSD, OR XB            00000590
C               AUTOMATICALLY TRIGGERS THE COMPUTATION OF QTY, FOR      00000600
C               WHICH AN ARRAY MUST BE PROVIDED IN THE CALLING          00000610
C               SEQUENCE.                                               00000620
C                                                                       00000630
C     ON RETURN                                                         00000640
C                                                                       00000650
C        QY     DOUBLE PRECISION(N).                                    00000660
C               QY CONNTAINS Q*Y, IF ITS COMPUTATION HAS BEEN           00000670
C               REQUESTED.                                              00000680
C                                                                       00000690
C        QTY    DOUBLE PRECISION(N).                                    00000700
C               QTY CONTAINS TRANS(Q)*Y, IF ITS COMPUTATION HAS         00000710
C               BEEN REQUESTED.  HERE TRANS(Q) IS THE                   00000720
C               TRANSPOSE OF THE MATRIX Q.                              00000730
C                                                                       00000740
C        B      DOUBLE PRECISION(K)                                     00000750
C               B CONTAINS THE SOLUTION OF THE LEAST SQUARES PROBLEM    00000760
C                                                                       00000770
C                    MINIMIZE NORM2(Y - XK*B),                          00000780
C                                                                       00000790
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  (NOTE THAT      00000800
C               IF PIVOTING WAS REQUESTED IN DQRDC, THE J-TH            00000810
C               COMPONENT OF B WILL BE ASSOCIATED WITH COLUMN JPVT(J)   00000820
C               OF THE ORIGINAL MATRIX X THAT WAS INPUT INTO DQRDC.)    00000830
C                                                                       00000840
C        RSD    DOUBLE PRECISION(N).                                    00000850
C               RSD CONTAINS THE LEAST SQUARES RESIDUAL Y - XK*B,       00000860
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  RSD IS          00000870
C               ALSO THE ORTHOGONAL PROJECTION OF Y ONTO THE            00000880
C               ORTHOGONAL COMPLEMENT OF THE COLUMN SPACE OF XK.        00000890
C                                                                       00000900
C        XB     DOUBLE PRECISION(N).                                    00000910
C               XB CONTAINS THE LEAST SQUARES APPROXIMATION XK*B,       00000920
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  XB IS ALSO      00000930
C               THE ORTHOGONAL PROJECTION OF Y ONTO THE COLUMN SPACE    00000940
C               OF X.                                                   00000950
C                                                                       00000960
C        INFO   INTEGER.                                                00000970
C               INFO IS ZERO UNLESS THE COMPUTATION OF B HAS            00000980
C               BEEN REQUESTED AND R IS EXACTLY SINGULAR.  IN           00000990
C               THIS CASE, INFO IS THE INDEX OF THE FIRST ZERO          00001000
C               DIAGONAL ELEMENT OF R AND B IS LEFT UNALTERED.          00001010
C                                                                       00001020
C     THE PARAMETERS QY, QTY, B, RSD, AND XB ARE NOT REFERENCED         00001030
C     IF THEIR COMPUTATION IS NOT REQUESTED AND IN THIS CASE            00001040
C     CAN BE REPLACED BY DUMMY VARIABLES IN THE CALLING PROGRAM.        00001050
C     TO SAVE STORAGE, THE USER MAY IN SOME CASES USE THE SAME          00001060
C     ARRAY FOR DIFFERENT PARAMETERS IN THE CALLING SEQUENCE.  A        00001070
C     FREQUENTLY OCCURING EXAMPLE IS WHEN ONE WISHES TO COMPUTE         00001080
C     ANY OF B, RSD, OR XB AND DOES NOT NEED Y OR QTY.  IN THIS         00001090
C     CASE ONE MAY IDENTIFY Y, QTY, AND ONE OF B, RSD, OR XB, WHILE     00001100
C     PROVIDING SEPARATE ARRAYS FOR ANYTHING ELSE THAT IS TO BE         00001110
C     COMPUTED.  THUS THE CALLING SEQUENCE                              00001120
C                                                                       00001130
C          CALL DQRSL(X,LDX,N,K,QRAUX,Y,DUM,Y,B,Y,DUM,110,INFO)         00001140
C                                                                       00001150
C     WILL RESULT IN THE COMPUTATION OF B AND RSD, WITH RSD             00001160
C     OVERWRITING Y.  MORE GENERALLY, EACH ITEM IN THE FOLLOWING        00001170
C     LIST CONTAINS GROUPS OF PERMISSIBLE IDENTIFICATIONS FOR           00001180
C     A SINGLE CALLINNG SEQUENCE.                                       00001190
C                                                                       00001200
C          1. (Y,QTY,B) (RSD) (XB) (QY)                                 00001210
C                                                                       00001220
C          2. (Y,QTY,RSD) (B) (XB) (QY)                                 00001230
C                                                                       00001240
C          3. (Y,QTY,XB) (B) (RSD) (QY)                                 00001250
C                                                                       00001260
C          4. (Y,QY) (QTY,B) (RSD) (XB)                                 00001270
C                                                                       00001280
C          5. (Y,QY) (QTY,RSD) (B) (XB)                                 00001290
C                                                                       00001300
C          6. (Y,QY) (QTY,XB) (B) (RSD)                                 00001310
C                                                                       00001320
C     IN ANY GROUP THE VALUE RETURNED IN THE ARRAY ALLOCATED TO         00001330
C     THE GROUP CORRESPONDS TO THE LAST MEMBER OF THE GROUP.            00001340
C                                                                       00001350
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00001360
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00001370
C                                                                       00001380
C     DQRSL USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00001390
C                                                                       00001400
C     BLAS DAXPY,DCOPY,DDOT                                             00001410
C     FORTRAN DABS,MIN0,MOD                                             00001420
C                                                                       00001430
C     INTERNAL VARIABLES                                                00001440
C                                                                       00001450
      INTEGER I,J,JJ,JU,KP1                                             00001460
      DOUBLE PRECISION DDOT,T,TEMP                                      00001470
      LOGICAL CB,CQY,CQTY,CR,CXB                                        00001480
C                                                                       00001490
C                                                                       00001500
C     SET INFO FLAG.                                                    00001510
C                                                                       00001520
      INFO = 0                                                          00001530
C                                                                       00001540
C     DETERMINE WHAT IS TO BE COMPUTED.                                 00001550
C                                                                       00001560
      CQY = JOB/10000 .NE. 0                                            00001570
      CQTY = MOD(JOB,10000) .NE. 0                                      00001580
      CB = MOD(JOB,1000)/100 .NE. 0                                     00001590
      CR = MOD(JOB,100)/10 .NE. 0                                       00001600
      CXB = MOD(JOB,10) .NE. 0                                          00001610
      JU = MIN0(K,N-1)                                                  00001620
C                                                                       00001630
C     SPECIAL ACTION WHEN N=1.                                          00001640
C                                                                       00001650
      IF (JU .NE. 0) GO TO 40                                           00001660
         IF (CQY) QY(1) = Y(1)                                          00001670
         IF (CQTY) QTY(1) = Y(1)                                        00001680
         IF (CXB) XB(1) = Y(1)                                          00001690
         IF (.NOT.CB) GO TO 30                                          00001700
            IF (X(1,1) .NE. 0.0D0) GO TO 10                             00001710
               INFO = 1                                                 00001720
            GO TO 20                                                    00001730
   10       CONTINUE                                                    00001740
               B(1) = Y(1)/X(1,1)                                       00001750
   20       CONTINUE                                                    00001760
   30    CONTINUE                                                       00001770
         IF (CR) RSD(1) = 0.0D0                                         00001780
      GO TO 250                                                         00001790
   40 CONTINUE                                                          00001800
C                                                                       00001810
C        SET UP TO COMPUTE QY OR QTY.                                   00001820
C                                                                       00001830
         IF (CQY) CALL DCOPY(N,Y,1,QY,1)                                00001840
         IF (CQTY) CALL DCOPY(N,Y,1,QTY,1)                              00001850
         IF (.NOT.CQY) GO TO 70                                         00001860
C                                                                       00001870
C           COMPUTE QY.                                                 00001880
C                                                                       00001890
            DO 60 JJ = 1, JU                                            00001900
               J = JU - JJ + 1                                          00001910
               IF (QRAUX(J) .EQ. 0.0D0) GO TO 50                        00001920
                  TEMP = X(J,J)                                         00001930
                  X(J,J) = QRAUX(J)                                     00001940
                  T = -DDOT(N-J+1,X(J,J),1,QY(J),1)/X(J,J)              00001950
                  CALL DAXPY(N-J+1,T,X(J,J),1,QY(J),1)                  00001960
                  X(J,J) = TEMP                                         00001970
   50          CONTINUE                                                 00001980
   60       CONTINUE                                                    00001990
   70    CONTINUE                                                       00002000
         IF (.NOT.CQTY) GO TO 100                                       00002010
C                                                                       00002020
C           COMPUTE TRANS(Q)*Y.                                         00002030
C                                                                       00002040
            DO 90 J = 1, JU                                             00002050
               IF (QRAUX(J) .EQ. 0.0D0) GO TO 80                        00002060
                  TEMP = X(J,J)                                         00002070
                  X(J,J) = QRAUX(J)                                     00002080
                  T = -DDOT(N-J+1,X(J,J),1,QTY(J),1)/X(J,J)             00002090
                  CALL DAXPY(N-J+1,T,X(J,J),1,QTY(J),1)                 00002100
                  X(J,J) = TEMP                                         00002110
   80          CONTINUE                                                 00002120
   90       CONTINUE                                                    00002130
  100    CONTINUE                                                       00002140
C                                                                       00002150
C        SET UP TO COMPUTE B, RSD, OR XB.                               00002160
C                                                                       00002170
         IF (CB) CALL DCOPY(K,QTY,1,B,1)                                00002180
         KP1 = K + 1                                                    00002190
         IF (CXB) CALL DCOPY(K,QTY,1,XB,1)                              00002200
         IF (CR .AND. K .LT. N) CALL DCOPY(N-K,QTY(KP1),1,RSD(KP1),1)   00002210
         IF (.NOT.CXB .OR. KP1 .GT. N) GO TO 120                        00002220
            DO 110 I = KP1, N                                           00002230
               XB(I) = 0.0D0                                            00002240
  110       CONTINUE                                                    00002250
  120    CONTINUE                                                       00002260
         IF (.NOT.CR) GO TO 140                                         00002270
            DO 130 I = 1, K                                             00002280
               RSD(I) = 0.0D0                                           00002290
  130       CONTINUE                                                    00002300
  140    CONTINUE                                                       00002310
         IF (.NOT.CB) GO TO 190                                         00002320
C                                                                       00002330
C           COMPUTE B.                                                  00002340
C                                                                       00002350
            DO 170 JJ = 1, K                                            00002360
               J = K - JJ + 1                                           00002370
               IF (X(J,J) .NE. 0.0D0) GO TO 150                         00002380
                  INFO = J                                              00002390
C           ......EXIT                                                  00002400
                  GO TO 180                                             00002410
  150          CONTINUE                                                 00002420
               B(J) = B(J)/X(J,J)                                       00002430
               IF (J .EQ. 1) GO TO 160                                  00002440
                  T = -B(J)                                             00002450
                  CALL DAXPY(J-1,T,X(1,J),1,B,1)                        00002460
  160          CONTINUE                                                 00002470
  170       CONTINUE                                                    00002480
  180       CONTINUE                                                    00002490
  190    CONTINUE                                                       00002500
         IF (.NOT.CR .AND. .NOT.CXB) GO TO 240                          00002510
C                                                                       00002520
C           COMPUTE RSD OR XB AS REQUIRED.                              00002530
C                                                                       00002540
            DO 230 JJ = 1, JU                                           00002550
               J = JU - JJ + 1                                          00002560
               IF (QRAUX(J) .EQ. 0.0D0) GO TO 220                       00002570
                  TEMP = X(J,J)                                         00002580
                  X(J,J) = QRAUX(J)                                     00002590
                  IF (.NOT.CR) GO TO 200                                00002600
                     T = -DDOT(N-J+1,X(J,J),1,RSD(J),1)/X(J,J)          00002610
                     CALL DAXPY(N-J+1,T,X(J,J),1,RSD(J),1)              00002620
  200             CONTINUE                                              00002630
                  IF (.NOT.CXB) GO TO 210                               00002640
                     T = -DDOT(N-J+1,X(J,J),1,XB(J),1)/X(J,J)           00002650
                     CALL DAXPY(N-J+1,T,X(J,J),1,XB(J),1)               00002660
  210             CONTINUE                                              00002670
                  X(J,J) = TEMP                                         00002680
  220          CONTINUE                                                 00002690
  230       CONTINUE                                                    00002700
  240    CONTINUE                                                       00002710
  250 CONTINUE                                                          00002720
      RETURN                                                            00002730
      END                                                               00002740
