*#**********************************************************************

      SUBROUTINE DSPFA(AP,N,KPVT,INFO)                                  00000010

      INTEGER N,KPVT(1),INFO                                            00000020
      DOUBLE PRECISION AP(1)                                            00000030
C                                                                       00000040
C     DSPFA FACTORS A DOUBLE PRECISION SYMMETRIC MATRIX STORED IN       00000050
C     PACKED FORM BY ELIMINATION WITH SYMMETRIC PIVOTING.               00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW DSPFA BY DSPSL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW DSPFA BY DSPSL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW DSPFA BY DSPDI.               00000100
C     TO COMPUTE  INERTIA(A) , FOLLOW DSPFA BY DSPDI.                   00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW DSPFA BY DSPDI.                   00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        AP      DOUBLE PRECISION (N*(N+1)/2)                           00000160
C                THE PACKED FORM OF A SYMMETRIC MATRIX  A .  THE        00000170
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000180
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000190
C                SEE COMMENTS BELOW FOR DETAILS.                        00000200
C                                                                       00000210
C        N       INTEGER                                                00000220
C                THE ORDER OF THE MATRIX  A .                           00000230
C                                                                       00000240
C     OUTPUT                                                            00000250
C                                                                       00000260
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000270
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000280
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000290
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000300
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000310
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000320
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000330
C                                                                       00000340
C        KPVT    INTEGER(N)                                             00000350
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000360
C                                                                       00000370
C        INFO    INTEGER                                                00000380
C                = 0  NORMAL VALUE.                                     00000390
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000400
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000410
C                     BUT IT DOES INDICATE THAT DSPSL OR DSPDI MAY      00000420
C                     DIVIDE BY ZERO IF CALLED.                         00000430
C                                                                       00000440
C     PACKED STORAGE                                                    00000450
C                                                                       00000460
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000470
C          TRIANGLE OF A SYMMETRIC MATRIX.                              00000480
C                                                                       00000490
C                K = 0                                                  00000500
C                DO 20 J = 1, N                                         00000510
C                   DO 10 I = 1, J                                      00000520
C                      K = K + 1                                        00000530
C                      AP(K)  = A(I,J)                                  00000540
C             10    CONTINUE                                            00000550
C             20 CONTINUE                                               00000560
C                                                                       00000570
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000580
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000590
C                                                                       00000600
C     SUBROUTINES AND FUNCTIONS                                         00000610
C                                                                       00000620
C     BLAS DAXPY,DSWAP,IDAMAX                                           00000630
C     FORTRAN DABS,DMAX1,DSQRT                                          00000640
C                                                                       00000650
C     INTERNAL VARIABLES                                                00000660
C                                                                       00000670
      DOUBLE PRECISION AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T              00000680
      DOUBLE PRECISION ABSAKK,ALPHA,COLMAX,ROWMAX                       00000690
      INTEGER IDAMAX,IJ,IJJ,IK,IKM1,IM,IMAX,IMAXP1,IMIM,IMJ,IMK         00000700
      INTEGER J,JJ,JK,JKM1,JMAX,JMIM,K,KK,KM1,KM1K,KM1KM1,KM2,KSTEP     00000710
      LOGICAL SWAP                                                      00000720
C                                                                       00000730
C                                                                       00000740
C     INITIALIZE                                                        00000750
C                                                                       00000760
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000770
      ALPHA = (1.0D0 + DSQRT(17.0D0))/8.0D0                             00000780
C                                                                       00000790
      INFO = 0                                                          00000800
C                                                                       00000810
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000820
C                                                                       00000830
      K = N                                                             00000840
      IK = (N*(N - 1))/2                                                00000850
   10 CONTINUE                                                          00000860
C                                                                       00000870
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000880
C                                                                       00000890
C     ...EXIT                                                           00000900
         IF (K .EQ. 0) GO TO 200                                        00000910
         IF (K .GT. 1) GO TO 20                                         00000920
            KPVT(1) = 1                                                 00000930
            IF (AP(1) .EQ. 0.0D0) INFO = 1                              00000940
C     ......EXIT                                                        00000950
            GO TO 200                                                   00000960
   20    CONTINUE                                                       00000970
C                                                                       00000980
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00000990
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00001000
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00001010
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00001020
C        REQUIRED.                                                      00001030
C                                                                       00001040
         KM1 = K - 1                                                    00001050
         KK = IK + K                                                    00001060
         ABSAKK = DABS(AP(KK))                                          00001070
C                                                                       00001080
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00001090
C        COLUMN K.                                                      00001100
C                                                                       00001110
         IMAX = IDAMAX(K-1,AP(IK+1),1)                                  00001120
         IMK = IK + IMAX                                                00001130
         COLMAX = DABS(AP(IMK))                                         00001140
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00001150
            KSTEP = 1                                                   00001160
            SWAP = .FALSE.                                              00001170
         GO TO 90                                                       00001180
   30    CONTINUE                                                       00001190
C                                                                       00001200
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001210
C           ROW IMAX.                                                   00001220
C                                                                       00001230
            ROWMAX = 0.0D0                                              00001240
            IMAXP1 = IMAX + 1                                           00001250
            IM = IMAX*(IMAX - 1)/2                                      00001260
            IMJ = IM + 2*IMAX                                           00001270
            DO 40 J = IMAXP1, K                                         00001280
               ROWMAX = DMAX1(ROWMAX,DABS(AP(IMJ)))                     00001290
               IMJ = IMJ + J                                            00001300
   40       CONTINUE                                                    00001310
            IF (IMAX .EQ. 1) GO TO 50                                   00001320
               JMAX = IDAMAX(IMAX-1,AP(IM+1),1)                         00001330
               JMIM = JMAX + IM                                         00001340
               ROWMAX = DMAX1(ROWMAX,DABS(AP(JMIM)))                    00001350
   50       CONTINUE                                                    00001360
            IMIM = IMAX + IM                                            00001370
            IF (DABS(AP(IMIM)) .LT. ALPHA*ROWMAX) GO TO 60              00001380
               KSTEP = 1                                                00001390
               SWAP = .TRUE.                                            00001400
            GO TO 80                                                    00001410
   60       CONTINUE                                                    00001420
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001430
               KSTEP = 1                                                00001440
               SWAP = .FALSE.                                           00001450
            GO TO 80                                                    00001460
   70       CONTINUE                                                    00001470
               KSTEP = 2                                                00001480
               SWAP = IMAX .NE. KM1                                     00001490
   80       CONTINUE                                                    00001500
   90    CONTINUE                                                       00001510
         IF (DMAX1(ABSAKK,COLMAX) .NE. 0.0D0) GO TO 100                 00001520
C                                                                       00001530
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001540
C                                                                       00001550
            KPVT(K) = K                                                 00001560
            INFO = K                                                    00001570
         GO TO 190                                                      00001580
  100    CONTINUE                                                       00001590
         IF (KSTEP .EQ. 2) GO TO 140                                    00001600
C                                                                       00001610
C           1 X 1 PIVOT BLOCK.                                          00001620
C                                                                       00001630
            IF (.NOT.SWAP) GO TO 120                                    00001640
C                                                                       00001650
C              PERFORM AN INTERCHANGE.                                  00001660
C                                                                       00001670
               CALL DSWAP(IMAX,AP(IM+1),1,AP(IK+1),1)                   00001680
               IMJ = IK + IMAX                                          00001690
               DO 110 JJ = IMAX, K                                      00001700
                  J = K + IMAX - JJ                                     00001710
                  JK = IK + J                                           00001720
                  T = AP(JK)                                            00001730
                  AP(JK) = AP(IMJ)                                      00001740
                  AP(IMJ) = T                                           00001750
                  IMJ = IMJ - (J - 1)                                   00001760
  110          CONTINUE                                                 00001770
  120       CONTINUE                                                    00001780
C                                                                       00001790
C           PERFORM THE ELIMINATION.                                    00001800
C                                                                       00001810
            IJ = IK - (K - 1)                                           00001820
            DO 130 JJ = 1, KM1                                          00001830
               J = K - JJ                                               00001840
               JK = IK + J                                              00001850
               MULK = -AP(JK)/AP(KK)                                    00001860
               T = MULK                                                 00001870
               CALL DAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                    00001880
               IJJ = IJ + J                                             00001890
               AP(JK) = MULK                                            00001900
               IJ = IJ - (J - 1)                                        00001910
  130       CONTINUE                                                    00001920
C                                                                       00001930
C           SET THE PIVOT ARRAY.                                        00001940
C                                                                       00001950
            KPVT(K) = K                                                 00001960
            IF (SWAP) KPVT(K) = IMAX                                    00001970
         GO TO 190                                                      00001980
  140    CONTINUE                                                       00001990
C                                                                       00002000
C           2 X 2 PIVOT BLOCK.                                          00002010
C                                                                       00002020
            KM1K = IK + K - 1                                           00002030
            IKM1 = IK - (K - 1)                                         00002040
            IF (.NOT.SWAP) GO TO 160                                    00002050
C                                                                       00002060
C              PERFORM AN INTERCHANGE.                                  00002070
C                                                                       00002080
               CALL DSWAP(IMAX,AP(IM+1),1,AP(IKM1+1),1)                 00002090
               IMJ = IKM1 + IMAX                                        00002100
               DO 150 JJ = IMAX, KM1                                    00002110
                  J = KM1 + IMAX - JJ                                   00002120
                  JKM1 = IKM1 + J                                       00002130
                  T = AP(JKM1)                                          00002140
                  AP(JKM1) = AP(IMJ)                                    00002150
                  AP(IMJ) = T                                           00002160
                  IMJ = IMJ - (J - 1)                                   00002170
  150          CONTINUE                                                 00002180
               T = AP(KM1K)                                             00002190
               AP(KM1K) = AP(IMK)                                       00002200
               AP(IMK) = T                                              00002210
  160       CONTINUE                                                    00002220
C                                                                       00002230
C           PERFORM THE ELIMINATION.                                    00002240
C                                                                       00002250
            KM2 = K - 2                                                 00002260
            IF (KM2 .EQ. 0) GO TO 180                                   00002270
               AK = AP(KK)/AP(KM1K)                                     00002280
               KM1KM1 = IKM1 + K - 1                                    00002290
               AKM1 = AP(KM1KM1)/AP(KM1K)                               00002300
               DENOM = 1.0D0 - AK*AKM1                                  00002310
               IJ = IK - (K - 1) - (K - 2)                              00002320
               DO 170 JJ = 1, KM2                                       00002330
                  J = KM1 - JJ                                          00002340
                  JK = IK + J                                           00002350
                  BK = AP(JK)/AP(KM1K)                                  00002360
                  JKM1 = IKM1 + J                                       00002370
                  BKM1 = AP(JKM1)/AP(KM1K)                              00002380
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002390
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002400
                  T = MULK                                              00002410
                  CALL DAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                 00002420
                  T = MULKM1                                            00002430
                  CALL DAXPY(J,T,AP(IKM1+1),1,AP(IJ+1),1)               00002440
                  AP(JK) = MULK                                         00002450
                  AP(JKM1) = MULKM1                                     00002460
                  IJJ = IJ + J                                          00002470
                  IJ = IJ - (J - 1)                                     00002480
  170          CONTINUE                                                 00002490
  180       CONTINUE                                                    00002500
C                                                                       00002510
C           SET THE PIVOT ARRAY.                                        00002520
C                                                                       00002530
            KPVT(K) = 1 - K                                             00002540
            IF (SWAP) KPVT(K) = -IMAX                                   00002550
            KPVT(K-1) = KPVT(K)                                         00002560
  190    CONTINUE                                                       00002570
         IK = IK - (K - 1)                                              00002580
         IF (KSTEP .EQ. 2) IK = IK - (K - 2)                            00002590
         K = K - KSTEP                                                  00002600
      GO TO 10                                                          00002610
  200 CONTINUE                                                          00002620
      RETURN                                                            00002630
      END                                                               00002640
