*#**********************************************************************

      SUBROUTINE DSVDC(X,LDX,N,P,S,E,U,LDU,V,LDV,WORK,JOB,INFO)         00000010

      INTEGER LDX,N,P,LDU,LDV,JOB,INFO                                  00000020
      DOUBLE PRECISION X(LDX,1),S(1),E(1),U(LDU,1),V(LDV,1),WORK(1)     00000030
C                                                                       00000040
C                                                                       00000050
C     DSVDC IS A SUBROUTINE TO REDUCE A DOUBLE PRECISION NXP MATRIX X   00000060
C     BY ORTHOGONAL TRANSFORMATIONS U AND V TO DIAGONAL FORM.  THE      00000070
C     DIAGONAL ELEMENTS S(I) ARE THE SINGULAR VALUES OF X.  THE         00000080
C     COLUMNS OF U ARE THE CORRESPONDING LEFT SINGULAR VECTORS,         00000090
C     AND THE COLUMNS OF V THE RIGHT SINGULAR VECTORS.                  00000100
C                                                                       00000110
C     ON ENTRY                                                          00000120
C                                                                       00000130
C         X         DOUBLE PRECISION(LDX,P), WHERE LDX.GE.N.            00000140
C                   X CONTAINS THE MATRIX WHOSE SINGULAR VALUE          00000150
C                   DECOMPOSITION IS TO BE COMPUTED.  X IS              00000160
C                   DESTROYED BY DSVDC.                                 00000170
C                                                                       00000180
C         LDX       INTEGER.                                            00000190
C                   LDX IS THE LEADING DIMENSION OF THE ARRAY X.        00000200
C                                                                       00000210
C         N         INTEGER.                                            00000220
C                   N IS THE NUMBER OF COLUMNS OF THE MATRIX X.         00000230
C                                                                       00000240
C         P         INTEGER.                                            00000250
C                   P IS THE NUMBER OF ROWS OF THE MATRIX X.            00000260
C                                                                       00000270
C         LDU       INTEGER.                                            00000280
C                   LDU IS THE LEADING DIMENSION OF THE ARRAY U.        00000290
C                   (SEE BELOW).                                        00000300
C                                                                       00000310
C         LDV       INTEGER.                                            00000320
C                   LDV IS THE LEADING DIMENSION OF THE ARRAY V.        00000330
C                   (SEE BELOW).                                        00000340
C                                                                       00000350
C         WORK      DOUBLE PRECISION(N).                                00000360
C                   WORK IS A SCRATCH ARRAY.                            00000370
C                                                                       00000380
C         JOB       INTEGER.                                            00000390
C                   JOB CONTROLS THE COMPUTATION OF THE SINGULAR        00000400
C                   VECTORS.  IT HAS THE DECIMAL EXPANSION AB           00000410
C                   WITH THE FOLLOWING MEANING                          00000420
C                                                                       00000430
C                        A.EQ.0    DO NOT COMPUTE THE LEFT SINGULAR     00000440
C                                  VECTORS.                             00000450
C                        A.EQ.1    RETURN THE N LEFT SINGULAR VECTORS   00000460
C                                  IN U.                                00000470
C                        A.GE.2    RETURN THE FIRST MIN(N,P) SINGULAR   00000480
C                                  VECTORS IN U.                        00000490
C                        B.EQ.0    DO NOT COMPUTE THE RIGHT SINGULAR    00000500
C                                  VECTORS.                             00000510
C                        B.EQ.1    RETURN THE RIGHT SINGULAR VECTORS    00000520
C                                  IN V.                                00000530
C                                                                       00000540
C     ON RETURN                                                         00000550
C                                                                       00000560
C         S         DOUBLE PRECISION(MM), WHERE MM=MIN(N+1,P).          00000570
C                   THE FIRST MIN(N,P) ENTRIES OF S CONTAIN THE         00000580
C                   SINGULAR VALUES OF X ARRANGED IN DESCENDING         00000590
C                   ORDER OF MAGNITUDE.                                 00000600
C                                                                       00000610
C         E         DOUBLE PRECISION(P)                                 00000620
C                   E ORDINARILY CONTAINS ZEROS.  HOWEVER SEE THE       00000630
C                   DISCUSSION OF INFO FOR EXCEPTIONS.                  00000640
C                                                                       00000650
C         U         DOUBLE PRECISION(LDU,K), WHERE LDU.GE.N.  IF        00000660
C                                   JOBA.EQ.1 THEN K.EQ.N, IF JOBA.GE.2 00000670
C                                   THEN K.EQ.MIN(N,P).                 00000680
C                   U CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.    00000690
C                   U IS NOT REFERENCED IF JOBA.EQ.0.  IF N.LE.P        00000700
C                   OR IF JOBA.EQ.2, THEN U MAY BE IDENTIFIED WITH X    00000710
C                   IN THE SUBROUTINE CALL.                             00000720
C                                                                       00000730
C         V         DOUBLE PRECISION(LDV,P), WHERE LDV.GE.P.            00000740
C                   V CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.    00000750
C                   V IS NOT REFERENCED IF JOB.EQ.0.  IF P.LE.N,        00000760
C                   THEN V MAY BE IDENTIFIED WITH X IN THE              00000770
C                   SUBROUTINE CALL.                                    00000780
C                                                                       00000790
C         INFO      INTEGER.                                            00000800
C                   THE SINGULAR VALUES (AND THEIR CORRESPONDING        00000810
C                   SINGULAR VECTORS) S(INFO+1),S(INFO+2),...,S(M)      00000820
C                   ARE CORRECT (HERE M=MIN(N,P)).  THUS IF             00000830
C                   INFO.EQ.0, ALL THE SINGULAR VALUES AND THEIR        00000840
C                   VECTORS ARE CORRECT.  IN ANY EVENT, THE MATRIX      00000850
C                   B = TRANS(U)*X*V IS THE BIDIAGONAL MATRIX           00000860
C                   WITH THE ELEMENTS OF S ON ITS DIAGONAL AND THE      00000870
C                   ELEMENTS OF E ON ITS SUPER-DIAGONAL (TRANS(U)       00000880
C                   IS THE TRANSPOSE OF U).  THUS THE SINGULAR          00000890
C                   VALUES OF X AND B ARE THE SAME.                     00000900
C                                                                       00000910
C     LINPACK. THIS VERSION DATED 03/19/79 .                            00000920
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00000930
C                                                                       00000940
C     DSVDC USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00000950
C                                                                       00000960
C     EXTERNAL DROT                                                     00000970
C     BLAS DAXPY,DDOT,DSCAL,DSWAP,DNRM2,DROTG                           00000980
C     FORTRAN DABS,DMAX1,MAX0,MIN0,MOD,DSQRT                            00000990
C                                                                       00001000
C     INTERNAL VARIABLES                                                00001010
C                                                                       00001020
      INTEGER I,ITER,J,JOBU,K,KASE,KK,L,LL,LLS,LM1,LP1,LS,LU,M,MAXIT,   00001030
     *        MM,MM1,MP1,NCT,NCTP1,NCU,NRT,NRTP1                        00001040
      DOUBLE PRECISION DDOT,T,R                                         00001050
      DOUBLE PRECISION B,C,CS,EL,EMM1,F,G,DNRM2,SCALE,SHIFT,SL,SM,SN,   00001060
     *                 SMM1,T1,TEST,ZTEST                               00001070
      LOGICAL WANTU,WANTV                                               00001080
C                                                                       00001090
C                                                                       00001100
C     SET THE MAXIMUM NUMBER OF ITERATIONS.                             00001110
C                                                                       00001120
      MAXIT = 30                                                        00001130
C                                                                       00001140
C     DETERMINE WHAT IS TO BE COMPUTED.                                 00001150
C                                                                       00001160
      WANTU = .FALSE.                                                   00001170
      WANTV = .FALSE.                                                   00001180
      JOBU = MOD(JOB,100)/10                                            00001190
      NCU = N                                                           00001200
      IF (JOBU .GT. 1) NCU = MIN0(N,P)                                  00001210
      IF (JOBU .NE. 0) WANTU = .TRUE.                                   00001220
      IF (MOD(JOB,10) .NE. 0) WANTV = .TRUE.                            00001230
C                                                                       00001240
C     REDUCE X TO BIDIAGONAL FORM, STORING THE DIAGONAL ELEMENTS        00001250
C     IN S AND THE SUPER-DIAGONAL ELEMENTS IN E.                        00001260
C                                                                       00001270
      INFO = 0                                                          00001280
      NCT = MIN0(N-1,P)                                                 00001290
      NRT = MAX0(0,MIN0(P-2,N))                                         00001300
      LU = MAX0(NCT,NRT)                                                00001310
      IF (LU .LT. 1) GO TO 170                                          00001320
      DO 160 L = 1, LU                                                  00001330
         LP1 = L + 1                                                    00001340
         IF (L .GT. NCT) GO TO 20                                       00001350
C                                                                       00001360
C           COMPUTE THE TRANSFORMATION FOR THE L-TH COLUMN AND          00001370
C           PLACE THE L-TH DIAGONAL IN S(L).                            00001380
C                                                                       00001390
            S(L) = DNRM2(N-L+1,X(L,L),1)                                00001400
            IF (S(L) .EQ. 0.0D0) GO TO 10                               00001410
               IF (X(L,L) .NE. 0.0D0) S(L) = DSIGN(S(L),X(L,L))         00001420
               CALL DSCAL(N-L+1,1.0D0/S(L),X(L,L),1)                    00001430
               X(L,L) = 1.0D0 + X(L,L)                                  00001440
   10       CONTINUE                                                    00001450
            S(L) = -S(L)                                                00001460
   20    CONTINUE                                                       00001470
         IF (P .LT. LP1) GO TO 50                                       00001480
         DO 40 J = LP1, P                                               00001490
            IF (L .GT. NCT) GO TO 30                                    00001500
            IF (S(L) .EQ. 0.0D0) GO TO 30                               00001510
C                                                                       00001520
C              APPLY THE TRANSFORMATION.                                00001530
C                                                                       00001540
               T = -DDOT(N-L+1,X(L,L),1,X(L,J),1)/X(L,L)                00001550
               CALL DAXPY(N-L+1,T,X(L,L),1,X(L,J),1)                    00001560
   30       CONTINUE                                                    00001570
C                                                                       00001580
C           PLACE THE L-TH ROW OF X INTO  E FOR THE                     00001590
C           SUBSEQUENT CALCULATION OF THE ROW TRANSFORMATION.           00001600
C                                                                       00001610
            E(J) = X(L,J)                                               00001620
   40    CONTINUE                                                       00001630
   50    CONTINUE                                                       00001640
         IF (.NOT.WANTU .OR. L .GT. NCT) GO TO 70                       00001650
C                                                                       00001660
C           PLACE THE TRANSFORMATION IN U FOR SUBSEQUENT BACK           00001670
C           MULTIPLICATION.                                             00001680
C                                                                       00001690
            DO 60 I = L, N                                              00001700
               U(I,L) = X(I,L)                                          00001710
   60       CONTINUE                                                    00001720
   70    CONTINUE                                                       00001730
         IF (L .GT. NRT) GO TO 150                                      00001740
C                                                                       00001750
C           COMPUTE THE L-TH ROW TRANSFORMATION AND PLACE THE           00001760
C           L-TH SUPER-DIAGONAL IN E(L).                                00001770
C                                                                       00001780
            E(L) = DNRM2(P-L,E(LP1),1)                                  00001790
            IF (E(L) .EQ. 0.0D0) GO TO 80                               00001800
               IF (E(LP1) .NE. 0.0D0) E(L) = DSIGN(E(L),E(LP1))         00001810
               CALL DSCAL(P-L,1.0D0/E(L),E(LP1),1)                      00001820
               E(LP1) = 1.0D0 + E(LP1)                                  00001830
   80       CONTINUE                                                    00001840
            E(L) = -E(L)                                                00001850
            IF (LP1 .GT. N .OR. E(L) .EQ. 0.0D0) GO TO 120              00001860
C                                                                       00001870
C              APPLY THE TRANSFORMATION.                                00001880
C                                                                       00001890
               DO 90 I = LP1, N                                         00001900
                  WORK(I) = 0.0D0                                       00001910
   90          CONTINUE                                                 00001920
               DO 100 J = LP1, P                                        00001930
                  CALL DAXPY(N-L,E(J),X(LP1,J),1,WORK(LP1),1)           00001940
  100          CONTINUE                                                 00001950
               DO 110 J = LP1, P                                        00001960
                  CALL DAXPY(N-L,-E(J)/E(LP1),WORK(LP1),1,X(LP1,J),1)   00001970
  110          CONTINUE                                                 00001980
  120       CONTINUE                                                    00001990
            IF (.NOT.WANTV) GO TO 140                                   00002000
C                                                                       00002010
C              PLACE THE TRANSFORMATION IN V FOR SUBSEQUENT             00002020
C              BACK MULTIPLICATION.                                     00002030
C                                                                       00002040
               DO 130 I = LP1, P                                        00002050
                  V(I,L) = E(I)                                         00002060
  130          CONTINUE                                                 00002070
  140       CONTINUE                                                    00002080
  150    CONTINUE                                                       00002090
  160 CONTINUE                                                          00002100
  170 CONTINUE                                                          00002110
C                                                                       00002120
C     SET UP THE FINAL BIDIAGONAL MATRIX OR ORDER M.                    00002130
C                                                                       00002140
      M = MIN0(P,N+1)                                                   00002150
      NCTP1 = NCT + 1                                                   00002160
      NRTP1 = NRT + 1                                                   00002170
      IF (NCT .LT. P) S(NCTP1) = X(NCTP1,NCTP1)                         00002180
      IF (N .LT. M) S(M) = 0.0D0                                        00002190
      IF (NRTP1 .LT. M) E(NRTP1) = X(NRTP1,M)                           00002200
      E(M) = 0.0D0                                                      00002210
C                                                                       00002220
C     IF REQUIRED, GENERATE U.                                          00002230
C                                                                       00002240
      IF (.NOT.WANTU) GO TO 300                                         00002250
         IF (NCU .LT. NCTP1) GO TO 200                                  00002260
         DO 190 J = NCTP1, NCU                                          00002270
            DO 180 I = 1, N                                             00002280
               U(I,J) = 0.0D0                                           00002290
  180       CONTINUE                                                    00002300
            U(J,J) = 1.0D0                                              00002310
  190    CONTINUE                                                       00002320
  200    CONTINUE                                                       00002330
         IF (NCT .LT. 1) GO TO 290                                      00002340
         DO 280 LL = 1, NCT                                             00002350
            L = NCT - LL + 1                                            00002360
            IF (S(L) .EQ. 0.0D0) GO TO 250                              00002370
               LP1 = L + 1                                              00002380
               IF (NCU .LT. LP1) GO TO 220                              00002390
               DO 210 J = LP1, NCU                                      00002400
                  T = -DDOT(N-L+1,U(L,L),1,U(L,J),1)/U(L,L)             00002410
                  CALL DAXPY(N-L+1,T,U(L,L),1,U(L,J),1)                 00002420
  210          CONTINUE                                                 00002430
  220          CONTINUE                                                 00002440
               CALL DSCAL(N-L+1,-1.0D0,U(L,L),1)                        00002450
               U(L,L) = 1.0D0 + U(L,L)                                  00002460
               LM1 = L - 1                                              00002470
               IF (LM1 .LT. 1) GO TO 240                                00002480
               DO 230 I = 1, LM1                                        00002490
                  U(I,L) = 0.0D0                                        00002500
  230          CONTINUE                                                 00002510
  240          CONTINUE                                                 00002520
            GO TO 270                                                   00002530
  250       CONTINUE                                                    00002540
               DO 260 I = 1, N                                          00002550
                  U(I,L) = 0.0D0                                        00002560
  260          CONTINUE                                                 00002570
               U(L,L) = 1.0D0                                           00002580
  270       CONTINUE                                                    00002590
  280    CONTINUE                                                       00002600
  290    CONTINUE                                                       00002610
  300 CONTINUE                                                          00002620
C                                                                       00002630
C     IF IT IS REQUIRED, GENERATE V.                                    00002640
C                                                                       00002650
      IF (.NOT.WANTV) GO TO 350                                         00002660
         DO 340 LL = 1, P                                               00002670
            L = P - LL + 1                                              00002680
            LP1 = L + 1                                                 00002690
            IF (L .GT. NRT) GO TO 320                                   00002700
            IF (E(L) .EQ. 0.0D0) GO TO 320                              00002710
               DO 310 J = LP1, P                                        00002720
                  T = -DDOT(P-L,V(LP1,L),1,V(LP1,J),1)/V(LP1,L)         00002730
                  CALL DAXPY(P-L,T,V(LP1,L),1,V(LP1,J),1)               00002740
  310          CONTINUE                                                 00002750
  320       CONTINUE                                                    00002760
            DO 330 I = 1, P                                             00002770
               V(I,L) = 0.0D0                                           00002780
  330       CONTINUE                                                    00002790
            V(L,L) = 1.0D0                                              00002800
  340    CONTINUE                                                       00002810
  350 CONTINUE                                                          00002820
C                                                                       00002830
C     MAIN ITERATION LOOP FOR THE SINGULAR VALUES.                      00002840
C                                                                       00002850
      MM = M                                                            00002860
      ITER = 0                                                          00002870
  360 CONTINUE                                                          00002880
C                                                                       00002890
C        QUIT IF ALL THE SINGULAR VALUES HAVE BEEN FOUND.               00002900
C                                                                       00002910
C     ...EXIT                                                           00002920
         IF (M .EQ. 0) GO TO 620                                        00002930
C                                                                       00002940
C        IF TOO MANY ITERATIONS HAVE BEEN PERFORMED, SET                00002950
C        FLAG AND RETURN.                                               00002960
C                                                                       00002970
         IF (ITER .LT. MAXIT) GO TO 370                                 00002980
            INFO = M                                                    00002990
C     ......EXIT                                                        00003000
            GO TO 620                                                   00003010
  370    CONTINUE                                                       00003020
C                                                                       00003030
C        THIS SECTION OF THE PROGRAM INSPECTS FOR                       00003040
C        NEGLIGIBLE ELEMENTS IN THE S AND E ARRAYS.  ON                 00003050
C        COMPLETION THE VARIABLES KASE AND L ARE SET AS FOLLOWS.        00003060
C                                                                       00003070
C           KASE = 1     IF S(M) AND E(L-1) ARE NEGLIGIBLE AND L.LT.M   00003080
C           KASE = 2     IF S(L) IS NEGLIGIBLE AND L.LT.M               00003090
C           KASE = 3     IF E(L-1) IS NEGLIGIBLE, L.LT.M, AND           00003100
C                        S(L), ..., S(M) ARE NOT NEGLIGIBLE (QR STEP).  00003110
C           KASE = 4     IF E(M-1) IS NEGLIGIBLE (CONVERGENCE).         00003120
C                                                                       00003130
         DO 390 LL = 1, M                                               00003140
            L = M - LL                                                  00003150
C        ...EXIT                                                        00003160
            IF (L .EQ. 0) GO TO 400                                     00003170
            TEST = DABS(S(L)) + DABS(S(L+1))                            00003180
            ZTEST = TEST + DABS(E(L))                                   00003190
            IF (ZTEST .NE. TEST) GO TO 380                              00003200
               E(L) = 0.0D0                                             00003210
C        ......EXIT                                                     00003220
               GO TO 400                                                00003230
  380       CONTINUE                                                    00003240
  390    CONTINUE                                                       00003250
  400    CONTINUE                                                       00003260
         IF (L .NE. M - 1) GO TO 410                                    00003270
            KASE = 4                                                    00003280
         GO TO 480                                                      00003290
  410    CONTINUE                                                       00003300
            LP1 = L + 1                                                 00003310
            MP1 = M + 1                                                 00003320
            DO 430 LLS = LP1, MP1                                       00003330
               LS = M - LLS + LP1                                       00003340
C           ...EXIT                                                     00003350
               IF (LS .EQ. L) GO TO 440                                 00003360
               TEST = 0.0D0                                             00003370
               IF (LS .NE. M) TEST = TEST + DABS(E(LS))                 00003380
               IF (LS .NE. L + 1) TEST = TEST + DABS(E(LS-1))           00003390
               ZTEST = TEST + DABS(S(LS))                               00003400
               IF (ZTEST .NE. TEST) GO TO 420                           00003410
                  S(LS) = 0.0D0                                         00003420
C           ......EXIT                                                  00003430
                  GO TO 440                                             00003440
  420          CONTINUE                                                 00003450
  430       CONTINUE                                                    00003460
  440       CONTINUE                                                    00003470
            IF (LS .NE. L) GO TO 450                                    00003480
               KASE = 3                                                 00003490
            GO TO 470                                                   00003500
  450       CONTINUE                                                    00003510
            IF (LS .NE. M) GO TO 460                                    00003520
               KASE = 1                                                 00003530
            GO TO 470                                                   00003540
  460       CONTINUE                                                    00003550
               KASE = 2                                                 00003560
               L = LS                                                   00003570
  470       CONTINUE                                                    00003580
  480    CONTINUE                                                       00003590
         L = L + 1                                                      00003600
C                                                                       00003610
C        PERFORM THE TASK INDICATED BY KASE.                            00003620
C                                                                       00003630
         GO TO (490,520,540,570), KASE                                  00003640
C                                                                       00003650
C        DEFLATE NEGLIGIBLE S(M).                                       00003660
C                                                                       00003670
  490    CONTINUE                                                       00003680
            MM1 = M - 1                                                 00003690
            F = E(M-1)                                                  00003700
            E(M-1) = 0.0D0                                              00003710
            DO 510 KK = L, MM1                                          00003720
               K = MM1 - KK + L                                         00003730
               T1 = S(K)                                                00003740
               CALL DROTG(T1,F,CS,SN)                                   00003750
               S(K) = T1                                                00003760
               IF (K .EQ. L) GO TO 500                                  00003770
                  F = -SN*E(K-1)                                        00003780
                  E(K-1) = CS*E(K-1)                                    00003790
  500          CONTINUE                                                 00003800
               IF (WANTV) CALL DROT(P,V(1,K),1,V(1,M),1,CS,SN)          00003810
  510       CONTINUE                                                    00003820
         GO TO 610                                                      00003830
C                                                                       00003840
C        SPLIT AT NEGLIGIBLE S(L).                                      00003850
C                                                                       00003860
  520    CONTINUE                                                       00003870
            F = E(L-1)                                                  00003880
            E(L-1) = 0.0D0                                              00003890
            DO 530 K = L, M                                             00003900
               T1 = S(K)                                                00003910
               CALL DROTG(T1,F,CS,SN)                                   00003920
               S(K) = T1                                                00003930
               F = -SN*E(K)                                             00003940
               E(K) = CS*E(K)                                           00003950
               IF (WANTU) CALL DROT(N,U(1,K),1,U(1,L-1),1,CS,SN)        00003960
  530       CONTINUE                                                    00003970
         GO TO 610                                                      00003980
C                                                                       00003990
C        PERFORM ONE QR STEP.                                           00004000
C                                                                       00004010
  540    CONTINUE                                                       00004020
C                                                                       00004030
C           CALCULATE THE SHIFT.                                        00004040
C                                                                       00004050
            SCALE = DMAX1(DABS(S(M)),DABS(S(M-1)),DABS(E(M-1)),         00004060
     *                    DABS(S(L)),DABS(E(L)))                        00004070
            SM = S(M)/SCALE                                             00004080
            SMM1 = S(M-1)/SCALE                                         00004090
            EMM1 = E(M-1)/SCALE                                         00004100
            SL = S(L)/SCALE                                             00004110
            EL = E(L)/SCALE                                             00004120
            B = ((SMM1 + SM)*(SMM1 - SM) + EMM1**2)/2.0D0               00004130
            C = (SM*EMM1)**2                                            00004140
            SHIFT = 0.0D0                                               00004150
            IF (B .EQ. 0.0D0 .AND. C .EQ. 0.0D0) GO TO 550              00004160
               SHIFT = DSQRT(B**2+C)                                    00004170
               IF (B .LT. 0.0D0) SHIFT = -SHIFT                         00004180
               SHIFT = C/(B + SHIFT)                                    00004190
  550       CONTINUE                                                    00004200
            F = (SL + SM)*(SL - SM) - SHIFT                             00004210
            G = SL*EL                                                   00004220
C                                                                       00004230
C           CHASE ZEROS.                                                00004240
C                                                                       00004250
            MM1 = M - 1                                                 00004260
            DO 560 K = L, MM1                                           00004270
               CALL DROTG(F,G,CS,SN)                                    00004280
               IF (K .NE. L) E(K-1) = F                                 00004290
               F = CS*S(K) + SN*E(K)                                    00004300
               E(K) = CS*E(K) - SN*S(K)                                 00004310
               G = SN*S(K+1)                                            00004320
               S(K+1) = CS*S(K+1)                                       00004330
               IF (WANTV) CALL DROT(P,V(1,K),1,V(1,K+1),1,CS,SN)        00004340
               CALL DROTG(F,G,CS,SN)                                    00004350
               S(K) = F                                                 00004360
               F = CS*E(K) + SN*S(K+1)                                  00004370
               S(K+1) = -SN*E(K) + CS*S(K+1)                            00004380
               G = SN*E(K+1)                                            00004390
               E(K+1) = CS*E(K+1)                                       00004400
               IF (WANTU .AND. K .LT. N)                                00004410
     *            CALL DROT(N,U(1,K),1,U(1,K+1),1,CS,SN)                00004420
  560       CONTINUE                                                    00004430
            E(M-1) = F                                                  00004440
            ITER = ITER + 1                                             00004450
         GO TO 610                                                      00004460
C                                                                       00004470
C        CONVERGENCE.                                                   00004480
C                                                                       00004490
  570    CONTINUE                                                       00004500
C                                                                       00004510
C           MAKE THE SINGULAR VALUE  POSITIVE.                          00004520
C                                                                       00004530
            IF (S(L) .GE. 0.0D0) GO TO 580                              00004540
               S(L) = -S(L)                                             00004550
               IF (WANTV) CALL DSCAL(P,-1.0D0,V(1,L),1)                 00004560
  580       CONTINUE                                                    00004570
C                                                                       00004580
C           ORDER THE SINGULAR VALUE.                                   00004590
C                                                                       00004600
  590       IF (L .EQ. MM) GO TO 600                                    00004610
C           ...EXIT                                                     00004620
               IF (S(L) .GE. S(L+1)) GO TO 600                          00004630
               T = S(L)                                                 00004640
               S(L) = S(L+1)                                            00004650
               S(L+1) = T                                               00004660
               IF (WANTV .AND. L .LT. P)                                00004670
     *            CALL DSWAP(P,V(1,L),1,V(1,L+1),1)                     00004680
               IF (WANTU .AND. L .LT. N)                                00004690
     *            CALL DSWAP(N,U(1,L),1,U(1,L+1),1)                     00004700
               L = L + 1                                                00004710
            GO TO 590                                                   00004720
  600       CONTINUE                                                    00004730
            ITER = 0                                                    00004740
            M = M - 1                                                   00004750
  610    CONTINUE                                                       00004760
      GO TO 360                                                         00004770
  620 CONTINUE                                                          00004780
      RETURN                                                            00004790
      END                                                               00004800
