*#**********************************************************************

      SUBROUTINE DTRCO(T,LDT,N,RCOND,Z,JOB)                             00000010

      INTEGER LDT,N,JOB                                                 00000020
      DOUBLE PRECISION T(LDT,1),Z(1)                                    00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     DTRCO ESTIMATES THE CONDITION OF A DOUBLE PRECISION TRIANGULAR    00000060
C     MATRIX.                                                           00000070
C                                                                       00000080
C     ON ENTRY                                                          00000090
C                                                                       00000100
C        T       DOUBLE PRECISION(LDT,N)                                00000110
C                T CONTAINS THE TRIANGULAR MATRIX. THE ZERO             00000120
C                ELEMENTS OF THE MATRIX ARE NOT REFERENCED, AND         00000130
C                THE CORRESPONDING ELEMENTS OF THE ARRAY CAN BE         00000140
C                USED TO STORE OTHER INFORMATION.                       00000150
C                                                                       00000160
C        LDT     INTEGER                                                00000170
C                LDT IS THE LEADING DIMENSION OF THE ARRAY T.           00000180
C                                                                       00000190
C        N       INTEGER                                                00000200
C                N IS THE ORDER OF THE SYSTEM.                          00000210
C                                                                       00000220
C        JOB     INTEGER                                                00000230
C                = 0         T  IS LOWER TRIANGULAR.                    00000240
C                = NONZERO   T  IS UPPER TRIANGULAR.                    00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        RCOND   DOUBLE PRECISION                                       00000290
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  T .        00000300
C                FOR THE SYSTEM  T*X = B , RELATIVE PERTURBATIONS       00000310
C                IN  T  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000320
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000330
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000340
C                           1.0 + RCOND .EQ. 1.0                        00000350
C                IS TRUE, THEN  T  MAY BE SINGULAR TO WORKING           00000360
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000370
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000380
C                UNDERFLOWS.                                            00000390
C                                                                       00000400
C        Z       DOUBLE PRECISION(N)                                    00000410
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000420
C                IF  T  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000430
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000440
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000450
C                                                                       00000460
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000470
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000480
C                                                                       00000490
C     SUBROUTINES AND FUNCTIONS                                         00000500
C                                                                       00000510
C     BLAS DAXPY,DSCAL,DASUM                                            00000520
C     FORTRAN DABS,DMAX1,DSIGN                                          00000530
C                                                                       00000540
C     INTERNAL VARIABLES                                                00000550
C                                                                       00000560
      DOUBLE PRECISION W,WK,WKM,EK                                      00000570
      DOUBLE PRECISION TNORM,YNORM,S,SM,DASUM                           00000580
      INTEGER I1,J,J1,J2,K,KK,L                                         00000590
      LOGICAL LOWER                                                     00000600
C                                                                       00000610
      LOWER = JOB .EQ. 0                                                00000620
C                                                                       00000630
C     COMPUTE 1-NORM OF T                                               00000640
C                                                                       00000650
      TNORM = 0.0D0                                                     00000660
      DO 10 J = 1, N                                                    00000670
         L = J                                                          00000680
         IF (LOWER) L = N + 1 - J                                       00000690
         I1 = 1                                                         00000700
         IF (LOWER) I1 = J                                              00000710
         TNORM = DMAX1(TNORM,DASUM(L,T(I1,J),1))                        00000720
   10 CONTINUE                                                          00000730
C                                                                       00000740
C     RCOND = 1/(NORM(T)*(ESTIMATE OF NORM(INVERSE(T)))) .              00000750
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  T*Z = Y  AND  TRANS(T)*Y = E .  00000760
C     TRANS(T)  IS THE TRANSPOSE OF T .                                 00000770
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00000780
C     GROWTH IN THE ELEMENTS OF Y .                                     00000790
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00000800
C                                                                       00000810
C     SOLVE TRANS(T)*Y = E                                              00000820
C                                                                       00000830
      EK = 1.0D0                                                        00000840
      DO 20 J = 1, N                                                    00000850
         Z(J) = 0.0D0                                                   00000860
   20 CONTINUE                                                          00000870
      DO 100 KK = 1, N                                                  00000880
         K = KK                                                         00000890
         IF (LOWER) K = N + 1 - KK                                      00000900
         IF (Z(K) .NE. 0.0D0) EK = DSIGN(EK,-Z(K))                      00000910
         IF (DABS(EK-Z(K)) .LE. DABS(T(K,K))) GO TO 30                  00000920
            S = DABS(T(K,K))/DABS(EK-Z(K))                              00000930
            CALL DSCAL(N,S,Z,1)                                         00000940
            EK = S*EK                                                   00000950
   30    CONTINUE                                                       00000960
         WK = EK - Z(K)                                                 00000970
         WKM = -EK - Z(K)                                               00000980
         S = DABS(WK)                                                   00000990
         SM = DABS(WKM)                                                 00001000
         IF (T(K,K) .EQ. 0.0D0) GO TO 40                                00001010
            WK = WK/T(K,K)                                              00001020
            WKM = WKM/T(K,K)                                            00001030
         GO TO 50                                                       00001040
   40    CONTINUE                                                       00001050
            WK = 1.0D0                                                  00001060
            WKM = 1.0D0                                                 00001070
   50    CONTINUE                                                       00001080
         IF (KK .EQ. N) GO TO 90                                        00001090
            J1 = K + 1                                                  00001100
            IF (LOWER) J1 = 1                                           00001110
            J2 = N                                                      00001120
            IF (LOWER) J2 = K - 1                                       00001130
            DO 60 J = J1, J2                                            00001140
               SM = SM + DABS(Z(J)+WKM*T(K,J))                          00001150
               Z(J) = Z(J) + WK*T(K,J)                                  00001160
               S = S + DABS(Z(J))                                       00001170
   60       CONTINUE                                                    00001180
            IF (S .GE. SM) GO TO 80                                     00001190
               W = WKM - WK                                             00001200
               WK = WKM                                                 00001210
               DO 70 J = J1, J2                                         00001220
                  Z(J) = Z(J) + W*T(K,J)                                00001230
   70          CONTINUE                                                 00001240
   80       CONTINUE                                                    00001250
   90    CONTINUE                                                       00001260
         Z(K) = WK                                                      00001270
  100 CONTINUE                                                          00001280
      S = 1.0D0/DASUM(N,Z,1)                                            00001290
      CALL DSCAL(N,S,Z,1)                                               00001300
C                                                                       00001310
      YNORM = 1.0D0                                                     00001320
C                                                                       00001330
C     SOLVE T*Z = Y                                                     00001340
C                                                                       00001350
      DO 130 KK = 1, N                                                  00001360
         K = N + 1 - KK                                                 00001370
         IF (LOWER) K = KK                                              00001380
         IF (DABS(Z(K)) .LE. DABS(T(K,K))) GO TO 110                    00001390
            S = DABS(T(K,K))/DABS(Z(K))                                 00001400
            CALL DSCAL(N,S,Z,1)                                         00001410
            YNORM = S*YNORM                                             00001420
  110    CONTINUE                                                       00001430
         IF (T(K,K) .NE. 0.0D0) Z(K) = Z(K)/T(K,K)                      00001440
         IF (T(K,K) .EQ. 0.0D0) Z(K) = 1.0D0                            00001450
         I1 = 1                                                         00001460
         IF (LOWER) I1 = K + 1                                          00001470
         IF (KK .GE. N) GO TO 120                                       00001480
            W = -Z(K)                                                   00001490
            CALL DAXPY(N-KK,W,T(I1,K),1,Z(I1),1)                        00001500
  120    CONTINUE                                                       00001510
  130 CONTINUE                                                          00001520
C     MAKE ZNORM = 1.0                                                  00001530
      S = 1.0D0/DASUM(N,Z,1)                                            00001540
      CALL DSCAL(N,S,Z,1)                                               00001550
      YNORM = S*YNORM                                                   00001560
C                                                                       00001570
      IF (TNORM .NE. 0.0D0) RCOND = YNORM/TNORM                         00001580
      IF (TNORM .EQ. 0.0D0) RCOND = 0.0D0                               00001590
      RETURN                                                            00001600
      END                                                               00001610
