*#**********************************************************************

      REAL FUNCTION SCNRM2( N, CX, INCX)                                00000010
      LOGICAL IMAG, SCALE                                               00000020
      INTEGER          NEXT                                             00000030
      REAL         CUTLO, CUTHI, HITEST, SUM, XMAX, ABSX, ZERO, ONE     00000040
      COMPLEX      CX(1)                                                00000050
      DATA         ZERO, ONE /0.0E0, 1.0E0/                             00000060
C                                                                       00000070
C     UNITARY NORM OF THE COMPLEX N-VECTOR STORED IN CX() WITH STORAGE  00000080
C     INCREMENT INCX .                                                  00000090
C     IF    N .LE. 0 RETURN WITH RESULT = 0.                            00000100
C     IF N .GE. 1 THEN INCX MUST BE .GE. 1                              00000110
C                                                                       00000120
C           C.L.LAWSON , 1978 JAN 08                                    00000130
C                                                                       00000140
C     FOUR PHASE METHOD     USING TWO BUILT-IN CONSTANTS THAT ARE       00000150
C     HOPEFULLY APPLICABLE TO ALL MACHINES.                             00000160
C         CUTLO = MAXIMUM OF  SQRT(U/EPS)  OVER ALL KNOWN MACHINES.     00000170
C         CUTHI = MINIMUM OF  SQRT(V)      OVER ALL KNOWN MACHINES.     00000180
C     WHERE                                                             00000190
C         EPS = SMALLEST NO. SUCH THAT EPS + 1. .GT. 1.                 00000200
C         U   = SMALLEST POSITIVE NO.   (UNDERFLOW LIMIT)               00000210
C         V   = LARGEST  NO.            (OVERFLOW  LIMIT)               00000220
C                                                                       00000230
C     BRIEF OUTLINE OF ALGORITHM..                                      00000240
C                                                                       00000250
C     PHASE 1    SCANS ZERO COMPONENTS.                                 00000260
C     MOVE TO PHASE 2 WHEN A COMPONENT IS NONZERO AND .LE. CUTLO        00000270
C     MOVE TO PHASE 3 WHEN A COMPONENT IS .GT. CUTLO                    00000280
C     MOVE TO PHASE 4 WHEN A COMPONENT IS .GE. CUTHI/M                  00000290
C     WHERE M = N FOR X() REAL AND M = 2*N FOR COMPLEX.                 00000300
C                                                                       00000310
C     VALUES FOR CUTLO AND CUTHI..                                      00000320
C     FROM THE ENVIRONMENTAL PARAMETERS LISTED IN THE IMSL CONVERTER    00000330
C     DOCUMENT THE LIMITING VALUES ARE AS FOLLOWS..                     00000340
C     CUTLO, S.P.   U/EPS = 2**(-102) FOR  HONEYWELL.  CLOSE SECONDS ARE00000350
C                   UNIVAC AND DEC AT 2**(-103)                         00000360
C                   THUS CUTLO = 2**(-51) = 4.44089E-16                 00000370
C     CUTHI, S.P.   V = 2**127 FOR UNIVAC, HONEYWELL, AND DEC.          00000380
C                   THUS CUTHI = 2**(63.5) = 1.30438E19                 00000390
C     CUTLO, D.P.   U/EPS = 2**(-67) FOR HONEYWELL AND DEC.             00000400
C                   THUS CUTLO = 2**(-33.5) = 8.23181D-11               00000410
C     CUTHI, D.P.   SAME AS S.P.  CUTHI = 1.30438D19                    00000420
C     DATA CUTLO, CUTHI / 8.232D-11,  1.304D19 /                        00000430
C     DATA CUTLO, CUTHI / 4.441E-16,  1.304E19 /                        00000440
      DATA CUTLO, CUTHI / 4.441E-16,  1.304E19 /                        00000450
C                                                                       00000460
      IF(N .GT. 0) GO TO 10                                             00000470
         SCNRM2  = ZERO                                                 00000480
         GO TO 300                                                      00000490
C                                                                       00000500
   10 ASSIGN 30 TO NEXT                                                 00000510
      SUM = ZERO                                                        00000520
      NN = N * INCX                                                     00000530
C                                                 BEGIN MAIN LOOP       00000540
      DO 210 I=1,NN,INCX                                                00000550
         ABSX = ABS(REAL(CX(I)))                                        00000560
         IMAG = .FALSE.                                                 00000570
         GO TO NEXT,(30, 50, 70, 90, 110)                               00000580
   30 IF( ABSX .GT. CUTLO) GO TO 85                                     00000590
      ASSIGN 50 TO NEXT                                                 00000600
      SCALE = .FALSE.                                                   00000610
C                                                                       00000620
C                        PHASE 1.  SUM IS ZERO                          00000630
C                                                                       00000640
   50 IF( ABSX .EQ. ZERO) GO TO 200                                     00000650
      IF( ABSX .GT. CUTLO) GO TO 85                                     00000660
C                                                                       00000670
C                                PREPARE FOR PHASE 2.                   00000680
      ASSIGN 70 TO NEXT                                                 00000690
      GO TO 105                                                         00000700
C                                                                       00000710
C                                PREPARE FOR PHASE 4.                   00000720
C                                                                       00000730
  100 ASSIGN 110 TO NEXT                                                00000740
      SUM = (SUM / ABSX) / ABSX                                         00000750
  105 SCALE = .TRUE.                                                    00000760
      XMAX = ABSX                                                       00000770
      GO TO 115                                                         00000780
C                                                                       00000790
C                   PHASE 2.  SUM IS SMALL.                             00000800
C                             SCALE TO AVOID DESTRUCTIVE UNDERFLOW.     00000810
C                                                                       00000820
   70 IF( ABSX .GT. CUTLO ) GO TO 75                                    00000830
C                                                                       00000840
C                     COMMON CODE FOR PHASES 2 AND 4.                   00000850
C                     IN PHASE 4 SUM IS LARGE.  SCALE TO AVOID OVERFLOW.00000860
C                                                                       00000870
  110 IF( ABSX .LE. XMAX ) GO TO 115                                    00000880
         SUM = ONE + SUM * (XMAX / ABSX)**2                             00000890
         XMAX = ABSX                                                    00000900
         GO TO 200                                                      00000910
C                                                                       00000920
  115 SUM = SUM + (ABSX/XMAX)**2                                        00000930
      GO TO 200                                                         00000940
C                                                                       00000950
C                                                                       00000960
C                  PREPARE FOR PHASE 3.                                 00000970
C                                                                       00000980
   75 SUM = (SUM * XMAX) * XMAX                                         00000990
C                                                                       00001000
   85 ASSIGN 90 TO NEXT                                                 00001010
      SCALE = .FALSE.                                                   00001020
C                                                                       00001030
C     FOR REAL OR D.P. SET HITEST = CUTHI/N                             00001040
C     FOR COMPLEX      SET HITEST = CUTHI/(2*N)                         00001050
C                                                                       00001060
      HITEST = CUTHI/FLOAT( N )                                         00001070
C                                                                       00001080
C                   PHASE 3.  SUM IS MID-RANGE.  NO SCALING.            00001090
C                                                                       00001100
   90 IF(ABSX .GE. HITEST) GO TO 100                                    00001110
         SUM = SUM + ABSX**2                                            00001120
  200 CONTINUE                                                          00001130
C                  CONTROL SELECTION OF REAL AND IMAGINARY PARTS.       00001140
C                                                                       00001150
      IF(IMAG) GO TO 210                                                00001160
         ABSX = ABS(AIMAG(CX(I)))                                       00001170
         IMAG = .TRUE.                                                  00001180
      GO TO NEXT,(  50, 70, 90, 110 )                                   00001190
C                                                                       00001200
  210 CONTINUE                                                          00001210
C                                                                       00001220
C              END OF MAIN LOOP.                                        00001230
C              COMPUTE SQUARE ROOT AND ADJUST FOR SCALING.              00001240
C                                                                       00001250
      SCNRM2 = SQRT(SUM)                                                00001260
      IF(SCALE) SCNRM2 = SCNRM2 * XMAX                                  00001270
  300 CONTINUE                                                          00001280
      RETURN                                                            00001290
      END                                                               00001300
