*#**********************************************************************

      SUBROUTINE SPBCO(ABD,LDA,N,M,RCOND,Z,INFO)                        00000010

      INTEGER LDA,N,M,INFO                                              00000020
      REAL ABD(LDA,1),Z(1)                                              00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     SPBCO FACTORS A REAL SYMMETRIC POSITIVE DEFINITE MATRIX           00000060
C     STORED IN BAND FORM AND ESTIMATES THE CONDITION OF THE MATRIX.    00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, SPBFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW SPBCO BY SPBSL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW SPBCO BY SPBSL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW SPBCO BY SPBDI.               00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        ABD     REAL(LDA, N)                                           00000160
C                THE MATRIX TO BE FACTORED.  THE COLUMNS OF THE UPPER   00000170
C                TRIANGLE ARE STORED IN THE COLUMNS OF ABD AND THE      00000180
C                DIAGONALS OF THE UPPER TRIANGLE ARE STORED IN THE      00000190
C                ROWS OF ABD .  SEE THE COMMENTS BELOW FOR DETAILS.     00000200
C                                                                       00000210
C        LDA     INTEGER                                                00000220
C                THE LEADING DIMENSION OF THE ARRAY  ABD .              00000230
C                LDA MUST BE .GE. M + 1 .                               00000240
C                                                                       00000250
C        N       INTEGER                                                00000260
C                THE ORDER OF THE MATRIX  A .                           00000270
C                                                                       00000280
C        M       INTEGER                                                00000290
C                THE NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.       00000300
C                0 .LE. M .LT. N .                                      00000310
C                                                                       00000320
C     ON RETURN                                                         00000330
C                                                                       00000340
C        ABD     AN UPPER TRIANGULAR MATRIX  R , STORED IN BAND         00000350
C                FORM, SO THAT  A = TRANS(R)*R .                        00000360
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000370
C                                                                       00000380
C        RCOND   REAL                                                   00000390
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000400
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000410
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000420
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000430
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000440
C                           1.0 + RCOND .EQ. 1.0                        00000450
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000460
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000470
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000480
C                UNDERFLOWS.  IF INFO .NE. 0 , RCOND IS UNCHANGED.      00000490
C                                                                       00000500
C        Z       REAL(N)                                                00000510
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000520
C                IF  A  IS SINGULAR TO WORKING PRECISION, THEN  Z  IS   00000530
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000540
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000550
C                IF  INFO .NE. 0 , Z  IS UNCHANGED.                     00000560
C                                                                       00000570
C        INFO    INTEGER                                                00000580
C                = 0  FOR NORMAL RETURN.                                00000590
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000600
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000610
C                                                                       00000620
C     BAND STORAGE                                                      00000630
C                                                                       00000640
C           IF  A  IS A SYMMETRIC POSITIVE DEFINITE BAND MATRIX,        00000650
C           THE FOLLOWING PROGRAM SEGMENT WILL SET UP THE INPUT.        00000660
C                                                                       00000670
C                   M = (BAND WIDTH ABOVE DIAGONAL)                     00000680
C                   DO 20 J = 1, N                                      00000690
C                      I1 = MAX0(1, J-M)                                00000700
C                      DO 10 I = I1, J                                  00000710
C                         K = I-J+M+1                                   00000720
C                         ABD(K,J) = A(I,J)                             00000730
C                10    CONTINUE                                         00000740
C                20 CONTINUE                                            00000750
C                                                                       00000760
C           THIS USES  M + 1  ROWS OF  A , EXCEPT FOR THE  M BY M       00000770
C           UPPER LEFT TRIANGLE, WHICH IS IGNORED.                      00000780
C                                                                       00000790
C     EXAMPLE..  IF THE ORIGINAL MATRIX IS                              00000800
C                                                                       00000810
C           11 12 13  0  0  0                                           00000820
C           12 22 23 24  0  0                                           00000830
C           13 23 33 34 35  0                                           00000840
C            0 24 34 44 45 46                                           00000850
C            0  0 35 45 55 56                                           00000860
C            0  0  0 46 56 66                                           00000870
C                                                                       00000880
C     THEN  N = 6 , M = 2  AND  ABD  SHOULD CONTAIN                     00000890
C                                                                       00000900
C            *  * 13 24 35 46                                           00000910
C            * 12 23 34 45 56                                           00000920
C           11 22 33 44 55 66                                           00000930
C                                                                       00000940
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000950
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000960
C                                                                       00000970
C     SUBROUTINES AND FUNCTIONS                                         00000980
C                                                                       00000990
C     LINPACK SPBFA                                                     00001000
C     BLAS SAXPY,SDOT,SSCAL,SASUM                                       00001010
C     FORTRAN ABS,AMAX1,MAX0,MIN0,REAL,SIGN                             00001020
C                                                                       00001030
C     INTERNAL VARIABLES                                                00001040
C                                                                       00001050
      REAL SDOT,EK,T,WK,WKM                                             00001060
      REAL ANORM,S,SASUM,SM,YNORM                                       00001070
      INTEGER I,J,J2,K,KB,KP1,L,LA,LB,LM,MU                             00001080
C                                                                       00001090
C                                                                       00001100
C     FIND NORM OF A                                                    00001110
C                                                                       00001120
      DO 30 J = 1, N                                                    00001130
         L = MIN0(J,M+1)                                                00001140
         MU = MAX0(M+2-J,1)                                             00001150
         Z(J) = SASUM(L,ABD(MU,J),1)                                    00001160
         K = J - L                                                      00001170
         IF (M .LT. MU) GO TO 20                                        00001180
         DO 10 I = MU, M                                                00001190
            K = K + 1                                                   00001200
            Z(K) = Z(K) + ABS(ABD(I,J))                                 00001210
   10    CONTINUE                                                       00001220
   20    CONTINUE                                                       00001230
   30 CONTINUE                                                          00001240
      ANORM = 0.0E0                                                     00001250
      DO 40 J = 1, N                                                    00001260
         ANORM = AMAX1(ANORM,Z(J))                                      00001270
   40 CONTINUE                                                          00001280
C                                                                       00001290
C     FACTOR                                                            00001300
C                                                                       00001310
      CALL SPBFA(ABD,LDA,N,M,INFO)                                      00001320
      IF (INFO .NE. 0) GO TO 180                                        00001330
C                                                                       00001340
C        RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .           00001350
C        ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .      00001360
C        THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL        00001370
C        GROWTH IN THE ELEMENTS OF W  WHERE  TRANS(R)*W = E .           00001380
C        THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.         00001390
C                                                                       00001400
C        SOLVE TRANS(R)*W = E                                           00001410
C                                                                       00001420
         EK = 1.0E0                                                     00001430
         DO 50 J = 1, N                                                 00001440
            Z(J) = 0.0E0                                                00001450
   50    CONTINUE                                                       00001460
         DO 110 K = 1, N                                                00001470
            IF (Z(K) .NE. 0.0E0) EK = SIGN(EK,-Z(K))                    00001480
            IF (ABS(EK-Z(K)) .LE. ABD(M+1,K)) GO TO 60                  00001490
               S = ABD(M+1,K)/ABS(EK-Z(K))                              00001500
               CALL SSCAL(N,S,Z,1)                                      00001510
               EK = S*EK                                                00001520
   60       CONTINUE                                                    00001530
            WK = EK - Z(K)                                              00001540
            WKM = -EK - Z(K)                                            00001550
            S = ABS(WK)                                                 00001560
            SM = ABS(WKM)                                               00001570
            WK = WK/ABD(M+1,K)                                          00001580
            WKM = WKM/ABD(M+1,K)                                        00001590
            KP1 = K + 1                                                 00001600
            J2 = MIN0(K+M,N)                                            00001610
            I = M + 1                                                   00001620
            IF (KP1 .GT. J2) GO TO 100                                  00001630
               DO 70 J = KP1, J2                                        00001640
                  I = I - 1                                             00001650
                  SM = SM + ABS(Z(J)+WKM*ABD(I,J))                      00001660
                  Z(J) = Z(J) + WK*ABD(I,J)                             00001670
                  S = S + ABS(Z(J))                                     00001680
   70          CONTINUE                                                 00001690
               IF (S .GE. SM) GO TO 90                                  00001700
                  T = WKM - WK                                          00001710
                  WK = WKM                                              00001720
                  I = M + 1                                             00001730
                  DO 80 J = KP1, J2                                     00001740
                     I = I - 1                                          00001750
                     Z(J) = Z(J) + T*ABD(I,J)                           00001760
   80             CONTINUE                                              00001770
   90          CONTINUE                                                 00001780
  100       CONTINUE                                                    00001790
            Z(K) = WK                                                   00001800
  110    CONTINUE                                                       00001810
         S = 1.0E0/SASUM(N,Z,1)                                         00001820
         CALL SSCAL(N,S,Z,1)                                            00001830
C                                                                       00001840
C        SOLVE  R*Y = W                                                 00001850
C                                                                       00001860
         DO 130 KB = 1, N                                               00001870
            K = N + 1 - KB                                              00001880
            IF (ABS(Z(K)) .LE. ABD(M+1,K)) GO TO 120                    00001890
               S = ABD(M+1,K)/ABS(Z(K))                                 00001900
               CALL SSCAL(N,S,Z,1)                                      00001910
  120       CONTINUE                                                    00001920
            Z(K) = Z(K)/ABD(M+1,K)                                      00001930
            LM = MIN0(K-1,M)                                            00001940
            LA = M + 1 - LM                                             00001950
            LB = K - LM                                                 00001960
            T = -Z(K)                                                   00001970
            CALL SAXPY(LM,T,ABD(LA,K),1,Z(LB),1)                        00001980
  130    CONTINUE                                                       00001990
         S = 1.0E0/SASUM(N,Z,1)                                         00002000
         CALL SSCAL(N,S,Z,1)                                            00002010
C                                                                       00002020
         YNORM = 1.0E0                                                  00002030
C                                                                       00002040
C        SOLVE TRANS(R)*V = Y                                           00002050
C                                                                       00002060
         DO 150 K = 1, N                                                00002070
            LM = MIN0(K-1,M)                                            00002080
            LA = M + 1 - LM                                             00002090
            LB = K - LM                                                 00002100
            Z(K) = Z(K) - SDOT(LM,ABD(LA,K),1,Z(LB),1)                  00002110
            IF (ABS(Z(K)) .LE. ABD(M+1,K)) GO TO 140                    00002120
               S = ABD(M+1,K)/ABS(Z(K))                                 00002130
               CALL SSCAL(N,S,Z,1)                                      00002140
               YNORM = S*YNORM                                          00002150
  140       CONTINUE                                                    00002160
            Z(K) = Z(K)/ABD(M+1,K)                                      00002170
  150    CONTINUE                                                       00002180
         S = 1.0E0/SASUM(N,Z,1)                                         00002190
         CALL SSCAL(N,S,Z,1)                                            00002200
         YNORM = S*YNORM                                                00002210
C                                                                       00002220
C        SOLVE  R*Z = W                                                 00002230
C                                                                       00002240
         DO 170 KB = 1, N                                               00002250
            K = N + 1 - KB                                              00002260
            IF (ABS(Z(K)) .LE. ABD(M+1,K)) GO TO 160                    00002270
               S = ABD(M+1,K)/ABS(Z(K))                                 00002280
               CALL SSCAL(N,S,Z,1)                                      00002290
               YNORM = S*YNORM                                          00002300
  160       CONTINUE                                                    00002310
            Z(K) = Z(K)/ABD(M+1,K)                                      00002320
            LM = MIN0(K-1,M)                                            00002330
            LA = M + 1 - LM                                             00002340
            LB = K - LM                                                 00002350
            T = -Z(K)                                                   00002360
            CALL SAXPY(LM,T,ABD(LA,K),1,Z(LB),1)                        00002370
  170    CONTINUE                                                       00002380
C        MAKE ZNORM = 1.0                                               00002390
         S = 1.0E0/SASUM(N,Z,1)                                         00002400
         CALL SSCAL(N,S,Z,1)                                            00002410
         YNORM = S*YNORM                                                00002420
C                                                                       00002430
         IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                      00002440
         IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                            00002450
  180 CONTINUE                                                          00002460
      RETURN                                                            00002470
      END                                                               00002480
