*#**********************************************************************

      SUBROUTINE SPTSL(N,D,E,B)                                         00000010

      INTEGER N                                                         00000020
      REAL D(1),E(1),B(2)                                               00000030
C                                                                       00000040
C     SPTSL GIVEN A POSITIVE DEFINITE TRIDIAGONAL MATRIX AND A RIGHT    00000050
C     HAND SIDE WILL FIND THE SOLUTION.                                 00000060
C                                                                       00000070
C     ON ENTRY                                                          00000080
C                                                                       00000090
C        N        INTEGER                                               00000100
C                 IS THE ORDER OF THE TRIDIAGONAL MATRIX.               00000110
C                                                                       00000120
C        D        REAL(N)                                               00000130
C                 IS THE DIAGONAL OF THE TRIDIAGONAL MATRIX.            00000140
C                 ON OUTPUT D IS DESTROYED.                             00000150
C                                                                       00000160
C        E        REAL(N)                                               00000170
C                 IS THE OFFDIAGONAL OF THE TRIDIAGONAL MATRIX.         00000180
C                 E(1) THROUGH E(N-1) SHOULD CONTAIN THE                00000190
C                 OFFDIAGONAL.                                          00000200
C                                                                       00000210
C        B        REAL(N)                                               00000220
C                 IS THE RIGHT HAND SIDE VECTOR.                        00000230
C                                                                       00000240
C     ON RETURN                                                         00000250
C                                                                       00000260
C        B        CONTAINS THE SOULTION.                                00000270
C                                                                       00000280
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000290
C     JACK DONGARRA, ARGONNE NATIONAL LABORATORY.                       00000300
C                                                                       00000310
C     NO EXTERNALS                                                      00000320
C     FORTRAN MOD                                                       00000330
C                                                                       00000340
C     INTERNAL VARIABLES                                                00000350
C                                                                       00000360
      INTEGER K,KBM1,KE,KF,KP1,NM1,NM1D2                                00000370
      REAL T1,T2                                                        00000380
C                                                                       00000390
C     CHECK FOR 1 X 1 CASE                                              00000400
C                                                                       00000410
      IF (N .NE. 1) GO TO 10                                            00000420
         B(1) = B(1)/D(1)                                               00000430
      GO TO 70                                                          00000440
   10 CONTINUE                                                          00000450
         NM1 = N - 1                                                    00000460
         NM1D2 = NM1/2                                                  00000470
         IF (N .EQ. 2) GO TO 30                                         00000480
            KBM1 = N - 1                                                00000490
C                                                                       00000500
C           ZERO TOP HALF OF SUBDIAGONAL AND BOTTOM HALF OF             00000510
C           SUPERDIAGONAL                                               00000520
C                                                                       00000530
            DO 20 K = 1, NM1D2                                          00000540
               T1 = E(K)/D(K)                                           00000550
               D(K+1) = D(K+1) - T1*E(K)                                00000560
               B(K+1) = B(K+1) - T1*B(K)                                00000570
               T2 = E(KBM1)/D(KBM1+1)                                   00000580
               D(KBM1) = D(KBM1) - T2*E(KBM1)                           00000590
               B(KBM1) = B(KBM1) - T2*B(KBM1+1)                         00000600
               KBM1 = KBM1 - 1                                          00000610
   20       CONTINUE                                                    00000620
   30    CONTINUE                                                       00000630
         KP1 = NM1D2 + 1                                                00000640
C                                                                       00000650
C        CLEAN UP FOR POSSIBLE 2 X 2 BLOCK AT CENTER                    00000660
C                                                                       00000670
         IF (MOD(N,2) .NE. 0) GO TO 40                                  00000680
            T1 = E(KP1)/D(KP1)                                          00000690
            D(KP1+1) = D(KP1+1) - T1*E(KP1)                             00000700
            B(KP1+1) = B(KP1+1) - T1*B(KP1)                             00000710
            KP1 = KP1 + 1                                               00000720
   40    CONTINUE                                                       00000730
C                                                                       00000740
C        BACK SOLVE STARTING AT THE CENTER, GOING TOWARDS THE TOP       00000750
C        AND BOTTOM                                                     00000760
C                                                                       00000770
         B(KP1) = B(KP1)/D(KP1)                                         00000780
         IF (N .EQ. 2) GO TO 60                                         00000790
            K = KP1 - 1                                                 00000800
            KE = KP1 + NM1D2 - 1                                        00000810
            DO 50 KF = KP1, KE                                          00000820
               B(K) = (B(K) - E(K)*B(K+1))/D(K)                         00000830
               B(KF+1) = (B(KF+1) - E(KF)*B(KF))/D(KF+1)                00000840
               K = K - 1                                                00000850
   50       CONTINUE                                                    00000860
   60    CONTINUE                                                       00000870
         IF (MOD(N,2) .EQ. 0) B(1) = (B(1) - E(1)*B(2))/D(1)            00000880
   70 CONTINUE                                                          00000890
      RETURN                                                            00000900
      END                                                               00000910
