*#**********************************************************************

      SUBROUTINE SSICO(A,LDA,N,KPVT,RCOND,Z)                            00000010

      INTEGER LDA,N,KPVT(1)                                             00000020
      REAL A(LDA,1),Z(1)                                                00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     SSICO FACTORS A REAL SYMMETRIC MATRIX BY ELIMINATION WITH         00000060
C     SYMMETRIC PIVOTING AND ESTIMATES THE CONDITION OF THE MATRIX.     00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, SSIFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW SSICO BY SSISL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW SSICO BY SSISL.                 00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW SSICO BY SSIDI.                   00000120
C     TO COMPUTE  DETERMINANT(A) , FOLLOW SSICO BY SSIDI.               00000130
C     TO COMPUTE  INERTIA(A), FOLLOW SSICO BY SSIDI.                    00000140
C                                                                       00000150
C     ON ENTRY                                                          00000160
C                                                                       00000170
C        A       REAL(LDA, N)                                           00000180
C                THE SYMMETRIC MATRIX TO BE FACTORED.                   00000190
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000200
C                                                                       00000210
C        LDA     INTEGER                                                00000220
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000230
C                                                                       00000240
C        N       INTEGER                                                00000250
C                THE ORDER OF THE MATRIX  A .                           00000260
C                                                                       00000270
C     OUTPUT                                                            00000280
C                                                                       00000290
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000300
C                WERE USED TO OBTAIN IT.                                00000310
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000320
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000330
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000340
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000350
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000360
C                                                                       00000370
C        KPVT    INTEGER(N)                                             00000380
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000390
C                                                                       00000400
C        RCOND   REAL                                                   00000410
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000420
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000430
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000440
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000450
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000460
C                           1.0 + RCOND .EQ. 1.0                        00000470
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000480
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000490
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000500
C                UNDERFLOWS.                                            00000510
C                                                                       00000520
C        Z       REAL(N)                                                00000530
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000540
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000550
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000560
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000570
C                                                                       00000580
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000590
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000600
C                                                                       00000610
C     SUBROUTINES AND FUNCTIONS                                         00000620
C                                                                       00000630
C     LINPACK SSIFA                                                     00000640
C     BLAS SAXPY,SDOT,SSCAL,SASUM                                       00000650
C     FORTRAN ABS,AMAX1,IABS,SIGN                                       00000660
C                                                                       00000670
C     INTERNAL VARIABLES                                                00000680
C                                                                       00000690
      REAL AK,AKM1,BK,BKM1,SDOT,DENOM,EK,T                              00000700
      REAL ANORM,S,SASUM,YNORM                                          00000710
      INTEGER I,INFO,J,JM1,K,KP,KPS,KS                                  00000720
C                                                                       00000730
C                                                                       00000740
C     FIND NORM OF A USING ONLY UPPER HALF                              00000750
C                                                                       00000760
      DO 30 J = 1, N                                                    00000770
         Z(J) = SASUM(J,A(1,J),1)                                       00000780
         JM1 = J - 1                                                    00000790
         IF (JM1 .LT. 1) GO TO 20                                       00000800
         DO 10 I = 1, JM1                                               00000810
            Z(I) = Z(I) + ABS(A(I,J))                                   00000820
   10    CONTINUE                                                       00000830
   20    CONTINUE                                                       00000840
   30 CONTINUE                                                          00000850
      ANORM = 0.0E0                                                     00000860
      DO 40 J = 1, N                                                    00000870
         ANORM = AMAX1(ANORM,Z(J))                                      00000880
   40 CONTINUE                                                          00000890
C                                                                       00000900
C     FACTOR                                                            00000910
C                                                                       00000920
      CALL SSIFA(A,LDA,N,KPVT,INFO)                                     00000930
C                                                                       00000940
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00000950
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00000960
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00000970
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00000980
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00000990
C                                                                       00001000
C     SOLVE U*D*W = E                                                   00001010
C                                                                       00001020
      EK = 1.0E0                                                        00001030
      DO 50 J = 1, N                                                    00001040
         Z(J) = 0.0E0                                                   00001050
   50 CONTINUE                                                          00001060
      K = N                                                             00001070
   60 IF (K .EQ. 0) GO TO 120                                           00001080
         KS = 1                                                         00001090
         IF (KPVT(K) .LT. 0) KS = 2                                     00001100
         KP = IABS(KPVT(K))                                             00001110
         KPS = K + 1 - KS                                               00001120
         IF (KP .EQ. KPS) GO TO 70                                      00001130
            T = Z(KPS)                                                  00001140
            Z(KPS) = Z(KP)                                              00001150
            Z(KP) = T                                                   00001160
   70    CONTINUE                                                       00001170
         IF (Z(K) .NE. 0.0E0) EK = SIGN(EK,Z(K))                        00001180
         Z(K) = Z(K) + EK                                               00001190
         CALL SAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                          00001200
         IF (KS .EQ. 1) GO TO 80                                        00001210
            IF (Z(K-1) .NE. 0.0E0) EK = SIGN(EK,Z(K-1))                 00001220
            Z(K-1) = Z(K-1) + EK                                        00001230
            CALL SAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)                   00001240
   80    CONTINUE                                                       00001250
         IF (KS .EQ. 2) GO TO 100                                       00001260
            IF (ABS(Z(K)) .LE. ABS(A(K,K))) GO TO 90                    00001270
               S = ABS(A(K,K))/ABS(Z(K))                                00001280
               CALL SSCAL(N,S,Z,1)                                      00001290
               EK = S*EK                                                00001300
   90       CONTINUE                                                    00001310
            IF (A(K,K) .NE. 0.0E0) Z(K) = Z(K)/A(K,K)                   00001320
            IF (A(K,K) .EQ. 0.0E0) Z(K) = 1.0E0                         00001330
         GO TO 110                                                      00001340
  100    CONTINUE                                                       00001350
            AK = A(K,K)/A(K-1,K)                                        00001360
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00001370
            BK = Z(K)/A(K-1,K)                                          00001380
            BKM1 = Z(K-1)/A(K-1,K)                                      00001390
            DENOM = AK*AKM1 - 1.0E0                                     00001400
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001410
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001420
  110    CONTINUE                                                       00001430
         K = K - KS                                                     00001440
      GO TO 60                                                          00001450
  120 CONTINUE                                                          00001460
      S = 1.0E0/SASUM(N,Z,1)                                            00001470
      CALL SSCAL(N,S,Z,1)                                               00001480
C                                                                       00001490
C     SOLVE TRANS(U)*Y = W                                              00001500
C                                                                       00001510
      K = 1                                                             00001520
  130 IF (K .GT. N) GO TO 160                                           00001530
         KS = 1                                                         00001540
         IF (KPVT(K) .LT. 0) KS = 2                                     00001550
         IF (K .EQ. 1) GO TO 150                                        00001560
            Z(K) = Z(K) + SDOT(K-1,A(1,K),1,Z(1),1)                     00001570
            IF (KS .EQ. 2)                                              00001580
     *         Z(K+1) = Z(K+1) + SDOT(K-1,A(1,K+1),1,Z(1),1)            00001590
            KP = IABS(KPVT(K))                                          00001600
            IF (KP .EQ. K) GO TO 140                                    00001610
               T = Z(K)                                                 00001620
               Z(K) = Z(KP)                                             00001630
               Z(KP) = T                                                00001640
  140       CONTINUE                                                    00001650
  150    CONTINUE                                                       00001660
         K = K + KS                                                     00001670
      GO TO 130                                                         00001680
  160 CONTINUE                                                          00001690
      S = 1.0E0/SASUM(N,Z,1)                                            00001700
      CALL SSCAL(N,S,Z,1)                                               00001710
C                                                                       00001720
      YNORM = 1.0E0                                                     00001730
C                                                                       00001740
C     SOLVE U*D*V = Y                                                   00001750
C                                                                       00001760
      K = N                                                             00001770
  170 IF (K .EQ. 0) GO TO 230                                           00001780
         KS = 1                                                         00001790
         IF (KPVT(K) .LT. 0) KS = 2                                     00001800
         IF (K .EQ. KS) GO TO 190                                       00001810
            KP = IABS(KPVT(K))                                          00001820
            KPS = K + 1 - KS                                            00001830
            IF (KP .EQ. KPS) GO TO 180                                  00001840
               T = Z(KPS)                                               00001850
               Z(KPS) = Z(KP)                                           00001860
               Z(KP) = T                                                00001870
  180       CONTINUE                                                    00001880
            CALL SAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                       00001890
            IF (KS .EQ. 2) CALL SAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)    00001900
  190    CONTINUE                                                       00001910
         IF (KS .EQ. 2) GO TO 210                                       00001920
            IF (ABS(Z(K)) .LE. ABS(A(K,K))) GO TO 200                   00001930
               S = ABS(A(K,K))/ABS(Z(K))                                00001940
               CALL SSCAL(N,S,Z,1)                                      00001950
               YNORM = S*YNORM                                          00001960
  200       CONTINUE                                                    00001970
            IF (A(K,K) .NE. 0.0E0) Z(K) = Z(K)/A(K,K)                   00001980
            IF (A(K,K) .EQ. 0.0E0) Z(K) = 1.0E0                         00001990
         GO TO 220                                                      00002000
  210    CONTINUE                                                       00002010
            AK = A(K,K)/A(K-1,K)                                        00002020
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00002030
            BK = Z(K)/A(K-1,K)                                          00002040
            BKM1 = Z(K-1)/A(K-1,K)                                      00002050
            DENOM = AK*AKM1 - 1.0E0                                     00002060
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002070
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002080
  220    CONTINUE                                                       00002090
         K = K - KS                                                     00002100
      GO TO 170                                                         00002110
  230 CONTINUE                                                          00002120
      S = 1.0E0/SASUM(N,Z,1)                                            00002130
      CALL SSCAL(N,S,Z,1)                                               00002140
      YNORM = S*YNORM                                                   00002150
C                                                                       00002160
C     SOLVE TRANS(U)*Z = V                                              00002170
C                                                                       00002180
      K = 1                                                             00002190
  240 IF (K .GT. N) GO TO 270                                           00002200
         KS = 1                                                         00002210
         IF (KPVT(K) .LT. 0) KS = 2                                     00002220
         IF (K .EQ. 1) GO TO 260                                        00002230
            Z(K) = Z(K) + SDOT(K-1,A(1,K),1,Z(1),1)                     00002240
            IF (KS .EQ. 2)                                              00002250
     *         Z(K+1) = Z(K+1) + SDOT(K-1,A(1,K+1),1,Z(1),1)            00002260
            KP = IABS(KPVT(K))                                          00002270
            IF (KP .EQ. K) GO TO 250                                    00002280
               T = Z(K)                                                 00002290
               Z(K) = Z(KP)                                             00002300
               Z(KP) = T                                                00002310
  250       CONTINUE                                                    00002320
  260    CONTINUE                                                       00002330
         K = K + KS                                                     00002340
      GO TO 240                                                         00002350
  270 CONTINUE                                                          00002360
C     MAKE ZNORM = 1.0                                                  00002370
      S = 1.0E0/SASUM(N,Z,1)                                            00002380
      CALL SSCAL(N,S,Z,1)                                               00002390
      YNORM = S*YNORM                                                   00002400
C                                                                       00002410
      IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                         00002420
      IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                               00002430
      RETURN                                                            00002440
      END                                                               00002450
