*#**********************************************************************

      SUBROUTINE SSVDC(X,LDX,N,P,S,E,U,LDU,V,LDV,WORK,JOB,INFO)         00000010

      INTEGER LDX,N,P,LDU,LDV,JOB,INFO                                  00000020
      REAL X(LDX,1),S(1),E(1),U(LDU,1),V(LDV,1),WORK(1)                 00000030
C                                                                       00000040
C                                                                       00000050
C     SSVDC IS A SUBROUTINE TO REDUCE A REAL NXP MATRIX X BY            00000060
C     ORTHOGONAL TRANSFORMATIONS U AND V TO DIAGONAL FORM.  THE         00000070
C     DIAGONAL ELEMENTS S(I) ARE THE SINGULAR VALUES OF X.  THE         00000080
C     COLUMNS OF U ARE THE CORRESPONDING LEFT SINGULAR VECTORS,         00000090
C     AND THE COLUMNS OF V THE RIGHT SINGULAR VECTORS.                  00000100
C                                                                       00000110
C     ON ENTRY                                                          00000120
C                                                                       00000130
C         X         REAL(LDX,P), WHERE LDX.GE.N.                        00000140
C                   X CONTAINS THE MATRIX WHOSE SINGULAR VALUE          00000150
C                   DECOMPOSITION IS TO BE COMPUTED.  X IS              00000160
C                   DESTROYED BY SSVDC.                                 00000170
C                                                                       00000180
C         LDX       INTEGER.                                            00000190
C                   LDX IS THE LEADING DIMENSION OF THE ARRAY X.        00000200
C                                                                       00000210
C         N         INTEGER.                                            00000220
C                   N IS THE NUMBER OF COLUMNS OF THE MATRIX X.         00000230
C                                                                       00000240
C         P         INTEGER.                                            00000250
C                   P IS THE NUMBER OF ROWS OF THE MATRIX X.            00000260
C                                                                       00000270
C         LDU       INTEGER.                                            00000280
C                   LDU IS THE LEADING DIMENSION OF THE ARRAY U.        00000290
C                   (SEE BELOW).                                        00000300
C                                                                       00000310
C         LDV       INTEGER.                                            00000320
C                   LDV IS THE LEADING DIMENSION OF THE ARRAY V.        00000330
C                   (SEE BELOW).                                        00000340
C                                                                       00000350
C         WORK      REAL(N).                                            00000360
C                   WORK IS A SCRATCH ARRAY.                            00000370
C                                                                       00000380
C         JOB       INTEGER.                                            00000390
C                   JOB CONTROLS THE COMPUTATION OF THE SINGULAR        00000400
C                   VECTORS.  IT HAS THE DECIMAL EXPANSION AB           00000410
C                   WITH THE FOLLOWING MEANING                          00000420
C                                                                       00000430
C                        A.EQ.0    DO NOT COMPUTE THE LEFT SINGULAR     00000440
C                                  VECTORS.                             00000450
C                        A.EQ.1    RETURN THE N LEFT SINGULAR VECTORS   00000460
C                                  IN U.                                00000470
C                        A.GE.2    RETURN THE FIRST MIN(N,P) SINGULAR   00000480
C                                  VECTORS IN U.                        00000490
C                        B.EQ.0    DO NOT COMPUTE THE RIGHT SINGULAR    00000500
C                                  VECTORS.                             00000510
C                        B.EQ.1    RETURN THE RIGHT SINGULAR VECTORS    00000520
C                                  IN V.                                00000530
C                                                                       00000540
C     ON RETURN                                                         00000550
C                                                                       00000560
C         S         REAL(MM), WHERE MM=MIN(N+1,P).                      00000570
C                   THE FIRST MIN(N,P) ENTRIES OF S CONTAIN THE         00000580
C                   SINGULAR VALUES OF X ARRANGED IN DESCENDING         00000590
C                   ORDER OF MAGNITUDE.                                 00000600
C                                                                       00000610
C         E         REAL(P).                                            00000620
C                   E ORDINARILY CONTAINS ZEROS.  HOWEVER SEE THE       00000630
C                   DISCUSSION OF INFO FOR EXCEPTIONS.                  00000640
C                                                                       00000650
C         U         REAL(LDU,K), WHERE LDU.GE.N.  IF JOBA.EQ.1 THEN     00000660
C                                   K.EQ.N, IF JOBA.GE.2 THEN           00000670
C                                   K.EQ.MIN(N,P).                      00000671
C                   U CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.    00000680
C                   U IS NOT REFERENCED IF JOBA.EQ.0.  IF N.LE.P        00000690
C                   OR IF JOBA.EQ.2, THEN U MAY BE IDENTIFIED WITH X    00000700
C                   IN THE SUBROUTINE CALL.                             00000710
C                                                                       00000720
C         V         REAL(LDV,P), WHERE LDV.GE.P.                        00000730
C                   V CONTAINS THE MATRIX OF RIGHT SINGULAR VECTORS.    00000740
C                   V IS NOT REFERENCED IF JOB.EQ.0.  IF P.LE.N,        00000750
C                   THEN V MAY BE IDENTIFIED WITH X IN THE              00000760
C                   SUBROUTINE CALL.                                    00000770
C                                                                       00000780
C         INFO      INTEGER.                                            00000790
C                   THE SINGULAR VALUES (AND THEIR CORRESPONDING        00000800
C                   SINGULAR VECTORS) S(INFO+1),S(INFO+2),...,S(M)      00000810
C                   ARE CORRECT (HERE M=MIN(N,P)).  THUS IF             00000820
C                   INFO.EQ.0, ALL THE SINGULAR VALUES AND THEIR        00000830
C                   VECTORS ARE CORRECT.  IN ANY EVENT, THE MATRIX      00000840
C                   B = TRANS(U)*X*V IS THE BIDIAGONAL MATRIX           00000850
C                   WITH THE ELEMENTS OF S ON ITS DIAGONAL AND THE      00000860
C                   ELEMENTS OF E ON ITS SUPER-DIAGONAL (TRANS(U)       00000870
C                   IS THE TRANSPOSE OF U).  THUS THE SINGULAR          00000880
C                   VALUES OF X AND B ARE THE SAME.                     00000890
C                                                                       00000900
C     LINPACK. THIS VERSION DATED 03/19/79 .                            00000910
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00000920
C                                                                       00000923
C     ***** USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00000926
C                                                                       00000930
C     EXTERNAL SROT                                                     00000940
C     BLAS SAXPY,SDOT,SSCAL,SSWAP,SNRM2,SROTG                           00000950
C     FORTRAN ABS,AMAX1,MAX0,MIN0,MOD,SQRT                              00000960
C                                                                       00000970
C     INTERNAL VARIABLES                                                00000980
C                                                                       00000990
      INTEGER I,ITER,J,JOBU,K,KASE,KK,L,LL,LLS,LM1,LP1,LS,LU,M,MAXIT,   00001000
     *        MM,MM1,MP1,NCT,NCTP1,NCU,NRT,NRTP1                        00001010
      REAL SDOT,T,R                                                     00001020
      REAL B,C,CS,EL,EMM1,F,G,SNRM2,SCALE,SHIFT,SL,SM,SN,SMM1,T1,TEST,  00001030
     *     ZTEST                                                        00001040
      LOGICAL WANTU,WANTV                                               00001050
C                                                                       00001060
C                                                                       00001070
C     SET THE MAXIMUM NUMBER OF ITERATIONS.                             00001080
C                                                                       00001090
      MAXIT = 30                                                        00001100
C                                                                       00001110
C     DETERMINE WHAT IS TO BE COMPUTED.                                 00001120
C                                                                       00001130
      WANTU = .FALSE.                                                   00001140
      WANTV = .FALSE.                                                   00001150
      JOBU = MOD(JOB,100)/10                                            00001160
      NCU = N                                                           00001170
      IF (JOBU .GT. 1) NCU = MIN0(N,P)                                  00001180
      IF (JOBU .NE. 0) WANTU = .TRUE.                                   00001190
      IF (MOD(JOB,10) .NE. 0) WANTV = .TRUE.                            00001200
C                                                                       00001210
C     REDUCE X TO BIDIAGONAL FORM, STORING THE DIAGONAL ELEMENTS        00001220
C     IN S AND THE SUPER-DIAGONAL ELEMENTS IN E.                        00001230
C                                                                       00001240
      INFO = 0                                                          00001250
      NCT = MIN0(N-1,P)                                                 00001260
      NRT = MAX0(0,MIN0(P-2,N))                                         00001270
      LU = MAX0(NCT,NRT)                                                00001280
      IF (LU .LT. 1) GO TO 170                                          00001290
      DO 160 L = 1, LU                                                  00001300
         LP1 = L + 1                                                    00001310
         IF (L .GT. NCT) GO TO 20                                       00001320
C                                                                       00001330
C           COMPUTE THE TRANSFORMATION FOR THE L-TH COLUMN AND          00001340
C           PLACE THE L-TH DIAGONAL IN S(L).                            00001350
C                                                                       00001360
            S(L) = SNRM2(N-L+1,X(L,L),1)                                00001370
            IF (S(L) .EQ. 0.0E0) GO TO 10                               00001380
               IF (X(L,L) .NE. 0.0E0) S(L) = SIGN(S(L),X(L,L))          00001390
               CALL SSCAL(N-L+1,1.0E0/S(L),X(L,L),1)                    00001400
               X(L,L) = 1.0E0 + X(L,L)                                  00001410
   10       CONTINUE                                                    00001420
            S(L) = -S(L)                                                00001430
   20    CONTINUE                                                       00001440
         IF (P .LT. LP1) GO TO 50                                       00001450
         DO 40 J = LP1, P                                               00001460
            IF (L .GT. NCT) GO TO 30                                    00001470
            IF (S(L) .EQ. 0.0E0) GO TO 30                               00001480
C                                                                       00001490
C              APPLY THE TRANSFORMATION.                                00001500
C                                                                       00001510
               T = -SDOT(N-L+1,X(L,L),1,X(L,J),1)/X(L,L)                00001520
               CALL SAXPY(N-L+1,T,X(L,L),1,X(L,J),1)                    00001530
   30       CONTINUE                                                    00001540
C                                                                       00001550
C           PLACE THE L-TH ROW OF X INTO  E FOR THE                     00001560
C           SUBSEQUENT CALCULATION OF THE ROW TRANSFORMATION.           00001570
C                                                                       00001580
            E(J) = X(L,J)                                               00001590
   40    CONTINUE                                                       00001600
   50    CONTINUE                                                       00001610
         IF (.NOT.WANTU .OR. L .GT. NCT) GO TO 70                       00001620
C                                                                       00001630
C           PLACE THE TRANSFORMATION IN U FOR SUBSEQUENT BACK           00001640
C           MULTIPLICATION.                                             00001650
C                                                                       00001660
            DO 60 I = L, N                                              00001670
               U(I,L) = X(I,L)                                          00001680
   60       CONTINUE                                                    00001690
   70    CONTINUE                                                       00001700
         IF (L .GT. NRT) GO TO 150                                      00001710
C                                                                       00001720
C           COMPUTE THE L-TH ROW TRANSFORMATION AND PLACE THE           00001730
C           L-TH SUPER-DIAGONAL IN E(L).                                00001740
C                                                                       00001750
            E(L) = SNRM2(P-L,E(LP1),1)                                  00001760
            IF (E(L) .EQ. 0.0E0) GO TO 80                               00001770
               IF (E(LP1) .NE. 0.0E0) E(L) = SIGN(E(L),E(LP1))          00001780
               CALL SSCAL(P-L,1.0E0/E(L),E(LP1),1)                      00001790
               E(LP1) = 1.0E0 + E(LP1)                                  00001800
   80       CONTINUE                                                    00001810
            E(L) = -E(L)                                                00001820
            IF (LP1 .GT. N .OR. E(L) .EQ. 0.0E0) GO TO 120              00001830
C                                                                       00001840
C              APPLY THE TRANSFORMATION.                                00001850
C                                                                       00001860
               DO 90 I = LP1, N                                         00001870
                  WORK(I) = 0.0E0                                       00001880
   90          CONTINUE                                                 00001890
               DO 100 J = LP1, P                                        00001900
                  CALL SAXPY(N-L,E(J),X(LP1,J),1,WORK(LP1),1)           00001910
  100          CONTINUE                                                 00001920
               DO 110 J = LP1, P                                        00001930
                  CALL SAXPY(N-L,-E(J)/E(LP1),WORK(LP1),1,X(LP1,J),1)   00001940
  110          CONTINUE                                                 00001950
  120       CONTINUE                                                    00001960
            IF (.NOT.WANTV) GO TO 140                                   00001970
C                                                                       00001980
C              PLACE THE TRANSFORMATION IN V FOR SUBSEQUENT             00001990
C              BACK MULTIPLICATION.                                     00002000
C                                                                       00002010
               DO 130 I = LP1, P                                        00002020
                  V(I,L) = E(I)                                         00002030
  130          CONTINUE                                                 00002040
  140       CONTINUE                                                    00002050
  150    CONTINUE                                                       00002060
  160 CONTINUE                                                          00002070
  170 CONTINUE                                                          00002080
C                                                                       00002090
C     SET UP THE FINAL BIDIAGONAL MATRIX OR ORDER M.                    00002100
C                                                                       00002110
      M = MIN0(P,N+1)                                                   00002120
      NCTP1 = NCT + 1                                                   00002130
      NRTP1 = NRT + 1                                                   00002140
      IF (NCT .LT. P) S(NCTP1) = X(NCTP1,NCTP1)                         00002150
      IF (N .LT. M) S(M) = 0.0E0                                        00002160
      IF (NRTP1 .LT. M) E(NRTP1) = X(NRTP1,M)                           00002170
      E(M) = 0.0E0                                                      00002180
C                                                                       00002190
C     IF REQUIRED, GENERATE U.                                          00002200
C                                                                       00002210
      IF (.NOT.WANTU) GO TO 300                                         00002220
         IF (NCU .LT. NCTP1) GO TO 200                                  00002230
         DO 190 J = NCTP1, NCU                                          00002240
            DO 180 I = 1, N                                             00002250
               U(I,J) = 0.0E0                                           00002260
  180       CONTINUE                                                    00002270
            U(J,J) = 1.0E0                                              00002280
  190    CONTINUE                                                       00002290
  200    CONTINUE                                                       00002300
         IF (NCT .LT. 1) GO TO 290                                      00002310
         DO 280 LL = 1, NCT                                             00002320
            L = NCT - LL + 1                                            00002330
            IF (S(L) .EQ. 0.0E0) GO TO 250                              00002340
               LP1 = L + 1                                              00002350
               IF (NCU .LT. LP1) GO TO 220                              00002360
               DO 210 J = LP1, NCU                                      00002370
                  T = -SDOT(N-L+1,U(L,L),1,U(L,J),1)/U(L,L)             00002380
                  CALL SAXPY(N-L+1,T,U(L,L),1,U(L,J),1)                 00002390
  210          CONTINUE                                                 00002400
  220          CONTINUE                                                 00002410
               CALL SSCAL(N-L+1,-1.0E0,U(L,L),1)                        00002420
               U(L,L) = 1.0E0 + U(L,L)                                  00002430
               LM1 = L - 1                                              00002440
               IF (LM1 .LT. 1) GO TO 240                                00002450
               DO 230 I = 1, LM1                                        00002460
                  U(I,L) = 0.0E0                                        00002470
  230          CONTINUE                                                 00002480
  240          CONTINUE                                                 00002490
            GO TO 270                                                   00002500
  250       CONTINUE                                                    00002510
               DO 260 I = 1, N                                          00002520
                  U(I,L) = 0.0E0                                        00002530
  260          CONTINUE                                                 00002540
               U(L,L) = 1.0E0                                           00002550
  270       CONTINUE                                                    00002560
  280    CONTINUE                                                       00002570
  290    CONTINUE                                                       00002580
  300 CONTINUE                                                          00002590
C                                                                       00002600
C     IF IT IS REQUIRED, GENERATE V.                                    00002610
C                                                                       00002620
      IF (.NOT.WANTV) GO TO 350                                         00002630
         DO 340 LL = 1, P                                               00002640
            L = P - LL + 1                                              00002650
            LP1 = L + 1                                                 00002660
            IF (L .GT. NRT) GO TO 320                                   00002670
            IF (E(L) .EQ. 0.0E0) GO TO 320                              00002680
               DO 310 J = LP1, P                                        00002690
                  T = -SDOT(P-L,V(LP1,L),1,V(LP1,J),1)/V(LP1,L)         00002700
                  CALL SAXPY(P-L,T,V(LP1,L),1,V(LP1,J),1)               00002710
  310          CONTINUE                                                 00002720
  320       CONTINUE                                                    00002730
            DO 330 I = 1, P                                             00002740
               V(I,L) = 0.0E0                                           00002750
  330       CONTINUE                                                    00002760
            V(L,L) = 1.0E0                                              00002770
  340    CONTINUE                                                       00002780
  350 CONTINUE                                                          00002790
C                                                                       00002800
C     MAIN ITERATION LOOP FOR THE SINGULAR VALUES.                      00002810
C                                                                       00002820
      MM = M                                                            00002830
      ITER = 0                                                          00002840
  360 CONTINUE                                                          00002850
C                                                                       00002860
C        QUIT IF ALL THE SINGULAR VALUES HAVE BEEN FOUND.               00002870
C                                                                       00002880
C     ...EXIT                                                           00002890
         IF (M .EQ. 0) GO TO 620                                        00002900
C                                                                       00002910
C        IF TOO MANY ITERATIONS HAVE BEEN PERFORMED, SET                00002920
C        FLAG AND RETURN.                                               00002930
C                                                                       00002940
         IF (ITER .LT. MAXIT) GO TO 370                                 00002950
            INFO = M                                                    00002960
C     ......EXIT                                                        00002970
            GO TO 620                                                   00002980
  370    CONTINUE                                                       00002990
C                                                                       00003000
C        THIS SECTION OF THE PROGRAM INSPECTS FOR                       00003010
C        NEGLIGIBLE ELEMENTS IN THE S AND E ARRAYS.  ON                 00003020
C        COMPLETION THE VARIABLES KASE AND L ARE SET AS FOLLOWS.        00003030
C                                                                       00003040
C           KASE = 1     IF S(M) AND E(L-1) ARE NEGLIGIBLE AND L.LT.M   00003050
C           KASE = 2     IF S(L) IS NEGLIGIBLE AND L.LT.M               00003060
C           KASE = 3     IF E(L-1) IS NEGLIGIBLE, L.LT.M, AND           00003070
C                        S(L), ..., S(M) ARE NOT NEGLIGIBLE (QR STEP).  00003080
C           KASE = 4     IF E(M-1) IS NEGLIGIBLE (CONVERGENCE).         00003090
C                                                                       00003100
         DO 390 LL = 1, M                                               00003110
            L = M - LL                                                  00003120
C        ...EXIT                                                        00003130
            IF (L .EQ. 0) GO TO 400                                     00003140
            TEST = ABS(S(L)) + ABS(S(L+1))                              00003150
            ZTEST = TEST + ABS(E(L))                                    00003160
            IF (ZTEST .NE. TEST) GO TO 380                              00003170
               E(L) = 0.0E0                                             00003180
C        ......EXIT                                                     00003190
               GO TO 400                                                00003200
  380       CONTINUE                                                    00003210
  390    CONTINUE                                                       00003220
  400    CONTINUE                                                       00003230
         IF (L .NE. M - 1) GO TO 410                                    00003240
            KASE = 4                                                    00003250
         GO TO 480                                                      00003260
  410    CONTINUE                                                       00003270
            LP1 = L + 1                                                 00003280
            MP1 = M + 1                                                 00003290
            DO 430 LLS = LP1, MP1                                       00003300
               LS = M - LLS + LP1                                       00003310
C           ...EXIT                                                     00003320
               IF (LS .EQ. L) GO TO 440                                 00003330
               TEST = 0.0E0                                             00003340
               IF (LS .NE. M) TEST = TEST + ABS(E(LS))                  00003350
               IF (LS .NE. L + 1) TEST = TEST + ABS(E(LS-1))            00003360
               ZTEST = TEST + ABS(S(LS))                                00003370
               IF (ZTEST .NE. TEST) GO TO 420                           00003380
                  S(LS) = 0.0E0                                         00003390
C           ......EXIT                                                  00003400
                  GO TO 440                                             00003410
  420          CONTINUE                                                 00003420
  430       CONTINUE                                                    00003430
  440       CONTINUE                                                    00003440
            IF (LS .NE. L) GO TO 450                                    00003450
               KASE = 3                                                 00003460
            GO TO 470                                                   00003470
  450       CONTINUE                                                    00003480
            IF (LS .NE. M) GO TO 460                                    00003490
               KASE = 1                                                 00003500
            GO TO 470                                                   00003510
  460       CONTINUE                                                    00003520
               KASE = 2                                                 00003530
               L = LS                                                   00003540
  470       CONTINUE                                                    00003550
  480    CONTINUE                                                       00003560
         L = L + 1                                                      00003570
C                                                                       00003580
C        PERFORM THE TASK INDICATED BY KASE.                            00003590
C                                                                       00003600
         GO TO (490,520,540,570), KASE                                  00003610
C                                                                       00003620
C        DEFLATE NEGLIGIBLE S(M).                                       00003630
C                                                                       00003640
  490    CONTINUE                                                       00003650
            MM1 = M - 1                                                 00003660
            F = E(M-1)                                                  00003670
            E(M-1) = 0.0E0                                              00003680
            DO 510 KK = L, MM1                                          00003690
               K = MM1 - KK + L                                         00003700
               T1 = S(K)                                                00003710
               CALL SROTG(T1,F,CS,SN)                                   00003720
               S(K) = T1                                                00003730
               IF (K .EQ. L) GO TO 500                                  00003740
                  F = -SN*E(K-1)                                        00003750
                  E(K-1) = CS*E(K-1)                                    00003760
  500          CONTINUE                                                 00003770
               IF (WANTV) CALL SROT(P,V(1,K),1,V(1,M),1,CS,SN)          00003780
  510       CONTINUE                                                    00003790
         GO TO 610                                                      00003800
C                                                                       00003810
C        SPLIT AT NEGLIGIBLE S(L).                                      00003820
C                                                                       00003830
  520    CONTINUE                                                       00003840
            F = E(L-1)                                                  00003850
            E(L-1) = 0.0E0                                              00003860
            DO 530 K = L, M                                             00003870
               T1 = S(K)                                                00003880
               CALL SROTG(T1,F,CS,SN)                                   00003890
               S(K) = T1                                                00003900
               F = -SN*E(K)                                             00003910
               E(K) = CS*E(K)                                           00003920
               IF (WANTU) CALL SROT(N,U(1,K),1,U(1,L-1),1,CS,SN)        00003930
  530       CONTINUE                                                    00003940
         GO TO 610                                                      00003950
C                                                                       00003960
C        PERFORM ONE QR STEP.                                           00003970
C                                                                       00003980
  540    CONTINUE                                                       00003990
C                                                                       00004000
C           CALCULATE THE SHIFT.                                        00004010
C                                                                       00004020
            SCALE = AMAX1(ABS(S(M)),ABS(S(M-1)),ABS(E(M-1)),ABS(S(L)),  00004030
     *                    ABS(E(L)))                                    00004040
            SM = S(M)/SCALE                                             00004050
            SMM1 = S(M-1)/SCALE                                         00004060
            EMM1 = E(M-1)/SCALE                                         00004070
            SL = S(L)/SCALE                                             00004080
            EL = E(L)/SCALE                                             00004090
            B = ((SMM1 + SM)*(SMM1 - SM) + EMM1**2)/2.0E0               00004100
            C = (SM*EMM1)**2                                            00004110
            SHIFT = 0.0E0                                               00004120
            IF (B .EQ. 0.0E0 .AND. C .EQ. 0.0E0) GO TO 550              00004130
               SHIFT = SQRT(B**2+C)                                     00004140
               IF (B .LT. 0.0E0) SHIFT = -SHIFT                         00004150
               SHIFT = C/(B + SHIFT)                                    00004160
  550       CONTINUE                                                    00004170
            F = (SL + SM)*(SL - SM) - SHIFT                             00004180
            G = SL*EL                                                   00004190
C                                                                       00004200
C           CHASE ZEROS.                                                00004210
C                                                                       00004220
            MM1 = M - 1                                                 00004230
            DO 560 K = L, MM1                                           00004240
               CALL SROTG(F,G,CS,SN)                                    00004250
               IF (K .NE. L) E(K-1) = F                                 00004260
               F = CS*S(K) + SN*E(K)                                    00004270
               E(K) = CS*E(K) - SN*S(K)                                 00004280
               G = SN*S(K+1)                                            00004290
               S(K+1) = CS*S(K+1)                                       00004300
               IF (WANTV) CALL SROT(P,V(1,K),1,V(1,K+1),1,CS,SN)        00004310
               CALL SROTG(F,G,CS,SN)                                    00004320
               S(K) = F                                                 00004330
               F = CS*E(K) + SN*S(K+1)                                  00004340
               S(K+1) = -SN*E(K) + CS*S(K+1)                            00004350
               G = SN*E(K+1)                                            00004360
               E(K+1) = CS*E(K+1)                                       00004370
               IF (WANTU .AND. K .LT. N)                                00004380
     *            CALL SROT(N,U(1,K),1,U(1,K+1),1,CS,SN)                00004390
  560       CONTINUE                                                    00004400
            E(M-1) = F                                                  00004410
            ITER = ITER + 1                                             00004420
         GO TO 610                                                      00004430
C                                                                       00004440
C        CONVERGENCE.                                                   00004450
C                                                                       00004460
  570    CONTINUE                                                       00004470
C                                                                       00004480
C           MAKE THE SINGULAR VALUE  POSITIVE.                          00004490
C                                                                       00004500
            IF (S(L) .GE. 0.0E0) GO TO 580                              00004510
               S(L) = -S(L)                                             00004520
               IF (WANTV) CALL SSCAL(P,-1.0E0,V(1,L),1)                 00004530
  580       CONTINUE                                                    00004540
C                                                                       00004550
C           ORDER THE SINGULAR VALUE.                                   00004560
C                                                                       00004570
  590       IF (L .EQ. MM) GO TO 600                                    00004580
C           ...EXIT                                                     00004590
               IF (S(L) .GE. S(L+1)) GO TO 600                          00004600
               T = S(L)                                                 00004610
               S(L) = S(L+1)                                            00004620
               S(L+1) = T                                               00004630
               IF (WANTV .AND. L .LT. P)                                00004640
     *            CALL SSWAP(P,V(1,L),1,V(1,L+1),1)                     00004650
               IF (WANTU .AND. L .LT. N)                                00004660
     *            CALL SSWAP(N,U(1,L),1,U(1,L+1),1)                     00004670
               L = L + 1                                                00004680
            GO TO 590                                                   00004690
  600       CONTINUE                                                    00004700
            ITER = 0                                                    00004710
            M = M - 1                                                   00004720
  610    CONTINUE                                                       00004730
      GO TO 360                                                         00004740
  620 CONTINUE                                                          00004750
      RETURN                                                            00004760
      END                                                               00004770
