*#**********************************************************************

      SUBROUTINE ZCHDD(R,LDR,P,X,Z,LDZ,NZ,Y,RHO,C,S,INFO)               00000010

      INTEGER LDR,P,LDZ,NZ,INFO                                         00000020
      COMPLEX*16 R(LDR,1),X(1),Z(LDZ,1),Y(1),S(1)                       00000030
      DOUBLE PRECISION RHO(1),C(1)                                      00000040
C                                                                       00000050
C     ZCHDD DOWNDATES AN AUGMENTED CHOLESKY DECOMPOSITION OR THE        00000060
C     TRIANGULAR FACTOR OF AN AUGMENTED QR DECOMPOSITION.               00000070
C     SPECIFICALLY, GIVEN AN UPPER TRIANGULAR MATRIX R OF ORDER P,  A   00000080
C     ROW VECTOR X, A COLUMN VECTOR Z, AND A SCALAR Y, ZCHDD            00000090
C     DETERMINEDS A UNITARY MATRIX U AND A SCALAR ZETA SUCH THAT        00000100
C                                                                       00000110
C                        (R   Z )     (RR  ZZ)                          00000120
C                    U * (      )  =  (      ) ,                        00000130
C                        (0 ZETA)     ( X   Y)                          00000140
C                                                                       00000150
C     WHERE RR IS UPPER TRIANGULAR.  IF R AND Z HAVE BEEN OBTAINED      00000160
C     FROM THE FACTORIZATION OF A LEAST SQUARES PROBLEM, THEN           00000170
C     RR AND ZZ ARE THE FACTORS CORRESPONDING TO THE PROBLEM            00000180
C     WITH THE OBSERVATION (X,Y) REMOVED.  IN THIS CASE, IF RHO         00000190
C     IS THE NORM OF THE RESIDUAL VECTOR, THEN THE NORM OF              00000200
C     THE RESIDUAL VECTOR OF THE DOWNDATED PROBLEM IS                   00000210
C     DSQRT(RHO**2 - ZETA**2). ZCHDD WILL SIMULTANEOUSLY DOWNDATE       00000220
C     SEVERAL TRIPLETS (Z,Y,RHO) ALONG WITH R.                          00000230
C     FOR A LESS TERSE DESCRIPTION OF WHAT ZCHDD DOES AND HOW           00000240
C     IT MAY BE APPLIED, SEE THE LINPACK GUIDE.                         00000250
C                                                                       00000260
C     THE MATRIX U IS DETERMINED AS THE PRODUCT U(1)*...*U(P)           00000270
C     WHERE U(I) IS A ROTATION IN THE (P+1,I)-PLANE OF THE              00000280
C     FORM                                                              00000290
C                                                                       00000300
C                       ( C(I)  -DCONJG(S(I)) )                         00000310
C                       (                    ) .                        00000320
C                       ( S(I)       C(I)    )                          00000330
C                                                                       00000340
C     THE ROTATIONS ARE CHOSEN SO THAT C(I) IS DOUBLE PRECISION.        00000350
C                                                                       00000360
C     THE USER IS WARNED THAT A GIVEN DOWNDATING PROBLEM MAY            00000370
C     BE IMPOSSIBLE TO ACCOMPLISH OR MAY PRODUCE                        00000380
C     INACCURATE RESULTS.  FOR EXAMPLE, THIS CAN HAPPEN                 00000390
C     IF X IS NEAR A VECTOR WHOSE REMOVAL WILL REDUCE THE               00000400
C     RANK OF R.  BEWARE.                                               00000410
C                                                                       00000420
C     ON ENTRY                                                          00000430
C                                                                       00000440
C         R      COMPLEX*16(LDR,P), WHERE LDR .GE. P.                   00000450
C                R CONTAINS THE UPPER TRIANGULAR MATRIX                 00000460
C                THAT IS TO BE DOWNDATED.  THE PART OF  R               00000470
C                BELOW THE DIAGONAL IS NOT REFERENCED.                  00000480
C                                                                       00000490
C         LDR    INTEGER.                                               00000500
C                LDR IS THE LEADING DIMENSION FO THE ARRAY R.           00000510
C                                                                       00000520
C         P      INTEGER.                                               00000530
C                P IS THE ORDER OF THE MATRIX R.                        00000540
C                                                                       00000550
C         X      COMPLEX*16(P).                                         00000560
C                X CONTAINS THE ROW VECTOR THAT IS TO                   00000570
C                BE REMOVED FROM R.  X IS NOT ALTERED BY ZCHDD.         00000580
C                                                                       00000590
C         Z      COMPLEX*16(LDZ,NZ), WHERE LDZ .GE. P.                  00000600
C                Z IS AN ARRAY OF NZ P-VECTORS WHICH                    00000610
C                ARE TO BE DOWNDATED ALONG WITH R.                      00000620
C                                                                       00000630
C         LDZ    INTEGER.                                               00000640
C                LDZ IS THE LEADING DIMENSION OF THE ARRAY Z.           00000650
C                                                                       00000660
C         NZ     INTEGER.                                               00000670
C                NZ IS THE NUMBER OF VECTORS TO BE DOWNDATED            00000680
C                NZ MAY BE ZERO, IN WHICH CASE Z, Y, AND RHO            00000690
C                ARE NOT REFERENCED.                                    00000700
C                                                                       00000710
C         Y      COMPLEX*16(NZ).                                        00000720
C                Y CONTAINS THE SCALARS FOR THE DOWNDATING              00000730
C                OF THE VECTORS Z.  Y IS NOT ALTERED BY ZCHDD.          00000740
C                                                                       00000750
C         RHO    DOUBLE PRECISION(NZ).                                  00000760
C                RHO CONTAINS THE NORMS OF THE RESIDUAL                 00000770
C                VECTORS THAT ARE TO BE DOWNDATED.                      00000780
C                                                                       00000790
C     ON RETURN                                                         00000800
C                                                                       00000810
C         R                                                             00000820
C         Z      CONTAIN THE DOWNDATED QUANTITIES.                      00000830
C         RHO                                                           00000840
C                                                                       00000850
C         C      DOUBLE PRECISION(P).                                   00000860
C                C CONTAINS THE COSINES OF THE TRANSFORMING             00000870
C                ROTATIONS.                                             00000880
C                                                                       00000890
C         S      COMPLEX*16(P).                                         00000900
C                S CONTAINS THE SINES OF THE TRANSFORMING               00000910
C                ROTATIONS.                                             00000920
C                                                                       00000930
C         INFO   INTEGER.                                               00000940
C                INFO IS SET AS FOLLOWS.                                00000950
C                                                                       00000960
C                   INFO = 0  IF THE ENTIRE DOWNDATING                  00000970
C                             WAS SUCCESSFUL.                           00000980
C                                                                       00000990
C                   INFO =-1  IF R COULD NOT BE DOWNDATED.              00001000
C                             IN THIS CASE, ALL QUANTITIES              00001010
C                             ARE LEFT UNALTERED.                       00001020
C                                                                       00001030
C                   INFO = 1  IF SOME RHO COULD NOT BE                  00001040
C                             DOWNDATED.  THE OFFENDING RHOS ARE        00001050
C                             SET TO -1.                                00001060
C                                                                       00001070
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00001080
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00001090
C                                                                       00001100
C     ZCHDD USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00001110
C                                                                       00001120
C     FORTRAN CDABS,DCONJG                                              00001130
C     BLAS ZDOTC, DZNRM2                                                00001140
C                                                                       00001150
      INTEGER I,II,J                                                    00001160
      DOUBLE PRECISION A,ALPHA,AZETA,NORM,DZNRM2                        00001170
      COMPLEX*16 ZDOTC,T,ZETA,B,XX                                      00001180
      DOUBLE PRECISION DREAL,DIMAG                                      00001190
      COMPLEX*16 ZDUMR,ZDUMI                                            00001200
      DREAL(ZDUMR) = ZDUMR                                              00001210
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00001220
C                                                                       00001230
C     SOLVE THE SYSTEM CTRANS(R)*A = X, PLACING THE RESULT              00001240
C     IN THE ARRAY S.                                                   00001250
C                                                                       00001260
      INFO = 0                                                          00001270
      S(1) = DCONJG(X(1))/DCONJG(R(1,1))                                00001280
      IF (P .LT. 2) GO TO 20                                            00001290
      DO 10 J = 2, P                                                    00001300
         S(J) = DCONJG(X(J)) - ZDOTC(J-1,R(1,J),1,S,1)                  00001310
         S(J) = S(J)/DCONJG(R(J,J))                                     00001320
   10 CONTINUE                                                          00001330
   20 CONTINUE                                                          00001340
      NORM = DZNRM2(P,S,1)                                              00001350
      IF (NORM .LT. 1.0D0) GO TO 30                                     00001360
         INFO = -1                                                      00001370
      GO TO 120                                                         00001380
   30 CONTINUE                                                          00001390
         ALPHA = DSQRT(1.0D0-NORM**2)                                   00001400
C                                                                       00001410
C        DETERMINE THE TRANSFORMATIONS.                                 00001420
C                                                                       00001430
         DO 40 II = 1, P                                                00001440
            I = P - II + 1                                              00001450
            SCALE = ALPHA + CDABS(S(I))                                 00001460
            A = ALPHA/SCALE                                             00001470
            B = S(I)/SCALE                                              00001480
            NORM = DSQRT(A**2+DREAL(B)**2+DIMAG(B)**2)                  00001490
            C(I) = A/NORM                                               00001500
            S(I) = DCONJG(B)/NORM                                       00001510
            ALPHA = SCALE*NORM                                          00001520
   40    CONTINUE                                                       00001530
C                                                                       00001540
C        APPLY THE TRANSFORMATIONS TO R.                                00001550
C                                                                       00001560
         DO 60 J = 1, P                                                 00001570
            XX = (0.0D0,0.0D0)                                          00001580
            DO 50 II = 1, J                                             00001590
               I = J - II + 1                                           00001600
               T = C(I)*XX + S(I)*R(I,J)                                00001610
               R(I,J) = C(I)*R(I,J) - DCONJG(S(I))*XX                   00001620
               XX = T                                                   00001630
   50       CONTINUE                                                    00001640
   60    CONTINUE                                                       00001650
C                                                                       00001660
C        IF REQUIRED, DOWNDATE Z AND RHO.                               00001670
C                                                                       00001680
         IF (NZ .LT. 1) GO TO 110                                       00001690
         DO 100 J = 1, NZ                                               00001700
            ZETA = Y(J)                                                 00001710
            DO 70 I = 1, P                                              00001720
               Z(I,J) = (Z(I,J) - DCONJG(S(I))*ZETA)/C(I)               00001730
               ZETA = C(I)*ZETA - S(I)*Z(I,J)                           00001740
   70       CONTINUE                                                    00001750
            AZETA = CDABS(ZETA)                                         00001760
            IF (AZETA .LE. RHO(J)) GO TO 80                             00001770
               INFO = 1                                                 00001780
               RHO(J) = -1.0D0                                          00001790
            GO TO 90                                                    00001800
   80       CONTINUE                                                    00001810
               RHO(J) = RHO(J)*DSQRT(1.0D0-(AZETA/RHO(J))**2)           00001820
   90       CONTINUE                                                    00001830
  100    CONTINUE                                                       00001840
  110    CONTINUE                                                       00001850
  120 CONTINUE                                                          00001860
      RETURN                                                            00001870
      END                                                               00001880
