*#**********************************************************************

      SUBROUTINE ZGECO(A,LDA,N,IPVT,RCOND,Z)                            00000010

      INTEGER LDA,N,IPVT(1)                                             00000020
      COMPLEX*16 A(LDA,1),Z(1)                                          00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZGECO FACTORS A COMPLEX*16 MATRIX BY GAUSSIAN ELIMINATION         00000060
C     AND ESTIMATES THE CONDITION OF THE MATRIX.                        00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, ZGEFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW ZGECO BY ZGESL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZGECO BY ZGESL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZGECO BY ZGEDI.               00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW ZGECO BY ZGEDI.                   00000130
C                                                                       00000140
C     ON ENTRY                                                          00000150
C                                                                       00000160
C        A       COMPLEX*16(LDA, N)                                     00000170
C                THE MATRIX TO BE FACTORED.                             00000180
C                                                                       00000190
C        LDA     INTEGER                                                00000200
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000210
C                                                                       00000220
C        N       INTEGER                                                00000230
C                THE ORDER OF THE MATRIX  A .                           00000240
C                                                                       00000250
C     ON RETURN                                                         00000260
C                                                                       00000270
C        A       AN UPPER TRIANGULAR MATRIX AND THE MULTIPLIERS         00000280
C                WHICH WERE USED TO OBTAIN IT.                          00000290
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U  WHERE       00000300
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER          00000310
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.       00000320
C                                                                       00000330
C        IPVT    INTEGER(N)                                             00000340
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000350
C                                                                       00000360
C        RCOND   DOUBLE PRECISION                                       00000370
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000380
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000390
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000400
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000410
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000420
C                           1.0 + RCOND .EQ. 1.0                        00000430
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000440
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000450
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000460
C                UNDERFLOWS.                                            00000470
C                                                                       00000480
C        Z       COMPLEX*16(N)                                          00000490
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000500
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000510
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000520
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000530
C                                                                       00000540
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000550
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000560
C                                                                       00000570
C     SUBROUTINES AND FUNCTIONS                                         00000580
C                                                                       00000590
C     LINPACK ZGEFA                                                     00000600
C     BLAS ZAXPY,ZDOTC,ZDSCAL,DZASUM                                    00000610
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG                                  00000620
C                                                                       00000630
C     INTERNAL VARIABLES                                                00000640
C                                                                       00000650
      COMPLEX*16 ZDOTC,EK,T,WK,WKM                                      00000660
      DOUBLE PRECISION ANORM,S,DZASUM,SM,YNORM                          00000670
      INTEGER INFO,J,K,KB,KP1,L                                         00000680
C                                                                       00000690
      COMPLEX*16 ZDUM,ZDUM1,ZDUM2,CSIGN1                                00000700
      DOUBLE PRECISION CABS1                                            00000710
      DOUBLE PRECISION DREAL,DIMAG                                      00000720
      COMPLEX*16 ZDUMR,ZDUMI                                            00000730
      DREAL(ZDUMR) = ZDUMR                                              00000740
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000750
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000760
      CSIGN1(ZDUM1,ZDUM2) = CABS1(ZDUM1)*(ZDUM2/CABS1(ZDUM2))           00000770
C                                                                       00000780
C     COMPUTE 1-NORM OF A                                               00000790
C                                                                       00000800
      ANORM = 0.0D0                                                     00000810
      DO 10 J = 1, N                                                    00000820
         ANORM = DMAX1(ANORM,DZASUM(N,A(1,J),1))                        00000830
   10 CONTINUE                                                          00000840
C                                                                       00000850
C     FACTOR                                                            00000860
C                                                                       00000870
      CALL ZGEFA(A,LDA,N,IPVT,INFO)                                     00000880
C                                                                       00000890
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00000900
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  CTRANS(A)*Y = E . 00000910
C     CTRANS(A)  IS THE CONJUGATE TRANSPOSE OF A .                      00000920
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00000930
C     GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(U)*W = E .             00000940
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00000950
C                                                                       00000960
C     SOLVE CTRANS(U)*W = E                                             00000970
C                                                                       00000980
      EK = (1.0D0,0.0D0)                                                00000990
      DO 20 J = 1, N                                                    00001000
         Z(J) = (0.0D0,0.0D0)                                           00001010
   20 CONTINUE                                                          00001020
      DO 100 K = 1, N                                                   00001030
         IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,-Z(K))              00001040
         IF (CABS1(EK-Z(K)) .LE. CABS1(A(K,K))) GO TO 30                00001050
            S = CABS1(A(K,K))/CABS1(EK-Z(K))                            00001060
            CALL ZDSCAL(N,S,Z,1)                                        00001070
            EK = DCMPLX(S,0.0D0)*EK                                     00001080
   30    CONTINUE                                                       00001090
         WK = EK - Z(K)                                                 00001100
         WKM = -EK - Z(K)                                               00001110
         S = CABS1(WK)                                                  00001120
         SM = CABS1(WKM)                                                00001130
         IF (CABS1(A(K,K)) .EQ. 0.0D0) GO TO 40                         00001140
            WK = WK/DCONJG(A(K,K))                                      00001150
            WKM = WKM/DCONJG(A(K,K))                                    00001160
         GO TO 50                                                       00001170
   40    CONTINUE                                                       00001180
            WK = (1.0D0,0.0D0)                                          00001190
            WKM = (1.0D0,0.0D0)                                         00001200
   50    CONTINUE                                                       00001210
         KP1 = K + 1                                                    00001220
         IF (KP1 .GT. N) GO TO 90                                       00001230
            DO 60 J = KP1, N                                            00001240
               SM = SM + CABS1(Z(J)+WKM*DCONJG(A(K,J)))                 00001250
               Z(J) = Z(J) + WK*DCONJG(A(K,J))                          00001260
               S = S + CABS1(Z(J))                                      00001270
   60       CONTINUE                                                    00001280
            IF (S .GE. SM) GO TO 80                                     00001290
               T = WKM - WK                                             00001300
               WK = WKM                                                 00001310
               DO 70 J = KP1, N                                         00001320
                  Z(J) = Z(J) + T*DCONJG(A(K,J))                        00001330
   70          CONTINUE                                                 00001340
   80       CONTINUE                                                    00001350
   90    CONTINUE                                                       00001360
         Z(K) = WK                                                      00001370
  100 CONTINUE                                                          00001380
      S = 1.0D0/DZASUM(N,Z,1)                                           00001390
      CALL ZDSCAL(N,S,Z,1)                                              00001400
C                                                                       00001410
C     SOLVE CTRANS(L)*Y = W                                             00001420
C                                                                       00001430
      DO 120 KB = 1, N                                                  00001440
         K = N + 1 - KB                                                 00001450
         IF (K .LT. N) Z(K) = Z(K) + ZDOTC(N-K,A(K+1,K),1,Z(K+1),1)     00001460
         IF (CABS1(Z(K)) .LE. 1.0D0) GO TO 110                          00001470
            S = 1.0D0/CABS1(Z(K))                                       00001480
            CALL ZDSCAL(N,S,Z,1)                                        00001490
  110    CONTINUE                                                       00001500
         L = IPVT(K)                                                    00001510
         T = Z(L)                                                       00001520
         Z(L) = Z(K)                                                    00001530
         Z(K) = T                                                       00001540
  120 CONTINUE                                                          00001550
      S = 1.0D0/DZASUM(N,Z,1)                                           00001560
      CALL ZDSCAL(N,S,Z,1)                                              00001570
C                                                                       00001580
      YNORM = 1.0D0                                                     00001590
C                                                                       00001600
C     SOLVE L*V = Y                                                     00001610
C                                                                       00001620
      DO 140 K = 1, N                                                   00001630
         L = IPVT(K)                                                    00001640
         T = Z(L)                                                       00001650
         Z(L) = Z(K)                                                    00001660
         Z(K) = T                                                       00001670
         IF (K .LT. N) CALL ZAXPY(N-K,T,A(K+1,K),1,Z(K+1),1)            00001680
         IF (CABS1(Z(K)) .LE. 1.0D0) GO TO 130                          00001690
            S = 1.0D0/CABS1(Z(K))                                       00001700
            CALL ZDSCAL(N,S,Z,1)                                        00001710
            YNORM = S*YNORM                                             00001720
  130    CONTINUE                                                       00001730
  140 CONTINUE                                                          00001740
      S = 1.0D0/DZASUM(N,Z,1)                                           00001750
      CALL ZDSCAL(N,S,Z,1)                                              00001760
      YNORM = S*YNORM                                                   00001770
C                                                                       00001780
C     SOLVE  U*Z = V                                                    00001790
C                                                                       00001800
      DO 160 KB = 1, N                                                  00001810
         K = N + 1 - KB                                                 00001820
         IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 150                  00001830
            S = CABS1(A(K,K))/CABS1(Z(K))                               00001840
            CALL ZDSCAL(N,S,Z,1)                                        00001850
            YNORM = S*YNORM                                             00001860
  150    CONTINUE                                                       00001870
         IF (CABS1(A(K,K)) .NE. 0.0D0) Z(K) = Z(K)/A(K,K)               00001880
         IF (CABS1(A(K,K)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)             00001890
         T = -Z(K)                                                      00001900
         CALL ZAXPY(K-1,T,A(1,K),1,Z(1),1)                              00001910
  160 CONTINUE                                                          00001920
C     MAKE ZNORM = 1.0                                                  00001930
      S = 1.0D0/DZASUM(N,Z,1)                                           00001940
      CALL ZDSCAL(N,S,Z,1)                                              00001950
      YNORM = S*YNORM                                                   00001960
C                                                                       00001970
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                         00001980
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                               00001990
      RETURN                                                            00002000
      END                                                               00002010
