*#**********************************************************************

      SUBROUTINE ZHICO(A,LDA,N,KPVT,RCOND,Z)                            00000010

      INTEGER LDA,N,KPVT(1)                                             00000020
      COMPLEX*16 A(LDA,1),Z(1)                                          00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZHICO FACTORS A COMPLEX*16 HERMITIAN MATRIX BY ELIMINATION WITH   00000060
C     SYMMETRIC PIVOTING AND ESTIMATES THE CONDITION OF THE MATRIX.     00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, ZHIFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW ZHICO BY ZHISL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZHICO BY ZHISL.                 00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW ZHICO BY ZHIDI.                   00000120
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZHICO BY ZHIDI.               00000130
C     TO COMPUTE  INERTIA(A), FOLLOW ZHICO BY ZHIDI.                    00000140
C                                                                       00000150
C     ON ENTRY                                                          00000160
C                                                                       00000170
C        A       COMPLEX*16(LDA, N)                                     00000180
C                THE HERMITIAN MATRIX TO BE FACTORED.                   00000190
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000200
C                                                                       00000210
C        LDA     INTEGER                                                00000220
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000230
C                                                                       00000240
C        N       INTEGER                                                00000250
C                THE ORDER OF THE MATRIX  A .                           00000260
C                                                                       00000270
C     OUTPUT                                                            00000280
C                                                                       00000290
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000300
C                WERE USED TO OBTAIN IT.                                00000310
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*CTRANS(U)    00000320
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000330
C                UPPER TRIANGULAR MATRICES , CTRANS(U) IS THE           00000340
C                CONJUGATE TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL  00000350
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000360
C                                                                       00000370
C        KPVT    INTEGER(N)                                             00000380
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000390
C                                                                       00000400
C        RCOND   DOUBLE PRECISION                                       00000410
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000420
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000430
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000440
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000450
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000460
C                           1.0 + RCOND .EQ. 1.0                        00000470
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000480
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000490
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000500
C                UNDERFLOWS.                                            00000510
C                                                                       00000520
C        Z       COMPLEX*16(N)                                          00000530
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000540
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000550
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000560
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000570
C                                                                       00000580
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000590
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000600
C                                                                       00000610
C     SUBROUTINES AND FUNCTIONS                                         00000620
C                                                                       00000630
C     LINPACK ZHIFA                                                     00000640
C     BLAS ZAXPY,ZDOTC,ZDSCAL,DZASUM                                    00000650
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG,IABS                             00000660
C                                                                       00000670
C     INTERNAL VARIABLES                                                00000680
C                                                                       00000690
      COMPLEX*16 AK,AKM1,BK,BKM1,ZDOTC,DENOM,EK,T                       00000700
      DOUBLE PRECISION ANORM,S,DZASUM,YNORM                             00000710
      INTEGER I,INFO,J,JM1,K,KP,KPS,KS                                  00000720
C                                                                       00000730
      COMPLEX*16 ZDUM,ZDUM2,CSIGN1                                      00000740
      DOUBLE PRECISION CABS1                                            00000750
      DOUBLE PRECISION DREAL,DIMAG                                      00000760
      COMPLEX*16 ZDUMR,ZDUMI                                            00000770
      DREAL(ZDUMR) = ZDUMR                                              00000780
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000790
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000800
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000810
C                                                                       00000820
C     FIND NORM OF A USING ONLY UPPER HALF                              00000830
C                                                                       00000840
      DO 30 J = 1, N                                                    00000850
         Z(J) = DCMPLX(DZASUM(J,A(1,J),1),0.0D0)                        00000860
         JM1 = J - 1                                                    00000870
         IF (JM1 .LT. 1) GO TO 20                                       00000880
         DO 10 I = 1, JM1                                               00000890
            Z(I) = DCMPLX(DREAL(Z(I))+CABS1(A(I,J)),0.0D0)              00000900
   10    CONTINUE                                                       00000910
   20    CONTINUE                                                       00000920
   30 CONTINUE                                                          00000930
      ANORM = 0.0D0                                                     00000940
      DO 40 J = 1, N                                                    00000950
         ANORM = DMAX1(ANORM,DREAL(Z(J)))                               00000960
   40 CONTINUE                                                          00000970
C                                                                       00000980
C     FACTOR                                                            00000990
C                                                                       00001000
      CALL ZHIFA(A,LDA,N,KPVT,INFO)                                     00001010
C                                                                       00001020
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00001030
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00001040
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001050
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00001060
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001070
C                                                                       00001080
C     SOLVE U*D*W = E                                                   00001090
C                                                                       00001100
      EK = (1.0D0,0.0D0)                                                00001110
      DO 50 J = 1, N                                                    00001120
         Z(J) = (0.0D0,0.0D0)                                           00001130
   50 CONTINUE                                                          00001140
      K = N                                                             00001150
   60 IF (K .EQ. 0) GO TO 120                                           00001160
         KS = 1                                                         00001170
         IF (KPVT(K) .LT. 0) KS = 2                                     00001180
         KP = IABS(KPVT(K))                                             00001190
         KPS = K + 1 - KS                                               00001200
         IF (KP .EQ. KPS) GO TO 70                                      00001210
            T = Z(KPS)                                                  00001220
            Z(KPS) = Z(KP)                                              00001230
            Z(KP) = T                                                   00001240
   70    CONTINUE                                                       00001250
         IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,Z(K))               00001260
         Z(K) = Z(K) + EK                                               00001270
         CALL ZAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                          00001280
         IF (KS .EQ. 1) GO TO 80                                        00001290
            IF (CABS1(Z(K-1)) .NE. 0.0D0) EK = CSIGN1(EK,Z(K-1))        00001300
            Z(K-1) = Z(K-1) + EK                                        00001310
            CALL ZAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)                   00001320
   80    CONTINUE                                                       00001330
         IF (KS .EQ. 2) GO TO 100                                       00001340
            IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 90                00001350
               S = CABS1(A(K,K))/CABS1(Z(K))                            00001360
               CALL ZDSCAL(N,S,Z,1)                                     00001370
               EK = DCMPLX(S,0.0D0)*EK                                  00001380
   90       CONTINUE                                                    00001390
            IF (CABS1(A(K,K)) .NE. 0.0D0) Z(K) = Z(K)/A(K,K)            00001400
            IF (CABS1(A(K,K)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)          00001410
         GO TO 110                                                      00001420
  100    CONTINUE                                                       00001430
            AK = A(K,K)/DCONJG(A(K-1,K))                                00001440
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00001450
            BK = Z(K)/DCONJG(A(K-1,K))                                  00001460
            BKM1 = Z(K-1)/A(K-1,K)                                      00001470
            DENOM = AK*AKM1 - 1.0D0                                     00001480
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001490
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001500
  110    CONTINUE                                                       00001510
         K = K - KS                                                     00001520
      GO TO 60                                                          00001530
  120 CONTINUE                                                          00001540
      S = 1.0D0/DZASUM(N,Z,1)                                           00001550
      CALL ZDSCAL(N,S,Z,1)                                              00001560
C                                                                       00001570
C     SOLVE CTRANS(U)*Y = W                                             00001580
C                                                                       00001590
      K = 1                                                             00001600
  130 IF (K .GT. N) GO TO 160                                           00001610
         KS = 1                                                         00001620
         IF (KPVT(K) .LT. 0) KS = 2                                     00001630
         IF (K .EQ. 1) GO TO 150                                        00001640
            Z(K) = Z(K) + ZDOTC(K-1,A(1,K),1,Z(1),1)                    00001650
            IF (KS .EQ. 2)                                              00001660
     *         Z(K+1) = Z(K+1) + ZDOTC(K-1,A(1,K+1),1,Z(1),1)           00001670
            KP = IABS(KPVT(K))                                          00001680
            IF (KP .EQ. K) GO TO 140                                    00001690
               T = Z(K)                                                 00001700
               Z(K) = Z(KP)                                             00001710
               Z(KP) = T                                                00001720
  140       CONTINUE                                                    00001730
  150    CONTINUE                                                       00001740
         K = K + KS                                                     00001750
      GO TO 130                                                         00001760
  160 CONTINUE                                                          00001770
      S = 1.0D0/DZASUM(N,Z,1)                                           00001780
      CALL ZDSCAL(N,S,Z,1)                                              00001790
C                                                                       00001800
      YNORM = 1.0D0                                                     00001810
C                                                                       00001820
C     SOLVE U*D*V = Y                                                   00001830
C                                                                       00001840
      K = N                                                             00001850
  170 IF (K .EQ. 0) GO TO 230                                           00001860
         KS = 1                                                         00001870
         IF (KPVT(K) .LT. 0) KS = 2                                     00001880
         IF (K .EQ. KS) GO TO 190                                       00001890
            KP = IABS(KPVT(K))                                          00001900
            KPS = K + 1 - KS                                            00001910
            IF (KP .EQ. KPS) GO TO 180                                  00001920
               T = Z(KPS)                                               00001930
               Z(KPS) = Z(KP)                                           00001940
               Z(KP) = T                                                00001950
  180       CONTINUE                                                    00001960
            CALL ZAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                       00001970
            IF (KS .EQ. 2) CALL ZAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)    00001980
  190    CONTINUE                                                       00001990
         IF (KS .EQ. 2) GO TO 210                                       00002000
            IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 200               00002010
               S = CABS1(A(K,K))/CABS1(Z(K))                            00002020
               CALL ZDSCAL(N,S,Z,1)                                     00002030
               YNORM = S*YNORM                                          00002040
  200       CONTINUE                                                    00002050
            IF (CABS1(A(K,K)) .NE. 0.0D0) Z(K) = Z(K)/A(K,K)            00002060
            IF (CABS1(A(K,K)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)          00002070
         GO TO 220                                                      00002080
  210    CONTINUE                                                       00002090
            AK = A(K,K)/DCONJG(A(K-1,K))                                00002100
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00002110
            BK = Z(K)/DCONJG(A(K-1,K))                                  00002120
            BKM1 = Z(K-1)/A(K-1,K)                                      00002130
            DENOM = AK*AKM1 - 1.0D0                                     00002140
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002150
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002160
  220    CONTINUE                                                       00002170
         K = K - KS                                                     00002180
      GO TO 170                                                         00002190
  230 CONTINUE                                                          00002200
      S = 1.0D0/DZASUM(N,Z,1)                                           00002210
      CALL ZDSCAL(N,S,Z,1)                                              00002220
      YNORM = S*YNORM                                                   00002230
C                                                                       00002240
C     SOLVE CTRANS(U)*Z = V                                             00002250
C                                                                       00002260
      K = 1                                                             00002270
  240 IF (K .GT. N) GO TO 270                                           00002280
         KS = 1                                                         00002290
         IF (KPVT(K) .LT. 0) KS = 2                                     00002300
         IF (K .EQ. 1) GO TO 260                                        00002310
            Z(K) = Z(K) + ZDOTC(K-1,A(1,K),1,Z(1),1)                    00002320
            IF (KS .EQ. 2)                                              00002330
     *         Z(K+1) = Z(K+1) + ZDOTC(K-1,A(1,K+1),1,Z(1),1)           00002340
            KP = IABS(KPVT(K))                                          00002350
            IF (KP .EQ. K) GO TO 250                                    00002360
               T = Z(K)                                                 00002370
               Z(K) = Z(KP)                                             00002380
               Z(KP) = T                                                00002390
  250       CONTINUE                                                    00002400
  260    CONTINUE                                                       00002410
         K = K + KS                                                     00002420
      GO TO 240                                                         00002430
  270 CONTINUE                                                          00002440
C     MAKE ZNORM = 1.0                                                  00002450
      S = 1.0D0/DZASUM(N,Z,1)                                           00002460
      CALL ZDSCAL(N,S,Z,1)                                              00002470
      YNORM = S*YNORM                                                   00002480
C                                                                       00002490
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                         00002500
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                               00002510
      RETURN                                                            00002520
      END                                                               00002530
