*#**********************************************************************

      SUBROUTINE ZHIDI(A,LDA,N,KPVT,DET,INERT,WORK,JOB)                 00000010

      INTEGER LDA,N,JOB                                                 00000020
      COMPLEX*16 A(LDA,1),WORK(1)                                       00000030
      DOUBLE PRECISION DET(2)                                           00000040
      INTEGER KPVT(1),INERT(3)                                          00000050
C                                                                       00000060
C     ZHIDI COMPUTES THE DETERMINANT, INERTIA AND INVERSE               00000070
C     OF A COMPLEX*16 HERMITIAN MATRIX USING THE FACTORS FROM ZHIFA.    00000080
C                                                                       00000090
C     ON ENTRY                                                          00000100
C                                                                       00000110
C        A       COMPLEX*16(LDA,N)                                      00000120
C                THE OUTPUT FROM ZHIFA.                                 00000130
C                                                                       00000140
C        LDA     INTEGER                                                00000150
C                THE LEADING DIMENSION OF THE ARRAY A.                  00000160
C                                                                       00000170
C        N       INTEGER                                                00000180
C                THE ORDER OF THE MATRIX A.                             00000190
C                                                                       00000200
C        KPVT    INTEGER(N)                                             00000210
C                THE PIVOT VECTOR FROM ZHIFA.                           00000220
C                                                                       00000230
C        WORK    COMPLEX*16(N)                                          00000240
C                WORK VECTOR.  CONTENTS DESTROYED.                      00000250
C                                                                       00000260
C        JOB     INTEGER                                                00000270
C                JOB HAS THE DECIMAL EXPANSION  ABC  WHERE              00000280
C                   IF  C .NE. 0, THE INVERSE IS COMPUTED,              00000290
C                   IF  B .NE. 0, THE DETERMINANT IS COMPUTED,          00000300
C                   IF  A .NE. 0, THE INERTIA IS COMPUTED.              00000310
C                                                                       00000320
C                FOR EXAMPLE, JOB = 111  GIVES ALL THREE.               00000330
C                                                                       00000340
C     ON RETURN                                                         00000350
C                                                                       00000360
C        VARIABLES NOT REQUESTED BY JOB ARE NOT USED.                   00000370
C                                                                       00000380
C        A      CONTAINS THE UPPER TRIANGLE OF THE INVERSE OF           00000390
C               THE ORIGINAL MATRIX.  THE STRICT LOWER TRIANGLE         00000400
C               IS NEVER REFERENCED.                                    00000410
C                                                                       00000420
C        DET    DOUBLE PRECISION(2)                                     00000430
C               DETERMINANT OF ORIGINAL MATRIX.                         00000440
C               DETERMINANT = DET(1) * 10.0**DET(2)                     00000450
C               WITH 1.0 .LE. DABS(DET(1)) .LT. 10.0                    00000460
C               OR DET(1) = 0.0.                                        00000470
C                                                                       00000480
C        INERT  INTEGER(3)                                              00000490
C               THE INERTIA OF THE ORIGINAL MATRIX.                     00000500
C               INERT(1)  =  NUMBER OF POSITIVE EIGENVALUES.            00000510
C               INERT(2)  =  NUMBER OF NEGATIVE EIGENVALUES.            00000520
C               INERT(3)  =  NUMBER OF ZERO EIGENVALUES.                00000530
C                                                                       00000540
C     ERROR CONDITION                                                   00000550
C                                                                       00000560
C        A DIVISION BY ZERO MAY OCCUR IF THE INVERSE IS REQUESTED       00000570
C        AND  ZHICO  HAS SET RCOND .EQ. 0.0                             00000580
C        OR  ZHIFA  HAS SET  INFO .NE. 0 .                              00000590
C                                                                       00000600
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000610
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB             00000620
C                                                                       00000630
C     SUBROUTINES AND FUNCTIONS                                         00000640
C                                                                       00000650
C     BLAS ZAXPY,ZCOPY,ZDOTC,ZSWAP                                      00000660
C     FORTRAN DABS,CDABS,DCMPLX,DCONJG,IABS,MOD                         00000670
C                                                                       00000680
C     INTERNAL VARIABLES.                                               00000690
C                                                                       00000700
      COMPLEX*16 AKKP1,ZDOTC,TEMP                                       00000710
      DOUBLE PRECISION TEN,D,T,AK,AKP1                                  00000720
      INTEGER J,JB,K,KM1,KS,KSTEP                                       00000730
      LOGICAL NOINV,NODET,NOERT                                         00000740
      DOUBLE PRECISION DREAL                                            00000750
      COMPLEX*16 ZDUMR                                                  00000760
      DREAL(ZDUMR) = ZDUMR                                              00000770
C                                                                       00000780
      NOINV = MOD(JOB,10) .EQ. 0                                        00000790
      NODET = MOD(JOB,100)/10 .EQ. 0                                    00000800
      NOERT = MOD(JOB,1000)/100 .EQ. 0                                  00000810
C                                                                       00000820
      IF (NODET .AND. NOERT) GO TO 140                                  00000830
         IF (NOERT) GO TO 10                                            00000840
            INERT(1) = 0                                                00000850
            INERT(2) = 0                                                00000860
            INERT(3) = 0                                                00000870
   10    CONTINUE                                                       00000880
         IF (NODET) GO TO 20                                            00000890
            DET(1) = 1.0D0                                              00000900
            DET(2) = 0.0D0                                              00000910
            TEN = 10.0D0                                                00000920
   20    CONTINUE                                                       00000930
         T = 0.0D0                                                      00000940
         DO 130 K = 1, N                                                00000950
            D = DREAL(A(K,K))                                           00000960
C                                                                       00000970
C           CHECK IF 1 BY 1                                             00000980
C                                                                       00000990
            IF (KPVT(K) .GT. 0) GO TO 50                                00001000
C                                                                       00001010
C              2 BY 2 BLOCK                                             00001020
C              USE DET (D  S)  =  (D/T * C - T) * T  ,  T = CDABS(S)    00001030
C                      (S  C)                                           00001040
C              TO AVOID UNDERFLOW/OVERFLOW TROUBLES.                    00001050
C              TAKE TWO PASSES THROUGH SCALING.  USE  T  FOR FLAG.      00001060
C                                                                       00001070
               IF (T .NE. 0.0D0) GO TO 30                               00001080
                  T = CDABS(A(K,K+1))                                   00001090
                  D = (D/T)*DREAL(A(K+1,K+1)) - T                       00001100
               GO TO 40                                                 00001110
   30          CONTINUE                                                 00001120
                  D = T                                                 00001130
                  T = 0.0D0                                             00001140
   40          CONTINUE                                                 00001150
   50       CONTINUE                                                    00001160
C                                                                       00001170
            IF (NOERT) GO TO 60                                         00001180
               IF (D .GT. 0.0D0) INERT(1) = INERT(1) + 1                00001190
               IF (D .LT. 0.0D0) INERT(2) = INERT(2) + 1                00001200
               IF (D .EQ. 0.0D0) INERT(3) = INERT(3) + 1                00001210
   60       CONTINUE                                                    00001220
C                                                                       00001230
            IF (NODET) GO TO 120                                        00001240
               DET(1) = D*DET(1)                                        00001250
               IF (DET(1) .EQ. 0.0D0) GO TO 110                         00001260
   70             IF (DABS(DET(1)) .GE. 1.0D0) GO TO 80                 00001270
                     DET(1) = TEN*DET(1)                                00001280
                     DET(2) = DET(2) - 1.0D0                            00001290
                  GO TO 70                                              00001300
   80             CONTINUE                                              00001310
   90             IF (DABS(DET(1)) .LT. TEN) GO TO 100                  00001320
                     DET(1) = DET(1)/TEN                                00001330
                     DET(2) = DET(2) + 1.0D0                            00001340
                  GO TO 90                                              00001350
  100             CONTINUE                                              00001360
  110          CONTINUE                                                 00001370
  120       CONTINUE                                                    00001380
  130    CONTINUE                                                       00001390
  140 CONTINUE                                                          00001400
C                                                                       00001410
C     COMPUTE INVERSE(A)                                                00001420
C                                                                       00001430
      IF (NOINV) GO TO 270                                              00001440
         K = 1                                                          00001450
  150    IF (K .GT. N) GO TO 260                                        00001460
            KM1 = K - 1                                                 00001470
            IF (KPVT(K) .LT. 0) GO TO 180                               00001480
C                                                                       00001490
C              1 BY 1                                                   00001500
C                                                                       00001510
               A(K,K) = DCMPLX(1.0D0/DREAL(A(K,K)),0.0D0)               00001520
               IF (KM1 .LT. 1) GO TO 170                                00001530
                  CALL ZCOPY(KM1,A(1,K),1,WORK,1)                       00001540
                  DO 160 J = 1, KM1                                     00001550
                     A(J,K) = ZDOTC(J,A(1,J),1,WORK,1)                  00001560
                     CALL ZAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001570
  160             CONTINUE                                              00001580
                  A(K,K) = A(K,K)                                       00001590
     *                     + DCMPLX(DREAL(ZDOTC(KM1,WORK,1,A(1,K),1)),  00001600
     *                              0.0D0)                              00001610
  170          CONTINUE                                                 00001620
               KSTEP = 1                                                00001630
            GO TO 220                                                   00001640
  180       CONTINUE                                                    00001650
C                                                                       00001660
C              2 BY 2                                                   00001670
C                                                                       00001680
               T = CDABS(A(K,K+1))                                      00001690
               AK = DREAL(A(K,K))/T                                     00001700
               AKP1 = DREAL(A(K+1,K+1))/T                               00001710
               AKKP1 = A(K,K+1)/T                                       00001720
               D = T*(AK*AKP1 - 1.0D0)                                  00001730
               A(K,K) = DCMPLX(AKP1/D,0.0D0)                            00001740
               A(K+1,K+1) = DCMPLX(AK/D,0.0D0)                          00001750
               A(K,K+1) = -AKKP1/D                                      00001760
               IF (KM1 .LT. 1) GO TO 210                                00001770
                  CALL ZCOPY(KM1,A(1,K+1),1,WORK,1)                     00001780
                  DO 190 J = 1, KM1                                     00001790
                     A(J,K+1) = ZDOTC(J,A(1,J),1,WORK,1)                00001800
                     CALL ZAXPY(J-1,WORK(J),A(1,J),1,A(1,K+1),1)        00001810
  190             CONTINUE                                              00001820
                  A(K+1,K+1) = A(K+1,K+1)                               00001830
     *                         + DCMPLX(DREAL(ZDOTC(KM1,WORK,1,         00001840
     *                                              A(1,K+1),1)),0.0D0) 00001850
                  A(K,K+1) = A(K,K+1) + ZDOTC(KM1,A(1,K),1,A(1,K+1),1)  00001860
                  CALL ZCOPY(KM1,A(1,K),1,WORK,1)                       00001870
                  DO 200 J = 1, KM1                                     00001880
                     A(J,K) = ZDOTC(J,A(1,J),1,WORK,1)                  00001890
                     CALL ZAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001900
  200             CONTINUE                                              00001910
                  A(K,K) = A(K,K)                                       00001920
     *                     + DCMPLX(DREAL(ZDOTC(KM1,WORK,1,A(1,K),1)),  00001930
     *                              0.0D0)                              00001940
  210          CONTINUE                                                 00001950
               KSTEP = 2                                                00001960
  220       CONTINUE                                                    00001970
C                                                                       00001980
C           SWAP                                                        00001990
C                                                                       00002000
            KS = IABS(KPVT(K))                                          00002010
            IF (KS .EQ. K) GO TO 250                                    00002020
               CALL ZSWAP(KS,A(1,KS),1,A(1,K),1)                        00002030
               DO 230 JB = KS, K                                        00002040
                  J = K + KS - JB                                       00002050
                  TEMP = DCONJG(A(J,K))                                 00002060
                  A(J,K) = DCONJG(A(KS,J))                              00002070
                  A(KS,J) = TEMP                                        00002080
  230          CONTINUE                                                 00002090
               IF (KSTEP .EQ. 1) GO TO 240                              00002100
                  TEMP = A(KS,K+1)                                      00002110
                  A(KS,K+1) = A(K,K+1)                                  00002120
                  A(K,K+1) = TEMP                                       00002130
  240          CONTINUE                                                 00002140
  250       CONTINUE                                                    00002150
            K = K + KSTEP                                               00002160
         GO TO 150                                                      00002170
  260    CONTINUE                                                       00002180
  270 CONTINUE                                                          00002190
      RETURN                                                            00002200
      END                                                               00002210
