*#**********************************************************************

      SUBROUTINE ZHPCO(AP,N,KPVT,RCOND,Z)                               00000010

      INTEGER N,KPVT(1)                                                 00000020
      COMPLEX*16 AP(1),Z(1)                                             00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZHPCO FACTORS A COMPLEX*16 HERMITIAN MATRIX STORED IN PACKED      00000060
C     FORM BY ELIMINATION WITH SYMMETRIC PIVOTING AND ESTIMATES         00000070
C     THE CONDITION OF THE MATRIX.                                      00000080
C                                                                       00000090
C     IF  RCOND  IS NOT NEEDED, ZHPFA IS SLIGHTLY FASTER.               00000100
C     TO SOLVE  A*X = B , FOLLOW ZHPCO BY ZHPSL.                        00000110
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZHPCO BY ZHPSL.                 00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW ZHPCO BY ZHPDI.                   00000130
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZHPCO BY ZHPDI.               00000140
C     TO COMPUTE  INERTIA(A), FOLLOW ZHPCO BY ZHPDI.                    00000150
C                                                                       00000160
C     ON ENTRY                                                          00000170
C                                                                       00000180
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000190
C                THE PACKED FORM OF A HERMITIAN MATRIX  A .  THE        00000200
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000210
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000220
C                SEE COMMENTS BELOW FOR DETAILS.                        00000230
C                                                                       00000240
C        N       INTEGER                                                00000250
C                THE ORDER OF THE MATRIX  A .                           00000260
C                                                                       00000270
C     OUTPUT                                                            00000280
C                                                                       00000290
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000300
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000310
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*CTRANS(U)    00000320
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000330
C                UPPER TRIANGULAR MATRICES , CTRANS(U) IS THE           00000340
C                CONJUGATE TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL  00000350
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000360
C                                                                       00000370
C        KPVT    INTEGER(N)                                             00000380
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000390
C                                                                       00000400
C        RCOND   DOUBLE PRECISION                                       00000410
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000420
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000430
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000440
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000450
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000460
C                           1.0 + RCOND .EQ. 1.0                        00000470
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000480
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000490
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000500
C                UNDERFLOWS.                                            00000510
C                                                                       00000520
C        Z       COMPLEX*16(N)                                          00000530
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000540
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000550
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000560
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000570
C                                                                       00000580
C     PACKED STORAGE                                                    00000590
C                                                                       00000600
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000610
C          TRIANGLE OF A HERMITIAN MATRIX.                              00000620
C                                                                       00000630
C                K = 0                                                  00000640
C                DO 20 J = 1, N                                         00000650
C                   DO 10 I = 1, J                                      00000660
C                      K = K + 1                                        00000670
C                      AP(K) = A(I,J)                                   00000680
C             10    CONTINUE                                            00000690
C             20 CONTINUE                                               00000700
C                                                                       00000710
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000720
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000730
C                                                                       00000740
C     SUBROUTINES AND FUNCTIONS                                         00000750
C                                                                       00000760
C     LINPACK ZHPFA                                                     00000770
C     BLAS ZAXPY,ZDOTC,ZDSCAL,DZASUM                                    00000780
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG,IABS                             00000790
C                                                                       00000800
C     INTERNAL VARIABLES                                                00000810
C                                                                       00000820
      COMPLEX*16 AK,AKM1,BK,BKM1,ZDOTC,DENOM,EK,T                       00000830
      DOUBLE PRECISION ANORM,S,DZASUM,YNORM                             00000840
      INTEGER I,IJ,IK,IKM1,IKP1,INFO,J,JM1,J1                           00000850
      INTEGER K,KK,KM1K,KM1KM1,KP,KPS,KS                                00000860
C                                                                       00000870
      COMPLEX*16 ZDUM,ZDUM2,CSIGN1                                      00000880
      DOUBLE PRECISION CABS1                                            00000890
      DOUBLE PRECISION DREAL,DIMAG                                      00000900
      COMPLEX*16 ZDUMR,ZDUMI                                            00000910
      DREAL(ZDUMR) = ZDUMR                                              00000920
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000930
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000940
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000950
C                                                                       00000960
C     FIND NORM OF A USING ONLY UPPER HALF                              00000970
C                                                                       00000980
      J1 = 1                                                            00000990
      DO 30 J = 1, N                                                    00001000
         Z(J) = DCMPLX(DZASUM(J,AP(J1),1),0.0D0)                        00001010
         IJ = J1                                                        00001020
         J1 = J1 + J                                                    00001030
         JM1 = J - 1                                                    00001040
         IF (JM1 .LT. 1) GO TO 20                                       00001050
         DO 10 I = 1, JM1                                               00001060
            Z(I) = DCMPLX(DREAL(Z(I))+CABS1(AP(IJ)),0.0D0)              00001070
            IJ = IJ + 1                                                 00001080
   10    CONTINUE                                                       00001090
   20    CONTINUE                                                       00001100
   30 CONTINUE                                                          00001110
      ANORM = 0.0D0                                                     00001120
      DO 40 J = 1, N                                                    00001130
         ANORM = DMAX1(ANORM,DREAL(Z(J)))                               00001140
   40 CONTINUE                                                          00001150
C                                                                       00001160
C     FACTOR                                                            00001170
C                                                                       00001180
      CALL ZHPFA(AP,N,KPVT,INFO)                                        00001190
C                                                                       00001200
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00001210
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00001220
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001230
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00001240
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001250
C                                                                       00001260
C     SOLVE U*D*W = E                                                   00001270
C                                                                       00001280
      EK = (1.0D0,0.0D0)                                                00001290
      DO 50 J = 1, N                                                    00001300
         Z(J) = (0.0D0,0.0D0)                                           00001310
   50 CONTINUE                                                          00001320
      K = N                                                             00001330
      IK = (N*(N - 1))/2                                                00001340
   60 IF (K .EQ. 0) GO TO 120                                           00001350
         KK = IK + K                                                    00001360
         IKM1 = IK - (K - 1)                                            00001370
         KS = 1                                                         00001380
         IF (KPVT(K) .LT. 0) KS = 2                                     00001390
         KP = IABS(KPVT(K))                                             00001400
         KPS = K + 1 - KS                                               00001410
         IF (KP .EQ. KPS) GO TO 70                                      00001420
            T = Z(KPS)                                                  00001430
            Z(KPS) = Z(KP)                                              00001440
            Z(KP) = T                                                   00001450
   70    CONTINUE                                                       00001460
         IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,Z(K))               00001470
         Z(K) = Z(K) + EK                                               00001480
         CALL ZAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                        00001490
         IF (KS .EQ. 1) GO TO 80                                        00001500
            IF (CABS1(Z(K-1)) .NE. 0.0D0) EK = CSIGN1(EK,Z(K-1))        00001510
            Z(K-1) = Z(K-1) + EK                                        00001520
            CALL ZAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)                 00001530
   80    CONTINUE                                                       00001540
         IF (KS .EQ. 2) GO TO 100                                       00001550
            IF (CABS1(Z(K)) .LE. CABS1(AP(KK))) GO TO 90                00001560
               S = CABS1(AP(KK))/CABS1(Z(K))                            00001570
               CALL ZDSCAL(N,S,Z,1)                                     00001580
               EK = DCMPLX(S,0.0D0)*EK                                  00001590
   90       CONTINUE                                                    00001600
            IF (CABS1(AP(KK)) .NE. 0.0D0) Z(K) = Z(K)/AP(KK)            00001610
            IF (CABS1(AP(KK)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)          00001620
         GO TO 110                                                      00001630
  100    CONTINUE                                                       00001640
            KM1K = IK + K - 1                                           00001650
            KM1KM1 = IKM1 + K - 1                                       00001660
            AK = AP(KK)/DCONJG(AP(KM1K))                                00001670
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00001680
            BK = Z(K)/DCONJG(AP(KM1K))                                  00001690
            BKM1 = Z(K-1)/AP(KM1K)                                      00001700
            DENOM = AK*AKM1 - 1.0D0                                     00001710
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001720
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001730
  110    CONTINUE                                                       00001740
         K = K - KS                                                     00001750
         IK = IK - K                                                    00001760
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00001770
      GO TO 60                                                          00001780
  120 CONTINUE                                                          00001790
      S = 1.0D0/DZASUM(N,Z,1)                                           00001800
      CALL ZDSCAL(N,S,Z,1)                                              00001810
C                                                                       00001820
C     SOLVE CTRANS(U)*Y = W                                             00001830
C                                                                       00001840
      K = 1                                                             00001850
      IK = 0                                                            00001860
  130 IF (K .GT. N) GO TO 160                                           00001870
         KS = 1                                                         00001880
         IF (KPVT(K) .LT. 0) KS = 2                                     00001890
         IF (K .EQ. 1) GO TO 150                                        00001900
            Z(K) = Z(K) + ZDOTC(K-1,AP(IK+1),1,Z(1),1)                  00001910
            IKP1 = IK + K                                               00001920
            IF (KS .EQ. 2)                                              00001930
     *         Z(K+1) = Z(K+1) + ZDOTC(K-1,AP(IKP1+1),1,Z(1),1)         00001940
            KP = IABS(KPVT(K))                                          00001950
            IF (KP .EQ. K) GO TO 140                                    00001960
               T = Z(K)                                                 00001970
               Z(K) = Z(KP)                                             00001980
               Z(KP) = T                                                00001990
  140       CONTINUE                                                    00002000
  150    CONTINUE                                                       00002010
         IK = IK + K                                                    00002020
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00002030
         K = K + KS                                                     00002040
      GO TO 130                                                         00002050
  160 CONTINUE                                                          00002060
      S = 1.0D0/DZASUM(N,Z,1)                                           00002070
      CALL ZDSCAL(N,S,Z,1)                                              00002080
C                                                                       00002090
      YNORM = 1.0D0                                                     00002100
C                                                                       00002110
C     SOLVE U*D*V = Y                                                   00002120
C                                                                       00002130
      K = N                                                             00002140
      IK = N*(N - 1)/2                                                  00002150
  170 IF (K .EQ. 0) GO TO 230                                           00002160
         KK = IK + K                                                    00002170
         IKM1 = IK - (K - 1)                                            00002180
         KS = 1                                                         00002190
         IF (KPVT(K) .LT. 0) KS = 2                                     00002200
         IF (K .EQ. KS) GO TO 190                                       00002210
            KP = IABS(KPVT(K))                                          00002220
            KPS = K + 1 - KS                                            00002230
            IF (KP .EQ. KPS) GO TO 180                                  00002240
               T = Z(KPS)                                               00002250
               Z(KPS) = Z(KP)                                           00002260
               Z(KP) = T                                                00002270
  180       CONTINUE                                                    00002280
            CALL ZAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                     00002290
            IF (KS .EQ. 2) CALL ZAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)  00002300
  190    CONTINUE                                                       00002310
         IF (KS .EQ. 2) GO TO 210                                       00002320
            IF (CABS1(Z(K)) .LE. CABS1(AP(KK))) GO TO 200               00002330
               S = CABS1(AP(KK))/CABS1(Z(K))                            00002340
               CALL ZDSCAL(N,S,Z,1)                                     00002350
               YNORM = S*YNORM                                          00002360
  200       CONTINUE                                                    00002370
            IF (CABS1(AP(KK)) .NE. 0.0D0) Z(K) = Z(K)/AP(KK)            00002380
            IF (CABS1(AP(KK)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)          00002390
         GO TO 220                                                      00002400
  210    CONTINUE                                                       00002410
            KM1K = IK + K - 1                                           00002420
            KM1KM1 = IKM1 + K - 1                                       00002430
            AK = AP(KK)/DCONJG(AP(KM1K))                                00002440
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00002450
            BK = Z(K)/DCONJG(AP(KM1K))                                  00002460
            BKM1 = Z(K-1)/AP(KM1K)                                      00002470
            DENOM = AK*AKM1 - 1.0D0                                     00002480
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002490
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002500
  220    CONTINUE                                                       00002510
         K = K - KS                                                     00002520
         IK = IK - K                                                    00002530
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00002540
      GO TO 170                                                         00002550
  230 CONTINUE                                                          00002560
      S = 1.0D0/DZASUM(N,Z,1)                                           00002570
      CALL ZDSCAL(N,S,Z,1)                                              00002580
      YNORM = S*YNORM                                                   00002590
C                                                                       00002600
C     SOLVE CTRANS(U)*Z = V                                             00002610
C                                                                       00002620
      K = 1                                                             00002630
      IK = 0                                                            00002640
  240 IF (K .GT. N) GO TO 270                                           00002650
         KS = 1                                                         00002660
         IF (KPVT(K) .LT. 0) KS = 2                                     00002670
         IF (K .EQ. 1) GO TO 260                                        00002680
            Z(K) = Z(K) + ZDOTC(K-1,AP(IK+1),1,Z(1),1)                  00002690
            IKP1 = IK + K                                               00002700
            IF (KS .EQ. 2)                                              00002710
     *         Z(K+1) = Z(K+1) + ZDOTC(K-1,AP(IKP1+1),1,Z(1),1)         00002720
            KP = IABS(KPVT(K))                                          00002730
            IF (KP .EQ. K) GO TO 250                                    00002740
               T = Z(K)                                                 00002750
               Z(K) = Z(KP)                                             00002760
               Z(KP) = T                                                00002770
  250       CONTINUE                                                    00002780
  260    CONTINUE                                                       00002790
         IK = IK + K                                                    00002800
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00002810
         K = K + KS                                                     00002820
      GO TO 240                                                         00002830
  270 CONTINUE                                                          00002840
C     MAKE ZNORM = 1.0                                                  00002850
      S = 1.0D0/DZASUM(N,Z,1)                                           00002860
      CALL ZDSCAL(N,S,Z,1)                                              00002870
      YNORM = S*YNORM                                                   00002880
C                                                                       00002890
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                         00002900
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                               00002910
      RETURN                                                            00002920
      END                                                               00002930
