*#**********************************************************************

      SUBROUTINE ZHPDI(AP,N,KPVT,DET,INERT,WORK,JOB)                    00000010

      INTEGER N,JOB                                                     00000020
      COMPLEX*16 AP(1),WORK(1)                                          00000030
      DOUBLE PRECISION DET(2)                                           00000040
      INTEGER KPVT(1),INERT(3)                                          00000050
C                                                                       00000060
C     ZHPDI COMPUTES THE DETERMINANT, INERTIA AND INVERSE               00000070
C     OF A COMPLEX*16 HERMITIAN MATRIX USING THE FACTORS FROM ZHPFA,    00000080
C     WHERE THE MATRIX IS STORED IN PACKED FORM.                        00000090
C                                                                       00000100
C     ON ENTRY                                                          00000110
C                                                                       00000120
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000130
C                THE OUTPUT FROM ZHPFA.                                 00000140
C                                                                       00000150
C        N       INTEGER                                                00000160
C                THE ORDER OF THE MATRIX A.                             00000170
C                                                                       00000180
C        KPVT    INTEGER(N)                                             00000190
C                THE PIVOT VECTOR FROM ZHPFA.                           00000200
C                                                                       00000210
C        WORK    COMPLEX*16(N)                                          00000220
C                WORK VECTOR.  CONTENTS IGNORED.                        00000230
C                                                                       00000240
C        JOB     INTEGER                                                00000250
C                JOB HAS THE DECIMAL EXPANSION  ABC  WHERE              00000260
C                   IF  C .NE. 0, THE INVERSE IS COMPUTED,              00000270
C                   IF  B .NE. 0, THE DETERMINANT IS COMPUTED,          00000280
C                   IF  A .NE. 0, THE INERTIA IS COMPUTED.              00000290
C                                                                       00000300
C                FOR EXAMPLE, JOB = 111  GIVES ALL THREE.               00000310
C                                                                       00000320
C     ON RETURN                                                         00000330
C                                                                       00000340
C        VARIABLES NOT REQUESTED BY JOB ARE NOT USED.                   00000350
C                                                                       00000360
C        AP     CONTAINS THE UPPER TRIANGLE OF THE INVERSE OF           00000370
C               THE ORIGINAL MATRIX, STORED IN PACKED FORM.             00000380
C               THE COLUMNS OF THE UPPER TRIANGLE ARE STORED            00000390
C               SEQUENTIALLY IN A ONE-DIMENSIONAL ARRAY.                00000400
C                                                                       00000410
C        DET    DOUBLE PRECISION(2)                                     00000420
C               DETERMINANT OF ORIGINAL MATRIX.                         00000430
C               DETERMINANT = DET(1) * 10.0**DET(2)                     00000440
C               WITH 1.0 .LE. DABS(DET(1)) .LT. 10.0                    00000450
C               OR DET(1) = 0.0.                                        00000460
C                                                                       00000470
C        INERT  INTEGER(3)                                              00000480
C               THE INERTIA OF THE ORIGINAL MATRIX.                     00000490
C               INERT(1)  =  NUMBER OF POSITIVE EIGENVALUES.            00000500
C               INERT(2)  =  NUMBER OF NEGATIVE EIGENVALUES.            00000510
C               INERT(3)  =  NUMBER OF ZERO EIGENVALUES.                00000520
C                                                                       00000530
C     ERROR CONDITION                                                   00000540
C                                                                       00000550
C        A DIVISION BY ZERO WILL OCCUR IF THE INVERSE IS REQUESTED      00000560
C        AND  ZHPCO  HAS SET RCOND .EQ. 0.0                             00000570
C        OR  ZHPFA  HAS SET  INFO .NE. 0 .                              00000580
C                                                                       00000590
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000600
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000610
C                                                                       00000620
C     SUBROUTINES AND FUNCTIONS                                         00000630
C                                                                       00000640
C     BLAS ZAXPY,ZCOPY,ZDOTC,ZSWAP                                      00000650
C     FORTRAN DABS,CDABS,DCMPLX,DCONJG,IABS,MOD                         00000660
C                                                                       00000670
C     INTERNAL VARIABLES.                                               00000680
C                                                                       00000690
      COMPLEX*16 AKKP1,ZDOTC,TEMP                                       00000700
      DOUBLE PRECISION TEN,D,T,AK,AKP1                                  00000710
      INTEGER IJ,IK,IKP1,IKS,J,JB,JK,JKP1                               00000720
      INTEGER K,KK,KKP1,KM1,KS,KSJ,KSKP1,KSTEP                          00000730
      LOGICAL NOINV,NODET,NOERT                                         00000740
      DOUBLE PRECISION DREAL                                            00000750
      COMPLEX*16 ZDUMR                                                  00000760
      DREAL(ZDUMR) = ZDUMR                                              00000770
C                                                                       00000780
      NOINV = MOD(JOB,10) .EQ. 0                                        00000790
      NODET = MOD(JOB,100)/10 .EQ. 0                                    00000800
      NOERT = MOD(JOB,1000)/100 .EQ. 0                                  00000810
C                                                                       00000820
      IF (NODET .AND. NOERT) GO TO 140                                  00000830
         IF (NOERT) GO TO 10                                            00000840
            INERT(1) = 0                                                00000850
            INERT(2) = 0                                                00000860
            INERT(3) = 0                                                00000870
   10    CONTINUE                                                       00000880
         IF (NODET) GO TO 20                                            00000890
            DET(1) = 1.0D0                                              00000900
            DET(2) = 0.0D0                                              00000910
            TEN = 10.0D0                                                00000920
   20    CONTINUE                                                       00000930
         T = 0.0D0                                                      00000940
         IK = 0                                                         00000950
         DO 130 K = 1, N                                                00000960
            KK = IK + K                                                 00000970
            D = DREAL(AP(KK))                                           00000980
C                                                                       00000990
C           CHECK IF 1 BY 1                                             00001000
C                                                                       00001010
            IF (KPVT(K) .GT. 0) GO TO 50                                00001020
C                                                                       00001030
C              2 BY 2 BLOCK                                             00001040
C              USE DET (D  S)  =  (D/T * C - T) * T  ,  T = CDABS(S)    00001050
C                      (S  C)                                           00001060
C              TO AVOID UNDERFLOW/OVERFLOW TROUBLES.                    00001070
C              TAKE TWO PASSES THROUGH SCALING.  USE  T  FOR FLAG.      00001080
C                                                                       00001090
               IF (T .NE. 0.0D0) GO TO 30                               00001100
                  IKP1 = IK + K                                         00001110
                  KKP1 = IKP1 + K                                       00001120
                  T = CDABS(AP(KKP1))                                   00001130
                  D = (D/T)*DREAL(AP(KKP1+1)) - T                       00001140
               GO TO 40                                                 00001150
   30          CONTINUE                                                 00001160
                  D = T                                                 00001170
                  T = 0.0D0                                             00001180
   40          CONTINUE                                                 00001190
   50       CONTINUE                                                    00001200
C                                                                       00001210
            IF (NOERT) GO TO 60                                         00001220
               IF (D .GT. 0.0D0) INERT(1) = INERT(1) + 1                00001230
               IF (D .LT. 0.0D0) INERT(2) = INERT(2) + 1                00001240
               IF (D .EQ. 0.0D0) INERT(3) = INERT(3) + 1                00001250
   60       CONTINUE                                                    00001260
C                                                                       00001270
            IF (NODET) GO TO 120                                        00001280
               DET(1) = D*DET(1)                                        00001290
               IF (DET(1) .EQ. 0.0D0) GO TO 110                         00001300
   70             IF (DABS(DET(1)) .GE. 1.0D0) GO TO 80                 00001310
                     DET(1) = TEN*DET(1)                                00001320
                     DET(2) = DET(2) - 1.0D0                            00001330
                  GO TO 70                                              00001340
   80             CONTINUE                                              00001350
   90             IF (DABS(DET(1)) .LT. TEN) GO TO 100                  00001360
                     DET(1) = DET(1)/TEN                                00001370
                     DET(2) = DET(2) + 1.0D0                            00001380
                  GO TO 90                                              00001390
  100             CONTINUE                                              00001400
  110          CONTINUE                                                 00001410
  120       CONTINUE                                                    00001420
            IK = IK + K                                                 00001430
  130    CONTINUE                                                       00001440
  140 CONTINUE                                                          00001450
C                                                                       00001460
C     COMPUTE INVERSE(A)                                                00001470
C                                                                       00001480
      IF (NOINV) GO TO 270                                              00001490
         K = 1                                                          00001500
         IK = 0                                                         00001510
  150    IF (K .GT. N) GO TO 260                                        00001520
            KM1 = K - 1                                                 00001530
            KK = IK + K                                                 00001540
            IKP1 = IK + K                                               00001550
            KKP1 = IKP1 + K                                             00001560
            IF (KPVT(K) .LT. 0) GO TO 180                               00001570
C                                                                       00001580
C              1 BY 1                                                   00001590
C                                                                       00001600
               AP(KK) = DCMPLX(1.0D0/DREAL(AP(KK)),0.0D0)               00001610
               IF (KM1 .LT. 1) GO TO 170                                00001620
                  CALL ZCOPY(KM1,AP(IK+1),1,WORK,1)                     00001630
                  IJ = 0                                                00001640
                  DO 160 J = 1, KM1                                     00001650
                     JK = IK + J                                        00001660
                     AP(JK) = ZDOTC(J,AP(IJ+1),1,WORK,1)                00001670
                     CALL ZAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IK+1),1)      00001680
                     IJ = IJ + J                                        00001690
  160             CONTINUE                                              00001700
                  AP(KK) = AP(KK)                                       00001710
     *                     + DCMPLX(DREAL(ZDOTC(KM1,WORK,1,AP(IK+1),1)) 00001720
     *                     ,0.0D0)                                      00001730
  170          CONTINUE                                                 00001740
               KSTEP = 1                                                00001750
            GO TO 220                                                   00001760
  180       CONTINUE                                                    00001770
C                                                                       00001780
C              2 BY 2                                                   00001790
C                                                                       00001800
               T = CDABS(AP(KKP1))                                      00001810
               AK = DREAL(AP(KK))/T                                     00001820
               AKP1 = DREAL(AP(KKP1+1))/T                               00001830
               AKKP1 = AP(KKP1)/T                                       00001840
               D = T*(AK*AKP1 - 1.0D0)                                  00001850
               AP(KK) = DCMPLX(AKP1/D,0.0D0)                            00001860
               AP(KKP1+1) = DCMPLX(AK/D,0.0D0)                          00001870
               AP(KKP1) = -AKKP1/D                                      00001880
               IF (KM1 .LT. 1) GO TO 210                                00001890
                  CALL ZCOPY(KM1,AP(IKP1+1),1,WORK,1)                   00001900
                  IJ = 0                                                00001910
                  DO 190 J = 1, KM1                                     00001920
                     JKP1 = IKP1 + J                                    00001930
                     AP(JKP1) = ZDOTC(J,AP(IJ+1),1,WORK,1)              00001940
                     CALL ZAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IKP1+1),1)    00001950
                     IJ = IJ + J                                        00001960
  190             CONTINUE                                              00001970
                  AP(KKP1+1) = AP(KKP1+1)                               00001980
     *                         + DCMPLX(DREAL(ZDOTC(KM1,WORK,1,         00001990
     *                                              AP(IKP1+1),1)),     00002000
     *                                  0.0D0)                          00002010
                  AP(KKP1) = AP(KKP1)                                   00002020
     *                       + ZDOTC(KM1,AP(IK+1),1,AP(IKP1+1),1)       00002030
                  CALL ZCOPY(KM1,AP(IK+1),1,WORK,1)                     00002040
                  IJ = 0                                                00002050
                  DO 200 J = 1, KM1                                     00002060
                     JK = IK + J                                        00002070
                     AP(JK) = ZDOTC(J,AP(IJ+1),1,WORK,1)                00002080
                     CALL ZAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IK+1),1)      00002090
                     IJ = IJ + J                                        00002100
  200             CONTINUE                                              00002110
                  AP(KK) = AP(KK)                                       00002120
     *                     + DCMPLX(DREAL(ZDOTC(KM1,WORK,1,AP(IK+1),1)) 00002130
     *                     ,0.0D0)                                      00002140
  210          CONTINUE                                                 00002150
               KSTEP = 2                                                00002160
  220       CONTINUE                                                    00002170
C                                                                       00002180
C           SWAP                                                        00002190
C                                                                       00002200
            KS = IABS(KPVT(K))                                          00002210
            IF (KS .EQ. K) GO TO 250                                    00002220
               IKS = (KS*(KS - 1))/2                                    00002230
               CALL ZSWAP(KS,AP(IKS+1),1,AP(IK+1),1)                    00002240
               KSJ = IK + KS                                            00002250
               DO 230 JB = KS, K                                        00002260
                  J = K + KS - JB                                       00002270
                  JK = IK + J                                           00002280
                  TEMP = DCONJG(AP(JK))                                 00002290
                  AP(JK) = DCONJG(AP(KSJ))                              00002300
                  AP(KSJ) = TEMP                                        00002310
                  KSJ = KSJ - (J - 1)                                   00002320
  230          CONTINUE                                                 00002330
               IF (KSTEP .EQ. 1) GO TO 240                              00002340
                  KSKP1 = IKP1 + KS                                     00002350
                  TEMP = AP(KSKP1)                                      00002360
                  AP(KSKP1) = AP(KKP1)                                  00002370
                  AP(KKP1) = TEMP                                       00002380
  240          CONTINUE                                                 00002390
  250       CONTINUE                                                    00002400
            IK = IK + K                                                 00002410
            IF (KSTEP .EQ. 2) IK = IK + K + 1                           00002420
            K = K + KSTEP                                               00002430
         GO TO 150                                                      00002440
  260    CONTINUE                                                       00002450
  270 CONTINUE                                                          00002460
      RETURN                                                            00002470
      END                                                               00002480
