*#**********************************************************************

      SUBROUTINE ZHPFA(AP,N,KPVT,INFO)                                  00000010

      INTEGER N,KPVT(1),INFO                                            00000020
      COMPLEX*16 AP(1)                                                  00000030
C                                                                       00000040
C     ZHPFA FACTORS A COMPLEX*16 HERMITIAN MATRIX STORED IN             00000050
C     PACKED FORM BY ELIMINATION WITH SYMMETRIC PIVOTING.               00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW ZHPFA BY ZHPSL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZHPFA BY ZHPSL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZHPFA BY ZHPDI.               00000100
C     TO COMPUTE  INERTIA(A) , FOLLOW ZHPFA BY ZHPDI.                   00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW ZHPFA BY ZHPDI.                   00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000160
C                THE PACKED FORM OF A HERMITIAN MATRIX  A .  THE        00000170
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000180
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000190
C                SEE COMMENTS BELOW FOR DETAILS.                        00000200
C                                                                       00000210
C        N       INTEGER                                                00000220
C                THE ORDER OF THE MATRIX  A .                           00000230
C                                                                       00000240
C     OUTPUT                                                            00000250
C                                                                       00000260
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000270
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000280
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*CTRANS(U)    00000290
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000300
C                UPPER TRIANGULAR MATRICES , CTRANS(U) IS THE           00000310
C                CONJUGATE TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL  00000320
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000330
C                                                                       00000340
C        KPVT    INTEGER(N)                                             00000350
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000360
C                                                                       00000370
C        INFO    INTEGER                                                00000380
C                = 0  NORMAL VALUE.                                     00000390
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000400
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000410
C                     BUT IT DOES INDICATE THAT ZHPSL OR ZHPDI MAY      00000420
C                     DIVIDE BY ZERO IF CALLED.                         00000430
C                                                                       00000440
C     PACKED STORAGE                                                    00000450
C                                                                       00000460
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000470
C          TRIANGLE OF A HERMITIAN MATRIX.                              00000480
C                                                                       00000490
C                K = 0                                                  00000500
C                DO 20 J = 1, N                                         00000510
C                   DO 10 I = 1, J                                      00000520
C                      K = K + 1                                        00000530
C                      AP(K)  = A(I,J)                                  00000540
C             10    CONTINUE                                            00000550
C             20 CONTINUE                                               00000560
C                                                                       00000570
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000580
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000590
C                                                                       00000600
C     SUBROUTINES AND FUNCTIONS                                         00000610
C                                                                       00000620
C     BLAS ZAXPY,ZSWAP,IZAMAX                                           00000630
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG,DSQRT                            00000640
C                                                                       00000650
C     INTERNAL VARIABLES                                                00000660
C                                                                       00000670
      COMPLEX*16 AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T                    00000680
      DOUBLE PRECISION ABSAKK,ALPHA,COLMAX,ROWMAX                       00000690
      INTEGER IZAMAX,IJ,IJJ,IK,IKM1,IM,IMAX,IMAXP1,IMIM,IMJ,IMK         00000700
      INTEGER J,JJ,JK,JKM1,JMAX,JMIM,K,KK,KM1,KM1K,KM1KM1,KM2,KSTEP     00000710
      LOGICAL SWAP                                                      00000720
C                                                                       00000730
      COMPLEX*16 ZDUM                                                   00000740
      DOUBLE PRECISION CABS1                                            00000750
      DOUBLE PRECISION DREAL,DIMAG                                      00000760
      COMPLEX*16 ZDUMR,ZDUMI                                            00000770
      DREAL(ZDUMR) = ZDUMR                                              00000780
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000790
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000800
C                                                                       00000810
C     INITIALIZE                                                        00000820
C                                                                       00000830
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000840
      ALPHA = (1.0D0 + DSQRT(17.0D0))/8.0D0                             00000850
C                                                                       00000860
      INFO = 0                                                          00000870
C                                                                       00000880
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000890
C                                                                       00000900
      K = N                                                             00000910
      IK = (N*(N - 1))/2                                                00000920
   10 CONTINUE                                                          00000930
C                                                                       00000940
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000950
C                                                                       00000960
C     ...EXIT                                                           00000970
         IF (K .EQ. 0) GO TO 200                                        00000980
         IF (K .GT. 1) GO TO 20                                         00000990
            KPVT(1) = 1                                                 00001000
            IF (CABS1(AP(1)) .EQ. 0.0D0) INFO = 1                       00001010
C     ......EXIT                                                        00001020
            GO TO 200                                                   00001030
   20    CONTINUE                                                       00001040
C                                                                       00001050
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00001060
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00001070
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00001080
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00001090
C        REQUIRED.                                                      00001100
C                                                                       00001110
         KM1 = K - 1                                                    00001120
         KK = IK + K                                                    00001130
         ABSAKK = CABS1(AP(KK))                                         00001140
C                                                                       00001150
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00001160
C        COLUMN K.                                                      00001170
C                                                                       00001180
         IMAX = IZAMAX(K-1,AP(IK+1),1)                                  00001190
         IMK = IK + IMAX                                                00001200
         COLMAX = CABS1(AP(IMK))                                        00001210
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00001220
            KSTEP = 1                                                   00001230
            SWAP = .FALSE.                                              00001240
         GO TO 90                                                       00001250
   30    CONTINUE                                                       00001260
C                                                                       00001270
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001280
C           ROW IMAX.                                                   00001290
C                                                                       00001300
            ROWMAX = 0.0D0                                              00001310
            IMAXP1 = IMAX + 1                                           00001320
            IM = IMAX*(IMAX - 1)/2                                      00001330
            IMJ = IM + 2*IMAX                                           00001340
            DO 40 J = IMAXP1, K                                         00001350
               ROWMAX = DMAX1(ROWMAX,CABS1(AP(IMJ)))                    00001360
               IMJ = IMJ + J                                            00001370
   40       CONTINUE                                                    00001380
            IF (IMAX .EQ. 1) GO TO 50                                   00001390
               JMAX = IZAMAX(IMAX-1,AP(IM+1),1)                         00001400
               JMIM = JMAX + IM                                         00001410
               ROWMAX = DMAX1(ROWMAX,CABS1(AP(JMIM)))                   00001420
   50       CONTINUE                                                    00001430
            IMIM = IMAX + IM                                            00001440
            IF (CABS1(AP(IMIM)) .LT. ALPHA*ROWMAX) GO TO 60             00001450
               KSTEP = 1                                                00001460
               SWAP = .TRUE.                                            00001470
            GO TO 80                                                    00001480
   60       CONTINUE                                                    00001490
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001500
               KSTEP = 1                                                00001510
               SWAP = .FALSE.                                           00001520
            GO TO 80                                                    00001530
   70       CONTINUE                                                    00001540
               KSTEP = 2                                                00001550
               SWAP = IMAX .NE. KM1                                     00001560
   80       CONTINUE                                                    00001570
   90    CONTINUE                                                       00001580
         IF (DMAX1(ABSAKK,COLMAX) .NE. 0.0D0) GO TO 100                 00001590
C                                                                       00001600
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001610
C                                                                       00001620
            KPVT(K) = K                                                 00001630
            INFO = K                                                    00001640
         GO TO 190                                                      00001650
  100    CONTINUE                                                       00001660
         IF (KSTEP .EQ. 2) GO TO 140                                    00001670
C                                                                       00001680
C           1 X 1 PIVOT BLOCK.                                          00001690
C                                                                       00001700
            IF (.NOT.SWAP) GO TO 120                                    00001710
C                                                                       00001720
C              PERFORM AN INTERCHANGE.                                  00001730
C                                                                       00001740
               CALL ZSWAP(IMAX,AP(IM+1),1,AP(IK+1),1)                   00001750
               IMJ = IK + IMAX                                          00001760
               DO 110 JJ = IMAX, K                                      00001770
                  J = K + IMAX - JJ                                     00001780
                  JK = IK + J                                           00001790
                  T = DCONJG(AP(JK))                                    00001800
                  AP(JK) = DCONJG(AP(IMJ))                              00001810
                  AP(IMJ) = T                                           00001820
                  IMJ = IMJ - (J - 1)                                   00001830
  110          CONTINUE                                                 00001840
  120       CONTINUE                                                    00001850
C                                                                       00001860
C           PERFORM THE ELIMINATION.                                    00001870
C                                                                       00001880
            IJ = IK - (K - 1)                                           00001890
            DO 130 JJ = 1, KM1                                          00001900
               J = K - JJ                                               00001910
               JK = IK + J                                              00001920
               MULK = -AP(JK)/AP(KK)                                    00001930
               T = DCONJG(MULK)                                         00001940
               CALL ZAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                    00001950
               IJJ = IJ + J                                             00001960
               AP(IJJ) = DCMPLX(DREAL(AP(IJJ)),0.0D0)                   00001970
               AP(JK) = MULK                                            00001980
               IJ = IJ - (J - 1)                                        00001990
  130       CONTINUE                                                    00002000
C                                                                       00002010
C           SET THE PIVOT ARRAY.                                        00002020
C                                                                       00002030
            KPVT(K) = K                                                 00002040
            IF (SWAP) KPVT(K) = IMAX                                    00002050
         GO TO 190                                                      00002060
  140    CONTINUE                                                       00002070
C                                                                       00002080
C           2 X 2 PIVOT BLOCK.                                          00002090
C                                                                       00002100
            KM1K = IK + K - 1                                           00002110
            IKM1 = IK - (K - 1)                                         00002120
            IF (.NOT.SWAP) GO TO 160                                    00002130
C                                                                       00002140
C              PERFORM AN INTERCHANGE.                                  00002150
C                                                                       00002160
               CALL ZSWAP(IMAX,AP(IM+1),1,AP(IKM1+1),1)                 00002170
               IMJ = IKM1 + IMAX                                        00002180
               DO 150 JJ = IMAX, KM1                                    00002190
                  J = KM1 + IMAX - JJ                                   00002200
                  JKM1 = IKM1 + J                                       00002210
                  T = DCONJG(AP(JKM1))                                  00002220
                  AP(JKM1) = DCONJG(AP(IMJ))                            00002230
                  AP(IMJ) = T                                           00002240
                  IMJ = IMJ - (J - 1)                                   00002250
  150          CONTINUE                                                 00002260
               T = AP(KM1K)                                             00002270
               AP(KM1K) = AP(IMK)                                       00002280
               AP(IMK) = T                                              00002290
  160       CONTINUE                                                    00002300
C                                                                       00002310
C           PERFORM THE ELIMINATION.                                    00002320
C                                                                       00002330
            KM2 = K - 2                                                 00002340
            IF (KM2 .EQ. 0) GO TO 180                                   00002350
               AK = AP(KK)/AP(KM1K)                                     00002360
               KM1KM1 = IKM1 + K - 1                                    00002370
               AKM1 = AP(KM1KM1)/DCONJG(AP(KM1K))                       00002380
               DENOM = 1.0D0 - AK*AKM1                                  00002390
               IJ = IK - (K - 1) - (K - 2)                              00002400
               DO 170 JJ = 1, KM2                                       00002410
                  J = KM1 - JJ                                          00002420
                  JK = IK + J                                           00002430
                  BK = AP(JK)/AP(KM1K)                                  00002440
                  JKM1 = IKM1 + J                                       00002450
                  BKM1 = AP(JKM1)/DCONJG(AP(KM1K))                      00002460
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002470
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002480
                  T = DCONJG(MULK)                                      00002490
                  CALL ZAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                 00002500
                  T = DCONJG(MULKM1)                                    00002510
                  CALL ZAXPY(J,T,AP(IKM1+1),1,AP(IJ+1),1)               00002520
                  AP(JK) = MULK                                         00002530
                  AP(JKM1) = MULKM1                                     00002540
                  IJJ = IJ + J                                          00002550
                  AP(IJJ) = DCMPLX(DREAL(AP(IJJ)),0.0D0)                00002560
                  IJ = IJ - (J - 1)                                     00002570
  170          CONTINUE                                                 00002580
  180       CONTINUE                                                    00002590
C                                                                       00002600
C           SET THE PIVOT ARRAY.                                        00002610
C                                                                       00002620
            KPVT(K) = 1 - K                                             00002630
            IF (SWAP) KPVT(K) = -IMAX                                   00002640
            KPVT(K-1) = KPVT(K)                                         00002650
  190    CONTINUE                                                       00002660
         IK = IK - (K - 1)                                              00002670
         IF (KSTEP .EQ. 2) IK = IK - (K - 2)                            00002680
         K = K - KSTEP                                                  00002690
      GO TO 10                                                          00002700
  200 CONTINUE                                                          00002710
      RETURN                                                            00002720
      END                                                               00002730
