*#**********************************************************************

      SUBROUTINE ZPBDI(ABD,LDA,N,M,DET)                                 00000010

      INTEGER LDA,N,M                                                   00000020
      COMPLEX*16 ABD(LDA,1)                                             00000030
      DOUBLE PRECISION DET(2)                                           00000040
C                                                                       00000050
C     ZPBDI COMPUTES THE DETERMINANT                                    00000060
C     OF A COMPLEX*16 HERMITIAN POSITIVE DEFINITE BAND MATRIX           00000070
C     USING THE FACTORS COMPUTED BY ZPBCO OR ZPBFA.                     00000080
C     IF THE INVERSE IS NEEDED, USE ZPBSL  N  TIMES.                    00000090
C                                                                       00000100
C     ON ENTRY                                                          00000110
C                                                                       00000120
C        ABD     COMPLEX*16(LDA, N)                                     00000130
C                THE OUTPUT FROM ZPBCO OR ZPBFA.                        00000140
C                                                                       00000150
C        LDA     INTEGER                                                00000160
C                THE LEADING DIMENSION OF THE ARRAY  ABD .              00000170
C                                                                       00000180
C        N       INTEGER                                                00000190
C                THE ORDER OF THE MATRIX  A .                           00000200
C                                                                       00000210
C        M       INTEGER                                                00000220
C                THE NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.       00000230
C                                                                       00000240
C     ON RETURN                                                         00000250
C                                                                       00000260
C        DET     DOUBLE PRECISION(2)                                    00000270
C                DETERMINANT OF ORIGINAL MATRIX IN THE FORM             00000280
C                DETERMINANT = DET(1) * 10.0**DET(2)                    00000290
C                WITH  1.0 .LE. DET(1) .LT. 10.0                        00000300
C                OR  DET(1) .EQ. 0.0 .                                  00000310
C                                                                       00000320
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000330
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000340
C                                                                       00000350
C     SUBROUTINES AND FUNCTIONS                                         00000360
C                                                                       00000370
C                                                                       00000380
C     INTERNAL VARIABLES                                                00000390
C                                                                       00000400
      DOUBLE PRECISION S                                                00000410
      INTEGER I                                                         00000420
      DOUBLE PRECISION DREAL                                            00000430
      COMPLEX*16 ZDUMR                                                  00000440
      DREAL(ZDUMR) = ZDUMR                                              00000450
C                                                                       00000460
C     COMPUTE DETERMINANT                                               00000470
C                                                                       00000480
      DET(1) = 1.0D0                                                    00000490
      DET(2) = 0.0D0                                                    00000500
      S = 10.0D0                                                        00000510
      DO 50 I = 1, N                                                    00000520
         DET(1) = DREAL(ABD(M+1,I))**2*DET(1)                           00000530
C     ...EXIT                                                           00000540
         IF (DET(1) .EQ. 0.0D0) GO TO 60                                00000550
   10    IF (DET(1) .GE. 1.0D0) GO TO 20                                00000560
            DET(1) = S*DET(1)                                           00000570
            DET(2) = DET(2) - 1.0D0                                     00000580
         GO TO 10                                                       00000590
   20    CONTINUE                                                       00000600
   30    IF (DET(1) .LT. S) GO TO 40                                    00000610
            DET(1) = DET(1)/S                                           00000620
            DET(2) = DET(2) + 1.0D0                                     00000630
         GO TO 30                                                       00000640
   40    CONTINUE                                                       00000650
   50 CONTINUE                                                          00000660
   60 CONTINUE                                                          00000670
      RETURN                                                            00000680
      END                                                               00000690
