*#**********************************************************************

      SUBROUTINE ZPOCO(A,LDA,N,RCOND,Z,INFO)                            00000010

      INTEGER LDA,N,INFO                                                00000020
      COMPLEX*16 A(LDA,1),Z(1)                                          00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZPOCO FACTORS A COMPLEX*16 HERMITIAN POSITIVE DEFINITE MATRIX     00000060
C     AND ESTIMATES THE CONDITION OF THE MATRIX.                        00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, ZPOFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW ZPOCO BY ZPOSL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZPOCO BY ZPOSL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZPOCO BY ZPODI.               00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW ZPOCO BY ZPODI.                   00000130
C                                                                       00000140
C     ON ENTRY                                                          00000150
C                                                                       00000160
C        A       COMPLEX*16(LDA, N)                                     00000170
C                THE HERMITIAN MATRIX TO BE FACTORED.  ONLY THE         00000180
C                DIAGONAL AND UPPER TRIANGLE ARE USED.                  00000190
C                                                                       00000200
C        LDA     INTEGER                                                00000210
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        A       AN UPPER TRIANGULAR MATRIX  R  SO THAT  A =            00000290
C                CTRANS(R)*R WHERE  CTRANS(R)  IS THE CONJUGATE         00000300
C                TRANSPOSE.  THE STRICT LOWER TRIANGLE IS UNALTERED.    00000310
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000320
C                                                                       00000330
C        RCOND   DOUBLE PRECISION                                       00000340
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000350
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000360
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000370
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000380
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000390
C                           1.0 + RCOND .EQ. 1.0                        00000400
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000410
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000420
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000430
C                UNDERFLOWS.  IF INFO .NE. 0 , RCOND IS UNCHANGED.      00000440
C                                                                       00000450
C        Z       COMPLEX*16(N)                                          00000460
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000470
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000480
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000490
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000500
C                IF  INFO .NE. 0 , Z  IS UNCHANGED.                     00000510
C                                                                       00000520
C        INFO    INTEGER                                                00000530
C                = 0  FOR NORMAL RETURN.                                00000540
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000550
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000560
C                                                                       00000570
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000580
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000590
C                                                                       00000600
C     SUBROUTINES AND FUNCTIONS                                         00000610
C                                                                       00000620
C     LINPACK ZPOFA                                                     00000630
C     BLAS ZAXPY,ZDOTC,ZDSCAL,DZASUM                                    00000640
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG                                  00000650
C                                                                       00000660
C     INTERNAL VARIABLES                                                00000670
C                                                                       00000680
      COMPLEX*16 ZDOTC,EK,T,WK,WKM                                      00000690
      DOUBLE PRECISION ANORM,S,DZASUM,SM,YNORM                          00000700
      INTEGER I,J,JM1,K,KB,KP1                                          00000710
C                                                                       00000720
      COMPLEX*16 ZDUM,ZDUM2,CSIGN1                                      00000730
      DOUBLE PRECISION CABS1                                            00000740
      DOUBLE PRECISION DREAL,DIMAG                                      00000750
      COMPLEX*16 ZDUMR,ZDUMI                                            00000760
      DREAL(ZDUMR) = ZDUMR                                              00000770
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000780
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000790
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000800
C                                                                       00000810
C     FIND NORM OF A USING ONLY UPPER HALF                              00000820
C                                                                       00000830
      DO 30 J = 1, N                                                    00000840
         Z(J) = DCMPLX(DZASUM(J,A(1,J),1),0.0D0)                        00000850
         JM1 = J - 1                                                    00000860
         IF (JM1 .LT. 1) GO TO 20                                       00000870
         DO 10 I = 1, JM1                                               00000880
            Z(I) = DCMPLX(DREAL(Z(I))+CABS1(A(I,J)),0.0D0)              00000890
   10    CONTINUE                                                       00000900
   20    CONTINUE                                                       00000910
   30 CONTINUE                                                          00000920
      ANORM = 0.0D0                                                     00000930
      DO 40 J = 1, N                                                    00000940
         ANORM = DMAX1(ANORM,DREAL(Z(J)))                               00000950
   40 CONTINUE                                                          00000960
C                                                                       00000970
C     FACTOR                                                            00000980
C                                                                       00000990
      CALL ZPOFA(A,LDA,N,INFO)                                          00001000
      IF (INFO .NE. 0) GO TO 180                                        00001010
C                                                                       00001020
C        RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .           00001030
C        ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .      00001040
C        THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL        00001050
C        GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(R)*W = E .          00001060
C        THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.         00001070
C                                                                       00001080
C        SOLVE CTRANS(R)*W = E                                          00001090
C                                                                       00001100
         EK = (1.0D0,0.0D0)                                             00001110
         DO 50 J = 1, N                                                 00001120
            Z(J) = (0.0D0,0.0D0)                                        00001130
   50    CONTINUE                                                       00001140
         DO 110 K = 1, N                                                00001150
            IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,-Z(K))           00001160
            IF (CABS1(EK-Z(K)) .LE. DREAL(A(K,K))) GO TO 60             00001170
               S = DREAL(A(K,K))/CABS1(EK-Z(K))                         00001180
               CALL ZDSCAL(N,S,Z,1)                                     00001190
               EK = DCMPLX(S,0.0D0)*EK                                  00001200
   60       CONTINUE                                                    00001210
            WK = EK - Z(K)                                              00001220
            WKM = -EK - Z(K)                                            00001230
            S = CABS1(WK)                                               00001240
            SM = CABS1(WKM)                                             00001250
            WK = WK/A(K,K)                                              00001260
            WKM = WKM/A(K,K)                                            00001270
            KP1 = K + 1                                                 00001280
            IF (KP1 .GT. N) GO TO 100                                   00001290
               DO 70 J = KP1, N                                         00001300
                  SM = SM + CABS1(Z(J)+WKM*DCONJG(A(K,J)))              00001310
                  Z(J) = Z(J) + WK*DCONJG(A(K,J))                       00001320
                  S = S + CABS1(Z(J))                                   00001330
   70          CONTINUE                                                 00001340
               IF (S .GE. SM) GO TO 90                                  00001350
                  T = WKM - WK                                          00001360
                  WK = WKM                                              00001370
                  DO 80 J = KP1, N                                      00001380
                     Z(J) = Z(J) + T*DCONJG(A(K,J))                     00001390
   80             CONTINUE                                              00001400
   90          CONTINUE                                                 00001410
  100       CONTINUE                                                    00001420
            Z(K) = WK                                                   00001430
  110    CONTINUE                                                       00001440
         S = 1.0D0/DZASUM(N,Z,1)                                        00001450
         CALL ZDSCAL(N,S,Z,1)                                           00001460
C                                                                       00001470
C        SOLVE R*Y = W                                                  00001480
C                                                                       00001490
         DO 130 KB = 1, N                                               00001500
            K = N + 1 - KB                                              00001510
            IF (CABS1(Z(K)) .LE. DREAL(A(K,K))) GO TO 120               00001520
               S = DREAL(A(K,K))/CABS1(Z(K))                            00001530
               CALL ZDSCAL(N,S,Z,1)                                     00001540
  120       CONTINUE                                                    00001550
            Z(K) = Z(K)/A(K,K)                                          00001560
            T = -Z(K)                                                   00001570
            CALL ZAXPY(K-1,T,A(1,K),1,Z(1),1)                           00001580
  130    CONTINUE                                                       00001590
         S = 1.0D0/DZASUM(N,Z,1)                                        00001600
         CALL ZDSCAL(N,S,Z,1)                                           00001610
C                                                                       00001620
         YNORM = 1.0D0                                                  00001630
C                                                                       00001640
C        SOLVE CTRANS(R)*V = Y                                          00001650
C                                                                       00001660
         DO 150 K = 1, N                                                00001670
            Z(K) = Z(K) - ZDOTC(K-1,A(1,K),1,Z(1),1)                    00001680
            IF (CABS1(Z(K)) .LE. DREAL(A(K,K))) GO TO 140               00001690
               S = DREAL(A(K,K))/CABS1(Z(K))                            00001700
               CALL ZDSCAL(N,S,Z,1)                                     00001710
               YNORM = S*YNORM                                          00001720
  140       CONTINUE                                                    00001730
            Z(K) = Z(K)/A(K,K)                                          00001740
  150    CONTINUE                                                       00001750
         S = 1.0D0/DZASUM(N,Z,1)                                        00001760
         CALL ZDSCAL(N,S,Z,1)                                           00001770
         YNORM = S*YNORM                                                00001780
C                                                                       00001790
C        SOLVE R*Z = V                                                  00001800
C                                                                       00001810
         DO 170 KB = 1, N                                               00001820
            K = N + 1 - KB                                              00001830
            IF (CABS1(Z(K)) .LE. DREAL(A(K,K))) GO TO 160               00001840
               S = DREAL(A(K,K))/CABS1(Z(K))                            00001850
               CALL ZDSCAL(N,S,Z,1)                                     00001860
               YNORM = S*YNORM                                          00001870
  160       CONTINUE                                                    00001880
            Z(K) = Z(K)/A(K,K)                                          00001890
            T = -Z(K)                                                   00001900
            CALL ZAXPY(K-1,T,A(1,K),1,Z(1),1)                           00001910
  170    CONTINUE                                                       00001920
C        MAKE ZNORM = 1.0                                               00001930
         S = 1.0D0/DZASUM(N,Z,1)                                        00001940
         CALL ZDSCAL(N,S,Z,1)                                           00001950
         YNORM = S*YNORM                                                00001960
C                                                                       00001970
         IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                      00001980
         IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                            00001990
  180 CONTINUE                                                          00002000
      RETURN                                                            00002010
      END                                                               00002020
