*#**********************************************************************

      SUBROUTINE ZPOFA(A,LDA,N,INFO)                                    00000010

      INTEGER LDA,N,INFO                                                00000020
      COMPLEX*16 A(LDA,1)                                               00000030
C                                                                       00000040
C     ZPOFA FACTORS A COMPLEX*16 HERMITIAN POSITIVE DEFINITE MATRIX.    00000050
C                                                                       00000060
C     ZPOFA IS USUALLY CALLED BY ZPOCO, BUT IT CAN BE CALLED            00000070
C     DIRECTLY WITH A SAVING IN TIME IF  RCOND  IS NOT NEEDED.          00000080
C     (TIME FOR ZPOCO) = (1 + 18/N)*(TIME FOR ZPOFA) .                  00000090
C                                                                       00000100
C     ON ENTRY                                                          00000110
C                                                                       00000120
C        A       COMPLEX*16(LDA, N)                                     00000130
C                THE HERMITIAN MATRIX TO BE FACTORED.  ONLY THE         00000140
C                DIAGONAL AND UPPER TRIANGLE ARE USED.                  00000150
C                                                                       00000160
C        LDA     INTEGER                                                00000170
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000180
C                                                                       00000190
C        N       INTEGER                                                00000200
C                THE ORDER OF THE MATRIX  A .                           00000210
C                                                                       00000220
C     ON RETURN                                                         00000230
C                                                                       00000240
C        A       AN UPPER TRIANGULAR MATRIX  R  SO THAT  A =            00000250
C                CTRANS(R)*R WHERE  CTRANS(R)  IS THE CONJUGATE         00000260
C                TRANSPOSE.  THE STRICT LOWER TRIANGLE IS UNALTERED.    00000270
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000280
C                                                                       00000290
C        INFO    INTEGER                                                00000300
C                = 0  FOR NORMAL RETURN.                                00000310
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000320
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000330
C                                                                       00000340
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000350
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000360
C                                                                       00000370
C     SUBROUTINES AND FUNCTIONS                                         00000380
C                                                                       00000390
C     BLAS ZDOTC                                                        00000400
C     FORTRAN DCMPLX,DCONJG,DSQRT                                       00000410
C                                                                       00000420
C     INTERNAL VARIABLES                                                00000430
C                                                                       00000440
      COMPLEX*16 ZDOTC,T                                                00000450
      DOUBLE PRECISION S                                                00000460
      INTEGER J,JM1,K                                                   00000470
      DOUBLE PRECISION DREAL,DIMAG                                      00000480
      COMPLEX*16 ZDUMR,ZDUMI                                            00000490
      DREAL(ZDUMR) = ZDUMR                                              00000500
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000510
C     BEGIN BLOCK WITH ...EXITS TO 40                                   00000520
C                                                                       00000530
C                                                                       00000540
         DO 30 J = 1, N                                                 00000550
            INFO = J                                                    00000560
            S = 0.0D0                                                   00000570
            JM1 = J - 1                                                 00000580
            IF (JM1 .LT. 1) GO TO 20                                    00000590
            DO 10 K = 1, JM1                                            00000600
               T = A(K,J) - ZDOTC(K-1,A(1,K),1,A(1,J),1)                00000610
               T = T/A(K,K)                                             00000620
               A(K,J) = T                                               00000630
               S = S + DREAL(T*DCONJG(T))                               00000640
   10       CONTINUE                                                    00000650
   20       CONTINUE                                                    00000660
            S = DREAL(A(J,J)) - S                                       00000670
C     ......EXIT                                                        00000680
            IF (S .LE. 0.0D0 .OR. DIMAG(A(J,J)) .NE. 0.0D0) GO TO 40    00000690
            A(J,J) = DCMPLX(DSQRT(S),0.0D0)                             00000700
   30    CONTINUE                                                       00000710
         INFO = 0                                                       00000720
   40 CONTINUE                                                          00000730
      RETURN                                                            00000740
      END                                                               00000750
