*#**********************************************************************

      SUBROUTINE ZSIFA(A,LDA,N,KPVT,INFO)                               00000010

      INTEGER LDA,N,KPVT(1),INFO                                        00000020
      COMPLEX*16 A(LDA,1)                                               00000030
C                                                                       00000040
C     ZSIFA FACTORS A COMPLEX*16 SYMMETRIC MATRIX BY ELIMINATION        00000050
C     WITH SYMMETRIC PIVOTING.                                          00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW ZSIFA BY ZSISL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZSIFA BY ZSISL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZSIFA BY ZSIDI.               00000100
C     TO COMPUTE  INVERSE(A) , FOLLOW ZSIFA BY ZSIDI.                   00000110
C                                                                       00000120
C     ON ENTRY                                                          00000130
C                                                                       00000140
C        A       COMPLEX*16(LDA,N)                                      00000150
C                THE SYMMETRIC MATRIX TO BE FACTORED.                   00000160
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000170
C                                                                       00000180
C        LDA     INTEGER                                                00000190
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000200
C                                                                       00000210
C        N       INTEGER                                                00000220
C                THE ORDER OF THE MATRIX  A .                           00000230
C                                                                       00000240
C     ON RETURN                                                         00000250
C                                                                       00000260
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000270
C                WERE USED TO OBTAIN IT.                                00000280
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000290
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000300
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000310
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000320
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000330
C                                                                       00000340
C        KPVT    INTEGER(N)                                             00000350
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000360
C                                                                       00000370
C        INFO    INTEGER                                                00000380
C                = 0  NORMAL VALUE.                                     00000390
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000400
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000410
C                     BUT IT DOES INDICATE THAT ZSISL OR ZSIDI MAY      00000420
C                     DIVIDE BY ZERO IF CALLED.                         00000430
C                                                                       00000440
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000450
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000460
C                                                                       00000470
C     SUBROUTINES AND FUNCTIONS                                         00000480
C                                                                       00000490
C     BLAS ZAXPY,ZSWAP,IZAMAX                                           00000500
C     FORTRAN DABS,DMAX1,DSQRT                                          00000510
C                                                                       00000520
C     INTERNAL VARIABLES                                                00000530
C                                                                       00000540
      COMPLEX*16 AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T                    00000550
      DOUBLE PRECISION ABSAKK,ALPHA,COLMAX,ROWMAX                       00000560
      INTEGER IMAX,IMAXP1,J,JJ,JMAX,K,KM1,KM2,KSTEP,IZAMAX              00000570
      LOGICAL SWAP                                                      00000580
C                                                                       00000590
      COMPLEX*16 ZDUM                                                   00000600
      DOUBLE PRECISION CABS1                                            00000610
      DOUBLE PRECISION DREAL,DIMAG                                      00000620
      COMPLEX*16 ZDUMR,ZDUMI                                            00000630
      DREAL(ZDUMR) = ZDUMR                                              00000640
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000650
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000660
C                                                                       00000670
C     INITIALIZE                                                        00000680
C                                                                       00000690
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000700
      ALPHA = (1.0D0 + DSQRT(17.0D0))/8.0D0                             00000710
C                                                                       00000720
      INFO = 0                                                          00000730
C                                                                       00000740
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000750
C                                                                       00000760
      K = N                                                             00000770
   10 CONTINUE                                                          00000780
C                                                                       00000790
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000800
C                                                                       00000810
C     ...EXIT                                                           00000820
         IF (K .EQ. 0) GO TO 200                                        00000830
         IF (K .GT. 1) GO TO 20                                         00000840
            KPVT(1) = 1                                                 00000850
            IF (CABS1(A(1,1)) .EQ. 0.0D0) INFO = 1                      00000860
C     ......EXIT                                                        00000870
            GO TO 200                                                   00000880
   20    CONTINUE                                                       00000890
C                                                                       00000900
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00000910
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00000920
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00000930
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00000940
C        REQUIRED.                                                      00000950
C                                                                       00000960
         KM1 = K - 1                                                    00000970
         ABSAKK = CABS1(A(K,K))                                         00000980
C                                                                       00000990
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00001000
C        COLUMN K.                                                      00001010
C                                                                       00001020
         IMAX = IZAMAX(K-1,A(1,K),1)                                    00001030
         COLMAX = CABS1(A(IMAX,K))                                      00001040
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00001050
            KSTEP = 1                                                   00001060
            SWAP = .FALSE.                                              00001070
         GO TO 90                                                       00001080
   30    CONTINUE                                                       00001090
C                                                                       00001100
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001110
C           ROW IMAX.                                                   00001120
C                                                                       00001130
            ROWMAX = 0.0D0                                              00001140
            IMAXP1 = IMAX + 1                                           00001150
            DO 40 J = IMAXP1, K                                         00001160
               ROWMAX = DMAX1(ROWMAX,CABS1(A(IMAX,J)))                  00001170
   40       CONTINUE                                                    00001180
            IF (IMAX .EQ. 1) GO TO 50                                   00001190
               JMAX = IZAMAX(IMAX-1,A(1,IMAX),1)                        00001200
               ROWMAX = DMAX1(ROWMAX,CABS1(A(JMAX,IMAX)))               00001210
   50       CONTINUE                                                    00001220
            IF (CABS1(A(IMAX,IMAX)) .LT. ALPHA*ROWMAX) GO TO 60         00001230
               KSTEP = 1                                                00001240
               SWAP = .TRUE.                                            00001250
            GO TO 80                                                    00001260
   60       CONTINUE                                                    00001270
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001280
               KSTEP = 1                                                00001290
               SWAP = .FALSE.                                           00001300
            GO TO 80                                                    00001310
   70       CONTINUE                                                    00001320
               KSTEP = 2                                                00001330
               SWAP = IMAX .NE. KM1                                     00001340
   80       CONTINUE                                                    00001350
   90    CONTINUE                                                       00001360
         IF (DMAX1(ABSAKK,COLMAX) .NE. 0.0D0) GO TO 100                 00001370
C                                                                       00001380
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001390
C                                                                       00001400
            KPVT(K) = K                                                 00001410
            INFO = K                                                    00001420
         GO TO 190                                                      00001430
  100    CONTINUE                                                       00001440
         IF (KSTEP .EQ. 2) GO TO 140                                    00001450
C                                                                       00001460
C           1 X 1 PIVOT BLOCK.                                          00001470
C                                                                       00001480
            IF (.NOT.SWAP) GO TO 120                                    00001490
C                                                                       00001500
C              PERFORM AN INTERCHANGE.                                  00001510
C                                                                       00001520
               CALL ZSWAP(IMAX,A(1,IMAX),1,A(1,K),1)                    00001530
               DO 110 JJ = IMAX, K                                      00001540
                  J = K + IMAX - JJ                                     00001550
                  T = A(J,K)                                            00001560
                  A(J,K) = A(IMAX,J)                                    00001570
                  A(IMAX,J) = T                                         00001580
  110          CONTINUE                                                 00001590
  120       CONTINUE                                                    00001600
C                                                                       00001610
C           PERFORM THE ELIMINATION.                                    00001620
C                                                                       00001630
            DO 130 JJ = 1, KM1                                          00001640
               J = K - JJ                                               00001650
               MULK = -A(J,K)/A(K,K)                                    00001660
               T = MULK                                                 00001670
               CALL ZAXPY(J,T,A(1,K),1,A(1,J),1)                        00001680
               A(J,K) = MULK                                            00001690
  130       CONTINUE                                                    00001700
C                                                                       00001710
C           SET THE PIVOT ARRAY.                                        00001720
C                                                                       00001730
            KPVT(K) = K                                                 00001740
            IF (SWAP) KPVT(K) = IMAX                                    00001750
         GO TO 190                                                      00001760
  140    CONTINUE                                                       00001770
C                                                                       00001780
C           2 X 2 PIVOT BLOCK.                                          00001790
C                                                                       00001800
            IF (.NOT.SWAP) GO TO 160                                    00001810
C                                                                       00001820
C              PERFORM AN INTERCHANGE.                                  00001830
C                                                                       00001840
               CALL ZSWAP(IMAX,A(1,IMAX),1,A(1,K-1),1)                  00001850
               DO 150 JJ = IMAX, KM1                                    00001860
                  J = KM1 + IMAX - JJ                                   00001870
                  T = A(J,K-1)                                          00001880
                  A(J,K-1) = A(IMAX,J)                                  00001890
                  A(IMAX,J) = T                                         00001900
  150          CONTINUE                                                 00001910
               T = A(K-1,K)                                             00001920
               A(K-1,K) = A(IMAX,K)                                     00001930
               A(IMAX,K) = T                                            00001940
  160       CONTINUE                                                    00001950
C                                                                       00001960
C           PERFORM THE ELIMINATION.                                    00001970
C                                                                       00001980
            KM2 = K - 2                                                 00001990
            IF (KM2 .EQ. 0) GO TO 180                                   00002000
               AK = A(K,K)/A(K-1,K)                                     00002010
               AKM1 = A(K-1,K-1)/A(K-1,K)                               00002020
               DENOM = 1.0D0 - AK*AKM1                                  00002030
               DO 170 JJ = 1, KM2                                       00002040
                  J = KM1 - JJ                                          00002050
                  BK = A(J,K)/A(K-1,K)                                  00002060
                  BKM1 = A(J,K-1)/A(K-1,K)                              00002070
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002080
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002090
                  T = MULK                                              00002100
                  CALL ZAXPY(J,T,A(1,K),1,A(1,J),1)                     00002110
                  T = MULKM1                                            00002120
                  CALL ZAXPY(J,T,A(1,K-1),1,A(1,J),1)                   00002130
                  A(J,K) = MULK                                         00002140
                  A(J,K-1) = MULKM1                                     00002150
  170          CONTINUE                                                 00002160
  180       CONTINUE                                                    00002170
C                                                                       00002180
C           SET THE PIVOT ARRAY.                                        00002190
C                                                                       00002200
            KPVT(K) = 1 - K                                             00002210
            IF (SWAP) KPVT(K) = -IMAX                                   00002220
            KPVT(K-1) = KPVT(K)                                         00002230
  190    CONTINUE                                                       00002240
         K = K - KSTEP                                                  00002250
      GO TO 10                                                          00002260
  200 CONTINUE                                                          00002270
      RETURN                                                            00002280
      END                                                               00002290
