*#**********************************************************************

      SUBROUTINE ZSISL(A,LDA,N,KPVT,B)                                  00000010

      INTEGER LDA,N,KPVT(1)                                             00000020
      COMPLEX*16 A(LDA,1),B(1)                                          00000030
C                                                                       00000040
C     ZSISL SOLVES THE COMPLEX*16 SYMMETRIC SYSTEM                      00000050
C     A * X = B                                                         00000060
C     USING THE FACTORS COMPUTED BY ZSIFA.                              00000070
C                                                                       00000080
C     ON ENTRY                                                          00000090
C                                                                       00000100
C        A       COMPLEX*16(LDA,N)                                      00000110
C                THE OUTPUT FROM ZSIFA.                                 00000120
C                                                                       00000130
C        LDA     INTEGER                                                00000140
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000150
C                                                                       00000160
C        N       INTEGER                                                00000170
C                THE ORDER OF THE MATRIX  A .                           00000180
C                                                                       00000190
C        KPVT    INTEGER(N)                                             00000200
C                THE PIVOT VECTOR FROM ZSIFA.                           00000210
C                                                                       00000220
C        B       COMPLEX*16(N)                                          00000230
C                THE RIGHT HAND SIDE VECTOR.                            00000240
C                                                                       00000250
C     ON RETURN                                                         00000260
C                                                                       00000270
C        B       THE SOLUTION VECTOR  X .                               00000280
C                                                                       00000290
C     ERROR CONDITION                                                   00000300
C                                                                       00000310
C        A DIVISION BY ZERO MAY OCCUR IF  ZSICO  HAS SET RCOND .EQ. 0.0 00000320
C        OR  ZSIFA  HAS SET INFO .NE. 0  .                              00000330
C                                                                       00000340
C     TO COMPUTE  INVERSE(A) * C  WHERE  C  IS A MATRIX                 00000350
C     WITH  P  COLUMNS                                                  00000360
C           CALL ZSIFA(A,LDA,N,KPVT,INFO)                               00000370
C           IF (INFO .NE. 0) GO TO ...                                  00000380
C           DO 10 J = 1, P                                              00000390
C              CALL ZSISL(A,LDA,N,KPVT,C(1,J))                          00000400
C        10 CONTINUE                                                    00000410
C                                                                       00000420
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000430
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000440
C                                                                       00000450
C     SUBROUTINES AND FUNCTIONS                                         00000460
C                                                                       00000470
C     BLAS ZAXPY,ZDOTU                                                  00000480
C     FORTRAN IABS                                                      00000490
C                                                                       00000500
C     INTERNAL VARIABLES.                                               00000510
C                                                                       00000520
      COMPLEX*16 AK,AKM1,BK,BKM1,ZDOTU,DENOM,TEMP                       00000530
      INTEGER K,KP                                                      00000540
C                                                                       00000550
C     LOOP BACKWARD APPLYING THE TRANSFORMATIONS AND                    00000560
C     D INVERSE TO B.                                                   00000570
C                                                                       00000580
      K = N                                                             00000590
   10 IF (K .EQ. 0) GO TO 80                                            00000600
         IF (KPVT(K) .LT. 0) GO TO 40                                   00000610
C                                                                       00000620
C           1 X 1 PIVOT BLOCK.                                          00000630
C                                                                       00000640
            IF (K .EQ. 1) GO TO 30                                      00000650
               KP = KPVT(K)                                             00000660
               IF (KP .EQ. K) GO TO 20                                  00000670
C                                                                       00000680
C                 INTERCHANGE.                                          00000690
C                                                                       00000700
                  TEMP = B(K)                                           00000710
                  B(K) = B(KP)                                          00000720
                  B(KP) = TEMP                                          00000730
   20          CONTINUE                                                 00000740
C                                                                       00000750
C              APPLY THE TRANSFORMATION.                                00000760
C                                                                       00000770
               CALL ZAXPY(K-1,B(K),A(1,K),1,B(1),1)                     00000780
   30       CONTINUE                                                    00000790
C                                                                       00000800
C           APPLY D INVERSE.                                            00000810
C                                                                       00000820
            B(K) = B(K)/A(K,K)                                          00000830
            K = K - 1                                                   00000840
         GO TO 70                                                       00000850
   40    CONTINUE                                                       00000860
C                                                                       00000870
C           2 X 2 PIVOT BLOCK.                                          00000880
C                                                                       00000890
            IF (K .EQ. 2) GO TO 60                                      00000900
               KP = IABS(KPVT(K))                                       00000910
               IF (KP .EQ. K - 1) GO TO 50                              00000920
C                                                                       00000930
C                 INTERCHANGE.                                          00000940
C                                                                       00000950
                  TEMP = B(K-1)                                         00000960
                  B(K-1) = B(KP)                                        00000970
                  B(KP) = TEMP                                          00000980
   50          CONTINUE                                                 00000990
C                                                                       00001000
C              APPLY THE TRANSFORMATION.                                00001010
C                                                                       00001020
               CALL ZAXPY(K-2,B(K),A(1,K),1,B(1),1)                     00001030
               CALL ZAXPY(K-2,B(K-1),A(1,K-1),1,B(1),1)                 00001040
   60       CONTINUE                                                    00001050
C                                                                       00001060
C           APPLY D INVERSE.                                            00001070
C                                                                       00001080
            AK = A(K,K)/A(K-1,K)                                        00001090
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00001100
            BK = B(K)/A(K-1,K)                                          00001110
            BKM1 = B(K-1)/A(K-1,K)                                      00001120
            DENOM = AK*AKM1 - 1.0D0                                     00001130
            B(K) = (AKM1*BK - BKM1)/DENOM                               00001140
            B(K-1) = (AK*BKM1 - BK)/DENOM                               00001150
            K = K - 2                                                   00001160
   70    CONTINUE                                                       00001170
      GO TO 10                                                          00001180
   80 CONTINUE                                                          00001190
C                                                                       00001200
C     LOOP FORWARD APPLYING THE TRANSFORMATIONS.                        00001210
C                                                                       00001220
      K = 1                                                             00001230
   90 IF (K .GT. N) GO TO 160                                           00001240
         IF (KPVT(K) .LT. 0) GO TO 120                                  00001250
C                                                                       00001260
C           1 X 1 PIVOT BLOCK.                                          00001270
C                                                                       00001280
            IF (K .EQ. 1) GO TO 110                                     00001290
C                                                                       00001300
C              APPLY THE TRANSFORMATION.                                00001310
C                                                                       00001320
               B(K) = B(K) + ZDOTU(K-1,A(1,K),1,B(1),1)                 00001330
               KP = KPVT(K)                                             00001340
               IF (KP .EQ. K) GO TO 100                                 00001350
C                                                                       00001360
C                 INTERCHANGE.                                          00001370
C                                                                       00001380
                  TEMP = B(K)                                           00001390
                  B(K) = B(KP)                                          00001400
                  B(KP) = TEMP                                          00001410
  100          CONTINUE                                                 00001420
  110       CONTINUE                                                    00001430
            K = K + 1                                                   00001440
         GO TO 150                                                      00001450
  120    CONTINUE                                                       00001460
C                                                                       00001470
C           2 X 2 PIVOT BLOCK.                                          00001480
C                                                                       00001490
            IF (K .EQ. 1) GO TO 140                                     00001500
C                                                                       00001510
C              APPLY THE TRANSFORMATION.                                00001520
C                                                                       00001530
               B(K) = B(K) + ZDOTU(K-1,A(1,K),1,B(1),1)                 00001540
               B(K+1) = B(K+1) + ZDOTU(K-1,A(1,K+1),1,B(1),1)           00001550
               KP = IABS(KPVT(K))                                       00001560
               IF (KP .EQ. K) GO TO 130                                 00001570
C                                                                       00001580
C                 INTERCHANGE.                                          00001590
C                                                                       00001600
                  TEMP = B(K)                                           00001610
                  B(K) = B(KP)                                          00001620
                  B(KP) = TEMP                                          00001630
  130          CONTINUE                                                 00001640
  140       CONTINUE                                                    00001650
            K = K + 2                                                   00001660
  150    CONTINUE                                                       00001670
      GO TO 90                                                          00001680
  160 CONTINUE                                                          00001690
      RETURN                                                            00001700
      END                                                               00001710
