C*****  AMX004  COMPUTE DIGIT REVERSE           REV 1.0     JAN 88
C
C  PURPOSE:
C       COMPUTES THE DIGIT REVERSE VALUES.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C       MATH ADVANTAGE VERSION  JAN 88          R.D. COLEMAN, QTC
C          CHANGED SUBROUTINE NAMES AND HEADER.
C
C  CALLING FORMAT:
C       CALL AMX004 (INDX, NFAC, M)
C
C  PARAMETERS:
C
C       INDX    INTEGER OUTPUT ARRAY OF LENGTH N
C               DIGIT REVERSE VALUES.
C
C       NFAC    INTEGER INPUT ARRAY OF LENGTH M
C               PRIME FACTORS OF N.
C
C       M       INTEGER INPUT SCALAR
C               NUMBER OF FACTORS IN ARRAY NFAC.
C
C       INDX    INTEGER OUTPUT ARRAY OF LENGTH N
C               DIGIT REVERSE VALUES.
C
C  DESCRIPTION:
C       This routine computes the digit reversed values of the indicies
C       of the array INDX and stores them in the array.  The order and
C       range of each "digit" is given by the prime factors stored in
C       the array NFAC.
C
C       For example, if NF = 2 and the values in NFAC are:
C
C          NFAC(1) = 2, NFAC(2) = 3
C
C       Then we know that INDX will contain six values (the product of
C       2 and 3) and that the non-reversed indicies can be represented
C       by:
C          INDX(1) = 0  -> 0, 0
C          INDX(2) = 1  -> 0, 1
C          INDX(3) = 2  -> 0, 2
C          INDX(4) = 3  -> 1, 0
C          INDX(5) = 4  -> 1, 1
C          INDX(6) = 5  -> 1, 2
C
C       When we digit reverse the factored indices we get:
C
C          INDX(1) = 0  <- 0, 0
C          INDX(2) = 2  <- 1, 0
C          INDX(3) = 4  <- 2, 0
C          INDX(4) = 1  <- 0, 1
C          INDX(5) = 3  <- 1, 1
C          INDX(6) = 5  <- 2, 1
C
C       The actual values stored in the output array are one greater
C       than the values shown here to account for Fortran array indicies
C       starting at 1.  Note also that INDX is a real array only because
C       we have an extra real array hanging around.  The values stored
C       in it are integers.
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       IF N IS NOT FACTORABLE BY 2, 3, 5, OR 7, THEN M IS SET TO 0.
C
C-----------------------------------------------------------------------
C
        SUBROUTINE AMX004 (INDX, NFAC, M)
C
        REAL INDX(1)
        INTEGER NFAC(1),M
        INTEGER DIGIT(50)
        INTEGER MULT(50)
        INTEGER N, I, J, ITMP
C
C-----------------------------------------------------------------------
C
C-----------------------------
C  Clear DIGIT and load MULT
C  with products of NFAC.
C----------------------------
C
        DIGIT(M) = 0
        MULT(1) = 1
        DO 10 I=1, M-1
                MULT(I+1) = MULT(I) * NFAC(I)
                DIGIT(I) = 0
10      CONTINUE
C
C-----------------------------------------
C  N is the product of entries in NFAC.
C  We also know that the first and last
C  values in INDX will be equal to their
C  indicies, they are invariant under
C  digit reversal.
C----------------------------------------
C
        N = NFAC(M) * MULT(M)
        INDX(1) = 1.0
        INDX(N) = FLOAT(N)
C
C--------------------------------------------------------------------
C  Main Loop - Here we use the DIGIT array to represent the factoring
C  of the indicies of INDX.  The last digit is incremented by one
C  on each pass through the main loop and any carry bits are propagated
C  down through the other digits by the loop at label 30.  The
C  digit reversed value is then computed by the loop at label 40 by
C  multiplying the digits by the appropriate multiplicand in MULT and
C  adding.  Finally, the result is incremented to account for Fortran
C  array indexing and floated before storing in INDX.
C--------------------------------------------------------------------
C
        DO 40 I=2,(N-1)
C
                DIGIT(M) = DIGIT(M) + 1
                DO 20 J=M,1,-1
                        IF (DIGIT(J) .EQ. NFAC(J)) THEN
                                DIGIT(J) = 0
                                DIGIT(J-1) = DIGIT(J-1) + 1
                        ENDIF
20              CONTINUE
C
                ITMP = 0
                DO 30 J=1,M
                        ITMP = ITMP + DIGIT(J) * MULT(J)
30              CONTINUE
                INDX(I) = FLOAT( ITMP + 1 )
C
40      CONTINUE
C
        RETURN
        END
C
