C*****  AMX006  INITIALIZE TABLES FOR AMX007    REV 1.0     JAN 88
C
C  PURPOSE:
C       INITIALIZES CONSTANT, TWIDDLE FACTOR, FACTOR, AND
C       PERMUTATION TABLES NEEDED BY AMX007.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C       MATH ADVANTAGE VERSION  JAN 88          R.D. COLEMAN, QTC
C          CHANGED SUBROUTINE NAMES.
C
C  CALLING FORMAT:
C       CALL AMX006 (INC, N, IFLG, NFAC, M, CNST, STABLE, CTABLE,
C      &             SRTAB, CRTAB, ISRC, IDST, NPERM)
C
C  PARAMETERS:
C
C       INC     INTEGER INPUT SCALAR
C               STRIDE OF DATA ARRAY USED BY AMX007,
C               MUST BE POSITIVE.
C
C       N       INTEGER INPUT SCALAR
C               LENGTH OF DATA ARRAY USED BY AMX007,
C               MUST BE EVEN.
C
C       IFLG    INTEGER INPUT SCALAR
C               DIRECTION OF TRANSFORMS, POSITIVE FOR
C               FORWARD, NEGATIVE FOR INVERSE.
C
C       NFAC    INTEGER OUTPUT ARRAY OF LENGTH M
C               PRIME FACTORS OF N/2.
C
C       M       INTEGER OUTPUT SCALAR
C               NUMBER OF FACTORS IN ARRAY NFAC.
C
C       CNST    REAL OUTPUT ARRAY OF LENGTH 11
C               CONSTANTS USED BY AMX007, DEPENDENT
C               ON IFLG.
C
C       STABLE  REAL OUTPUT ARRAY OF LENGTH N/2
C               SINE TWIDDLE FACTORS, DEPENDENT
C               ON IFLG.
C
C       CTABLE  REAL OUTPUT ARRAY OF LENGTH N/2
C               COSINE TWIDDLE FACTORS.
C
C       SRTAB   REAL OUTPUT ARRAY OF LENGTH N/4
C               SINE VALUES FOR RGSCR.
C
C       CRTAB   REAL OUTPUT ARRAY OF LENGTH N/4
C               COSINE VALUES FOR RGSCR.
C
C       ISRC    INTEGER OUTPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       IDST    INTEGER OUTPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       NPERM   INTEGER OUTPUT SCALAR
C               NUMBER OF INDICIES IN ISRC AND IDST,
C               ALWAYS LESS THAN N/2.
C
C  DESCRIPTION:
C       THIS ROUTINE FACTORS N, LOADS THE CONSTANT AND TWIDDLE
C       FACTOR TABLES, AND LOADS THE PERMUTATION ARRAYS.
C       IT MUST BE CALLED ONCE BEFORE ANY NUMBER OF CALLS TO
C       AMX007 THAT USE THE SAME N, INC, AND IFLG.
C
C  SUBPROGRAMS CALLED:
C       AMX001
C
C  ERROR CONDITIONS:
C       IF M .EQ. 0, N IS NOT FACTORABLE BY 2, 3, 5, OR 7.
C
C-----------------------------------------------------------------------
C
        SUBROUTINE AMX006 (INC, N, IFLG, NFAC, M, CNST, STABLE,
     &                     CTABLE, SRTAB, CRTAB, ISRC, IDST, NPERM)
C
C
        REAL CNST(1), STABLE(1), CTABLE(1), SRTAB(1), CRTAB(1)
        INTEGER N,INC,IFLG, NFAC(1), M, ISRC(1), IDST(1), NPERM
C
        REAL ARG, AK, TWOPI
        INTEGER I
C
        DATA TWOPI / 6.283185307179586 /
C
C-----------------------------------------------------------------------
C
C-----------------------------
C  Initialize Tables for CFFTM
C-----------------------------
C
        CALL AMX001 (INC*2, N/2, IFLG, NFAC, M, CNST, STABLE, CTABLE,
     +                  ISRC, IDST, NPERM)
C
        IF (M .EQ. 0) RETURN
C
C------------------------------
C  Initialize Tables for RGSCR
C------------------------------
C
        AK = TWOPI / FLOAT(N)
C
        IF (IFLG .GE. 0) THEN
C
            DO 10 I=1,N/4
                ARG = AK * FLOAT(I)
                SRTAB(I) = SIN( ARG )
                CRTAB(I) = COS( ARG )
10          CONTINUE
C
        ELSE
C
            DO 20 I=1,N/4
                ARG = AK * FLOAT(I)
                SRTAB(I) = SIN( ARG )
                CRTAB(I) = -COS( ARG )
20          CONTINUE
C
        ENDIF
C
        RETURN
        END
C
