C*****  AMX007  NESTED REAL FFT (MIXED-RADIX)   REV 1.0     JAN 88
C
C  PURPOSE:
C       COMPUTES THE FORWARD OR INVERSE IN-PLACE FFT OF A REAL ARRAY
C       OF SUBVECTORS WHOSE LENGTH FACTORABLE BY 2, 3, 5, AND/OR 7.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C       MATH ADVANTAGE VERSION  JAN 88          R.D. COLEMAN, QTC
C          CHANGED SUBROUTINE NAMES.
C       NESTED VERSION OF AMX007  FEB 88        P.G. CROSE, QTC
C
C  CALLING FORMAT:
C       CALL AMX007 (A, INCE, INCV, N, NV, IFLG, NFAC, M, CNST, STABLE,
C                    CTABLE, SRTAB, CRTAB, ISRC, IDST, NPERM, W)
C
C  PARAMETERS:
C
C       A       REAL INPUT/OUTPUT ARRAY OF LENGTH N.
C
C       INCE    INTEGER INPUT SCALAR
C               STRIDE OF ARRAY A BETWEEN ELEMENTS OF SUBVECTOR,
C               MUST BE POSITIVE.
C
C       INCV    INTEGER INPUT SCALAR
C               STRIDE BETWEEN SUBVECTORS OF A.
C
C       N       INTEGER INPUT SCALAR
C               LENGTH OF SUBVECTOR OF A, MUST BE EVEN.
C
C       NV      INTEGER INPUT SCALAR
C               NUMBER OF SUBVECTORS IN A
C
C       IFLG    INTEGER INPUT SCALAR
C               DIRECTION OF TRANSFORM, POSITIVE FOR
C               FORWARD, NEGATIVE FOR INVERSE.
C
C       NFAC    INTEGER INPUT ARRAY OF LENGTH M
C               PRIME FACTORS OF N/2.
C
C       M       INTEGER INPUT SCALAR
C               NUMBER OF FACTORS IN ARRAY NFAC.
C
C       CNST    REAL INPUT ARRAY OF LENGTH 11
C               CONSTANTS, DEPENDENT ON IFLG.
C
C       STABLE  REAL INPUT ARRAY OF LENGTH N/2
C               SINE TWIDDLE FACTORS, DEPENDENT
C               ON IFLG.
C
C       CTABLE  REAL INPUT ARRAY OF LENGTH N/2
C               COSINE TWIDDLE FACTORS.
C
C       SRTAB   REAL INPUT ARRAY OF LENGTH N/4
C               SINE VALUES FOR AMX008.
C
C       CRTAB   REAL INPUT ARRAY OF LENGTH N/4
C               COSINE VALUES FOR AMX008.
C
C       ISRC    INTEGER INPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       IDST    INTEGER INPUT ARRAY OF LENGTH NPERM
C               PERMUTATION INDICIES.
C
C       NPERM   INTEGER INPUT SCALAR
C               NUMBER OF INDICIES IN ISRC AND IDST,
C               ALWAYS LESS THAN N/2.
C
C       W       REAL VECTOR OF LENGTH 18*NV
C               SCRATCH WORK AREA FOR TEMPORARRY COMPUTATIONS
C
C  DESCRIPTION:
C       THIS ROUTINE COMPUTES THE IN-PLACE FORWARD OR INVERSE
C       FAST FOURIER TRANSFORM OF A REAL ARRAY.  THE LENGTH OF
C       THE ARRAY, N, MUST BE EVEN AND FACTORABLE BY THE PRIME
C       FACTORS 2, 3, 5, AND/OR 7.  THE TRANSFORM IS PERFORMED
C       IN PLACE USING PRE-COMPUTED SINE, COSINE, FACTOR,
C       CONSTANT, AND PERMUTATION TABLES.  THE TABLES ARE UNIQUE
C       FOR EACH VALUE OF N, INC, AND IFLG.
C
C       THE REAL TRANSFORM IS COMPUTED USING A COMPLEX FFT OF
C       LENGTH N/2 AND A REAL/COMPLEX SCRAMBLE ALGORITHM.  FOR AN
C       EXPLANATION OF THIS TECHNIQUE SEE E.O. BRIGHAM, "THE FAST
C       FOURIER TRANSFORM", PRENTICE-HALL, 1974, PP. 167-169. THE
C       COMPLEX FFT IS COMPUTED USING AMX002, A NESTED MIXED RADIX
C       FFT ROUTINE.  SEE THE HEADER OF AMX002 FOR A DESCRIPTION AND
C       REFERENCES TO THE COMPLEX FFT ALGORITHM.  THE SUBROUTINE
C       THAT COMPUTES THE REAL/COMPLEX SCRAMBLE PASS IS NAMED
C       AMX008.  SEE THE HEADER OF THAT ROUTINE FOR DETAILS OF THE
C       ALGORITHM.
C
C       THE DESIGN STRATEGY FOR THIS ROUTINE ASSUMES THAT IT WILL BE
C       CALLED MANY TIMES WITH THE SAME VALUES OF N, INC, AND IFLG,
C       SO THAT THE OVERHEAD ASSOCIATED WITH CREATING THE TABLES IS
C       INSIGNIFICANT.  SEE THE ROUTINE RFFTM1 FOR THE TABLE
C       INITIALIZATION ALGORITHMS.
C
C       THE NESTED VERSION PERFORMS THE CALCULATIONS ON EACH OF THE
C       SUBVECTORS AS AN INTERNAL LOOP TO THE OUTER LOOP OF THE SUBVECTOR
C       IN ORDER TO REDUCE THE NEED OF RECALCULATING THE TERMS WHICH ARE
C       COMMON FOR EACH SUBVECTOR.
C
C       THE DISCRETE FOURIER TRANSFORM OF A REAL ARRAY OF LENGTH N IS
C       A COMPLEX ARRAY OF LENGTH N.  SINCE THE REAL ARRAY ONLY
C       OCCUPIES N STORAGE LOCATIONS, THERE IS ONLY ROOM FOR HALF OF
C       THE COMPLEX RESULT WHEN THE TRANSFORM IS COMPUTED IN PLACE.
C       FORTUNATELY THE TRANSFORM OF A REAL ARRAY IS HERMITIAN.  THE
C       NEGATIVE FREQUENCY COEFFICIENTS THAT FILL THE LAST HALF OF
C       THE ARRAY ARE THE COMPLEX CONJUGATES OF THE POSITIVE
C       FREQUENCY COMPONENTS.  ALSO, THE COMPONENTS AT ZERO FREQUENCY
C       AND AT THE NYQUIST POINT ARE PURELY REAL.  THIS ALLOWS US TO
C       PACK THE RESULTS OF A FORWARD REAL FFT IN TO THE SAME STORAGE
C       LOCATIONS AS THE ORIGINAL ARRAY.  THE FIRST VALUE IS THE REAL
C       PART OF THE ZERO FREQUENCY COMPONENT.  THE SECOND VALUE IS THE
C       REAL PART OF THE NYQUIST FREQUENCY COMPONENT.  THE THIRD AND
C       FOURTH VALUES ARE A COMPLEX PAIR REPRESENTING THE FIRST
C       NON-ZERO POSITIVE FREQUENCY COEFFICIENT.  SUBSEQUENT PAIRS
C       ALSO REPRESENT REAL AND IMAGINARY PORTIONS OF THE POSITIVE
C       FREQUENCY COEFFIENTS.   TO COMPUTE AN INVERSE TRANSFORM, THE
C       INPUT ARRAY MUST BE LOADED IN THE SAME SPECIAL PACKED FORMAT.
C       (NOTE: THIS FORMAT IS COMPATIBLE WITH THE MATH ADVANTAGE RFFT)
C
C  SUBPROGRAMS CALLED:
C       AMX002, AMX008
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
        SUBROUTINE AMX007 (A, INCE, INCV, N, NV, IFLG, NFAC, M, CNST,
     &                     STABLE, CTABLE, SRTAB, CRTAB, ISRC, IDST,
     &                     NPERM, W)
C
        REAL A(1), CNST(1), STABLE(1), CTABLE(1), SRTAB(1), CRTAB(1)
        REAL W(1)
        INTEGER N, NV, INCE, INCV, IFLG, M, NPERM
        INTEGER ISRC(1), IDST(1), NFAC(1)
C
C   LOCAL VARIABLES:
C
        INTEGER ISTARTW(18)
C                      STARTING INDEX FOR WORKING VECTORS OF LENGTH NV
        INTEGER IL
C                      INDEX FOR CONSECUTIVE ELEMENTS WITHIN SUBVECTOR
        INTEGER IPIL
C                      SELECTIVE INDEX USED FOR FIRST SUBVETOR ELEMENT IN A
        INTEGER KPIL
C                      SELECTIVE INDEX USED FOR IL'th SUBVETOR ELEMEMENT OF A
        INTEGER IPRL
C                      SELECTIVE INDEX USED FOR FIRST SUBVETOR ELEMENT IN A
        INTEGER KPLL
C                      SELECTIVE INDEX USED FOR IL'th SUBVETOR ELEMEMENT OF A
        INTEGER IPIH
C                      SELECTIVE INDEX USED FOR FIRST SUBVETOR ELEMENT IN A
        INTEGER KPIH
C                      SELECTIVE INDEX USED FOR IL'th SUBVETOR ELEMEMENT OF A
        INTEGER IPRH
C                      SELECTIVE INDEX USED FOR FIRST SUBVETOR ELEMENT IN A
        INTEGER KPRH
C                      SELECTIVE INDEX USED FOR IL'th SUBVETOR ELEMEMENT OF A
        INTEGER J
C                      DUMMY LOOP VARIABLE
        REAL    CF
C                      SELECTED VALUE FROM COSINE TABLE CRTAB
        REAL    SF
C                      SELECTED VALUE FROM SINE TABLE SRTAB
C
C-----------------------------------------------------------------------
C
C  INITIALIZE STARTING INDEXES FOR WORKING VECTORS
C
      ISTARTW(1) = 1
      DO 10 J = 2, 18
            ISTARTW(J) = ISTARTW(J-1) + NV
 10   CONTINUE
C
C--------------------
C Forward Transform
C--------------------
C
      IF (IFLG .GE. 0) THEN
C
         CALL AMX002 (A, A(1+INCE), 2*INCE, INCV, N/2, NV, IFLG,
     &             NFAC, M, CNST, STABLE, CTABLE, ISRC, IDST, NPERM,
     &             W(ISTARTW(1)), W(ISTARTW(2)), W(ISTARTW(3)),
     &           W(ISTARTW(4)), W(ISTARTW(5)), W(ISTARTW(6)),
     &             W(ISTARTW(7)), W(ISTARTW(8)), W(ISTARTW(9)),
     &             W(ISTARTW(10)), W(ISTARTW(11)), W(ISTARTW(12)),
     &             W(ISTARTW(13)), W(ISTARTW(14)), W(ISTARTW(15)),
     &             W(ISTARTW(16)), W(ISTARTW(17)), W(ISTARTW(18)) )
C
         CALL AMX008 (A, INCE, INCV, N, NV, IFLG, SRTAB, CRTAB,
     &                W(ISTARTW(1)), W(ISTARTW(2)), W(ISTARTW(3)),
     &                W(ISTARTW(4)), W(ISTARTW(5)), W(ISTARTW(6)),
     &                W(ISTARTW(7)), W(ISTARTW(8)) )
C
C--------------------
C Inverse Transform
C--------------------
C
      ELSE
C
         CALL AMX008 (A, INCE, INCV, N, NV, IFLG, SRTAB, CRTAB,
     &                W(ISTARTW(1)), W(ISTARTW(2)), W(ISTARTW(3)),
     &                W(ISTARTW(4)), W(ISTARTW(5)), W(ISTARTW(6)),
     &                W(ISTARTW(7)), W(ISTARTW(8)) )
C
         CALL AMX002 (A, A(1+INCE), 2*INCE, INCV, N/2, NV, IFLG,
     &             NFAC, M, CNST, STABLE, CTABLE, ISRC, IDST, NPERM,
     &             W(ISTARTW(1)), W(ISTARTW(2)), W(ISTARTW(3)),
     &           W(ISTARTW(4)), W(ISTARTW(5)), W(ISTARTW(6)),
     &             W(ISTARTW(7)), W(ISTARTW(8)), W(ISTARTW(9)),
     &             W(ISTARTW(10)), W(ISTARTW(11)), W(ISTARTW(12)),
     &             W(ISTARTW(13)), W(ISTARTW(14)), W(ISTARTW(15)),
     &             W(ISTARTW(16)), W(ISTARTW(17)), W(ISTARTW(18)) )
C
      ENDIF
C
        RETURN
        END
C
