C*****  AMX008  REAL/COMPLEX FFT SCRAMBLE       REV 1.0     FEB 88
C
C  PURPOSE:
C       PERFORMS THE REAL/COMPLEX SCRAMBLE ALGORITHM.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C       MATH ADVANTAGE VERSION  JAN 88          R.D. COLEMAN, QTC
C          CHANGED SUBROUTINE NAMES AND HEADER DOCUMENTATION AND
C          REMOVED SCALING.
C       ADDED NESTING TO AMX008  FEB 88          P. G. CROSE, QTC
C
C  CALLING FORMAT:
C       CALL AMX008 (A, INCE, INCV, N, NV, IFLG, SRTAB, CRTAB, W,
C                    ARL, AIL, ARH, AIH, BRPR, BRMR, BIPI, BIMI )
C
C  PARAMETERS:
C
C       A       REAL INPUT/OUTPUT ARRAY OF LENGTH N.
C
C       INCE    INTEGER INPUT SCALAR
C               STRIDE BETWEEN ELEMENTS OF SUBVECTOR OF A,
C               MUST BE POSITIVE.
C
C       INCV    INTEGER INPUT SCALAR
C               STRIDE BETWEEN SUBVECTORS OF A
C
C       N       INTEGER INPUT SCALAR
C               LENGTH OF SUBVECTORS OF A, MUST BE EVEN AND FACTORABLE
C               AS INTEGER POWERS OF 2, 3, 5, AND 7.
C
C       NV      INTEGER INPUT SCALAR
C               NUMBER OF SUBVECTORS IN A
C
C       IFLG    INTEGER INPUT SCALAR
C               DIRECTION OF TRANSFORM, POSITIVE FOR
C               FORWARD, NEGATIVE FOR INVERSE.
C
C       SRTAB   REAL INPUT ARRAY OF LENGTH N/4
C               SINE VALUES.
C
C       CRTAB   REAL INPUT ARRAY OF LENGTH N/4
C               COSINE VALUES.
C
C       W       REAL WORK ARRAY OF LENGTH 18*NV
C               SCRATCH AREA FOR TEMPORARY CALCULATIONS
C
C       ARL     TEMPORARY CALCULATION ARRAY OF  LENGTH NV
C
C       AIL     TEMPORARY CALCULATION ARRAY OF  LENGTH NV
C
C       ARH     TEMPORARY CALCULATION ARRAY OF  LENGTH NV
C
C       AIH     TEMPORARY CALCULATION ARRAY OF  LENGTH NV
C
C       BRPR    TEMPORARY CALCULATION ARRAY OF  LENGTH NV
C
C       BRMR    TEMPORARY CALCULATION ARRAY OF  LENGTH NV
C
C       BIPI    TEMPORARY CALCULATION ARRAY OF  LENGTH NV
C
C       BIMI    TEMPORARY CALCULATION ARRAY OF  LENGTH NV
C
C
C  DESCRIPTION:
C       This routine implements the real/complex scramble algorithm
C       that permits a real FFT of length N to be computed with
C       a complex FFT of length N/2.  For an explanation of
C       this technique see E.O. Brigham, "The Fast Fourier Transform",
C       Prentice-Hall, 1974, pp. 167-169.
C
C       To compute a forward real FFT, this routine is called after
C       the complex FFT computation.   To compute the inverse FFT, this
C       routine is called first, followed by a complex inverse FFT.
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE AMX008 (A, INCE, INCV, N, NV, IFLG, SRTAB, CRTAB,
     &                   ARL, AIL, ARH, AIH, BRPR, BRMR, BIPI, BIMI )
C
        REAL A(1), SRTAB(1), CRTAB(1), W(1)
        REAL ARL(1), AIL(1), ARH(1), AIH(1), BRPR(1), BRMR(1),
     &       BIPI(1), BIMI(1)
        INTEGER INCE, INCV, N, NV, IFLG
C  LOCAL VARIABLES
        INTEGER IL
C                      INDEX FOR CONSECUTIVE ELEMENTS WITHIN SUBVECTOR
        INTEGER IPIL
C                      SELECTIVE INDEX USED FOR FIRST SUBVETOR ELEMENT IN A
        INTEGER KPIL
C                      SELECTIVE INDEX USED FOR IL'th SUBVETOR ELEMEMENT OF A
        INTEGER IPRL
C                      SELECTIVE INDEX USED FOR FIRST SUBVETOR ELEMENT IN A
        INTEGER KPRL
C                      SELECTIVE INDEX USED FOR IL'th SUBVETOR ELEMEMENT OF A
        INTEGER IPIH
C                      SELECTIVE INDEX USED FOR FIRST SUBVETOR ELEMENT IN A
        INTEGER KPIH
C                      SELECTIVE INDEX USED FOR IL'th SUBVETOR ELEMEMENT OF A
        INTEGER IPRH
C                      SELECTIVE INDEX USED FOR FIRST SUBVETOR ELEMENT IN A
        INTEGER KPRH
C                      SELECTIVE INDEX USED FOR IL'th SUBVETOR ELEMEMENT OF A
C
        INTEGER I
C                      DUMMY LOOP VARIABLE
C
        REAL    CF
C                      SELECTED COSINE FACTOR
C
        REAL    SF
C                      SELECTED SINE FACTOR
C
C-----------------------------------------------------------------------
C
        IPRL = 1
        IPIL = 1 + INCE
C
C----------------------------
C  First Pair, special case
C----------------------------
C
       KPRL = IPRL
       KPIL = IPIL
C
        DO 1 IL = 1, NV
            ARL(IL) = A(KPRL)
            AIL(IL) = A(KPIL)
C
            KPRL = KPRL + INCV
            KPIL = KPIL + INCV
 1      CONTINUE
C
       KPRL = IPRL
       KPIL = IPIL
C
        IF (IFLG .GE. 0) THEN
CDIR$ IVDEP
            DO 11 IL = 1, NV
                A(KPRL) = 2.0 * (ARL(IL) + AIL(IL))
                A(KPIL) = 2.0 * (ARL(IL) - AIL(IL))
                KPRL = KPRL + INCV
                KPIL = KPIL + INCV
 11         CONTINUE
        ELSE
CDIR$ IVDEP
            DO 12 IL = 1, NV
                A(KPRL) = ARL(IL) + AIL(IL)
                A(KPIL) = ARL(IL) - AIL(IL)
                KPRL = KPRL + INCV
                KPIL = KPIL + INCV
 12         CONTINUE
        ENDIF
C
C-------------
C  Main Loop
C-------------
C
        IPRH = 1 + N*INCE
C
        DO 10 I=1,N/4
C
            IPRL = IPIL + INCE
            IPIL = IPRL + INCE
            IPIH = IPRH - INCE
            IPRH = IPIH - INCE
C
            KPRL = IPRL
            KPIL = IPIL
            KPRH = IPRH
            KPIH = IPIH
C
            CF = CRTAB(I)
            SF = SRTAB(I)
C
            DO 2 IL = 1, NV
 
                ARL(IL) = A(KPRL)
                AIL(IL) = A(KPIL)
C
                ARH(IL) = A(KPRH)
                AIH(IL) = A(KPIH)
C
                BRPR(IL) = ARL(IL) + ARH(IL)
                BRMR(IL) = ARL(IL) - ARH(IL)
                BIPI(IL) = AIL(IL) + AIH(IL)
                BIMI(IL) = AIL(IL) - AIH(IL)
C
                KPIL = KPIL + INCV
                KPRL = KPRL + INCV
                KPIH = KPIH + INCV
                KPRH = KPRH + INCV
 2          CONTINUE
C
            KPRL = IPRL
            KPIL = IPIL
            KPRH = IPRH
            KPIH = IPIH
C
CDIR$ IVDEP
            DO 3 IL = 1, NV
                A(KPRL) =  BRPR(IL) + CF*BIPI(IL) - SF*BRMR(IL)
                A(KPIL) =  BIMI(IL) - SF*BIPI(IL) - CF*BRMR(IL)
                A(KPRH) =  BRPR(IL) - CF*BIPI(IL) + SF*BRMR(IL)
                A(KPIH) = -BIMI(IL) - SF*BIPI(IL) - CF*BRMR(IL)
C
                KPIL = KPIL + INCV
                KPRL = KPRL + INCV
                KPIH = KPIH + INCV
                KPRH = KPRH + INCV
 3          CONTINUE
C
10      CONTINUE
C
        RETURN
        END
