C*****  ASPEC   Accumulating Auto-Spectrum        MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL ASPEC (A,C,N)
C
C       where,
C
C       A       Complex input vector.
C
C       C       Real input/output vector.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine performs an accumulating auto-spectrum on
C       a complex vector A.  Each element in the output vector C
C       is the sum of the input value of C and the square of the
C       real and imaginary parts of the corresponding element
C       of A.
C
C            C(i) = C(i) + [real(A(i))**2 + imag(A(i))**2]    for i=1,N
C
C
C  REFERENCE
C
C       P. Bloomfield.  1976.  Fourier analysis of time series:
C       an introduction.  New York: Wiley & Sons.
C
C
C  EXAMPLE
C
C       CALL ASPEC (A,C,5)
C
C       Input Operands:
C
C       A =  (1.000, 2.000)
C            (3.000, 4.000)
C            (5.000, 6.000)
C            (7.000, 8.000)
C            (9.000,10.000)
C
C       C =   1.000
C             2.000
C             3.000
C             4.000
C             5.000
C
C       Output Operands:
C
C       C =   6.000
C            27.000
C            64.000
C           117.000
C           186.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE ASPEC(A,C,N)
C
      INTEGER N,II,M
      REAL A(1),C(1)
      IF (N.LE.0) GO TO 800
      II = 1
      DO 300 M = 1, N
        C(M) = C(M) + A(II) * A(II) + A(II+1) * A(II+1)
        II = II + 2
300   CONTINUE
800   RETURN
      END
