C****** ATRM2D   2 DIMENSION ALPHA TRIM MEAN           MTADV EXT    REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL ATRM2D (A,ISORT,WORK,ALPHA,ATM,IWCN,IWCT,IWNWTH,IWTWTH,N,
C     &                             NDIM,NTRC,IERR)
C
C        where,
C
C        A        Real input matrix of dimension NDIM by NTRC.  The columns of
C                 A contain NTRC traces with length less than or equal to NDIM.
C
C        ISORT    Integer work vector used for the sorting.   ISORT must be
C                 long enough to contain the points within the window being
C                 operated upon.   At most, ISORT must be of length N*NTRC
C
C        WORK     Real work vector used for sorting.   This vector is filled
C                 with the elements of A that must be sorted and is used as
C                 work space for the sorting.  Hence, it should be twice the
C                 length of ISORT for a maximum size of 2*N*NTRC.
C
C        ALPHA    Real input scaler.  The absolute value of ALPHA is the
C                 fractional half width of the sequence used in the mean
C                 computation.   Values of ALPHA greater than 1 are treated
C                 identically to values equal to 1.
C
C        ATM      Real output ocaler containing the 2 dimension alpha trim mean.
C
C        IWCN     Integer input scaler.  IWCN is the index within a trace
C                 pointing to the center of the processing window (ie the
C                 coordinate of the window center in the N dimension).
C
C        IWCT     Integer input scaler.  IWCT is an index specifying the trace
C                 that contains the contains the processing window center (ie
C                 the coordinate of the window center in the NTRC dimension).
C
C        IWNWTH   Integer input scaler equal to the half width of the processing
C                 window within a trace (ie in the N dimension).
C
C        IWTWTH   Integer input scaler equal to the half width of the processing
C                 window in traces (ie in the NTRC dimension).
C
C        N        Integer input scaler.  The actual length of each trace.
C
C        NDIM     Integer input scaler.  The separation of the beginnings of
C                 adjacent traces in A.
C
C        NTRC     Integer input scaler.  The number of traces in A.
C
C        IERR     Integer output scaler.  Completion code with values:
C                      IERR =  0      normal completion
C                      IERR = -1      N or NTRC less than or equal to 0
C                      IERR = -2      window center outside of data
C
C  DESCRIPTION
C
C        This routine will find the two dimensional alpha trim mean of an
C        array.   The two dimensional alpha trim mean is defined as the alpha
C        trim mean of a vector constructed from A.  This vector is defined as
C        the contents of a window, specified in terms of its center (with N by
C        NTRC coordinates  IWCN and IWCT) and half widths in the trace (IWTWTH)
C        and N (IWNWTH) directions.  The regular alpha trim mean routine,
C        ATRMMN, is then called to find the alpha trim mean of this vector, ATM.
C
C        The alpha trim mean of a vector is computed by a three step procedure.
C        First, the elements in the vector are sorted into ascending order. Next
C        a window is placed about the middle of the sorted vector.  Finally, the
C        alpha trim mean is computed as the mean of the contents of the window.
C
C        The parameter ALPHA specifies the size of the window with the window's
C        half width given by the product of ALPHA and N/2.   An alpha value
C        of 0 results in an alpha trim mean equal to the median of the vector
C        while a  value of 1 yields the mean of the entire vector as the alpha
C        trim mean. The median for an even number of points is defined as the
C        mean of the central two points.
C
C  EXAMPLE
C
C        CALL ATRM2D ( A, ISORT, WORK, 0.30, ATM, 3, 4, 2, 1, 6, 6, 5, IERR)
C
C        Input Operands:
C
C              A  =   7.00   3.00   3.00   5.00   2.00
C                     2.00   6.00   2.00   7.00   7.00
C                    10.00   4.00  11.00   9.00   5.00
C                     3.00   8.00   2.00  13.00   1.00
C                     9.00   5.00  16.00   4.00   2.00
C                     1.00   3.00   1.00   6.00   3.00
C
C        Output Operands:
C
C              ATM  = 4.80
C              IERR = 0
C
C  SUBPROGRAMS
C
C       MATH ADVANTAGE:   VMOV
C       OTHER:            ATRMMN
C
C  HISTORY
C        (1) MAY 88           T.G. Mattson           Original
C
C-----------------------------------------------------------------------
       SUBROUTINE ATRM2D ( A, ISORT, WORK, ALPHA, ATM, IWCN, IWCT,
     &                             IWNWTH, IWTWTH, N, NDIM, NTRC, IERR)
C
       INTEGER NTRC, NDIM, N, ISORT(*), IWCN, IWCT, IWNWTH, IWTWTH, IERR
       REAL    A(NDIM,*), WORK(*), ALPHA, ATM
       INTEGER NW, NTSZ, IADD, ITRC2, ITRC1, IN, IN1, IN2
C
C-----------------------------------------------------------------------
C
C  Test input parameters
C
       IERR = 0
       IF ( (N .LE. 0) .OR. (NTRC .LE. 0) ) THEN
          IERR = -1
          RETURN
       ELSE IF ( (IWCN .LE. 0) .OR. (IWCN .GT. N) )THEN
          IERR = -2
          RETURN
       ELSE IF ( (IWCT .LE. 0) .OR. (IWCT .GT. NTRC) )THEN
          IERR = -2
          RETURN
       ENDIF
C
C  Define window limits and sizes
C
       ITRC1 = IWCT - IWTWTH
       ITRC2 = IWCT + IWTWTH
       IN1   = IWCN - IWNWTH
       IN2   = IWCN + IWNWTH
       IF( IN2   .GT. N   ) IN2   = N
       IF( IN1   .LE. 0   ) IN1   = 1
       IF( ITRC2 .GT. NTRC) ITRC2 = NTRC
       IF( ITRC1 .LE. 0   ) ITRC1 = 1
       NTSZ  = ITRC2 - ITRC1 + 1
C
C  Copy the contents of the window into the work array and find window size.
C
       IADD = 1
       DO 100 IN = IN1,IN2
          CALL VMOV (A(IN,ITRC1), NDIM, WORK(IADD), 1, NTSZ)
          IADD = IADD + NTSZ
 100   CONTINUE
C
C  Find the alpha trim mean of the work array.  This is the desired
C  two dimensional alpha trim mean.
C
       NW   = IADD
       IADD = IADD - 1
       CALL ATRMMN ( WORK, ISORT, WORK(NW), ALPHA, ATM, IADD)
C
       RETURN
       END
