C*****  CCORT   Cross-Correlation (Time-Domain)   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CCORT (A,B,C,N,M)
C
C       where,
C
C       A       Real input vector.
C
C       B       Real input vector.
C
C       C       Real output vector.
C
C       N       Integer input element count for C,
C               number of lags.
C
C       M       Integer input element count for A and B.
C
C
C  DESCRIPTION
C
C       This routine performs a cross-correlation on
C       two vectors, A and B, and stores the results
C       in vector C.  It performs the same operation
C       as CCORF but uses a time-domain method rather than a
C       frequency-domain (FFT) method.  CCORT runs faster than
C       CCORF for small vectors and small number of lags
C       (i.e., for small values of M and N).  It also requires less
C       memory space than CCORF because there is no need for
C       FFT space.
C
C            C(j) = SUM[A(j+i-1)*B(i)]    for i=1,M-j+1 and j=1,N
C
C
C  REFERENCE
C
C       G. W. Jenkins and D. G. Watts.  1969.  Spectral
C       analysis and its applications.  San Francisco: Holden-
C       Day.
C
C
C  EXAMPLE
C
C       CALL CCORT (A,B,C,6,8)
C
C       Input Operands:
C
C       A =   1.000
C             2.000
C             3.000
C             4.000
C             5.000
C             6.000
C             7.000
C             8.000
C
C       B =   1.000
C             2.000
C             3.000
C             4.000
C             5.000
C             6.000
C             7.000
C             8.000
C
C       Output Operands:
C
C       C = 204.00
C           168.00
C           133.00
C           100.00
C            70.00
C            44.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CCORT(A,B,C,N,M)
C
      INTEGER N,M,J2,IA,IB
      REAL A(1),B(1),C(1),SUM
      IF (M.LE.0 .OR. N.LE.0) GO TO 800
      DO 300 IA = 1, N
         SUM = 0.0
         J2  = M - IA + 1
         IF (J2.LE.0) GOTO 200
            DO 100 IB = 1, J2
               SUM = SUM + B(IB) * A(IA+IB-1)
100         CONTINUE
200       C(IA) = SUM
300   CONTINUE
800   RETURN
      END
