C*****  CFFTSC  Complex FFT Scale                 MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CFFTSC (C,N)
C
C       where,
C
C       C       Complex input/output vector.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine scales the results of a complex-
C       to-complex forward FFT, by multiplying the
C       results by 1/N.  The properly scaled results
C       are stored in C.
C
C            real(C(i)) = real(C(i))/N
C            imag(C(i)) = imag(C(i))/N    for i=1,N
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL CFFTSC (C,4)
C
C       Input Operands:
C
C       C = (4.000,0.000)
C           (0.000,0.000)
C           (0.000,0.000)
C           (0.000,0.000)
C
C       Output Operands:
C
C       C = (1.000,0.000)
C           (0.000,0.000)
C           (0.000,0.000)
C           (0.000,0.000)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CFFTSC(C,N)
C
      REAL C(2),WT
      INTEGER N,I
      IF (N.LE.0) GOTO 25
      WT = 1.0 / FLOAT(N)
      DO 10 I=1,N+N
        C(I) = WT * C(I)
10    CONTINUE
25    RETURN
      END
