C*****  CFFTSS  Complex FFT Scale with Stride          MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CFFTSS (C,IC,N)
C
C       where,
C
C       C       Complex input/output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine scales the results of a complex-to-complex
C       forward FFT, by multiplying the results by 1/N.  The complex
C       vector must have a stride specified.
C       The properly scaled results are stored in C.
C
C            real(C(i)) = real(C(i))/N
C            imag(C(i)) = imag(C(i))/N    for i=1,N
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL CFFTSS (C,2,4)
C
C       Input Operands:
C
C       C = (4.000,0.000)
C           (0.000,0.000)
C           (0.000,0.000)
C           (0.000,0.000)
C
C       Output Operands:
C
C       C = (1.000,0.000)
C           (0.000,0.000)
C           (0.000,0.000)
C           (0.000,0.000)
C
C  HISTORY
C         1) Feb 88     L. Shanbeck     Original.
C
      SUBROUTINE CFFTSS(C,IC,N)
C
      REAL C(1),WT
      INTEGER N,I,II,IC
      IF (N.LE.0) GOTO 25
      WT = 1.0 / FLOAT(N)
      II = 1
      DO 10 I=1,N
        C(II) = WT * C(II)
        C(II+1) = WT * C(II+1)
        II = II + IC
10    CONTINUE
25    RETURN
      END
