C*****  CGEAA  Complex General Eigenvalues & Eigenvectors    MATH ADV REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CGEAA(NM,N,A,W,Z,WRK,IERR)
C
C       where,
C
C       NM      Integer input number of rows in full matrices A and Z.
C
C       N       Integer input order of matrices A and Z.
C
C       A       Complex input matrix.
C
C       W       Complex output vector of length N, eigenvalues.
C
C       Z       Complex output matrix, eigenvectors.
C
C       WRK     Real workspace vector of length 3*N.
C
C       IERR    Integer output completion code:
C                If IERR=0, the routine terminated normally.
C                If 1<=IERR<=N, the calculation of eigenvalue IERR
C                 failed to converge.  Eigenvalues IERR+1 to N are still
C                 valid; none of the eigenvectors are valid.
C
C  DESCRIPTION
C
C       This routine determines all eigenvalues and all eigenvectors
C       of complex matrix A.
C
C       The eigenvectors, stored in matrix Z, are not normalized.
C
C       On output, matrix A is altered.
C
C       This routine contains a subset of the EISPACK eigensystem
C       package developed by Argonne National Laboratory.  It uses the
C       EISPACK recommended path of CBAL-CORTH-COMQR2-CBABK2.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       J. H. Wilkinson.  1965.  The algebraic eigenvalue prob-
C       lem.  New York: Oxford University Press.
C
C
C  EXAMPLE
C
C       CALL CGEAA(4,4,A,W,Z,WRK,IERR)
C
C       Input Operands:
C
C       A = ( 2.0, 4.0)  ( 3.0, 3.0)  ( 5.0, 1.0)  ( 7.0, 6.0)
C           ( 1.0, 6.0)  ( 6.0, 1.0)  ( 8.0, 5.0)  ( 3.0, 7.0)
C           ( 2.0, 8.0)  ( 5.0, 3.0)  ( 3.0, 2.0)  ( 2.0, 1.0)
C           ( 4.0, 4.0)  ( 0.0, 0.0)  ( 8.0, 5.0)  ( 5.0, 4.0)
C
C       Output Operands:
C
C       W = (15.959,14.823)
C           ( 4.728,-0.907)
C           ( 1.893,-3.476)
C           (-6.580, 0.560)
C
C       Z = ( 0.826,-0.087) ( 0.514, 0.010) ( 1.000, 0.000) ( 0.043,-0.872)
C           ( 1.000, 0.000) (-1.000, 0.000) ( 0.091,-0.661) ( 0.398,-0.001)
C           ( 0.734, 0.044) (-0.668,-0.334) (-0.663, 0.656) (-1.000, 0.000)
C           ( 0.748,-0.102) ( 0.815,-0.293) (-0.459,-0.804) ( 0.541, 0.558)
C
C       IERR = 0
C
C       Note concerning output values:
C
C       The eigenvalues (array W) may be arranged in any order; and the
C       rows of the eigenvectors (matrix Z) are associated with a particular
C       eigenvalue and will be ordered correspondingly.  Also, the eigen-
C       vectors may be multiplied by a constant and still be correct
C       (i.e., orthonormal vectors).
C
C  HISTORY
C         1) Sep 86     L. Tarvestad    Original.
C
      SUBROUTINE CGEAA(NM,N,A,W,Z,WRK,IERR)
      INTEGER N,NM,IS1,IS2,IERR
      REAL A(1),W(1),Z(1),WRK(1)
C
      IF (N.LE.0 .OR. N.GT.NM) GO TO 50
      CALL  QTC031(NM,N,A,IS1,IS2,WRK(1))
      CALL  QTC034(NM,N,IS1,IS2,A,WRK(1+N))
      CALL  QTC033(NM,N,IS1,IS2,WRK(1+N),A,W,Z,IERR)
      IF (IERR .NE. 0) GO TO 50
      CALL  QTC030(NM,N,IS1,IS2,WRK(1),N,Z)
50    RETURN
      END
