C*****  CMESFC  Complex Envelope Factor           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMESFC (S,ICP,N,NS,ZTOL,IERR)
C
C       where,
C
C       S       Complex input/output vector of length NS.
C               On input, S contains the elements of the complex
C               matrix A stored in envelope symmetric format.
C               On output, S contains a superposition of the L' and D
C               factors of A.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       IERR    Integer output completion code:
C                   =0 if routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine factors a complex symmetric matrix A,
C       represented in envelope format by the vectors S and ICP,
C       into LDL' form.
C
C       D is a diagonal matrix.  L is a lower triangular matrix
C       that has all 1's on its diagonal.  L' is the transpose of L.
C       L' and the reciprocated elements of D are overlaid on S.
C       L is not stored.
C
C       This routine does not do pivoting.  Therefore, the
C       matrix A should be numerically stable in the form in which
C       it is input.
C
C  REFERENCE
C
C       C. R. Rao.  1962.  A note on a generalized inverse of a
C       matrix with application to problems in mathematical
C       statistics.  J. R. Statis. Soc., Vol. B24,  pp. 152-
C       158.
C
C       J. H. Wilkinson.  1965.  The algebraic eigenvalue prob-
C       lem.  New York: Oxford University Press.
C
C       M. J. R. Healy.  1968.  Triangular decomposition of a
C       symmetric matrix.  Appl. Statis., Vol. 17,  pp. 195-
C       197.
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMESFC (S,ICP,6,11,ZTOL,IERR)
C
C       Input Operands:
C
C       S = (10.0,12.0)              ICP = 1
C           ( 2.0, 6.0)                    2
C           (-1.0, 2.0)                    4
C           ( 8.0,-8.0)                    7
C           ( 0.0, 0.0)                    8
C           ( 3.0,-3.0)                   11
C           ( 0.0, 2.0)                   12
C           (-4.0,10.0)
C           ( 0.0, 0.0)
C           ( 1.0,-1.0)
C           ( 0.0, 4.0)
C
C       ZTOL = 1.0E-5
C
C
C       Output Operands:
C
C       S = ( 0.041,-0.049)
C           ( 0.056,-0.145)
C           ( 0.057, 0.131)
C           ( 0.068, 0.055)
C           (-0.064, 0.069)
C           (-0.025,-0.270)
C           ( 0.000,-0.500)
C           (-0.034,-0.085)
C           ( 0.000, 0.000)
C           ( 0.123,-0.012)
C           ( 0.000,-0.250)
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE CMESFC(S,ICP,N,NS,ZTOL,IERR)
C
      INTEGER N,NS,ICP(1),IERR
      REAL    S(1),SUMR,SUMI,TEMPR,TEMPI
      REAL    ZTOL,ZTOLSQ,MAGN
      INTEGER I,IC,J,J1,J2,K,K1,K2,KJ,KP,MAX,NJ,NP,P,IC2,KP2,IM
C
      IF (N.LE.0 .OR. NS.LE.0) GOTO 700
C
      MAX = 0
      DO 110 J = 1, N
         NJ = ICP(J+1) - ICP(J)
         IF (NJ .GT. MAX) MAX = NJ
  110 CONTINUE
C
      ZTOLSQ = ZTOL * ZTOL
      DO 150 P = 1, N
         KP = ICP(P)
         KP2 = KP + KP
         K1 = ICP(P  ) + 1
         K2 = ICP(P+1) - 1
         IF (K1 .LE. K2) GOTO 115
            TEMPR = S(KP2-1)
            TEMPI = S(KP2)
            MAGN = TEMPR*TEMPR + TEMPI*TEMPI
            IF (MAGN .LE. ZTOLSQ) GO TO 800
C --- INVERT S:
            S(KP2-1) = TEMPR / MAGN
            S(KP2)   = -TEMPI / MAGN
            GO TO 150
115      CONTINUE
C
         SUMR = 0.0
         SUMI = 0.0
         I = P
         DO 120 K = K1+K1, K2+K2, 2
            I = I - 1
            IM = ICP(I)*2
            TEMPR = S(K-1) * S(IM-1) - S(K) * S(IM)
            TEMPI = S(K-1) * S(IM) + S(K) * S(IM-1)
            SUMR = SUMR + TEMPR * S(K-1) - TEMPI * S(K)
            SUMI = SUMI + TEMPR * S(K) + TEMPI * S(K-1)
            S(K-1) = TEMPR
            S(K) = TEMPI
  120    CONTINUE
C
         TEMPR = S(KP2-1) - SUMR
         TEMPI = S(KP2) - SUMI
         MAGN = TEMPR*TEMPR + TEMPI*TEMPI
         IF (MAGN .LE. ZTOLSQ) GO TO 800
C --- INVERT S:
         S(KP2-1) = TEMPR / MAGN
         S(KP2)   = -TEMPI / MAGN
C
         NP = K2 - K1 + 1
         J1 = P + 1
         J2 = P + MIN0( MAX-1, N-P)
         IF (J1 .GT. J2) GO TO 150
C
         DO 140 J = J1, J2
            KJ = ICP(J  ) + J - P
            NJ = ICP(J+1) - 1 - KJ
            IF (NJ .LE. 0) GO TO 140
            K2 = KP + MIN0( NP, NJ)
            IC = KJ - KP
            IC2 = IC+IC
            SUMR = 0.0
            SUMI = 0.0
            DO 130 K = K1+K1, K2+K2, 2
               IM = K + IC2
               SUMR = SUMR + S(K-1) * S(IM-1) - S(K) * S(IM)
               SUMI = SUMI + S(K-1) * S(IM) + S(K) * S(IM-1)
  130       CONTINUE
            IM = KP2 + IC2
            S(IM-1) = S(IM-1) - SUMR
            S(IM)   = S(IM) - SUMI
  140    CONTINUE
  150 CONTINUE
C
700   IERR = 0
      GOTO 900
C
800   CONTINUE
      IERR = P
900   RETURN
      END
