C*****  CMESFS  Complex Envelope Factor and Solve   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMESFS (S,ICP,N,NS,ZTOL,BX,M,IERR)
C
C       where,
C
C       S       Complex input/output vector of length NS.
C               On input, S contains the elements of the complex
C               matrix A stored in envelope symmetric format.
C               On output, S contains a superposition of the L' and D
C               factors of A.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       BX      Complex input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves the complex linear system Ax = b where A
C       is represented in envelope format by the vectors S
C       and ICP.  This routine calls CMESFC to perform an LDL'
C       factorization of A and then calls CMESSV to solve
C       the system.
C
C
C  REFERENCE
C
C       J. H. Wilkinson.  1965.  The algebraic eigenvalue prob-
C       lem.  New York: Oxford University Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMESFS (S,ICP,6,11,ZTOL,BX,2,IERR)
C
C       Input Operands:
C
C       S = (10.0,12.0)              ICP = 1
C           ( 2.0, 6.0)                    2
C           (-1.0, 2.0)                    4
C           ( 8.0,-8.0)                    7
C           ( 0.0, 0.0)                    8
C           ( 3.0,-3.0)                   11
C           ( 0.0, 2.0)                   12
C           (-4.0,10.0)
C           ( 0.0, 0.0)
C           ( 1.0,-1.0)
C           ( 0.0, 4.0)
C
C       BX = ( 28.0, 37.0)    ( 10.0,-27.0)
C            ( 15.0,-60.0)    (-37.0, 24.0)
C            ( 88.0,-68.0)    ( 87.0,-29.0)
C            ( -8.0, -6.0)    ( 12.0, -8.0)
C            (-40.0,-64.0)    ( 54.0,-22.0)
C            (  0.0, 16.0)    (  8.0,-12.0)
C
C       ZTOL = 1.0E-5
C
C
C       Output Operands:
C
C       S =  ( 0.041,-0.049)
C            ( 0.056,-0.145)
C            ( 0.057, 0.131)
C            ( 0.068, 0.055)
C            (-0.064, 0.069)
C            (-0.025,-0.270)
C            ( 0.000,-0.500)
C            (-0.034,-0.085)
C            ( 0.000, 0.000)
C            ( 0.123,-0.012)
C            ( 0.000,-0.250)
C
C       BX = ( 3.0, 4.0)    (-1.0, 0.0)
C            (-8.0,-7.0)    ( 2.0, 7.0)
C            ( 9.0,-1.0)    ( 8.0, 4.0)
C            (-3.0, 4.0)    (-4.0,-6.0)
C            (-3.0, 6.0)    (-3.0,-3.0)
C            ( 4.0, 0.0)    (-3.0,-2.0)
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE CMESFS(S,ICP,N,NS,ZTOL,BX,M,IERR)
C
      INTEGER M,N,NS,ICP(1),IERR
      REAL    S(1),BX(1),ZTOL
C
      IERR = 0
      IF (M.LE.0 .OR. N.LE.0 .OR. NS.LE.0) GOTO 900
      CALL CMESFC(S,ICP,N,NS,ZTOL,IERR)
      IF (IERR .EQ. 0) CALL CMESSV(S,ICP,N,NS,BX,M)
C
900   RETURN
      END
