C*****  CMFUIN  Complex Full Matrix Invert        MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMFUIN (A,NRA,N,ZTOL,IPERM,X,NRX,IERR)
C
C       where,
C
C       A       Complex input/output matrix.  On input, A contains
C               the matrix to be inverted.  On output, A contains
C               the LU factored form.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       N       Integer input order of submatrix A.
C
C       ZTOL    Real input scalar, pivot zero tolerance.
C
C       IPERM   Integer output permutation vector of length N.
C
C       X       Complex output matrix containing the inverted matrix.
C
C       NRX     Integer input number of rows in full matrix X.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a pivot
C                      was less than or equal to ZTOL.
C                      This implies the matrix is singular.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine factors and inverts the complex full
C       matrix A. It calls CMFUFC to factor A into LU form.
C       The factored matrix is stored in A and the inverted
C       matrix is stored in X.
C
C
C  REFERENCE
C
C       C. R. Rao.  1962.  A note on a generalized inverse of a
C       matrix with application to problems in mathematical
C       statistics.  J. R. Statis. Soc., Vol. B24,  pp. 152-
C       158.
C
C       J. H. Wilkinson.  1965.  The algebraic eigenvalue prob-
C       lem.  New York: Oxford University Press.
C
C       M. J. R. Healy.  1968.  Triangular decomposition of a
C       symmetric matrix.  Appl. Statis., Vol. 17,  pp. 195-
C       197.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL CMFUIN (A,3,3,ZTOL,IPERM,X,3,IERR)
C
C       Input Operands:
C
C       A = (1.000,1.000)  (0.000,0.000)  ( 1.000, 5.000)
C           (1.000,2.000)  (3.000,1.000)  (-1.000,18.000)
C           (0.000,0.000)  (2.000,3.000)  (-6.000, 8.000)
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       A = ( 0.200,-0.400)  ( 1.000,-1.000)  ( 7.000,4.000)
C           ( 0.000, 0.000)  ( 0.154,-0.231)  ( 0.923,2.615)
C           ( 1.000, 1.000)  (-2.000, 0.000)  (-0.250,1.250)
C
C       X = ( 3.750,-3.750)  (-1.300, 2.600)  (-0.500,-2.500)
C           ( 3.500,-0.500)  (-2.000, 1.000)  ( 1.000,-2.000)
C           (-0.250, 1.250)  (-0.100,-0.800)  ( 0.500, 0.500)
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE CMFUIN(A,NRA,N,ZTOL,IPERM,X,NRX,IERR)
C
      INTEGER NRA,N,I,IERR,IPERM(1),J,K,NRX,LX2,LA2,N2,IX,IA
      REAL    A(1),X(1),ZTOL
C
C   *******************************************************************
C
      IERR = 0
      IF (N.LE.0 .OR. NRA.LT.N .OR. NRX.LT.N) GO TO 800
C
C     FACTOR MATRIX
C
      CALL CMFUFC(A,NRA,N,ZTOL,IPERM,IERR)
      IF (IERR .NE. 0) GO TO 800
C
C     INITIALIZE INVERSE
C
      LX2 = NRX + NRX
      LA2 = NRA + NRA
      N2 = N + N
      IX = 1
      DO 110 J = 1, N
         CALL VCLR( X(IX), 1, N2)
         IX = IX + LX2
  110 CONTINUE
      CALL CVMOV( A, LA2+2, X, LX2+2, N)
      IF (N .EQ. 1) GO TO 800
C
C     PERFORM FORWARD ELIMINATION
C
      IA = 3 + LA2
      IX = 3
      DO 120 I = 2, N
         CALL QTC004(A(IA), X(IX), LX2, A(IX), LA2, X, LX2, I-1)
         IX = IX + 2
         IA = IA + 2 + LA2
  120 CONTINUE
C
C     PERFORM BACKWARD SUBSTITUTION
C
      IA = N2 + LA2*(N-1) - 3
      IX = N2 - 1
      DO 130 I = N-1, 1, -1
         CALL CNDOTP(A(IA),LA2,0,X(IX),2,LX2,X(IX-2),LX2,N-I,N,3)
         IX = IX - 2
         IA = IA - 2 - LA2
  130 CONTINUE
C
C     UNSCRAMBLE THE COLUMNS OF THE INVERSE
C
      IX = 1
      DO 150 J = 1, N-1
  140    CONTINUE
         K = IPERM(J)
         IF (K .EQ. J) GOTO 145
            IPERM(J) = IPERM(K)
            IPERM(K) = K
            CALL QTC003( X(IX),2,X((K-1)*LX2+1),2,N)
            GO TO 140
145      CONTINUE
         IX = IX + LX2
  150 CONTINUE
C
  800 CONTINUE
      RETURN
      END
