C*****  CMSUFC  Complex Sparse Factor             MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMSUFC (S,IRN,ICP,IDP,N,NS,ZTOL,WRK,IERR)
C
C       where,
C
C       S       Complex input/output vector of length NS.
C               On input, S contains the elements of the complex
C               matrix A stored in sparse unsymmetric format.
C               On output, S contains a superposition of the L and U
C               factors of A.
C
C       IRN     Integer input vector of length NS containing
C               row number of each element stored in vector S.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       IDP     Integer input vector of diagonal pointers of length N.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       WRK     Complex workspace vector of length N.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine factors a complex, sparse, unsymmetric matrix A
C       represented by S, IRN, ICP and IDP into LU form.
C
C       L is lower triangular and U is upper triangular.  The diagonal
C       elements of U are all 1's and are therefore not stored.  The
C       diagonal elements of L are reciprocated.
C
C       This routine does not do pivoting.  Therefore, the matrix A
C       should be numerically stable in the form in which it is input.
C
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMSUFC (S,IRN,ICP,IDP,6,16,ZTOL,WRK,IERR)
C
C       Input Operands:
C
C       S = (10.0,12.0)       IRN = 1   ICP = 1   IDP = 1
C           (-1.0, 2.0)             2         5         6
C           ( 3.0,-3.0)             3         9        11
C           ( 1.0, 0.0)             6        14        14
C           (-1.0, 2.0)             1        15        15
C           ( 2.0, 6.0)             2        16        16
C           (-1.0, 1.0)             3        17
C           ( 0.0, 0.0)  (Fill-in)  6
C           ( 3.0,-3.0)             1
C           (-1.0, 1.0)             2
C           ( 8.0,-8.0)             3
C           ( 1.0,-1.0)             5
C           ( 0.0, 0.0)  (Fill-in)  6
C           ( 0.0, 2.0)             4
C           (-4.0,10.0)             5
C           ( 0.0, 4.0)             6
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       S = ( 0.041,-0.049)
C           (-1.000, 2.000)
C           ( 3.000,-3.000)
C           ( 1.000, 0.000)
C           ( 0.057, 0.131)
C           ( 0.056,-0.145)
C           (-1.566, 0.779)
C           (-0.057,-0.131)
C           (-0.025,-0.270)  (Fill-in)
C           ( 0.025, 0.270)
C           ( 0.070, 0.053)
C           ( 1.000,-1.000)
C           (-0.009, 0.289)  (Fill-in)
C           ( 0.000,-0.500)
C           (-0.034,-0.086)
C           ( 0.000,-0.250)
C
C       IERR = 0
C
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE CMSUFC(S,IRN,ICP,IDP,N,NS,ZTOL,WRK,IERR)
C
      INTEGER N,NS,IERR
      REAL ZTOL,X,Y,XY2SUM,ZTOLSQ
      REAL S(1), WRK(1), TMPR, TMPI, WRKR, WRKI,SR,SI
      INTEGER ICP(1), IRN(1), IDP(1)
      INTEGER I,J,K,L,IDPJ,L1,L2,LL1,LL2,IPTR
C
      IF(N.LE.0 .OR. NS.LE.0) GOTO 700
      ZTOLSQ = ZTOL*ZTOL
      J = 1
      X = S(ICP(1)*2-1)
      Y = S(ICP(1)*2)
      XY2SUM = X*X + Y*Y
C
      IF (XY2SUM .LE. ZTOLSQ) GOTO 800
C
C---- S(ICP(1))=(1.,0.)/S(ICP(1)):
C
      S(ICP(1)*2-1) = X / XY2SUM
      S(ICP(1)*2) = -Y / XY2SUM
      IF (N.EQ.1) GOTO 700
      DO 30 J=2,N
C  EXPAND JTH COLUMN INTO WORK SPACE
          L1=ICP(J)
          L2=ICP(J+1)-1
          IDPJ=IDP(J)
          IF(L1 .GE. IDPJ) GO TO 29
          DO 6 I=L1,L2
              IPTR = IRN(I)+IRN(I)
              WRK(IPTR-1)=S(I+I-1)
              WRK(IPTR)=S(I+I)
6         CONTINUE
          DO 20 L=L1,IDPJ-1
              I=IRN(L)
C-----        IF (CABS(WRK(I)).EQ.0.0) GO TO 20
              IF (WRK(I+I).EQ.0.0 .AND. WRK(I+I-1).EQ.0.0) GOTO 20
C-----        WRK(I)=WRK(I)*S(IDP(I))
              IPTR = IDP(I)+IDP(I)
              SR = S(IPTR-1)
              SI = S(IPTR)
              WRKR = WRK(I+I-1)
              WRKI = WRK(I+I)
              TMPR = WRKR * SR - WRKI * SI
              TMPI = WRKR * SI + WRKI * SR
C-----        TMP=WRK(I)
              WRK(I+I-1) = TMPR
              WRK(I+I) = TMPI
              LL1=IDP(I)+1
              LL2=ICP(I+1)-1
              IF (LL1.GT.LL2) GO TO 20
              DO 10 K=LL1,LL2
C-----            WRK(IRN(K))=WRK(IRN(K))-TMP*S(K)
                  IPTR = IRN(K)+IRN(K)
                  WRK(IPTR-1)=WRK(IPTR-1)-(TMPR*S(K+K-1) - TMPI*S(K+K))
                  WRK(IPTR)=WRK(IPTR)-(TMPR*S(K+K) + TMPI*S(K+K-1))
10            CONTINUE
20        CONTINUE
C  STORE WORK SPACE INTO JTH COLUMN
          DO 25 I=L1,L2
              IPTR = IRN(I)+IRN(I)
C-----        S(I)=WRK(IRN(I))
              S(I+I-1) = WRK(IPTR-1)
              S(I+I) = WRK(IPTR)
25        CONTINUE
29        CONTINUE
C-----    IF (CABS(S(IDP(J))).LE.ZTOL) GOTO 800
      IPTR = IDP(J)+IDP(J)
      X = S(IPTR-1)
      Y = S(IPTR)
      XY2SUM = X*X + Y*Y
      IF (XY2SUM .LE. ZTOLSQ) GOTO 800
C  REPLACE DIAGONAL ELEMENT BY ITS RECIPROCAL
C-----    S(IDP(J))=(1.,0.)/S(IDP(J))
      S(IPTR-1) = X / XY2SUM
      S(IPTR) = -Y / XY2SUM
30    CONTINUE
C  LU FACTORING IS COMPLETE
700   IERR=0
      GOTO 900
C
800   IERR=J
900   RETURN
      END
