C*****  CMTUFC  Complex Matrix Tridiagonal Unsymmetric Factor MATHADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMTUFC (AD, AU, AL, N, ZTOL, IERR)
C
C       where,
C
C       AD      Complex input/output vector of length N.
C               On input, AD contains the main diagonal of the
C               tridiagonal matrix to be factored.
C               On output, AD contains the reciprocals of the
C               main diagonal of the factored matrix.
C
C       AU      Complex input/output vector of length N-1.
C               On input, AU contains the upper diagonal of the
C               tridiagonal matrix to be factored.
C               On output, AU contains the reciprocals of the
C               upper diagonal of the factored matrix.
C
C       AL      Complex input/output vector of length N-1.
C               On input, AL contains the lower diagonal of the
C               tridiagonal matrix to be factored.
C               On output, AL contains the reciprocals of the
C               lower diagonal of the factored matrix.
C
C       N       Integer input number of rows in full matrix.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      This implies the matrix is singular.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine factors a complex tridiagonal unsymmetric matrix A
C       represented by AD, AU and AL into LU form.
C
C       L is lower triangular and U is upper triangular.  The diagonal
C       elements of U are all 1's and are therefore not stored.  The
C       diagonal elements of L are reciprocated.
C
C       This routine does not do pivoting.  Therefore, the matrix A
C       should be numerically stable in the form in which it is input.
C
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMTUFC (AD, AU, AL, 5, ZTOL, IERR)
C
C       Input Operands:
C
C       AD = ( 22.0,-22.0)   AU = ( 8.0, 4.0)   AL = (-2.0,-8.0)
C            (-28.0,-27.0)        ( 4.0,-4.0)        (-2.0,-9.0)
C            ( 24.0, 21.0)        (-4.0, 0.0)        ( 0.0, 3.0)
C            (-12.0, 12.0)        ( 7.0, 1.0)        ( 1.0, 9.0)
C            (-20.0, 17.0)
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       AD = ( 0.0227, 0.0227)  AU = ( 0.0909, 0.2727)  AL = (-2.0,-8.0)
C            (-0.0192, 0.0165)       (-0.0109, 0.1427)       (-2.0,-9.0)
C            ( 0.0235,-0.0220)       (-0.0942, 0.0879)       ( 0.0, 3.0)
C            (-0.0407,-0.0426)       (-0.2421,-0.3386)       ( 1.0, 9.0)
C            (-0.0253,-0.0217)
C
C       IERR = 0
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C                       R. Coleman
C
      SUBROUTINE CMTUFC (AD, AU, AL, N, ZTOL, IERR)
C
      REAL AD(1), AU(1), AL(1), ZTOL, ZTOLSQ
      REAL RI2SUM, ADR,ADI, AUR,AUI, ALR,ALI
      INTEGER N, IERR, I, II
C
C   *******************************************************************
C
C     DO VALIDITY CHECKS AND INITIALIZATION
C
      IERR = 0
      IF (N.LE.0) GO TO 999
      I = 1
      ZTOLSQ = ZTOL*ZTOL
      ADR = AD(1)
      ADI = AD(2)
      RI2SUM = ADR*ADR + ADI*ADI
      IF (RI2SUM .LE. ZTOLSQ) GO TO 810
C
      AD(1) =  ADR / RI2SUM
      AD(2) = -ADI / RI2SUM
      IF (N .EQ. 1) GO TO 999
C
      ADR = AD(1)
      ADI = AD(2)
      AUR = AU(1)
      AUI = AU(2)
      AU(1) = ADR * AUR - ADI * AUI
      AU(2) = ADR * AUI + ADI * AUR
      II = 3
      IF (N .EQ. 2) GO TO 120
C
      DO 110 I = 2, N-1
         AUR = AU(II-2)
         AUI = AU(II-1)
         ALR = AL(II-2)
         ALI = AL(II-1)
         AD(II) = AD(II) - (ALR * AUR - ALI * AUI)
         AD(II+1) = AD(II+1) - (ALR * AUI + ALI * AUR)
         RI2SUM = AD(II)*AD(II) + AD(II+1)*AD(II+1)
         IF (RI2SUM .LE. ZTOLSQ) GO TO 810
         AD(II) = AD(II) / RI2SUM
         AD(II+1) = -AD(II+1) / RI2SUM
         AUR = AU(II)
         AUI = AU(II+1)
         AU(II) = AD(II) * AUR - AD(II+1) * AUI
         AU(II+1) = AD(II) * AUI + AD(II+1) * AUR
         II = II + 2
  110 CONTINUE
C
  120 CONTINUE
      I = N
      AUR = AU(II-2)
      AUI = AU(II-1)
      ALR = AL(II-2)
      ALI = AL(II-1)
      AD(II) = AD(II) - (ALR * AUR - ALI * AUI)
      AD(II+1) = AD(II+1) - (ALR * AUI + ALI * AUR)
      RI2SUM = AD(II)*AD(II) + AD(II+1)*AD(II+1)
      IF (RI2SUM .LE. ZTOLSQ) GO TO 810
      AD(II) = AD(II) / RI2SUM
      AD(II+1) = -AD(II+1) / RI2SUM
      GO TO 999
C
  810 CONTINUE
      IERR = I
  999 RETURN
      END
