C*****  CMTUFS  Cmplx Matrix Tridiagonal Unsym Factor & Solve MATHADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CMTUFS (AD, AU, AL, N, ZTOL, BX, M, IERR)
C
C       where,
C
C       AD      Complex input/output vector of length N.
C               On input, AD contains the main diagonal of the
C               tridiagonal matrix to be factored.
C               On output, AD contains the reciprocals of the
C               main diagonal of the factored matrix.
C
C       AU      Complex input/output vector of length N-1.
C               On input, AU contains the upper diagonal of the
C               tridiagonal matrix to be factored.
C               On output, AU contains the reciprocals of the
C               upper diagonal of the factored matrix.
C
C       AL      Complex input/output vector of length N-1.
C               On input, AL contains the lower diagonal of the
C               tridiagonal matrix to be factored.
C               On output, AL contains the reciprocals of the
C               lower diagonal of the factored matrix.
C
C       N       Integer input number of rows in full matrix.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       BX      Complex input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      This implies the matrix is singular.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves a complex linear system Ax = b, by calling
C       CMTUFC to factor the complex tridiagonal matrix A, represented
C       in tridiagonal format by AD, AU and AL into LU form.
C       It then calls CMTUSV to solve the system.
C
C  REFERENCE
C
C       D. Young.  1971.  Iterative solution of large linear
C       systems.  New York: Academic Press.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C       D. J. Evans (ed).  1985.  Sparsity and its applica-
C       tions.  New York: Cambridge University Press.
C
C
C  EXAMPLE
C
C       CALL CMTUFS (AD, AU, AL, 5, ZTOL, BX, 2, IERR)
C
C       Input Operands:
C
C       AD = ( 22.0,-22.0)   AU = ( 8.0, 4.0)   AL = (-2.0,-8.0)
C            (-28.0,-27.0)        ( 4.0,-4.0)        (-2.0,-9.0)
C            ( 24.0, 21.0)        (-4.0, 0.0)        ( 0.0, 3.0)
C            (-12.0, 12.0)        ( 7.0, 1.0)        ( 1.0, 9.0)
C            (-20.0, 17.0)
C
C       ZTOL = 1.0E-5
C
C       BX = ( -16.0,-176.0)   (-352.0,-120.0)
C            (-111.0,-179.0)   ( 306.0, -98.0)
C            (-315.0, -18.0)   ( 175.0,-311.0)
C            ( -59.0, -42.0)   ( -60.0,-160.0)
C            ( -76.0,-103.0)   ( 181.0,  72.0)
C
C       Output Operands:
C
C       AD = ( 0.0227, 0.0227)  AU = ( 0.0909, 0.2727)  AL = (-2.0,-8.0)
C            (-0.0192, 0.0165)       (-0.0109, 0.1427)       (-2.0,-9.0)
C            ( 0.0235,-0.0220)       (-0.0942, 0.0879)       ( 0.0, 3.0)
C            (-0.0407,-0.0426)       (-0.2421,-0.3386)       ( 1.0, 9.0)
C            (-0.0253,-0.0217)
C
C       BX = ( 4.0,-6.0)   (-2.0,-10.0)
C            ( 5.0, 3.0)   (-6.0, 10.0)
C            (-7.0, 8.0)   (-5.0, -9.0)
C            (-1.0, 3.0)   (-1.0,  6.0)
C            (-1.0, 4.0)   (-5.0, -8.0)
C
C       IERR = 0
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C                       R. Coleman
C
      SUBROUTINE CMTUFS (AD, AU, AL, N, ZTOL, BX, M, IERR)
C
      REAL    AD(1), AU(1), AL(1), ZTOL, BX(1)
      INTEGER N, M, IERR
C
      IERR = 0
      IF (N .LE. 0 .OR. M .LE. 0) GO TO 900
      CALL CMTUFC (AD, AU, AL, N, ZTOL, IERR)
      IF (IERR .EQ. 0) CALL CMTUSV (AD, AU, AL, N, BX, M)
C
900   RETURN
      END
